/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring.psm_scores;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.math.BasicMathFunctions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class AAIntensityRankScore {
    public static final int nBins = 10;

    public static double getScore(Peptide peptide, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int identificationCharge, double mzTolerance) {
        return AAIntensityRankScore.getScore(peptide, spectrum, iontypes, neutralLosses, charges, identificationCharge, mzTolerance, null);
    }

    public static double getScore(Peptide peptide, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int identificationCharge, double mzTolerance, PeptideSpectrumAnnotator peptideSpectrumAnnotator) {
        if (peptideSpectrumAnnotator == null) {
            peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
        }
        int sequenceLength = peptide.getSequence().length();
        HashMap<Integer, Double> aaIntensities = new HashMap<Integer, Double>(sequenceLength);
        for (int i = 1; i <= sequenceLength; ++i) {
            aaIntensities.put(i, 0.0);
        }
        ArrayList<IonMatch> matches = peptideSpectrumAnnotator.getSpectrumAnnotation(iontypes, neutralLosses, charges, identificationCharge, spectrum, peptide, 0.0, mzTolerance, false, true);
        for (IonMatch ionMatch : matches) {
            PeptideFragmentIon peptideFragmentIon;
            int number;
            double intensity;
            double tempIntensity;
            Ion ion = ionMatch.ion;
            if (!(ion instanceof PeptideFragmentIon) || !((tempIntensity = ionMatch.peak.intensity) > (intensity = ((Double)aaIntensities.get(number = (peptideFragmentIon = (PeptideFragmentIon)ion).getNumber())).doubleValue()))) continue;
            aaIntensities.put(number, tempIntensity);
        }
        int percentile = spectrum.getNPeaks() / 10;
        HashMap<Double, ArrayList<Peak>> intensityMap = spectrum.getIntensityMap();
        ArrayList<Double> intensities = new ArrayList<Double>(intensityMap.keySet());
        Collections.sort(intensities, Collections.reverseOrder());
        ArrayList<Double> thresholds = new ArrayList<Double>(100);
        int count = 0;
        for (double intensity : intensities) {
            if (++count != percentile) continue;
            thresholds.add(intensity);
            count = 0;
        }
        HashMap<Integer, Double> aaPercentile = new HashMap<Integer, Double>(sequenceLength);
        Iterator i$ = aaIntensities.keySet().iterator();
        while (i$.hasNext()) {
            int aa = (Integer)i$.next();
            double intensity = (Double)aaIntensities.get(aa);
            double rank = 10.0;
            if (intensity > 0.0) {
                double threshold;
                rank = 0.0;
                Iterator i$2 = thresholds.iterator();
                while (i$2.hasNext() && !(intensity >= (threshold = ((Double)i$2.next()).doubleValue()))) {
                    rank += 1.0;
                }
            }
            aaPercentile.put(aa, rank);
        }
        ArrayList<Double> ranks = new ArrayList<Double>(aaPercentile.values());
        return BasicMathFunctions.mean(ranks);
    }
}

