/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring.psm_scores;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.math.BasicMathFunctions;
import java.util.ArrayList;
import java.util.HashMap;

public class AAMS2MzFidelityScore {
    public static double getScore(Peptide peptide, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int identificationCharge, double mzTolerance) {
        return AAMS2MzFidelityScore.getScore(peptide, spectrum, iontypes, neutralLosses, charges, identificationCharge, mzTolerance, null);
    }

    public static double getScore(Peptide peptide, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int identificationCharge, double mzTolerance, PeptideSpectrumAnnotator peptideSpectrumAnnotator) {
        if (peptideSpectrumAnnotator == null) {
            peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
        }
        int sequenceLength = peptide.getSequence().length();
        HashMap<Integer, Double> aaDeviations = new HashMap<Integer, Double>(sequenceLength);
        for (int i = 1; i <= sequenceLength; ++i) {
            aaDeviations.put(i, mzTolerance);
        }
        ArrayList<IonMatch> matches = peptideSpectrumAnnotator.getSpectrumAnnotation(iontypes, neutralLosses, charges, identificationCharge, spectrum, peptide, 0.0, mzTolerance, false, true);
        for (IonMatch ionMatch : matches) {
            Ion ion = ionMatch.ion;
            if (!(ion instanceof PeptideFragmentIon)) continue;
            PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ion;
            int number = peptideFragmentIon.getNumber();
            double error = (Double)aaDeviations.get(number);
            double tempError = Math.abs(ionMatch.getAbsoluteError());
            if (!(tempError < error)) continue;
            aaDeviations.put(number, tempError);
        }
        ArrayList<Double> mzDeviations = new ArrayList<Double>(aaDeviations.values());
        if (mzDeviations.isEmpty()) {
            return mzTolerance;
        }
        return BasicMathFunctions.mean(mzDeviations);
    }
}

