/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.ptm.ptmscores;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.refinementparameters.MascotScore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class MDScore {
    public static Double getMDScore(SpectrumMatch spectrumMatch, ArrayList<String> ptms, AminoAcidPattern.MatchingType matchingType, Double massTolerance) {
        return MDScore.getMDScore(spectrumMatch, spectrumMatch.getBestPeptideAssumption().getPeptide(), ptms, matchingType, massTolerance);
    }

    public static Double getMDScore(SpectrumMatch spectrumMatch, Peptide peptideCandidate, ArrayList<String> ptms, AminoAcidPattern.MatchingType matchingType, Double massTolerance) {
        HashMap mascotAssumptionsMap = new HashMap();
        Double firstScore = null;
        Double secondScore = null;
        if (spectrumMatch.getAllAssumptions(Advocate.mascot.getIndex()) != null) {
            for (ArrayList<SpectrumIdentificationAssumption> assumptionList : spectrumMatch.getAllAssumptions(Advocate.mascot.getIndex()).values()) {
                for (SpectrumIdentificationAssumption assumption : assumptionList) {
                    PeptideAssumption peptideAssumption = (PeptideAssumption)assumption;
                    if (!peptideAssumption.getPeptide().isSameSequenceAndModificationStatus(peptideCandidate, matchingType, massTolerance)) continue;
                    MascotScore mascotScore = new MascotScore();
                    Double score = (mascotScore = (MascotScore)peptideAssumption.getUrParam(mascotScore)).getScore();
                    if (!mascotAssumptionsMap.containsKey(score)) {
                        mascotAssumptionsMap.put(score, new ArrayList());
                    }
                    ((ArrayList)mascotAssumptionsMap.get(score)).add(peptideAssumption.getPeptide());
                }
            }
            ArrayList scores = new ArrayList(mascotAssumptionsMap.keySet());
            Collections.sort(scores, Collections.reverseOrder());
            Iterator i$ = scores.iterator();
            while (i$.hasNext()) {
                double score = (Double)i$.next();
                for (Peptide peptide : (ArrayList)mascotAssumptionsMap.get(score)) {
                    if (peptide.sameModificationsAs(peptideCandidate)) {
                        firstScore = score;
                        if (secondScore == null) continue;
                        break;
                    }
                    if (secondScore != null || peptide.sameModificationsAs(peptideCandidate, ptms)) continue;
                    secondScore = score;
                    if (firstScore == null) continue;
                    break;
                }
                if (firstScore == null || secondScore == null) continue;
                break;
            }
        }
        if (firstScore == null && secondScore == null) {
            return null;
        }
        if (firstScore == null) {
            return -secondScore.doubleValue();
        }
        if (secondScore == null) {
            return firstScore;
        }
        return firstScore - secondScore;
    }
}

