/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry;

import com.compomics.util.experiment.io.massspectrometry.MgfIndex;
import com.compomics.util.experiment.io.massspectrometry.MgfReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MS1Spectrum;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Precursor;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import uk.ac.ebi.jmzml.model.mzml.BinaryDataArray;
import uk.ac.ebi.jmzml.model.mzml.CVParam;
import uk.ac.ebi.jmzml.model.mzml.ParamGroup;
import uk.ac.ebi.jmzml.model.mzml.PrecursorList;
import uk.ac.ebi.jmzml.model.mzml.Scan;
import uk.ac.ebi.jmzml.model.mzml.ScanList;
import uk.ac.ebi.jmzml.model.mzml.SelectedIonList;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshaller;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshallerException;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class SpectrumFactory {
    private static SpectrumFactory instance = null;
    private HashMap<String, HashMap<String, Spectrum>> currentSpectrumMap = new HashMap();
    private HashMap<String, HashMap<String, Precursor>> loadedPrecursorsMap = new HashMap();
    private static int nSpectraCache = 10000;
    private static int nPrecursorsCache = 1000000;
    private LinkedBlockingDeque<String> loadedSpectra = new LinkedBlockingDeque();
    private LinkedBlockingDeque<String> loadedPrecursors = new LinkedBlockingDeque();
    private HashMap<String, BufferedRandomAccessFile> mgfFilesMap = new HashMap();
    private HashMap<String, MgfIndex> mgfIndexesMap = new HashMap();
    private HashMap<String, MzMLUnmarshaller> mzMLUnmarshallers = new HashMap();
    private HashMap<String, File> idToSpectrumName = new HashMap();
    public static final long timeOut = 10000L;

    private SpectrumFactory() {
    }

    public static SpectrumFactory getInstance() {
        if (instance == null) {
            instance = new SpectrumFactory();
        }
        return instance;
    }

    public static SpectrumFactory getInstance(int nCache) {
        if (instance == null) {
            instance = new SpectrumFactory();
        }
        instance.setCacheSize(nCache);
        return instance;
    }

    public void clearFactory() {
        this.currentSpectrumMap.clear();
        this.loadedPrecursorsMap.clear();
        this.loadedSpectra.clear();
        this.loadedPrecursors.clear();
        this.mgfFilesMap.clear();
        this.mgfIndexesMap.clear();
        this.mzMLUnmarshallers.clear();
        this.idToSpectrumName.clear();
    }

    public void emptyCache() {
        this.currentSpectrumMap.clear();
        this.loadedPrecursorsMap.clear();
        this.loadedSpectra.clear();
        this.loadedPrecursors.clear();
    }

    public void setCacheSize(int nCache) {
        nSpectraCache = nCache;
    }

    public int getCacheSize() {
        return nSpectraCache;
    }

    public void addSpectra(File spectrumFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        this.addSpectra(spectrumFile, null);
    }

    public void addSpectra(File spectrumFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, IllegalArgumentException {
        String fileName = spectrumFile.getName();
        if (fileName.toLowerCase().endsWith(".mgf")) {
            File indexFile = new File(spectrumFile.getParent(), fileName + ".cui");
            MgfIndex mgfIndex = null;
            if (indexFile.exists()) {
                try {
                    MgfIndex tempIndex = this.getIndex(indexFile);
                    Long indexLastModified = tempIndex.getLastModified();
                    if (indexLastModified != null) {
                        long fileLastModified = spectrumFile.lastModified();
                        if (indexLastModified == fileLastModified) {
                            mgfIndex = tempIndex;
                        } else {
                            System.err.println("Reindexing: " + fileName + ". (changes in the file detected)");
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Reindexing: " + fileName + ". (Reason: " + e.getLocalizedMessage() + ")");
                }
            }
            if (mgfIndex == null) {
                mgfIndex = MgfReader.getIndexMap(spectrumFile, waitingHandler);
                if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                    return;
                }
                this.writeIndex(mgfIndex, spectrumFile.getParentFile());
            }
            if (mgfIndex == null) {
                throw new IllegalArgumentException("An error occurred while indexing " + spectrumFile.getAbsolutePath());
            }
            this.mgfFilesMap.put(fileName, new BufferedRandomAccessFile(spectrumFile, "r", 102400));
            this.mgfIndexesMap.put(fileName, mgfIndex);
        } else if (fileName.toLowerCase().endsWith(".mzml")) {
            MzMLUnmarshaller mzMLUnmarshaller = new MzMLUnmarshaller(spectrumFile);
            this.mzMLUnmarshallers.put(fileName, mzMLUnmarshaller);
        } else {
            throw new IllegalArgumentException("Spectrum file format not supported.");
        }
    }

    public Precursor getPrecursor(String fileName, String spectrumTitle) throws IOException, MzMLUnmarshallerException {
        return this.getPrecursor(fileName, spectrumTitle, true);
    }

    public Precursor getPrecursor(String fileName, String spectrumTitle, boolean save) throws IOException, MzMLUnmarshallerException {
        Precursor currentPrecursor;
        Spectrum spectrum;
        HashMap<String, Spectrum> fileSpectrumMap = this.currentSpectrumMap.get(fileName);
        if (fileSpectrumMap != null && (spectrum = fileSpectrumMap.get(spectrumTitle)) != null) {
            return ((MSnSpectrum)spectrum).getPrecursor();
        }
        HashMap<String, Precursor> filePrecursorMap = this.loadedPrecursorsMap.get(fileName);
        if (filePrecursorMap != null && (currentPrecursor = filePrecursorMap.get(spectrumTitle)) != null) {
            return currentPrecursor;
        }
        return this.getPrecursor(fileName, spectrumTitle, save, 1L);
    }

    public Precursor getPrecursor(String spectrumKey) throws IOException, MzMLUnmarshallerException, IllegalArgumentException {
        return this.getPrecursor(spectrumKey, true);
    }

    public Double getMaxMz(String fileName) {
        return this.mgfIndexesMap.get(fileName).getMaxMz();
    }

    public Double getMaxMz() {
        double maxMz = 0.0;
        for (MgfIndex mgfIndex : this.mgfIndexesMap.values()) {
            if (!(maxMz < mgfIndex.getMaxMz())) continue;
            maxMz = mgfIndex.getMaxMz();
        }
        return maxMz;
    }

    public Integer getMaxCharge(String fileName) {
        return this.mgfIndexesMap.get(fileName).getMaxCharge();
    }

    public Integer getMaxCharge() {
        int maxCharge = 0;
        for (MgfIndex mgfIndex : this.mgfIndexesMap.values()) {
            if (mgfIndex.getMaxCharge() <= maxCharge) continue;
            maxCharge = mgfIndex.getMaxCharge();
        }
        return maxCharge;
    }

    public Integer getMaxPeakCount(String fileName) {
        return this.mgfIndexesMap.get(fileName).getMaxPeakCount();
    }

    public Integer getMaxPeakCount() {
        int maxPeakCount = 0;
        for (MgfIndex mgfIndex : this.mgfIndexesMap.values()) {
            if (mgfIndex.getMaxPeakCount() <= maxPeakCount) continue;
            maxPeakCount = mgfIndex.getMaxPeakCount();
        }
        return maxPeakCount;
    }

    public Double getMaxIntensity(String fileName) {
        return this.mgfIndexesMap.get(fileName).getMaxIntensity();
    }

    public Double getMaxIntensity() {
        double maxIntensity = 0.0;
        for (MgfIndex mgfIndex : this.mgfIndexesMap.values()) {
            if (!(maxIntensity < mgfIndex.getMaxIntensity())) continue;
            maxIntensity = mgfIndex.getMaxIntensity();
        }
        return maxIntensity;
    }

    public Double getMaxRT(String fileName) {
        return this.mgfIndexesMap.get(fileName).getMaxRT();
    }

    public Double getMinRT(String fileName) {
        return this.mgfIndexesMap.get(fileName).getMinRT();
    }

    public Double getMaxRT() {
        double maxRT = 0.0;
        for (MgfIndex mgfIndex : this.mgfIndexesMap.values()) {
            if (!(maxRT < mgfIndex.getMaxRT())) continue;
            maxRT = mgfIndex.getMaxRT();
        }
        return maxRT;
    }

    public Double getMinRT() {
        double minRT = Double.MAX_VALUE;
        for (MgfIndex mgfIndex : this.mgfIndexesMap.values()) {
            if (!(minRT > mgfIndex.getMinRT())) continue;
            minRT = mgfIndex.getMinRT();
        }
        if (minRT == Double.MAX_VALUE) {
            minRT = 0.0;
        }
        return minRT;
    }

    public int getNSpectra(String fileName) {
        return this.mgfIndexesMap.get(fileName).getNSpectra();
    }

    public int getNSpectra() {
        int totalSpectrumCount = 0;
        for (String fileName : this.mgfIndexesMap.keySet()) {
            totalSpectrumCount += this.getNSpectra(fileName);
        }
        return totalSpectrumCount;
    }

    public Precursor getPrecursor(String spectrumKey, boolean save) throws IOException, MzMLUnmarshallerException, IllegalArgumentException {
        String fileName = Spectrum.getSpectrumFile(spectrumKey);
        String spectrumTitle = Spectrum.getSpectrumTitle(spectrumKey);
        return this.getPrecursor(fileName, spectrumTitle, save);
    }

    public boolean fileLoaded(String fileName) {
        return this.mgfIndexesMap.containsKey(fileName);
    }

    public boolean spectrumLoaded(String fileName, String spectrumTitle) {
        spectrumTitle = this.fixMgfTitle(spectrumTitle, fileName);
        return this.mgfIndexesMap.containsKey(fileName) && this.mgfIndexesMap.get(fileName).containsSpectrum(spectrumTitle);
    }

    public boolean spectrumLoaded(String spectrumKey) {
        String fileName = Spectrum.getSpectrumFile(spectrumKey);
        String spectrumTitle = Spectrum.getSpectrumTitle(spectrumKey);
        return this.spectrumLoaded(fileName, spectrumTitle);
    }

    private synchronized Precursor getPrecursor(String fileName, String spectrumTitle, boolean save, long waitingTime) throws IOException, MzMLUnmarshallerException, IllegalArgumentException {
        if (waitingTime <= 0L) {
            throw new IllegalArgumentException("Waiting time should be a positive number.");
        }
        Precursor currentPrecursor = null;
        if (fileName.toLowerCase().endsWith(".mgf")) {
            spectrumTitle = this.fixMgfTitle(spectrumTitle, fileName);
            if (this.mgfIndexesMap.get(fileName) == null) {
                throw new IOException("Mgf file not found: '" + fileName + "'.");
            }
            if (this.mgfIndexesMap.get(fileName).getIndex(spectrumTitle) == null) {
                throw new IOException("Spectrum '" + spectrumTitle + "' in mgf file '" + fileName + "' not found.");
            }
            try {
                currentPrecursor = MgfReader.getPrecursor(this.mgfFilesMap.get(fileName), this.mgfIndexesMap.get(fileName).getIndex(spectrumTitle), fileName);
            }
            catch (Exception e) {
                if (waitingTime < 10000L) {
                    try {
                        this.wait(waitingTime);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    return this.getPrecursor(fileName, spectrumTitle, save, 2L * waitingTime);
                }
                e.printStackTrace();
                throw new IllegalArgumentException("Error while loading precursor of spectrum " + spectrumTitle + " of file " + fileName + ".");
            }
        }
        if (fileName.toLowerCase().endsWith(".mzml")) {
            SelectedIonList sIonList;
            PrecursorList precursorList;
            ScanList scanList;
            uk.ac.ebi.jmzml.model.mzml.Spectrum mzMLSpectrum = this.mzMLUnmarshallers.get(fileName).getSpectrumById(spectrumTitle);
            int level = 2;
            double mzPrec = 0.0;
            double scanTime = -1.0;
            int chargePrec = 0;
            for (CVParam cvParam : mzMLSpectrum.getCvParam()) {
                if (!cvParam.getAccession().equals("MS:1000511")) continue;
                level = new Integer(cvParam.getValue());
                break;
            }
            if ((scanList = mzMLSpectrum.getScanList()) != null) {
                for (CVParam cvParam : ((Scan)scanList.getScan().get(scanList.getScan().size() - 1)).getCvParam()) {
                    if (!cvParam.getAccession().equals("MS:1000016")) continue;
                    scanTime = new Double(cvParam.getValue());
                    break;
                }
            }
            if ((precursorList = mzMLSpectrum.getPrecursorList()) != null && precursorList.getCount() == 1 && (sIonList = ((uk.ac.ebi.jmzml.model.mzml.Precursor)precursorList.getPrecursor().get(0)).getSelectedIonList()) != null) {
                for (CVParam cvParam : ((ParamGroup)sIonList.getSelectedIon().get(0)).getCvParam()) {
                    if (cvParam.getAccession().equals("MS:1000744") || cvParam.getAccession().equals("MS:1000040")) {
                        mzPrec = new Double(cvParam.getValue());
                        continue;
                    }
                    if (!cvParam.getAccession().equals("MS:1000041")) continue;
                    chargePrec = new Integer(cvParam.getValue());
                }
            }
            if (level == 1) {
                throw new IllegalArgumentException("MS1 spectrum");
            }
            ArrayList<Charge> charges = new ArrayList<Charge>();
            charges.add(new Charge(1, chargePrec));
            currentPrecursor = new Precursor(scanTime, mzPrec, charges);
        } else {
            throw new IllegalArgumentException("Spectrum file format not supported.");
        }
        if (save) {
            HashMap<String, Precursor> fileMap = this.loadedPrecursorsMap.get(fileName);
            if (fileMap == null) {
                fileMap = new HashMap();
                this.loadedPrecursorsMap.put(fileName, fileMap);
            }
            fileMap.put(spectrumTitle, currentPrecursor);
            String spectrumKey = Spectrum.getSpectrumKey(fileName, spectrumTitle);
            this.loadedPrecursors.add(spectrumKey);
            while (this.loadedPrecursors.size() > nPrecursorsCache) {
                String tempKey = this.loadedPrecursors.pollFirst();
                String tempFileName = Spectrum.getSpectrumFile(tempKey);
                fileMap = this.loadedPrecursorsMap.get(tempFileName);
                if (fileMap == null) continue;
                String tempTitle = Spectrum.getSpectrumTitle(tempKey);
                fileMap.remove(tempTitle);
            }
        }
        return currentPrecursor;
    }

    public Spectrum getSpectrum(String spectrumFile, String spectrumTitle) throws IOException, MzMLUnmarshallerException {
        Spectrum currentSpectrum;
        HashMap<String, Spectrum> fileMap = this.currentSpectrumMap.get(spectrumFile);
        if (fileMap != null && (currentSpectrum = fileMap.get(spectrumTitle)) != null) {
            return currentSpectrum;
        }
        return this.getSpectrum(spectrumFile, spectrumTitle, 1L);
    }

    public Spectrum getSpectrum(String spectrumKey) throws IOException, IllegalArgumentException, MzMLUnmarshallerException {
        String fileName = Spectrum.getSpectrumFile(spectrumKey);
        String spectrumTitle = Spectrum.getSpectrumTitle(spectrumKey);
        return this.getSpectrum(fileName, spectrumTitle);
    }

    private synchronized Spectrum getSpectrum(String spectrumFile, String spectrumTitle, long waitingTime) throws IOException, IllegalArgumentException, MzMLUnmarshallerException {
        HashMap<String, Spectrum> fileMap;
        String tempKey;
        String tempFile;
        HashMap<String, Spectrum> fileMap2;
        if (waitingTime <= 0L) {
            throw new IllegalArgumentException("Waiting time should be a positive number.");
        }
        Spectrum currentSpectrum = null;
        if (spectrumFile.toLowerCase().endsWith(".mgf")) {
            spectrumTitle = this.fixMgfTitle(spectrumTitle, spectrumFile);
            if (this.mgfIndexesMap.get(spectrumFile) == null) {
                throw new FileNotFoundException("Mgf file not found: '" + spectrumFile + "'!");
            }
            if (this.mgfIndexesMap.get(spectrumFile).getIndex(spectrumTitle) == null) {
                throw new IOException("Spectrum '" + spectrumTitle + "' in mgf file '" + spectrumFile + "' not found!");
            }
            try {
                currentSpectrum = MgfReader.getSpectrum(this.mgfFilesMap.get(spectrumFile), this.mgfIndexesMap.get(spectrumFile).getIndex(spectrumTitle), spectrumFile);
            }
            catch (Exception e) {
                if (waitingTime < 10000L) {
                    try {
                        this.wait(waitingTime);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    return this.getSpectrum(spectrumFile, spectrumTitle, 2L * waitingTime);
                }
                e.printStackTrace();
                throw new IllegalArgumentException("Error while loading spectrum " + spectrumTitle + " of file " + spectrumFile + ".");
            }
        }
        if (spectrumFile.toLowerCase().endsWith(".mzml")) {
            SelectedIonList sIonList;
            PrecursorList precursorList;
            ScanList scanList;
            if (this.mzMLUnmarshallers.get(spectrumFile) == null) {
                throw new IOException("mzML file not found: '" + spectrumFile + "'!");
            }
            if (this.mzMLUnmarshallers.get(spectrumFile).getSpectrumById(spectrumTitle) == null) {
                throw new IOException("Spectrum '" + spectrumTitle + "' in mzML file '" + spectrumFile + "' not found!");
            }
            uk.ac.ebi.jmzml.model.mzml.Spectrum mzMLSpectrum = this.mzMLUnmarshallers.get(spectrumFile).getSpectrumById(spectrumTitle);
            int level = 2;
            double mzPrec = 0.0;
            double scanTime = -1.0;
            int chargePrec = 0;
            for (CVParam cvParam : mzMLSpectrum.getCvParam()) {
                if (!cvParam.getAccession().equals("MS:1000511")) continue;
                level = new Integer(cvParam.getValue());
                break;
            }
            if ((scanList = mzMLSpectrum.getScanList()) != null) {
                for (CVParam cvParam : ((Scan)scanList.getScan().get(scanList.getScan().size() - 1)).getCvParam()) {
                    if (!cvParam.getAccession().equals("MS:1000016")) continue;
                    scanTime = new Double(cvParam.getValue());
                    break;
                }
            }
            if ((precursorList = mzMLSpectrum.getPrecursorList()) != null && precursorList.getCount() == 1 && (sIonList = ((uk.ac.ebi.jmzml.model.mzml.Precursor)precursorList.getPrecursor().get(0)).getSelectedIonList()) != null) {
                for (CVParam cvParam : ((ParamGroup)sIonList.getSelectedIon().get(0)).getCvParam()) {
                    if (cvParam.getAccession().equals("MS:1000744") || cvParam.getAccession().equals("MS:1000040")) {
                        mzPrec = new Double(cvParam.getValue());
                        continue;
                    }
                    if (!cvParam.getAccession().equals("MS:1000041")) continue;
                    chargePrec = new Integer(cvParam.getValue());
                }
            }
            List bdal = mzMLSpectrum.getBinaryDataArrayList().getBinaryDataArray();
            BinaryDataArray mzBinaryDataArray = (BinaryDataArray)bdal.get(0);
            Number[] mzNumbers = mzBinaryDataArray.getBinaryDataAsNumberArray();
            BinaryDataArray intBinaryDataArray = (BinaryDataArray)bdal.get(1);
            Number[] intNumbers = intBinaryDataArray.getBinaryDataAsNumberArray();
            HashMap<Double, Peak> peakList = new HashMap<Double, Peak>();
            for (int i = 0; i < mzNumbers.length; ++i) {
                peakList.put(mzNumbers[i].doubleValue(), new Peak(mzNumbers[i].doubleValue(), intNumbers[i].doubleValue(), scanTime));
            }
            if (level == 1) {
                currentSpectrum = new MS1Spectrum(spectrumFile, spectrumTitle, scanTime, peakList);
            } else {
                ArrayList<Charge> charges = new ArrayList<Charge>();
                charges.add(new Charge(1, chargePrec));
                Precursor precursor = new Precursor(scanTime, mzPrec, charges);
                currentSpectrum = new MSnSpectrum(level, precursor, spectrumTitle, peakList, spectrumFile, scanTime);
            }
        } else {
            throw new IllegalArgumentException("Spectrum file format not supported.");
        }
        if (this.loadedSpectra.size() == nSpectraCache && (fileMap2 = this.currentSpectrumMap.get(tempFile = Spectrum.getSpectrumFile(tempKey = this.loadedSpectra.pollFirst()))) != null) {
            String tempTitle = Spectrum.getSpectrumTitle(tempKey);
            fileMap2.remove(tempTitle);
        }
        if ((fileMap = this.currentSpectrumMap.get(spectrumFile)) == null) {
            fileMap = new HashMap();
            this.currentSpectrumMap.put(spectrumFile, fileMap);
        }
        fileMap.put(spectrumTitle, currentSpectrum);
        String spectrumKey = Spectrum.getSpectrumKey(spectrumFile, spectrumTitle);
        this.loadedSpectra.add(spectrumKey);
        return currentSpectrum;
    }

    public void writeIndex(MgfIndex mgfIndex, File directory) throws IOException {
        File indexFile = new File(directory, mgfIndex.getFileName() + ".cui");
        SerializationUtils.writeObject(mgfIndex, indexFile);
    }

    public MgfIndex getIndex(File mgfIndex) throws FileNotFoundException, IOException, ClassNotFoundException {
        return (MgfIndex)SerializationUtils.readObject(mgfIndex);
    }

    public void closeFiles() throws IOException {
        for (BufferedRandomAccessFile randomAccessFile : this.mgfFilesMap.values()) {
            randomAccessFile.close();
        }
    }

    public ArrayList<String> getMgfFileNames() {
        return new ArrayList<String>(this.mgfFilesMap.keySet());
    }

    public ArrayList<String> getMzMLFileNames() {
        return new ArrayList<String>(this.mzMLUnmarshallers.keySet());
    }

    public ArrayList<String> getSpectrumTitles(String mgfFile) {
        return this.mgfIndexesMap.get(mgfFile).getSpectrumTitles();
    }

    public Integer getSpectrumIndex(String spectrumTitle, String mgfFile) {
        MgfIndex mgfIndex = this.mgfIndexesMap.get(mgfFile);
        if (mgfIndex == null) {
            return null;
        }
        return mgfIndex.getSpectrumIndex(spectrumTitle);
    }

    public String getSpectrumTitle(String mgfFile, int spectrumNumber) {
        MgfIndex mgfIndex = this.mgfIndexesMap.get(mgfFile);
        if (mgfIndex == null) {
            return null;
        }
        return mgfIndex.getSpectrumTitle(spectrumNumber);
    }

    private String fixMgfTitle(String spectrumTitle, String fileName) {
        if (this.mgfIndexesMap.get(fileName).getIndex(spectrumTitle) == null) {
            try {
                spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("An exception was thrown when trying to decode an mgf title: " + spectrumTitle);
                e.printStackTrace();
            }
        }
        if (this.mgfIndexesMap.get(fileName).getIndex(spectrumTitle) == null) {
            spectrumTitle = spectrumTitle.replaceAll("\\\\\\\\", "\\\\");
        }
        return spectrumTitle;
    }

    public void addIdNameMapping(String idName, File spectrumFile) {
        this.idToSpectrumName.put(idName, spectrumFile);
    }

    public File getSpectrumFileFromIdName(String idName) {
        return this.idToSpectrumName.get(idName);
    }
}

