/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.quantification.reporterion;

import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.quantification.reporterion.Reagent;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ReporterMethodFactory
extends ExperimentObject {
    private ArrayList<ReporterMethod> methods;
    private static ReporterMethodFactory instance = null;

    private ReporterMethodFactory() {
    }

    public static ReporterMethodFactory getInstance() {
        if (instance == null) {
            instance = new ReporterMethodFactory();
        }
        return instance;
    }

    public ArrayList<ReporterMethod> getMethods() {
        return this.methods;
    }

    public String[] getMethodsNames() {
        String[] names = new String[this.methods.size()];
        for (int i = 0; i < this.methods.size(); ++i) {
            names[i] = this.methods.get(i).getName();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File aFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(aFile));
        try {
            String indent = "\t";
            writer.write("<xml>");
            writer.newLine();
            for (ReporterMethod reporterMethod : this.methods) {
                writer.write(indent + "<reorterMethod>");
                writer.newLine();
                writer.write(indent + indent + "<name>" + reporterMethod.getName() + "</name>");
                writer.newLine();
                writer.write(indent + indent + "<reagentList>");
                writer.newLine();
                ArrayList<String> reagentNames = new ArrayList<String>(reporterMethod.getReagentNames());
                Collections.sort(reagentNames);
                for (String reagentName : reagentNames) {
                    Reagent reagent = reporterMethod.getReagent(reagentName);
                    writer.write(indent + indent + indent + "<reagent>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<name>" + reagent.getName() + "</name>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<monoisotopicMass>" + reagent.getReporterIon().getTheoreticMass() + "</monoisotopicMass>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<minus2>" + reagent.getMinus2() + "</minus2>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<minus1>" + reagent.getMinus1() + "</minus2>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<ref>" + reagent.getRef() + "</ref>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<plus1>" + reagent.getPlus1() + "</plus1>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<plus2>" + reagent.getPlus2() + "</plus2>");
                    writer.newLine();
                    writer.write(indent + indent + indent + "</reagent>");
                    writer.newLine();
                }
                writer.write(indent + indent + "</reagentList>");
                writer.newLine();
                writer.write(indent + "</reorterMethod>");
                writer.newLine();
                writer.write("</xml>");
                writer.newLine();
            }
        }
        finally {
            writer.close();
        }
    }

    public void importMethods(File aFile) throws IOException, XmlPullParserException {
        this.methods = new ArrayList();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(aFile));
        parser.setInput((Reader)br);
        int type = parser.next();
        while (type != 1) {
            if (type == 2 && parser.getName().equals("reporterMethod")) {
                this.methods.add(this.parseMethod(parser));
            }
            type = parser.next();
        }
        br.close();
    }

    private ReporterMethod parseMethod(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.next();
        while (type != 2 || !parser.getName().equals("name")) {
            type = parser.next();
        }
        type = parser.next();
        String name = parser.getText().trim();
        ArrayList<Reagent> reagents = new ArrayList<Reagent>();
        while (type != 3 || !parser.getName().equals("reagentList")) {
            Reagent reagent = new Reagent();
            while (type != 2 || !parser.getName().equals("name")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagentList")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent list when parsing method " + name + ".");
            }
            type = parser.next();
            String reagentName = parser.getText().trim();
            reagent.setName(reagentName);
            while (type != 2 || !parser.getName().equals("monoisotopicMass")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagent")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
            }
            type = parser.next();
            Double monoisotopicMass = new Double(parser.getText().trim());
            ReporterIon reporterIon = new ReporterIon(reagentName, monoisotopicMass);
            reagent.setReporterIon(reporterIon);
            while (type != 2 || !parser.getName().equals("minus2")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagent")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
            }
            type = parser.next();
            Double correctionFactor = new Double(parser.getText().trim());
            reagent.setMinus2(correctionFactor);
            while (type != 2 || !parser.getName().equals("minus1")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagent")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
            }
            type = parser.next();
            correctionFactor = new Double(parser.getText().trim());
            reagent.setMinus1(correctionFactor);
            while (type != 2 || !parser.getName().equals("ref")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagent")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
            }
            type = parser.next();
            correctionFactor = new Double(parser.getText().trim());
            reagent.setRef(correctionFactor);
            while (type != 2 || !parser.getName().equals("plus1")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagent")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
            }
            type = parser.next();
            correctionFactor = new Double(parser.getText().trim());
            reagent.setPlus1(correctionFactor);
            while (type != 2 || !parser.getName().equals("plus2")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagent")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
            }
            type = parser.next();
            correctionFactor = new Double(parser.getText().trim());
            reagent.setPlus2(correctionFactor);
            reagents.add(reagent);
            while (type != 3 || !parser.getName().equals("reagent")) {
                type = parser.next();
            }
            type = parser.next();
            while (type != 2 && type != 3) {
                type = parser.next();
            }
        }
        return new ReporterMethod(name, reagents);
    }
}

