/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.ptm;

import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesColorTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class PtmChooser
extends JDialog {
    private boolean canceled = false;
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private ArrayList<String> ptmList = new ArrayList();
    private ArrayList<String> modificationTableToolTips;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JPanel ptmSelectionPanel;
    private JTable ptmTable;
    private JScrollPane ptmTableScrollPane;

    public PtmChooser(Frame parent, ArrayList<String> ptmList, ArrayList<String> selectedPTMs) {
        super(parent, true);
        this.ptmList = ptmList;
        this.initComponents();
        this.setUpGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public ArrayList<String> getSelection() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i : this.ptmTable.getSelectedRows()) {
            int index = this.ptmTable.convertRowIndexToModel(i);
            result.add(this.ptmList.get(index));
        }
        return result;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void setUpGUI() {
        this.ptmTableScrollPane.getViewport().setOpaque(false);
        double minMass = 0.0;
        double maxMass = 0.0;
        for (String modification : this.ptmList) {
            PTM ptm = this.ptmFactory.getPTM(modification);
            double mass = ptm.getMass();
            if (mass < minMass) {
                minMass = mass;
            }
            if (!(mass > maxMass)) continue;
            maxMass = mass;
        }
        this.ptmTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        this.ptmTable.getColumn(" ").setMaxWidth(35);
        this.ptmTable.getColumn("Mass").setMaxWidth(100);
        this.ptmTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(minMass), Double.valueOf(maxMass)));
        ((JSparklinesBarChartTableCellRenderer)this.ptmTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
        this.modificationTableToolTips = new ArrayList();
        this.modificationTableToolTips.add(null);
        this.modificationTableToolTips.add("Modification Name");
        this.modificationTableToolTips.add("Modification Mass");
        this.modificationTableToolTips.add("Default Modification");
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.ptmSelectionPanel = new JPanel();
        this.ptmTableScrollPane = new JScrollPane();
        this.ptmTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)PtmChooser.this.modificationTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(400, 400));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PtmChooser.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.ptmSelectionPanel.setBorder(BorderFactory.createTitledBorder("PTM Selection"));
        this.ptmSelectionPanel.setOpaque(false);
        this.ptmTable.setModel(new PtmTable());
        this.ptmTableScrollPane.setViewportView(this.ptmTable);
        GroupLayout ptmSelectionPanelLayout = new GroupLayout(this.ptmSelectionPanel);
        this.ptmSelectionPanel.setLayout(ptmSelectionPanelLayout);
        ptmSelectionPanelLayout.setHorizontalGroup(ptmSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmSelectionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ptmTableScrollPane, -1, 375, Short.MAX_VALUE).addContainerGap()));
        ptmSelectionPanelLayout.setVerticalGroup(ptmSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmSelectionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ptmTableScrollPane, -1, 275, Short.MAX_VALUE).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmChooser.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmChooser.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.ptmSelectionPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ptmSelectionPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private class PtmTable
    extends DefaultTableModel {
        private PtmTable() {
        }

        @Override
        public int getRowCount() {
            return PtmChooser.this.ptmList.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Mass";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String ptmName = (String)PtmChooser.this.ptmList.get(row);
            switch (column) {
                case 0: {
                    return PtmChooser.this.ptmFactory.getColor(ptmName);
                }
                case 1: {
                    return ptmName;
                }
                case 2: {
                    PTM ptm = PtmChooser.this.ptmFactory.getPTM(ptmName);
                    return ptm.getMass();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

