/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class BasicMathFunctions {
    public static int factorial(int n) {
        if (n <= 1) {
            return 1;
        }
        return n * (n - 1);
    }

    public static double getCombination(int k, int n) {
        if (k <= n) {
            return (double)BasicMathFunctions.factorial(n) / (double)(BasicMathFunctions.factorial(k) * BasicMathFunctions.factorial(n - k));
        }
        return 0.0;
    }

    public static double median(double[] ratios) {
        Arrays.sort(ratios);
        int length = ratios.length;
        if (ratios.length == 1) {
            return ratios[0];
        }
        if (length % 2 == 1) {
            return ratios[(length - 1) / 2];
        }
        return (ratios[length / 2] + ratios[length / 2 - 1]) / 2.0;
    }

    public static double median(ArrayList<Double> input) {
        return BasicMathFunctions.percentile(input, 0.5);
    }

    public static double percentile(double[] input, double percentile) {
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Incorrect input for percentile: " + percentile + ". Input must be between 0 and 1.");
        }
        Arrays.sort(input);
        int length = input.length;
        if (length == 0) {
            throw new IllegalArgumentException("Attempting to estimate the percentile of an empty list.");
        }
        if (length == 1) {
            return input[0];
        }
        double indexDouble = percentile * (double)(length - 1);
        int index = (int)indexDouble;
        double valueAtIndex = input[index];
        double rest = indexDouble - (double)index;
        if (index == input.length - 1 || rest == 0.0) {
            return valueAtIndex;
        }
        return valueAtIndex + rest * (input[index + 1] - valueAtIndex);
    }

    public static double percentile(ArrayList<Double> input, double percentile) {
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Incorrect input for percentile: " + percentile + ". Input must be between 0 and 1.");
        }
        Collections.sort(input);
        int length = input.size();
        if (length == 0) {
            throw new IllegalArgumentException("Attempting to estimate the percentile of an empty list.");
        }
        if (length == 1) {
            return input.get(0);
        }
        double indexDouble = percentile * (double)(length - 1);
        int index = (int)indexDouble;
        double valueAtIndex = input.get(index);
        double rest = indexDouble - (double)index;
        if (index == input.size() - 1 || rest == 0.0) {
            return valueAtIndex;
        }
        return valueAtIndex + rest * (input.get(index + 1) - valueAtIndex);
    }

    public static double mad(double[] ratios) {
        double[] deviations = new double[ratios.length];
        double med = BasicMathFunctions.median(ratios);
        for (int i = 0; i < ratios.length; ++i) {
            deviations[i] = Math.abs(ratios[i] - med);
        }
        return BasicMathFunctions.median(deviations);
    }

    public static double std(ArrayList<Double> input) {
        if (input == null || input.size() < 2) {
            return 0.0;
        }
        double result = 0.0;
        double mean = BasicMathFunctions.mean(input);
        for (Double x : input) {
            result += Math.pow(x - mean, 2.0);
        }
        result /= (double)(input.size() - 1);
        result = Math.sqrt(result);
        return result;
    }

    public static double mean(ArrayList<Double> input) {
        double result = 0.0;
        for (Double x : input) {
            result += x.doubleValue();
        }
        return result / (double)input.size();
    }

    public static double getCorrelation(ArrayList<Double> series1, ArrayList<Double> series2) {
        if (series1.size() != series2.size()) {
            throw new IllegalArgumentException("Series must be of same size for correlation analysis (series 1: " + series1.size() + " elements, series 1: " + series2.size() + " elements).");
        }
        int n = series1.size();
        if (n <= 1) {
            throw new IllegalArgumentException("At least two values are required for the estimation of correlation factors (" + n + " elements).");
        }
        double std1 = BasicMathFunctions.std(series1);
        double std2 = BasicMathFunctions.std(series2);
        if (std1 == 0.0 && std2 == 0.0) {
            return 1.0;
        }
        if (std1 == 0.0) {
            std1 = std2;
        }
        if (std2 == 0.0) {
            std2 = std1;
        }
        double mean1 = BasicMathFunctions.mean(series1);
        double mean2 = BasicMathFunctions.mean(series2);
        double corr = 0.0;
        for (int i = 0; i < n; ++i) {
            corr += (series1.get(i) - mean1) * (series2.get(i) - mean2);
        }
        corr /= std1 * std2;
        return corr /= (double)(n - 1);
    }

    public static double getRobustCorrelation(ArrayList<Double> series1, ArrayList<Double> series2) {
        if (series1.size() != series2.size()) {
            throw new IllegalArgumentException("Series must be of same size for correlation analysis (series 1: " + series1.size() + " elements, series 1: " + series2.size() + " elements).");
        }
        int n = series1.size();
        if (n <= 1) {
            throw new IllegalArgumentException("At least two values are required for the estimation of correlation factors (" + n + " elements).");
        }
        double std1 = (BasicMathFunctions.percentile(series1, 0.841) - BasicMathFunctions.percentile(series1, 0.159)) / 2.0;
        double std2 = (BasicMathFunctions.percentile(series2, 0.841) - BasicMathFunctions.percentile(series2, 0.159)) / 2.0;
        if (std1 == 0.0 && std2 == 0.0) {
            return 1.0;
        }
        if (std1 == 0.0) {
            std1 = std2;
        }
        if (std2 == 0.0) {
            std2 = std1;
        }
        double mean1 = BasicMathFunctions.median(series1);
        double mean2 = BasicMathFunctions.median(series2);
        double corr = 0.0;
        for (int i = 0; i < n; ++i) {
            corr += (series1.get(i) - mean1) * (series2.get(i) - mean2);
        }
        corr /= std1 * std2;
        return corr /= (double)(n - 1);
    }
}

