/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class ModificationTemplate {
    Logger logger = Logger.getLogger(ModificationTemplate.class);
    protected HashMap iMassDeltas = null;
    protected String iCode = null;
    protected String iTitle = null;
    protected boolean iArtifact = false;

    public ModificationTemplate(String aTitle, String aCode, HashMap aMassDeltas) {
        this(aTitle, aCode, aMassDeltas, false);
    }

    public ModificationTemplate(String aTitle, String aCode, HashMap aMassDeltas, boolean aArtifact) {
        this.iTitle = aTitle;
        this.iCode = aCode;
        Iterator it = aMassDeltas.keySet().iterator();
        while (it.hasNext()) {
            Object value;
            boolean pass = false;
            Object key = it.next();
            if (key instanceof String && (value = aMassDeltas.get(key)) instanceof double[] && ((double[])value).length >= 2) {
                pass = true;
            }
            if (pass) continue;
            throw new IllegalArgumentException("Your HashMap did not conform to the required (String, double[] (length 2)) conformation!");
        }
        this.iMassDeltas = aMassDeltas;
        this.iArtifact = aArtifact;
    }

    public double getAverageMassDelta(String aResidue) {
        return this.getMassDelta(aResidue, 1);
    }

    public String getCode() {
        return this.iCode;
    }

    public String getTitle() {
        return this.iTitle;
    }

    public Collection getResidues() {
        return this.iMassDeltas.keySet();
    }

    public double getMonoisotopicMassDelta(String aResidue) {
        return this.getMassDelta(aResidue, 0);
    }

    public boolean isArtifact() {
        return this.iArtifact;
    }

    public boolean equals(Object obj) {
        boolean result = true;
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            result = false;
        } else if (!((ModificationTemplate)obj).iTitle.equals(this.iTitle)) {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.iTitle.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Modification: '" + this.iTitle + "':");
        if (this.iArtifact) {
            sb.append("\n\tHidden");
        }
        sb.append("\n\tCode: " + this.iCode);
        Set keySet = this.iMassDeltas.keySet();
        Object[] residues = new String[keySet.size()];
        keySet.toArray(residues);
        Arrays.sort(residues);
        for (int i = 0; i < residues.length; ++i) {
            Object lResidue = residues[i];
            double[] deltas = (double[])this.iMassDeltas.get(lResidue);
            if (((String)lResidue).equals("0")) {
                lResidue = "Nterm";
            } else if (((String)lResidue).equals("1")) {
                lResidue = "Cterm";
            }
            sb.append("\n\tResidue: " + (String)lResidue + " " + deltas[0] + " Da [MONOISOTOPIC] " + deltas[1] + " Da [AVERAGE]");
        }
        return sb.toString();
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            this.logger.error((Object)cnse.getMessage(), (Throwable)cnse);
        }
        return clone;
    }

    public int compareTo(Object o) {
        ModificationTemplate mi = (ModificationTemplate)o;
        int result = this.iTitle.compareTo(mi.iTitle);
        return result;
    }

    protected double getMassDelta(String aResidue, int aMonoOrAvg) {
        if (aMonoOrAvg < 0 || aMonoOrAvg > 1) {
            throw new IllegalArgumentException("The index in the double[] you specified (" + aMonoOrAvg + ") is outside the range of MONOISOTOPIC-AVERAGE (0-1)!!");
        }
        double delta = 0.0;
        Object temp = this.iMassDeltas.get(aResidue);
        if (temp != null && temp instanceof double[]) {
            double[] deltas = (double[])temp;
            delta = deltas[aMonoOrAvg];
        }
        return delta;
    }
}

