/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.marc;

import com.compomics.util.math.statistics.ROC;
import com.compomics.util.math.statistics.distributions.NonSymmetricalNormalDistribution;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.math.MathException;

public class JillROC {
    private static final String separator = "\t";

    public static void main(String[] args) {
        JillROC m = new JillROC();
        try {
            m.createRoc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRoc() throws FileNotFoundException, IOException, MathException {
        double y;
        ROC roc;
        File inFile = new File("D:\\projects\\jill roc\\intensities.txt");
        HashMap<String, ArrayList<Double>> controlInput = new HashMap<String, ArrayList<Double>>();
        HashMap<String, ArrayList<Double>> msInput = new HashMap<String, ArrayList<Double>>();
        HashMap<String, NonSymmetricalNormalDistribution> controlDistributions = new HashMap<String, NonSymmetricalNormalDistribution>();
        HashMap<String, NonSymmetricalNormalDistribution> msDistributions = new HashMap<String, NonSymmetricalNormalDistribution>();
        HashMap<String, ROC> rocs = new HashMap<String, ROC>();
        ArrayList<String> proteins = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(inFile));
        try {
            String line = br.readLine();
            while ((line = br.readLine()) != null) {
                String[] split = line.split(separator);
                String accession = split[0];
                proteins.add(accession);
                ArrayList<Double> input = new ArrayList<Double>();
                for (int i = 5; i <= 68; ++i) {
                    String intensity = split[i];
                    if (intensity.equals("")) continue;
                    input.add(new Double(intensity));
                }
                controlInput.put(accession, input);
                NonSymmetricalNormalDistribution controlDistribution = NonSymmetricalNormalDistribution.getRobustNonSymmetricalNormalDistribution(input);
                controlDistributions.put(accession, controlDistribution);
                input = new ArrayList();
                for (int i = 69; i <= 105; ++i) {
                    String intensity = split[i];
                    if (intensity.equals("")) continue;
                    input.add(new Double(intensity));
                }
                msInput.put(accession, input);
                NonSymmetricalNormalDistribution msDistribution = NonSymmetricalNormalDistribution.getRobustNonSymmetricalNormalDistribution(input);
                msDistributions.put(accession, msDistribution);
                roc = new ROC(controlDistribution, msDistribution);
                rocs.put(accession, roc);
            }
        }
        finally {
            br.close();
        }
        File outFile = new File("D:\\projects\\jill roc\\rocs.txt");
        BufferedWriter bw = new BufferedWriter(new FileWriter(outFile));
        for (String accession : proteins) {
            bw.write(separator + accession);
        }
        bw.newLine();
        try {
            for (double x = 0.0; x <= 1.0; x += 0.01) {
                bw.write(x + "");
                for (String accession : proteins) {
                    roc = (ROC)rocs.get(accession);
                    y = roc.getValueAt(x);
                    bw.write(separator + y);
                }
                bw.newLine();
            }
        }
        finally {
            bw.close();
        }
        outFile = new File("D:\\projects\\jill roc\\inverted_rocs.txt");
        bw = new BufferedWriter(new FileWriter(outFile));
        for (String accession : proteins) {
            bw.write(separator + accession);
        }
        bw.newLine();
        try {
            for (double x = 0.0; x <= 1.0; x += 0.01) {
                bw.write(x + "");
                for (String accession : proteins) {
                    roc = (ROC)rocs.get(accession);
                    y = roc.getSpecificityAt(x);
                    bw.write(separator + y);
                }
                bw.newLine();
            }
        }
        finally {
            bw.close();
        }
    }
}

