/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.marc;

import com.compomics.util.Util;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.protein.Header;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class MapPfu {
    public static final String separator = "\t";

    public static void main(String[] args) {
        MapPfu m = new MapPfu();
        try {
            m.addPfuToPSMs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addPfuToProject() throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        File dbFile = new File("D:/databases/uniprot_eukaryota_reviewed_pyrococcus_furiosus_21.10.13_concatenated_target_decoy.fasta");
        SequenceFactory sequenceFactory = SequenceFactory.getInstance(1000000);
        sequenceFactory.loadFastaFile(dbFile);
        String folder = "D:\\projects\\PeptideShaker\\supplementary info\\pfu\\pfu eukaryota\\revision\\reports";
        System.out.println("processing protein file");
        File proteinFile = new File(folder, "proteins.txt");
        this.processProteinFile(proteinFile);
        System.out.println("processing peptide file");
        File peptideFile = new File(folder, "peptides.txt");
        this.processPeptideFile(peptideFile);
        System.out.println("processing psm file");
        File psmFile = new File(folder, "psms.txt");
        this.processPsmFile(psmFile);
    }

    public void addPfuToPSMs() throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        File dbFile = new File("D:/databases/uniprot_eukaryota_reviewed_pyrococcus_furiosus_21.10.13_concatenated_target_decoy.fasta");
        SequenceFactory sequenceFactory = SequenceFactory.getInstance(1000000);
        sequenceFactory.loadFastaFile(dbFile);
        String folder = "D:\\projects\\PeptideShaker\\supplementary info\\pfu\\pfu eukaryota\\revision\\reports\\se";
        System.out.println("processing MS Amanda file");
        File psmFile = new File(folder, "a psms.txt");
        this.processPsmFile(psmFile);
        System.out.println("processing MS-GF+ file");
        psmFile = new File(folder, "m psms.txt");
        this.processPsmFile(psmFile);
        System.out.println("processing OMSSA file");
        psmFile = new File(folder, "o psms.txt");
        this.processPsmFile(psmFile);
        System.out.println("processing X!Tandem file");
        psmFile = new File(folder, "x psms.txt");
        this.processPsmFile(psmFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processProteinFile(File proteinFile) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        File newFile = new File(proteinFile.getParent(), Util.appendSuffix(proteinFile.getName(), "_processed"));
        BufferedWriter bw = new BufferedWriter(new FileWriter(newFile));
        File conflictFile = new File(proteinFile.getParent(), Util.appendSuffix(proteinFile.getName(), "_conflict"));
        BufferedWriter bw1 = new BufferedWriter(new FileWriter(conflictFile));
        File histogramsFile = new File(proteinFile.getParent(), Util.appendSuffix(proteinFile.getName(), "_histograms"));
        BufferedWriter bw2 = new BufferedWriter(new FileWriter(histogramsFile));
        BufferedReader br = new BufferedReader(new FileReader(proteinFile));
        String line = br.readLine();
        HashMap<Double, Integer> nTargetFP = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nDecoy = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nTarget = new HashMap<Double, Integer>();
        ArrayList<Double> scores = new ArrayList<Double>();
        try {
            bw.write(line + separator + "contaminant" + separator + "pfu");
            bw.newLine();
            bw1.write(line);
            bw1.newLine();
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                String[] splittedLine = line.split(separator);
                String[] accessions = splittedLine[1].split(", ");
                boolean contaminant = false;
                boolean pfu = false;
                boolean decoy = false;
                for (String accession : accessions) {
                    Header header = sequenceFactory.getHeader(accession);
                    String description = header.getDescription().toLowerCase();
                    if (description.contains("keratin") || description.contains("trypsin")) {
                        contaminant = true;
                    }
                    if (description.contains("pyrococcus")) {
                        pfu = true;
                    }
                    if (sequenceFactory.isDecoyAccession(accession)) {
                        decoy = true;
                        if (!pfu) continue;
                        bw1.write(line);
                        bw1.newLine();
                        continue;
                    }
                    if (!decoy) continue;
                    bw1.write(line);
                    bw1.newLine();
                }
                bw.write(line + contaminant + separator + pfu);
                bw.newLine();
                double score = new Double(splittedLine[22]);
                if (!scores.contains(score)) {
                    scores.add(score);
                }
                if (decoy) {
                    if (nDecoy.containsKey(score)) {
                        nDecoy.put(score, (Integer)nDecoy.get(score) + 1);
                        continue;
                    }
                    nDecoy.put(score, 1);
                    continue;
                }
                if (nTarget.containsKey(score)) {
                    nTarget.put(score, (Integer)nTarget.get(score) + 1);
                } else {
                    nTarget.put(score, 1);
                }
                if (pfu || contaminant) continue;
                if (nTargetFP.containsKey(score)) {
                    nTargetFP.put(score, (Integer)nTargetFP.get(score) + 1);
                    continue;
                }
                nTargetFP.put(score, 1);
            }
            bw2.write("score\t# decoy\t# FP\t# target");
            bw2.newLine();
            Collections.sort(scores);
            Iterator i$ = scores.iterator();
            while (i$.hasNext()) {
                double score = (Double)i$.next();
                bw2.write(score + separator);
                if (nDecoy.containsKey(score)) {
                    bw2.write(nDecoy.get(score) + separator);
                } else {
                    bw2.write("0\t");
                }
                if (nTargetFP.containsKey(score)) {
                    bw2.write(nTargetFP.get(score) + separator);
                } else {
                    bw2.write("0\t");
                }
                if (nTarget.containsKey(score)) {
                    bw2.write(nTarget.get(score) + separator);
                } else {
                    bw2.write("0\t");
                }
                bw2.newLine();
            }
        }
        finally {
            br.close();
            bw.close();
            bw1.close();
            bw2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPeptideFile(File peptideFile) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        File newFile = new File(peptideFile.getParent(), Util.appendSuffix(peptideFile.getName(), "_processed"));
        BufferedWriter bw = new BufferedWriter(new FileWriter(newFile));
        File conflictFile = new File(peptideFile.getParent(), Util.appendSuffix(peptideFile.getName(), "_conflict"));
        BufferedWriter bw1 = new BufferedWriter(new FileWriter(conflictFile));
        File histogramsFile1 = new File(peptideFile.getParent(), Util.appendSuffix(peptideFile.getName(), "_nomod_histograms"));
        BufferedWriter bw2 = new BufferedWriter(new FileWriter(histogramsFile1));
        File histogramsFile2 = new File(peptideFile.getParent(), Util.appendSuffix(peptideFile.getName(), "_mod_histograms"));
        BufferedWriter bw3 = new BufferedWriter(new FileWriter(histogramsFile2));
        BufferedReader br = new BufferedReader(new FileReader(peptideFile));
        String line = br.readLine();
        HashMap<Double, Integer> nTargetFP = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nDecoy = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nTarget = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nTargetFPModified = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nDecoyModified = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nTargetModified = new HashMap<Double, Integer>();
        ArrayList<Double> scores = new ArrayList<Double>();
        try {
            bw.write(line + separator + "contaminant" + separator + "pfu");
            bw.newLine();
            bw1.write(line);
            bw1.newLine();
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                String[] splittedLine = line.split(separator);
                String[] accessions = splittedLine[1].split("; ");
                boolean contaminant = false;
                boolean pfu = false;
                boolean decoy = false;
                for (String accession : accessions) {
                    Header header = sequenceFactory.getHeader(accession);
                    String description = header.getDescription().toLowerCase();
                    if (description.contains("keratin") || description.contains("trypsin")) {
                        contaminant = true;
                    }
                    if (description.contains("pyrococcus")) {
                        pfu = true;
                    }
                    if (sequenceFactory.isDecoyAccession(accession)) {
                        decoy = true;
                        if (!pfu) continue;
                        bw1.write(line);
                        bw1.newLine();
                        continue;
                    }
                    if (!decoy) continue;
                    bw1.write(line);
                    bw1.newLine();
                }
                boolean modified = !splittedLine[6].trim().equals("");
                bw.write(line + contaminant + separator + pfu);
                bw.newLine();
                double score = new Double(splittedLine[11]);
                if (!scores.contains(score)) {
                    scores.add(score);
                }
                if (!modified) {
                    if (decoy) {
                        if (nDecoy.containsKey(score)) {
                            nDecoy.put(score, (Integer)nDecoy.get(score) + 1);
                            continue;
                        }
                        nDecoy.put(score, 1);
                        continue;
                    }
                    if (nTarget.containsKey(score)) {
                        nTarget.put(score, (Integer)nTarget.get(score) + 1);
                    } else {
                        nTarget.put(score, 1);
                    }
                    if (pfu || contaminant) continue;
                    if (nTargetFP.containsKey(score)) {
                        nTargetFP.put(score, (Integer)nTargetFP.get(score) + 1);
                        continue;
                    }
                    nTargetFP.put(score, 1);
                    continue;
                }
                if (decoy) {
                    if (nDecoyModified.containsKey(score)) {
                        nDecoyModified.put(score, (Integer)nDecoyModified.get(score) + 1);
                        continue;
                    }
                    nDecoyModified.put(score, 1);
                    continue;
                }
                if (nTargetModified.containsKey(score)) {
                    nTargetModified.put(score, (Integer)nTargetModified.get(score) + 1);
                } else {
                    nTargetModified.put(score, 1);
                }
                if (pfu || contaminant) continue;
                if (nTargetFPModified.containsKey(score)) {
                    nTargetFPModified.put(score, (Integer)nTargetFPModified.get(score) + 1);
                    continue;
                }
                nTargetFPModified.put(score, 1);
            }
            bw2.write("score\t# decoy\t# FP\t# target");
            bw2.newLine();
            bw3.write("score\t# decoy\t# FP\t# target");
            bw3.newLine();
            Collections.sort(scores, Collections.reverseOrder());
            Iterator i$ = scores.iterator();
            while (i$.hasNext()) {
                double score = (Double)i$.next();
                bw2.write(score + separator);
                if (nDecoy.containsKey(score)) {
                    bw2.write(nDecoy.get(score) + separator);
                } else {
                    bw2.write("0\t");
                }
                if (nTargetFP.containsKey(score)) {
                    bw2.write(nTargetFP.get(score) + separator);
                } else {
                    bw2.write("0\t");
                }
                if (nTarget.containsKey(score)) {
                    bw2.write(nTarget.get(score) + separator);
                } else {
                    bw2.write("0\t");
                }
                bw2.newLine();
                bw3.write(score + separator);
                if (nDecoyModified.containsKey(score)) {
                    bw3.write(nDecoyModified.get(score) + separator);
                } else {
                    bw3.write("0\t");
                }
                if (nTargetFPModified.containsKey(score)) {
                    bw3.write(nTargetFPModified.get(score) + separator);
                } else {
                    bw3.write("0\t");
                }
                if (nTargetModified.containsKey(score)) {
                    bw3.write(nTargetModified.get(score) + separator);
                } else {
                    bw3.write("0\t");
                }
                bw3.newLine();
            }
        }
        finally {
            br.close();
            bw.close();
            bw1.close();
            bw2.close();
            bw3.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPsmFile(File psmFile) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        File newFile = new File(psmFile.getParent(), Util.appendSuffix(psmFile.getName(), "_processed"));
        BufferedWriter bw = new BufferedWriter(new FileWriter(newFile));
        File conflictFile = new File(psmFile.getParent(), Util.appendSuffix(psmFile.getName(), "_conflict"));
        BufferedWriter bw1 = new BufferedWriter(new FileWriter(conflictFile));
        File histogramsFile1 = new File(psmFile.getParent(), Util.appendSuffix(psmFile.getName(), "_2_histograms"));
        BufferedWriter bw2 = new BufferedWriter(new FileWriter(histogramsFile1));
        File histogramsFile2 = new File(psmFile.getParent(), Util.appendSuffix(psmFile.getName(), "_3_histograms"));
        BufferedWriter bw3 = new BufferedWriter(new FileWriter(histogramsFile2));
        File histogramsFile3 = new File(psmFile.getParent(), Util.appendSuffix(psmFile.getName(), "_more_histograms"));
        BufferedWriter bw4 = new BufferedWriter(new FileWriter(histogramsFile3));
        BufferedReader br = new BufferedReader(new FileReader(psmFile));
        String line = br.readLine();
        HashMap<Double, Integer> nTargetFP = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nDecoy = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nTarget = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nTargetFP2 = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nDecoy2 = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nTarget2 = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nTargetFP3 = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nDecoy3 = new HashMap<Double, Integer>();
        HashMap<Double, Integer> nTarget3 = new HashMap<Double, Integer>();
        ArrayList<Double> scores = new ArrayList<Double>();
        try {
            bw.write(line + separator + "contaminant" + separator + "pfu");
            bw.newLine();
            bw1.write(line);
            bw1.newLine();
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                String[] splittedLine = line.split(separator);
                String[] accessions = splittedLine[1].split(", ");
                boolean contaminant = false;
                boolean pfu = false;
                boolean decoy = false;
                for (String accession : accessions) {
                    Header header = sequenceFactory.getHeader(accession);
                    String description = header.getDescription().toLowerCase();
                    if (description.contains("keratin") || description.contains("trypsin")) {
                        contaminant = true;
                    }
                    if (description.contains("pyrococcus")) {
                        pfu = true;
                    }
                    if (sequenceFactory.isDecoyAccession(accession)) {
                        decoy = true;
                        if (!pfu) continue;
                        bw1.write(line);
                        bw1.newLine();
                        continue;
                    }
                    if (!decoy) continue;
                    bw1.write(line);
                    bw1.newLine();
                }
                boolean charge2 = splittedLine[14].trim().equals("2+");
                boolean charge3 = splittedLine[14].trim().equals("3+");
                bw.write(line + contaminant + separator + pfu);
                bw.newLine();
                double score = new Double(splittedLine[18]);
                if (!scores.contains(score)) {
                    scores.add(score);
                }
                if (charge2) {
                    if (decoy) {
                        if (nDecoy2.containsKey(score)) {
                            nDecoy2.put(score, (Integer)nDecoy2.get(score) + 1);
                            continue;
                        }
                        nDecoy2.put(score, 1);
                        continue;
                    }
                    if (nTarget2.containsKey(score)) {
                        nTarget2.put(score, (Integer)nTarget2.get(score) + 1);
                    } else {
                        nTarget2.put(score, 1);
                    }
                    if (pfu || contaminant) continue;
                    if (nTargetFP2.containsKey(score)) {
                        nTargetFP2.put(score, (Integer)nTargetFP2.get(score) + 1);
                        continue;
                    }
                    nTargetFP2.put(score, 1);
                    continue;
                }
                if (charge3) {
                    if (decoy) {
                        if (nDecoy3.containsKey(score)) {
                            nDecoy3.put(score, (Integer)nDecoy3.get(score) + 1);
                            continue;
                        }
                        nDecoy3.put(score, 1);
                        continue;
                    }
                    if (nTarget3.containsKey(score)) {
                        nTarget3.put(score, (Integer)nTarget3.get(score) + 1);
                    } else {
                        nTarget3.put(score, 1);
                    }
                    if (pfu || contaminant) continue;
                    if (nTargetFP3.containsKey(score)) {
                        nTargetFP3.put(score, (Integer)nTargetFP3.get(score) + 1);
                        continue;
                    }
                    nTargetFP3.put(score, 1);
                    continue;
                }
                if (decoy) {
                    if (nDecoy.containsKey(score)) {
                        nDecoy.put(score, (Integer)nDecoy.get(score) + 1);
                        continue;
                    }
                    nDecoy.put(score, 1);
                    continue;
                }
                if (nTarget.containsKey(score)) {
                    nTarget.put(score, (Integer)nTarget.get(score) + 1);
                } else {
                    nTarget.put(score, 1);
                }
                if (pfu || contaminant) continue;
                if (nTargetFP.containsKey(score)) {
                    nTargetFP.put(score, (Integer)nTargetFP.get(score) + 1);
                    continue;
                }
                nTargetFP.put(score, 1);
            }
            bw2.write("score\t# decoy\t# FP\t# target");
            bw2.newLine();
            bw3.write("score\t# decoy\t# FP\t# target");
            bw3.newLine();
            bw4.write("score\t# decoy\t# FP\t# target");
            bw4.newLine();
            Collections.sort(scores, Collections.reverseOrder());
            Iterator i$ = scores.iterator();
            while (i$.hasNext()) {
                double score = (Double)i$.next();
                bw2.write(score + separator);
                if (nDecoy2.containsKey(score)) {
                    bw2.write(nDecoy2.get(score) + separator);
                } else {
                    bw2.write("0\t");
                }
                if (nTargetFP2.containsKey(score)) {
                    bw2.write(nTargetFP2.get(score) + separator);
                } else {
                    bw2.write("0\t");
                }
                if (nTarget2.containsKey(score)) {
                    bw2.write(nTarget2.get(score) + "");
                } else {
                    bw2.write("0");
                }
                bw2.newLine();
                bw3.write(score + separator);
                if (nDecoy3.containsKey(score)) {
                    bw3.write(nDecoy3.get(score) + separator);
                } else {
                    bw3.write("0\t");
                }
                if (nTargetFP3.containsKey(score)) {
                    bw3.write(nTargetFP3.get(score) + separator);
                } else {
                    bw3.write("0\t");
                }
                if (nTarget3.containsKey(score)) {
                    bw3.write(nTarget3.get(score) + "");
                } else {
                    bw3.write("0");
                }
                bw3.newLine();
                bw4.write(score + separator);
                if (nDecoy.containsKey(score)) {
                    bw4.write(nDecoy.get(score) + separator);
                } else {
                    bw4.write("0\t");
                }
                if (nTargetFP.containsKey(score)) {
                    bw4.write(nTargetFP.get(score) + separator);
                } else {
                    bw4.write("0\t");
                }
                if (nTarget.containsKey(score)) {
                    bw4.write(nTarget.get(score) + "");
                } else {
                    bw4.write("0");
                }
                bw4.newLine();
            }
        }
        finally {
            br.close();
            bw.close();
            bw1.close();
            bw2.close();
            bw3.close();
            bw4.close();
        }
    }
}

