/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db;

import com.compomics.util.Util;
import com.compomics.util.db.DerbyUtil;
import com.compomics.util.db.ObjectsCache;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.sql.rowset.serial.SerialBlob;

public class ObjectsDB
implements Serializable {
    static final long serialVersionUID = -8595805180622832745L;
    private String dbName;
    private String path;
    private Connection dbConnection;
    public static final int TABLE_NAME_MAX_LENGTH = 128;
    public static final int VARCHAR_MAX_LENGTH = 32672;
    public static final int MAX_KEY_LENGTH = 1000;
    private ArrayList<String> longKeys = new ArrayList();
    private ArrayList<String> longTableNames = new ArrayList();
    private HashMap<String, ArrayList<String>> longKeysMap = new HashMap();
    public static final String LONG_KEY_PREFIX = "long_key_";
    public static final String LONG_TABLE_NAMES = "long_tables";
    public static final String LONG_KEY_TABLE = "long_key_table";
    private ObjectsCache objectsCache;
    private BufferedWriter debugSpeedWriter;
    private BufferedWriter debugContentWriter;
    private File debugFolder;
    private boolean busy = false;
    private String tableQueueUpdating = "";
    private ArrayList<String> tableQueue = new ArrayList();
    private HashMap<String, ArrayList<String>> contentQueue = new HashMap();
    private ArrayList<String> contentTableQueue = new ArrayList();
    private boolean debugSpeed = false;
    private boolean debugContent = false;
    private boolean debugInteractions = false;
    private boolean useSQLite = false;
    public static final String derbyConnectionID = "objectsDB";

    public ObjectsDB(String folder, String dbName, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException {
        this.dbName = dbName;
        objectsCache.addDb(this);
        this.establishConnection(folder, deleteOldDatabase, objectsCache);
    }

    public String getName() {
        if (this.dbName == null) {
            this.dbName = "old_idDB";
        }
        return this.dbName;
    }

    public ObjectsCache getObjectsCache() {
        return this.objectsCache;
    }

    public void setObjectCache(ObjectsCache objectCache) {
        this.objectsCache = objectCache;
        objectCache.addDb(this);
    }

    public void addTable(String tableName) throws SQLException {
        if (this.debugInteractions) {
            System.out.println("Inserting table, table: " + tableName);
        }
        Statement stmt = this.dbConnection.createStatement();
        try {
            stmt.execute("CREATE table " + tableName + " (" + "NAME VARCHAR(" + 32672 + ") PRIMARY KEY," + "MATCH_BLOB blob" + ")");
        }
        catch (SQLException e) {
            System.out.println("An error occurred while creating table " + tableName);
            throw e;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTable(String tableName) throws SQLException {
        DatabaseMetaData dmd = this.dbConnection.getMetaData();
        boolean result = false;
        ResultSet rs = dmd.getTables(null, null, tableName.toUpperCase(), null);
        try {
            result = rs.next();
        }
        finally {
            rs.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertObject(String tableName, String objectKey, Object object, boolean inCache) throws SQLException, IOException, InterruptedException {
        String correctedKey = this.correctKey(tableName, objectKey);
        if (inCache) {
            this.objectsCache.addObject(this.dbName, tableName, correctedKey, object, true);
        } else {
            if (this.debugInteractions) {
                System.out.println("Inserting single object, table: " + tableName + ", key: " + objectKey);
            }
            PreparedStatement ps = this.dbConnection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?)");
            ps.setString(1, correctedKey);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            try {
                oos.writeObject(object);
            }
            finally {
                oos.close();
                bos.close();
            }
            ps.setBytes(2, bos.toByteArray());
            ps.executeUpdate();
        }
    }

    public void insertObjects(String tableName, HashMap<String, Object> objects, WaitingHandler waitingHandler) throws SQLException, IOException {
        this.insertObjects(tableName, objects, waitingHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertObjects(String tableName, HashMap<String, Object> objects, WaitingHandler waitingHandler, boolean allNewObjects) throws SQLException, IOException {
        if (this.debugInteractions) {
            System.out.println("Preparing table insertion: " + tableName);
        }
        PreparedStatement insertStatement = this.dbConnection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?)");
        try {
            PreparedStatement updateStatement = this.dbConnection.prepareStatement("UPDATE " + tableName + " SET MATCH_BLOB=? WHERE NAME=?");
            try {
                this.dbConnection.setAutoCommit(false);
                ArrayList<Object> tableContent = new ArrayList();
                if (!allNewObjects) {
                    tableContent = this.tableContent(tableName);
                }
                int rowCounter = 0;
                for (String objectKey : objects.keySet()) {
                    String correctedKey = this.correctKey(tableName, objectKey);
                    if (this.debugContent) {
                        if (this.debugInteractions) {
                            System.out.println("Inserting batch of objects, table: " + tableName + ", key: " + objectKey);
                        }
                        File debugObjectFile = new File(this.debugFolder, "debugMatch");
                        FileOutputStream fos = new FileOutputStream(debugObjectFile);
                        BufferedOutputStream debugBos = new BufferedOutputStream(fos);
                        ObjectOutputStream debugOos = new ObjectOutputStream(debugBos);
                        debugOos.writeObject(objects.get(objectKey));
                        debugOos.close();
                        debugBos.close();
                        fos.close();
                        long size = debugObjectFile.length();
                        this.debugContentWriter.write(tableName + "\t" + objectKey + "\t" + size + "\n");
                        this.debugContentWriter.flush();
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        ObjectOutputStream oos = new ObjectOutputStream(bos);
                        try {
                            oos.writeObject(objects.get(objectKey));
                            if (!allNewObjects && tableContent.contains(objectKey)) {
                                updateStatement.setString(2, correctedKey);
                                updateStatement.setBytes(1, bos.toByteArray());
                                updateStatement.addBatch();
                            } else {
                                insertStatement.setString(1, correctedKey);
                                insertStatement.setBytes(2, bos.toByteArray());
                                insertStatement.addBatch();
                            }
                            if (++rowCounter % this.objectsCache.getBatchSize() == 0) {
                                updateStatement.executeBatch();
                                insertStatement.executeBatch();
                                updateStatement.clearParameters();
                                insertStatement.clearParameters();
                                this.dbConnection.commit();
                                rowCounter = 0;
                            }
                        }
                        finally {
                            oos.close();
                        }
                    }
                    finally {
                        bos.close();
                    }
                    if (waitingHandler == null) continue;
                    waitingHandler.increaseSecondaryProgressCounter();
                    if (!waitingHandler.isRunCanceled()) continue;
                    break;
                }
                if (waitingHandler == null || !waitingHandler.isRunCanceled()) {
                    updateStatement.executeBatch();
                    insertStatement.executeBatch();
                    updateStatement.clearParameters();
                    insertStatement.clearParameters();
                    this.dbConnection.commit();
                }
                this.dbConnection.setAutoCommit(true);
            }
            finally {
                updateStatement.close();
            }
        }
        finally {
            insertStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadObjects(String tableName, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        block18: {
            if (!this.busy && (this.tableQueue.isEmpty() || this.tableQueue.indexOf(tableName) == 0)) {
                ResultSet results;
                if (this.debugInteractions) {
                    System.out.println("getting table objects, table: " + tableName);
                }
                if (waitingHandler != null) {
                    waitingHandler.setSecondaryProgressCounterIndeterminate(true);
                    Statement rowCountStatement = this.dbConnection.createStatement();
                    results = rowCountStatement.executeQuery("select count(*) from " + tableName);
                    results.next();
                    Integer numberOfRows = results.getInt(1);
                    waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                    waitingHandler.setSecondaryProgressCounter(0);
                    waitingHandler.setMaxSecondaryProgressCounter(numberOfRows);
                }
                this.busy = true;
                try {
                    Statement stmt = this.dbConnection.createStatement();
                    try {
                        results = stmt.executeQuery("select * from " + tableName);
                        try {
                            while (results.next()) {
                                Blob tempBlob;
                                String key;
                                if (waitingHandler != null) {
                                    waitingHandler.increaseSecondaryProgressCounter();
                                    if (waitingHandler.isRunCanceled()) break;
                                }
                                if (this.objectsCache.inCache(this.dbName, tableName, key = results.getString(1))) continue;
                                if (this.useSQLite) {
                                    byte[] bytes = results.getBytes(2);
                                    tempBlob = new SerialBlob(bytes);
                                } else {
                                    tempBlob = results.getBlob(2);
                                }
                                BufferedInputStream bis = new BufferedInputStream(tempBlob.getBinaryStream());
                                ObjectInputStream in = new ObjectInputStream(bis);
                                Object object = in.readObject();
                                in.close();
                                this.objectsCache.addObject(this.dbName, tableName, key, object, false);
                            }
                            this.tableQueue.remove(tableName);
                            break block18;
                        }
                        finally {
                            results.close();
                        }
                    }
                    finally {
                        stmt.close();
                    }
                }
                finally {
                    this.busy = false;
                }
            }
            if (!this.tableQueue.contains(tableName)) {
                this.tableQueue.add(tableName);
            }
            while (this.busy) {
                this.wait(11L);
            }
            this.loadObjects(tableName, waitingHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadObjects(String tableName, ArrayList<String> keys, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (!this.busy && (this.contentTableQueue.isEmpty() || this.contentTableQueue.indexOf(tableName) == 0)) {
            if (this.debugInteractions) {
                System.out.println("getting " + keys.size() + " objects, table: " + tableName);
            }
            boolean concurrentAccess = this.tableQueueUpdating.equals(tableName);
            ArrayList<Object> queue = new ArrayList();
            if (!concurrentAccess && this.contentQueue.get(tableName) != null) {
                queue = this.contentQueue.get(tableName);
                this.contentTableQueue.remove(tableName);
                this.contentQueue.remove(tableName);
            }
            if (!keys.equals(queue)) {
                for (String key : keys) {
                    if (queue.contains(key)) continue;
                    queue.add(key);
                }
            }
            ArrayList<String> toLoad = new ArrayList<String>();
            for (String string : queue) {
                String correctedKey = this.correctKey(tableName, string);
                if (this.objectsCache == null || this.objectsCache.inCache(this.dbName, tableName, correctedKey)) continue;
                toLoad.add(correctedKey);
            }
            if (!toLoad.isEmpty()) {
                this.busy = true;
                try {
                    Statement stmt = this.dbConnection.createStatement();
                    try {
                        ResultSet resultSet = stmt.executeQuery("select * from " + tableName);
                        try {
                            int found = 0;
                            while (resultSet.next() && found < toLoad.size()) {
                                String key = resultSet.getString(1);
                                if (toLoad.contains(key)) {
                                    Blob tempBlob;
                                    ++found;
                                    if (this.useSQLite) {
                                        byte[] bytes = resultSet.getBytes(2);
                                        tempBlob = new SerialBlob(bytes);
                                    } else {
                                        tempBlob = resultSet.getBlob(2);
                                    }
                                    BufferedInputStream bis = new BufferedInputStream(tempBlob.getBinaryStream());
                                    ObjectInputStream in = new ObjectInputStream(bis);
                                    try {
                                        Object object = in.readObject();
                                        this.objectsCache.addObject(this.dbName, tableName, key, object, false);
                                    }
                                    finally {
                                        in.close();
                                        bis.close();
                                    }
                                    if (waitingHandler != null) {
                                        waitingHandler.increaseSecondaryProgressCounter();
                                    }
                                }
                                if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                                break;
                            }
                        }
                        finally {
                            resultSet.close();
                        }
                    }
                    finally {
                        stmt.close();
                    }
                }
                finally {
                    this.busy = false;
                }
            }
        } else {
            this.tableQueueUpdating = tableName;
            if (!this.contentTableQueue.contains(tableName)) {
                this.contentTableQueue.add(tableName);
                this.contentQueue.put(tableName, keys);
            } else if (keys.equals(this.contentQueue.get(tableName))) {
                while (this.busy) {
                    this.wait(7L);
                }
                this.loadObjects(tableName, keys, waitingHandler);
            } else {
                ArrayList<String> queue = this.contentQueue.get(tableName);
                for (String newItem : keys) {
                    if (queue.contains(newItem)) continue;
                    queue.add(newItem);
                }
            }
            this.tableQueueUpdating = "";
        }
    }

    public Object retrieveObject(String tableName, String objectKey, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.retrieveObject(tableName, objectKey, useDB, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object retrieveObject(String tableName, String objectKey, boolean useDB, boolean useCache) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        block21: {
            String correctedKey = this.correctKey(tableName, objectKey);
            Object object = null;
            if (this.objectsCache != null) {
                object = this.objectsCache.getObject(this.dbName, tableName, correctedKey);
            }
            if (!useDB || object != null) {
                return object;
            }
            if (this.debugInteractions) {
                System.out.println("Retrieving object, table: " + tableName + ", key: " + objectKey);
            }
            if (this.dbConnection == null) {
                return object;
            }
            long start = System.currentTimeMillis();
            Statement stmt = this.dbConnection.createStatement();
            try {
                ResultSet results = stmt.executeQuery("select MATCH_BLOB from " + tableName + " where NAME='" + correctedKey + "'");
                try {
                    Blob tempBlob;
                    if (!results.next()) break block21;
                    if (this.useSQLite) {
                        byte[] bytes = results.getBytes(1);
                        tempBlob = new SerialBlob(bytes);
                    } else {
                        tempBlob = results.getBlob(1);
                    }
                    BufferedInputStream bis = new BufferedInputStream(tempBlob.getBinaryStream());
                    try {
                        ObjectInputStream in = new ObjectInputStream(bis);
                        try {
                            object = in.readObject();
                        }
                        finally {
                            in.close();
                        }
                    }
                    finally {
                        bis.close();
                    }
                    if (useCache) {
                        this.objectsCache.addObject(this.dbName, tableName, objectKey, object, false);
                    }
                    if (this.debugSpeed) {
                        long loaded = System.currentTimeMillis();
                        File debugObjectFile = new File(this.debugFolder, "debugMatch");
                        FileOutputStream fos = new FileOutputStream(debugObjectFile);
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        ObjectOutputStream oos = new ObjectOutputStream(bos);
                        oos.writeObject(object);
                        oos.close();
                        bos.close();
                        fos.close();
                        long written = System.currentTimeMillis();
                        FileInputStream fis = new FileInputStream(debugObjectFile);
                        bis = new BufferedInputStream(fis);
                        ObjectInputStream in = new ObjectInputStream(bis);
                        Object match = in.readObject();
                        fis.close();
                        bis.close();
                        in.close();
                        long read = System.currentTimeMillis();
                        long size = debugObjectFile.length();
                        long queryTime = loaded - start;
                        long serializationTime = written - loaded;
                        long deserializationTime = read - written;
                        this.debugSpeedWriter.write(tableName + "\t" + objectKey + "\t" + queryTime + "\t" + serializationTime + "\t" + deserializationTime + "\t" + size + "\n");
                    }
                    Object object2 = object;
                    return object2;
                }
                finally {
                    results.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inDB(String tableName, String objectKey, boolean cache) throws SQLException {
        String correctedKey = this.correctKey(tableName, objectKey);
        if (cache && this.objectsCache.inCache(this.dbName, tableName, correctedKey)) {
            return true;
        }
        if (this.debugInteractions) {
            System.out.println("checking db content, table: " + tableName + ", key: " + objectKey);
        }
        Statement stmt = this.dbConnection.createStatement();
        boolean result = false;
        try {
            ResultSet results = stmt.executeQuery("select * from " + tableName + " where NAME='" + correctedKey + "'");
            try {
                result = results.next();
            }
            finally {
                results.close();
            }
        }
        finally {
            stmt.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> tableContent(String tableName) throws SQLException {
        if (this.debugInteractions) {
            System.out.println("checking db content, table: " + tableName);
        }
        ArrayList<String> tableContent = new ArrayList<String>();
        Statement stmt = this.dbConnection.createStatement();
        try {
            ResultSet results = stmt.executeQuery("select * from " + tableName);
            try {
                while (results.next()) {
                    String key = results.getString(1);
                    if (key.startsWith(LONG_KEY_PREFIX)) {
                        key = this.getOriginalKey(tableName, key);
                    }
                    tableContent.add(key);
                }
            }
            finally {
                results.close();
            }
        }
        finally {
            stmt.close();
        }
        return tableContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> tableContentAsSet(String tableName) throws SQLException {
        if (this.debugInteractions) {
            System.out.println("checking db content, table: " + tableName);
        }
        HashSet<String> tableContent = new HashSet<String>();
        Statement stmt = this.dbConnection.createStatement();
        try {
            ResultSet results = stmt.executeQuery("select * from " + tableName);
            try {
                while (results.next()) {
                    String key = results.getString(1);
                    if (key.startsWith(LONG_KEY_PREFIX)) {
                        key = this.getOriginalKey(tableName, key);
                    }
                    tableContent.add(key);
                }
            }
            finally {
                results.close();
            }
        }
        finally {
            stmt.close();
        }
        return tableContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(String tableName, String objectKey) throws SQLException, IOException {
        String correctedKey = this.correctKey(tableName, objectKey);
        this.objectsCache.removeObject(this.dbName, tableName, correctedKey);
        if (this.debugInteractions) {
            System.out.println("Removing object, table: " + tableName + ", key: " + objectKey);
        }
        Statement stmt = this.dbConnection.createStatement();
        try {
            stmt.executeUpdate("delete from " + tableName + " where NAME='" + correctedKey + "'");
        }
        finally {
            stmt.close();
        }
    }

    public void updateObject(String tableName, String objectKey, Object object) throws SQLException, IOException {
        this.updateObject(tableName, objectKey, object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(String tableName, String objectKey, Object object, boolean cache) throws SQLException, IOException {
        String correctedKey = this.correctKey(tableName, objectKey);
        boolean cacheUpdated = false;
        if (cache) {
            cacheUpdated = this.objectsCache.updateObject(this.dbName, tableName, correctedKey, object);
        }
        if (!cacheUpdated) {
            if (this.debugInteractions) {
                System.out.println("Updating object, table: " + tableName + ", key: " + objectKey);
            }
            PreparedStatement ps = this.dbConnection.prepareStatement("update " + tableName + " set MATCH_BLOB=? where NAME='" + objectKey + "'");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                try {
                    oos.writeObject(object);
                }
                finally {
                    oos.close();
                }
            }
            finally {
                bos.close();
            }
            ps.setBytes(1, bos.toByteArray());
            ps.executeUpdate();
        }
    }

    private void loadLongKeys() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (this.hasTable(LONG_KEY_TABLE)) {
            this.longTableNames = (ArrayList)this.retrieveObject(LONG_KEY_TABLE, LONG_TABLE_NAMES, true, false);
            this.longKeysMap = (HashMap)this.retrieveObject(LONG_KEY_TABLE, LONG_KEY_PREFIX, true, false);
        }
    }

    private void saveLongKeys() throws SQLException, IOException, InterruptedException {
        if (!this.hasTable(LONG_KEY_TABLE)) {
            this.addTable(LONG_KEY_TABLE);
        }
        if (this.inDB(LONG_KEY_TABLE, LONG_TABLE_NAMES, false)) {
            this.updateObject(LONG_KEY_TABLE, LONG_TABLE_NAMES, this.longTableNames, false);
        } else {
            this.insertObject(LONG_KEY_TABLE, LONG_TABLE_NAMES, this.longTableNames, false);
        }
        if (this.inDB(LONG_KEY_TABLE, LONG_KEY_PREFIX, false)) {
            this.updateObject(LONG_KEY_TABLE, LONG_KEY_PREFIX, this.longKeysMap, false);
        } else {
            this.insertObject(LONG_KEY_TABLE, LONG_KEY_PREFIX, this.longKeysMap, false);
        }
    }

    public void close() throws SQLException {
        boolean connectionActive;
        block10: {
            if (this.dbConnection != null) {
                try {
                    this.saveLongKeys();
                }
                catch (Exception e) {
                    if (this.dbConnection == null) break block10;
                    e.printStackTrace();
                }
            }
        }
        this.objectsCache = null;
        boolean bl = connectionActive = this.path != null && DerbyUtil.isActiveConnection(derbyConnectionID, this.path);
        if (this.dbConnection != null && connectionActive) {
            this.dbConnection.close();
            DerbyUtil.removeActiveConnection(derbyConnectionID, this.path);
        }
        if (this.debugSpeed && this.debugSpeedWriter != null) {
            try {
                this.debugSpeedWriter.close();
                this.debugSpeedWriter = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.debugContent && this.debugContentWriter != null) {
            try {
                this.debugContentWriter.close();
                this.debugContentWriter = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dbConnection = null;
    }

    public void establishConnection(String aDbFolder, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException {
        File parentFolder = new File(aDbFolder);
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        File dbFolder = new File(aDbFolder, this.dbName);
        this.path = dbFolder.getAbsolutePath();
        if (dbFolder.exists() && deleteOldDatabase) {
            this.close();
            DerbyUtil.closeConnection();
            boolean deleted = Util.deleteDir(dbFolder);
            if (!deleted) {
                System.out.println("Failed to delete db folder: " + dbFolder.getPath());
            }
        }
        if (this.useSQLite) {
            try {
                Class.forName("org.sqlite.JDBC");
                this.dbConnection = DriverManager.getConnection("jdbc:sqlite:" + this.path);
            }
            catch (SQLException e) {
                this.useSQLite = false;
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        if (!this.useSQLite) {
            if (DerbyUtil.isActiveConnection(this.path)) {
                throw new IllegalArgumentException("Impossible to establish a Derby connection in " + this.path + ", connection to the folder already active.");
            }
            String url = "jdbc:derby:" + this.path + ";create=true";
            this.dbConnection = DriverManager.getConnection(url);
            DerbyUtil.addActiveConnection(derbyConnectionID, this.path);
        }
        this.objectsCache = objectsCache;
        if (this.debugSpeed) {
            try {
                this.debugFolder = new File(aDbFolder);
                this.debugSpeedWriter = new BufferedWriter(new FileWriter(new File(parentFolder, "dbSpeed.txt")));
                this.debugSpeedWriter.write("Table\tkey\tQuery time\tSerialization time\tDeserialization time\tsize\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.debugContent) {
            try {
                this.debugFolder = new File(aDbFolder);
                String tempFileName = "dbContent.txt";
                int counter = 1;
                while (new File(parentFolder, tempFileName).exists()) {
                    tempFileName = "dbContent" + counter++ + ".txt";
                }
                this.debugContentWriter = new BufferedWriter(new FileWriter(new File(parentFolder, tempFileName)));
                this.debugContentWriter.write("Table\tkey\tsize\n");
                this.debugContentWriter.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.loadLongKeys();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void compatibilityCheck() {
        if (this.longTableNames == null) {
            this.longTableNames = new ArrayList<String>(this.longKeys);
            this.longKeysMap = new HashMap();
        }
    }

    public String correctTableName(String tableName) {
        tableName = "\"" + tableName + "\"";
        this.compatibilityCheck();
        if (this.longTableNames.contains(tableName)) {
            tableName = "\"" + this.longTableNames.indexOf(tableName) + "\"";
        } else if (tableName.length() >= 128) {
            int index = this.longTableNames.size();
            this.longTableNames.add(tableName);
            tableName = "\"" + index + "\"";
        }
        if (tableName.length() >= 128 && !tableName.startsWith(LONG_KEY_PREFIX)) {
            throw new IllegalArgumentException("Table name " + tableName + " is too long to be stored in the database.");
        }
        return tableName;
    }

    public String correctKey(String tableName, String key) {
        String correctedKey = key;
        this.compatibilityCheck();
        if (!correctedKey.startsWith(LONG_KEY_PREFIX)) {
            if (this.longKeysMap.containsKey(tableName) && this.longKeysMap.get(tableName).contains(key)) {
                correctedKey = LONG_KEY_PREFIX + this.longKeysMap.get(tableName).indexOf(key);
            } else if (key.length() >= 1000) {
                if (!this.longKeysMap.containsKey(tableName)) {
                    this.longKeysMap.put(tableName, new ArrayList());
                }
                int index = this.longKeysMap.get(tableName).size();
                this.longKeysMap.get(tableName).add(key);
                correctedKey = LONG_KEY_PREFIX + index;
            }
        }
        if (correctedKey.length() >= 1000 && !correctedKey.startsWith(LONG_KEY_PREFIX)) {
            throw new IllegalArgumentException("Object key " + correctedKey + " is too long to be stored in the database.");
        }
        return correctedKey;
    }

    public String getOriginalKey(String tableName, String correctedKey) {
        String subKey = correctedKey.substring(LONG_KEY_PREFIX.length());
        this.compatibilityCheck();
        try {
            Integer index = new Integer(subKey);
            return this.longKeysMap.get(tableName).get(index);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("An error occurred when getting the original key of " + correctedKey + ".");
        }
    }
}

