/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.NeutralLoss;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class NeutralLossesMap
implements Serializable {
    static final long serialVersionUID = -4690159937753713106L;
    private HashMap<NeutralLoss, Integer> bBoundaries = new HashMap();
    private HashMap<NeutralLoss, Integer> yBoundaries = new HashMap();

    public void addNeutralLoss(NeutralLoss neutralLoss, int bStart, int yStart) {
        boolean found = false;
        for (NeutralLoss oldNeutralLoss : this.bBoundaries.keySet()) {
            if (!oldNeutralLoss.isSameAs(neutralLoss) || bStart >= this.bBoundaries.get(oldNeutralLoss)) continue;
            this.bBoundaries.put(oldNeutralLoss, bStart);
            found = true;
            break;
        }
        if (!found) {
            this.bBoundaries.put(neutralLoss, bStart);
        }
        found = false;
        for (NeutralLoss oldNeutralLoss : this.yBoundaries.keySet()) {
            if (!oldNeutralLoss.isSameAs(neutralLoss) || yStart >= this.yBoundaries.get(oldNeutralLoss)) continue;
            this.yBoundaries.put(oldNeutralLoss, yStart);
            found = true;
            break;
        }
        if (!found) {
            this.yBoundaries.put(neutralLoss, yStart);
        }
    }

    public void clearNeutralLosses() {
        this.bBoundaries.clear();
        this.yBoundaries.clear();
    }

    public void makeSequenceIndependant() {
        for (NeutralLoss neutralLoss : this.bBoundaries.keySet()) {
            this.bBoundaries.put(neutralLoss, 1);
            this.yBoundaries.put(neutralLoss, 1);
        }
    }

    public boolean isEmpty() {
        return this.bBoundaries.isEmpty();
    }

    public ArrayList<NeutralLoss> getAccountedNeutralLosses() {
        return new ArrayList<NeutralLoss>(this.bBoundaries.keySet());
    }

    public int getBStart(NeutralLoss neutralLoss) {
        return this.bBoundaries.get(neutralLoss);
    }

    public int getYStart(NeutralLoss neutralLoss) {
        return this.yBoundaries.get(neutralLoss);
    }

    public boolean containsLoss(NeutralLoss neutralLoss) {
        return this.bBoundaries.containsKey(neutralLoss);
    }
}

