/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.IdentificationAlgorithmParameter;

public class MsgfParameters
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -2656523093031942973L;
    private boolean searchDecoyDatabase = false;
    private int instrumentID = 0;
    private int fragmentationType = 0;
    private int protocol = 0;
    private Integer minPeptideLength = 6;
    private Integer maxPeptideLength = 30;
    private Integer numberOfSpectrumMarches = 1;
    private boolean additionalOutput = false;
    private Integer lowerIsotopeErrorRange = 0;
    private Integer upperIsotopeErrorRange = 1;
    private Integer numberTolerableTermini = 2;
    private Integer numberOfPtmsPerPeptide = 2;

    @Override
    public Advocate getAlgorithm() {
        return Advocate.msgf;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof MsgfParameters) {
            MsgfParameters msgfParameters = (MsgfParameters)identificationAlgorithmParameter;
            if (this.searchDecoyDatabase != msgfParameters.searchDecoyDatabase()) {
                return false;
            }
            if (this.instrumentID != msgfParameters.getInstrumentID()) {
                return false;
            }
            if (this.fragmentationType != msgfParameters.getFragmentationType()) {
                return false;
            }
            if (this.protocol != msgfParameters.getProtocol()) {
                return false;
            }
            if (this.minPeptideLength != msgfParameters.getMinPeptideLength()) {
                return false;
            }
            if (this.maxPeptideLength != msgfParameters.getMaxPeptideLength()) {
                return false;
            }
            if (this.numberOfSpectrumMarches != msgfParameters.getNumberOfSpectrumMatches()) {
                return false;
            }
            if (this.additionalOutput != msgfParameters.isAdditionalOutput()) {
                return false;
            }
            if (this.lowerIsotopeErrorRange != msgfParameters.getLowerIsotopeErrorRange()) {
                return false;
            }
            if (this.upperIsotopeErrorRange != msgfParameters.getUpperIsotopeErrorRange()) {
                return false;
            }
            if (this.numberTolerableTermini != msgfParameters.getNumberTolerableTermini()) {
                return false;
            }
            return this.numberOfPtmsPerPeptide == msgfParameters.getNumberOfPtmsPerPeptide();
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("SEARCH_DECOY=");
        output.append(this.searchDecoyDatabase);
        output.append(newLine);
        output.append("INSTRUMENT_ID=");
        output.append(this.instrumentID);
        output.append(newLine);
        output.append("FRAGMENTATION_ID=");
        output.append(this.fragmentationType);
        output.append(newLine);
        output.append("PROTOCOL_ID=");
        output.append(this.protocol);
        output.append(newLine);
        output.append("MIN_PEP_LENGTH=");
        output.append(this.minPeptideLength);
        output.append(newLine);
        output.append("MAX_PEP_LENGTH=");
        output.append(this.maxPeptideLength);
        output.append(newLine);
        output.append("NUMBER_SPECTRUM_MATCHES=");
        output.append(this.numberOfSpectrumMarches);
        output.append(newLine);
        output.append("ADDITIONAL_OUTPUT=");
        output.append(this.additionalOutput);
        output.append(newLine);
        output.append("LOWER_ISOTOPE_ERROR_RANGE=");
        output.append(this.lowerIsotopeErrorRange);
        output.append(newLine);
        output.append("UPPER_ISOTOPE_ERROR_RANGE=");
        output.append(this.upperIsotopeErrorRange);
        output.append(newLine);
        output.append("NUMBER_OF_TOLERABLE_TERMINI=");
        output.append(this.numberTolerableTermini);
        output.append(newLine);
        output.append("MAX_NUMBER_PTMS=");
        output.append(this.numberOfPtmsPerPeptide);
        output.append(newLine);
        return output.toString();
    }

    public boolean searchDecoyDatabase() {
        return this.searchDecoyDatabase;
    }

    public void setSearchDecoyDatabase(boolean searchDecoyDatabase) {
        this.searchDecoyDatabase = searchDecoyDatabase;
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public int getInstrumentID() {
        return this.instrumentID;
    }

    public void setInstrumentID(int instrumentID) {
        this.instrumentID = instrumentID;
    }

    public int getFragmentationType() {
        return this.fragmentationType;
    }

    public void setFragmentationType(int fragmentationType) {
        this.fragmentationType = fragmentationType;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public Integer getNumberOfSpectrumMarches() {
        return this.numberOfSpectrumMarches;
    }

    public Integer getNumberOfSpectrumMatches() {
        return this.numberOfSpectrumMarches;
    }

    public void setNumberOfSpectrumMarches(Integer numberOfSpectrumMarches) {
        this.numberOfSpectrumMarches = numberOfSpectrumMarches;
    }

    public boolean isAdditionalOutput() {
        return this.additionalOutput;
    }

    public void setAdditionalOutput(boolean additionalOutput) {
        this.additionalOutput = additionalOutput;
    }

    public Integer getLowerIsotopeErrorRange() {
        return this.lowerIsotopeErrorRange;
    }

    public void setLowerIsotopeErrorRange(Integer lowerIsotopeErrorRange) {
        this.lowerIsotopeErrorRange = lowerIsotopeErrorRange;
    }

    public Integer getUpperIsotopeErrorRange() {
        return this.upperIsotopeErrorRange;
    }

    public void setUpperIsotopeErrorRange(Integer upperIsotopeErrorRange) {
        this.upperIsotopeErrorRange = upperIsotopeErrorRange;
    }

    public Integer getNumberTolerableTermini() {
        return this.numberTolerableTermini;
    }

    public void setNumberTolerableTermini(Integer numberTolerableTermini) {
        this.numberTolerableTermini = numberTolerableTermini;
    }

    public Integer getNumberOfPtmsPerPeptide() {
        return this.numberOfPtmsPerPeptide;
    }

    public void setNumberOfPtmsPerPeptide(Integer numberOfPtmsPerPeptide) {
        this.numberOfPtmsPerPeptide = numberOfPtmsPerPeptide;
    }

    public static String enzymeMapping(Enzyme enzyme) {
        String msgfEnzymeIndex = null;
        String enzymeName = enzyme.getName();
        if (enzymeName.equalsIgnoreCase("No Enzyme")) {
            msgfEnzymeIndex = "0";
        } else if (enzymeName.equalsIgnoreCase("Trypsin")) {
            msgfEnzymeIndex = "1";
        } else if (enzymeName.equalsIgnoreCase("Chymotrypsin (FYWL)")) {
            msgfEnzymeIndex = "2";
        } else if (enzymeName.equalsIgnoreCase("Lys-C")) {
            msgfEnzymeIndex = "3";
        } else if (enzymeName.equalsIgnoreCase("Lys-N (K)")) {
            msgfEnzymeIndex = "4";
        } else if (enzymeName.equalsIgnoreCase("Glu-C (DE)")) {
            msgfEnzymeIndex = "5";
        } else if (enzymeName.equalsIgnoreCase("Arg-C")) {
            msgfEnzymeIndex = "6";
        } else if (enzymeName.equalsIgnoreCase("Asp-N")) {
            msgfEnzymeIndex = "7";
        } else if (enzymeName.equalsIgnoreCase("Top-Down") || enzymeName.equalsIgnoreCase("Whole Protein")) {
            msgfEnzymeIndex = "9";
        }
        return msgfEnzymeIndex;
    }
}

