/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.IdentificationAlgorithmParameter;

public class MyriMatchParameters
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = 8755937399680481097L;
    private Integer minPeptideLength = 6;
    private Integer maxPeptideLength = 30;
    private Integer numberOfSpectrumMarches = 1;

    @Override
    public Advocate getAlgorithm() {
        return Advocate.myriMatch;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof MyriMatchParameters) {
            MyriMatchParameters msgfParameters = (MyriMatchParameters)identificationAlgorithmParameter;
            if (this.minPeptideLength != msgfParameters.getMinPeptideLength()) {
                return false;
            }
            if (this.maxPeptideLength != msgfParameters.getMaxPeptideLength()) {
                return false;
            }
            return this.numberOfSpectrumMarches == msgfParameters.getNumberOfSpectrumMatches();
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("MIN_PEP_LENGTH=");
        output.append(this.minPeptideLength);
        output.append(newLine);
        output.append("MAX_PEP_LENGTH=");
        output.append(this.maxPeptideLength);
        output.append(newLine);
        output.append("NUMBER_SPECTRUM_MATCHES=");
        output.append(this.numberOfSpectrumMarches);
        output.append(newLine);
        return output.toString();
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public Integer getNumberOfSpectrumMatches() {
        return this.numberOfSpectrumMarches;
    }

    public void setNumberOfSpectrumMarches(Integer numberOfSpectrumMarches) {
        this.numberOfSpectrumMarches = numberOfSpectrumMarches;
    }
}

