/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.proteintree;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.identification.SequenceFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class Node
implements Serializable {
    static final long serialVersionUID = 8936868785405252371L;
    private int depth;
    private HashMap<String, ArrayList<Integer>> accessions = new HashMap();
    private HashMap<String, ArrayList<Integer>> termini = new HashMap();
    private HashMap<Character, Node> subtree = null;
    public static final int proteinBatchSize = 100;
    private boolean listening = true;

    public Node(int depth) {
        this.depth = depth;
    }

    public Node(int depth, HashMap<String, ArrayList<Integer>> accessions) {
        this.depth = depth;
        this.accessions = accessions;
    }

    public HashMap<String, HashMap<String, ArrayList<Integer>>> getProteinMapping(AminoAcidPattern query, String currentSequence, AminoAcidPattern.MatchingType matchingType, Double massTolerance, boolean limitXs) throws IOException, InterruptedException, ClassNotFoundException {
        HashMap<String, HashMap<String, ArrayList<Integer>>> result = new HashMap<String, HashMap<String, ArrayList<Integer>>>();
        if (this.depth == query.length()) {
            result.put(currentSequence, this.getAllMappings());
        } else if (this.accessions != null) {
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            HashMap<String, HashMap<String, ArrayList<Integer>>> indexes = new HashMap<String, HashMap<String, ArrayList<Integer>>>();
            for (String accession : this.accessions.keySet()) {
                Protein protein = sequenceFactory.getProtein(accession);
                indexes.put(accession, this.matchInProtein(protein, this.accessions.get(accession), query, matchingType, massTolerance));
            }
            for (String accession : indexes.keySet()) {
                for (String tempSequence : ((HashMap)indexes.get(accession)).keySet()) {
                    HashMap<String, ArrayList<Integer>> mapping = result.get(tempSequence);
                    if (mapping == null) {
                        mapping = new HashMap(1);
                        result.put(tempSequence, mapping);
                    }
                    mapping.put(accession, (ArrayList<Integer>)((HashMap)indexes.get(accession)).get(tempSequence));
                }
            }
        } else {
            for (char aa : this.getNextAminoAcids(query, matchingType, massTolerance)) {
                Node node = this.subtree.get(Character.valueOf(aa));
                if (node == null) continue;
                String newSequence = currentSequence + aa;
                double xShare = (double)Util.getOccurrence(newSequence, 'X') / (double)query.length();
                if (limitXs && !(xShare <= 0.25)) continue;
                result.putAll(node.getProteinMapping(query, newSequence, matchingType, massTolerance, limitXs));
            }
        }
        return result;
    }

    private ArrayList<Character> getNextAminoAcids(AminoAcidPattern peptideSequence, AminoAcidPattern.MatchingType matchingType, Double massTolerance) {
        ArrayList<Character> result = new ArrayList<Character>();
        for (AminoAcid aa : peptideSequence.getTargetedAA(this.depth)) {
            if (matchingType == AminoAcidPattern.MatchingType.string) {
                result.add(Character.valueOf(aa.singleLetterCode.charAt(0)));
                continue;
            }
            for (char aaChar : aa.getSubAminoAcids()) {
                if (result.contains(Character.valueOf(aaChar)) || peptideSequence.getExcludedAA(this.depth).contains(AminoAcid.getAminoAcid(aaChar))) continue;
                result.add(Character.valueOf(aaChar));
            }
            for (char aaChar : aa.getCombinations()) {
                if (result.contains(Character.valueOf(aaChar)) || peptideSequence.getExcludedAA(this.depth).contains(AminoAcid.getAminoAcid(aaChar))) continue;
                result.add(Character.valueOf(aaChar));
            }
            if (matchingType != AminoAcidPattern.MatchingType.indistiguishibleAminoAcids) continue;
            for (char aaChar : aa.getIndistinguishibleAminoAcids(massTolerance)) {
                if (result.contains(Character.valueOf(aaChar)) || peptideSequence.getExcludedAA(this.depth).contains(AminoAcid.getAminoAcid(aaChar))) continue;
                result.add(Character.valueOf(aaChar));
            }
        }
        return result;
    }

    public boolean splitNode(int maxNodeSize, int maxDepth) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException {
        if (this.accessions.size() > maxNodeSize && this.depth <= maxDepth) {
            this.subtree = new HashMap();
            for (String accession : this.accessions.keySet()) {
                HashMap<Character, ArrayList<Integer>> indexes = this.getAA(accession, this.accessions.get(accession), this.depth);
                if (indexes.isEmpty()) {
                    indexes = this.getAA(accession, this.accessions.get(accession), this.depth);
                }
                for (char aa : indexes.keySet()) {
                    if (!this.subtree.containsKey(Character.valueOf(aa))) {
                        this.subtree.put(Character.valueOf(aa), new Node(this.depth + 1));
                    }
                    Node node = this.subtree.get(Character.valueOf(aa));
                    node.addAccession(accession, indexes.get(Character.valueOf(aa)));
                }
            }
            this.accessions.clear();
            this.accessions = null;
            for (Node node : this.subtree.values()) {
                node.splitNode(maxNodeSize, maxDepth);
            }
            return true;
        }
        return false;
    }

    public void addAccession(String accession, ArrayList<Integer> indexes) {
        this.accessions.put(accession, indexes);
    }

    public long getSize() {
        if (this.accessions != null) {
            return this.accessions.size();
        }
        long result = 0L;
        for (Node node : this.subtree.values()) {
            result += node.getSize();
        }
        return result;
    }

    public HashMap<String, ArrayList<Integer>> getAccessions() {
        return this.accessions;
    }

    public HashMap<String, ArrayList<Integer>> getTermini() {
        return this.termini;
    }

    public HashMap<Character, Node> getSubtree() {
        return this.subtree;
    }

    public void clearAccessions() {
        this.accessions.clear();
    }

    public boolean isEmpty() {
        return this.subtree == null && this.accessions.isEmpty();
    }

    public int getDepth() {
        return this.depth;
    }

    public HashMap<String, ArrayList<Integer>> getAllMappings() throws IOException {
        if (this.accessions != null) {
            return this.accessions;
        }
        HashMap<String, ArrayList<Integer>> result = new HashMap<String, ArrayList<Integer>>();
        for (Node node : this.subtree.values()) {
            HashMap<String, ArrayList<Integer>> subResult = node.getAllMappings();
            for (String accession : subResult.keySet()) {
                ArrayList<Integer> indexes = result.get(accession);
                if (indexes == null) {
                    indexes = new ArrayList(subResult.get(accession).size());
                    indexes.addAll((Collection<Integer>)subResult.get(accession));
                    result.put(accession, indexes);
                    continue;
                }
                indexes.addAll((Collection<Integer>)subResult.get(accession));
                Collections.sort(indexes);
                int previousIndex = -1;
                ArrayList<Integer> singleIndexes = new ArrayList<Integer>(indexes.size());
                for (int tempIndex : indexes) {
                    if (tempIndex == previousIndex) continue;
                    singleIndexes.add(tempIndex);
                    previousIndex = tempIndex;
                }
                result.put(accession, singleIndexes);
            }
        }
        for (String accession : this.termini.keySet()) {
            ArrayList<Integer> indexes = result.get(accession);
            if (indexes == null) {
                indexes = new ArrayList(0);
                result.put(accession, indexes);
            }
            for (Integer index : this.termini.get(accession)) {
                if (indexes.contains(index)) continue;
                indexes.add(index);
            }
        }
        return result;
    }

    private HashMap<String, ArrayList<Integer>> matchInProtein(Protein protein, ArrayList<Integer> seeds, AminoAcidPattern peptidePattern, AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException {
        String proteinSequence = protein.getSequence();
        HashMap<String, ArrayList<Integer>> results = new HashMap<String, ArrayList<Integer>>();
        int peptideLength = peptidePattern.length();
        for (int startIndex : seeds) {
            String subSequence;
            int endIndex = startIndex + peptideLength;
            if (endIndex > proteinSequence.length() || !peptidePattern.matches(subSequence = proteinSequence.substring(startIndex, endIndex), matchingType, massTolerance)) continue;
            ArrayList<Integer> indexes = results.get(subSequence);
            if (indexes == null) {
                indexes = new ArrayList(0);
                results.put(subSequence, indexes);
            }
            indexes.add(startIndex);
        }
        return results;
    }

    private HashMap<Character, ArrayList<Integer>> getAA(String accession, ArrayList<Integer> seeds, int offset) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException {
        String proteinSequence = SequenceFactory.getInstance().getProtein(accession).getSequence();
        HashMap<Character, ArrayList<Integer>> result = new HashMap<Character, ArrayList<Integer>>();
        for (int startIndex : seeds) {
            int tempIndex = startIndex + offset;
            if (tempIndex < proteinSequence.length()) {
                char aa = proteinSequence.charAt(tempIndex);
                ArrayList<Integer> indexes = result.get(Character.valueOf(aa));
                if (indexes == null) {
                    indexes = new ArrayList(0);
                    result.put(Character.valueOf(aa), indexes);
                }
                if (indexes.contains(startIndex)) continue;
                indexes.add(startIndex);
                continue;
            }
            if (tempIndex == proteinSequence.length()) {
                ArrayList<Integer> indexes = this.termini.get(accession);
                if (indexes == null) {
                    indexes = new ArrayList(0);
                    this.termini.put(accession, indexes);
                }
                if (indexes.contains(startIndex)) continue;
                indexes.add(startIndex);
                continue;
            }
            throw new IllegalArgumentException("Attempting to index after the protein termini.");
        }
        return result;
    }

    public Node getSubNode(String sequence) {
        if (sequence.length() <= this.depth) {
            throw new IllegalArgumentException(sequence + " is not subnode of the node (depth=" + this.depth + ").");
        }
        char aa = sequence.charAt(this.depth);
        if (this.depth < sequence.length() - 1) {
            return this.subtree.get(Character.valueOf(aa)).getSubNode(sequence);
        }
        if (this.depth == sequence.length() - 1) {
            return this.subtree.get(Character.valueOf(aa));
        }
        throw new IllegalArgumentException("depth " + this.depth + " longer than sequence " + sequence + ".");
    }
}

