/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisData;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisSoftware;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisSoftwareList;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.DataCollection;
import uk.ac.ebi.jmzidml.model.mzidml.Modification;
import uk.ac.ebi.jmzidml.model.mzidml.ModificationParams;
import uk.ac.ebi.jmzidml.model.mzidml.Param;
import uk.ac.ebi.jmzidml.model.mzidml.Peptide;
import uk.ac.ebi.jmzidml.model.mzidml.SearchModification;
import uk.ac.ebi.jmzidml.model.mzidml.SpecificityRules;
import uk.ac.ebi.jmzidml.model.mzidml.SpectraData;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationItem;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationList;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationProtocol;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationResult;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLUnmarshaller;

public class MzIdentMLIdfileReader
extends ExperimentObject
implements IdfileReader {
    private HashMap<String, ArrayList<String>> tempSoftwareVersions = new HashMap();
    private HashMap<String, ArrayList<String>> softwareVersions = new HashMap();
    private File mzIdentMLFile;
    private String mzIdentMLFileName;
    private MzIdentMLUnmarshaller unmarshaller;
    private ArrayList<SearchModification> fixedModifications;

    public MzIdentMLIdfileReader() {
    }

    public MzIdentMLIdfileReader(File mzIdentMLFile) throws FileNotFoundException, IOException {
        this(mzIdentMLFile, null);
    }

    public MzIdentMLIdfileReader(File mzIdentMLFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        this.mzIdentMLFile = mzIdentMLFile;
        this.mzIdentMLFileName = Util.getFileName(mzIdentMLFile);
        this.unmarshaller = mzIdentMLFile.length() < 0xA00000L ? new MzIdentMLUnmarshaller(mzIdentMLFile, true) : new MzIdentMLUnmarshaller(mzIdentMLFile);
        AnalysisSoftwareList analysisSoftwareList = (AnalysisSoftwareList)this.unmarshaller.unmarshal(AnalysisSoftwareList.class);
        for (AnalysisSoftware software : analysisSoftwareList.getAnalysisSoftware()) {
            Param softwareNameObject = software.getSoftwareName();
            String name = softwareNameObject.getCvParam().getName();
            if (name == null) {
                name = softwareNameObject.getUserParam().getName();
            }
            String version = software.getVersion();
            if (name == null || version == null) continue;
            ArrayList<String> versions = this.tempSoftwareVersions.get(name);
            if (versions == null) {
                versions = new ArrayList();
                versions.add(version);
                this.tempSoftwareVersions.put(name, versions);
                continue;
            }
            if (versions.contains(version)) continue;
            versions.add(version);
        }
        this.softwareVersions = this.tempSoftwareVersions;
        this.fixedModifications = new ArrayList();
        SpectrumIdentificationProtocol spectrumIdentificationProtocol = (SpectrumIdentificationProtocol)this.unmarshaller.unmarshal(SpectrumIdentificationProtocol.class);
        ModificationParams modifications = spectrumIdentificationProtocol.getModificationParams();
        if (modifications != null) {
            for (SearchModification tempMod : modifications.getSearchModification()) {
                if (!tempMod.isFixedMod()) continue;
                this.fixedModifications.add(tempMod);
            }
        }
    }

    @Override
    public String getExtension() {
        return ".mzid";
    }

    @Override
    public HashSet<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, Exception {
        HashSet<SpectrumMatch> foundPeptides = new HashSet<SpectrumMatch>();
        DataCollection dataCollection = (DataCollection)this.unmarshaller.unmarshal(DataCollection.class);
        AnalysisData analysisData = dataCollection.getAnalysisData();
        List spectrumIdList = analysisData.getSpectrumIdentificationList();
        int spectrumIdentificationResultSize = 0;
        for (SpectrumIdentificationList spectrumIdElements : spectrumIdList) {
            spectrumIdentificationResultSize += spectrumIdElements.getSpectrumIdentificationResult().size();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(spectrumIdentificationResultSize);
        }
        this.softwareVersions.clear();
        for (SpectrumIdentificationList spectrumIdElements : spectrumIdList) {
            for (SpectrumIdentificationResult spectrumIdentResult : spectrumIdElements.getSpectrumIdentificationResult()) {
                String spectrumTitle = null;
                for (CvParam cvParam : spectrumIdentResult.getCvParam()) {
                    if (!cvParam.getAccession().equalsIgnoreCase("MS:1000796") && !cvParam.getName().equalsIgnoreCase("spectrum title")) continue;
                    spectrumTitle = cvParam.getValue();
                }
                String spectrumId = spectrumIdentResult.getSpectrumID();
                Integer spectrumNumber = null;
                if (spectrumId != null && spectrumId.startsWith("index=")) {
                    spectrumNumber = Integer.valueOf(spectrumId.substring(spectrumId.indexOf("=") + 1));
                }
                SpectraData spectraData = (SpectraData)this.unmarshaller.unmarshal(SpectraData.class, spectrumIdentResult.getSpectraDataRef());
                String spectrumFileName = new File(spectraData.getLocation()).getName();
                SpectrumMatch currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(spectrumFileName, spectrumTitle));
                if (spectrumNumber != null) {
                    currentMatch.setSpectrumNumber(spectrumNumber);
                }
                for (SpectrumIdentificationItem spectrumIdentItem : spectrumIdentResult.getSpectrumIdentificationItem()) {
                    ArrayList<String> versions;
                    int rank = spectrumIdentItem.getRank();
                    String peptideReference = spectrumIdentItem.getPeptideRef();
                    Peptide mzIdentMLPeptide = (Peptide)this.unmarshaller.unmarshal(Peptide.class, peptideReference);
                    String peptideSequence = mzIdentMLPeptide.getPeptideSequence();
                    ArrayList<ModificationMatch> utilitiesModifications = new ArrayList<ModificationMatch>();
                    for (Modification modification : mzIdentMLPeptide.getModification()) {
                        String accession = ((CvParam)modification.getCvParam().get(0)).getAccession();
                        int location = modification.getLocation();
                        double monoMassDelta = modification.getMonoisotopicMassDelta();
                        boolean fixed = false;
                        for (SearchModification searchFixedModification : this.fixedModifications) {
                            if (accession.equals(((CvParam)searchFixedModification.getCvParam().get(0)).getAccession()) || (double)searchFixedModification.getMassDelta() == monoMassDelta) {
                                boolean allRules = true;
                                List specificityRules = searchFixedModification.getSpecificityRules();
                                if (specificityRules != null && !specificityRules.isEmpty()) {
                                    for (SpecificityRules specificityRule : specificityRules) {
                                        for (CvParam cvParam : specificityRule.getCvParam()) {
                                            if (cvParam.getAccession().equals("MS:1001189") || cvParam.getAccession().equals("MS:1002057")) {
                                                if (location == 0) continue;
                                                allRules = false;
                                                break;
                                            }
                                            if (cvParam.getAccession().equals("MS:1001190") || cvParam.getAccession().equals("MS:1002058")) {
                                                if (location == peptideSequence.length() + 1) continue;
                                                allRules = false;
                                                break;
                                            }
                                            if (cvParam.getAccession().equals("MS:1001875") || cvParam.getAccession().equals("MS:1001876")) continue;
                                            throw new IllegalArgumentException("Specificity rule " + cvParam.getAccession() + " not recognized.");
                                        }
                                        if (allRules) continue;
                                        break;
                                    }
                                }
                                if (allRules) {
                                    List residues = searchFixedModification.getResidues();
                                    if (residues == null || residues.isEmpty()) {
                                        fixed = true;
                                        break;
                                    }
                                    String aaAtLocation = location == 0 ? peptideSequence.charAt(0) + "" : (location == peptideSequence.length() + 1 ? peptideSequence.charAt(location - 2) + "" : peptideSequence.charAt(location - 1) + "");
                                    for (String residue : residues) {
                                        if (!residue.equals(aaAtLocation)) continue;
                                        fixed = true;
                                        break;
                                    }
                                }
                            }
                            if (!fixed) continue;
                            break;
                        }
                        if (fixed) continue;
                        if (location == 0) {
                            location = 1;
                        } else if (location == peptideSequence.length() + 1) {
                            --location;
                        }
                        utilitiesModifications.add(new ModificationMatch(monoMassDelta + "@" + peptideSequence.charAt(location - 1), true, location));
                    }
                    com.compomics.util.experiment.biology.Peptide peptide = new com.compomics.util.experiment.biology.Peptide(mzIdentMLPeptide.getPeptideSequence(), utilitiesModifications);
                    HashMap<String, Double> scoreMap = this.getAccessionToEValue(spectrumIdentItem);
                    Double eValue = null;
                    Advocate advocate = null;
                    eValue = scoreMap.get("MS:1001568");
                    if (eValue != null) {
                        advocate = Advocate.scaffold;
                        String name = advocate.getName();
                        if (!this.softwareVersions.containsKey(name)) {
                            versions = this.tempSoftwareVersions.get(name);
                            if (versions == null) {
                                versions = new ArrayList();
                            }
                            this.softwareVersions.put(name, versions);
                        }
                    } else {
                        eValue = scoreMap.get("MS:1002466");
                        if (eValue != null) {
                            eValue = Math.pow(10.0, -eValue.doubleValue());
                            advocate = Advocate.peptideShaker;
                            String name = advocate.getName();
                            if (!this.softwareVersions.containsKey(name)) {
                                versions = this.tempSoftwareVersions.get(name);
                                if (versions == null) {
                                    versions = new ArrayList();
                                }
                                this.softwareVersions.put(name, versions);
                            }
                        } else {
                            eValue = scoreMap.get("MS:1002467");
                            if (eValue != null) {
                                eValue = Math.pow(10.0, -eValue.doubleValue());
                                advocate = Advocate.peptideShaker;
                                String name = advocate.getName();
                                if (!this.softwareVersions.containsKey(name)) {
                                    versions = this.tempSoftwareVersions.get(name);
                                    if (versions == null) {
                                        versions = new ArrayList();
                                    }
                                    this.softwareVersions.put(name, versions);
                                }
                            } else {
                                eValue = scoreMap.get("MS:1001330");
                                if (eValue != null) {
                                    advocate = Advocate.xtandem;
                                    String name = advocate.getName();
                                    if (!this.softwareVersions.containsKey(name)) {
                                        versions = this.tempSoftwareVersions.get(name);
                                        if (versions == null) {
                                            versions = new ArrayList();
                                        }
                                        this.softwareVersions.put(name, versions);
                                    }
                                } else {
                                    eValue = scoreMap.get("MS:1001331");
                                    if (eValue != null) {
                                        eValue = Math.pow(10.0, -eValue.doubleValue());
                                        advocate = Advocate.xtandem;
                                        String name = advocate.getName();
                                        if (!this.softwareVersions.containsKey(name)) {
                                            versions = this.tempSoftwareVersions.get(name);
                                            if (versions == null) {
                                                versions = new ArrayList();
                                            }
                                            this.softwareVersions.put(name, versions);
                                        }
                                    } else {
                                        eValue = scoreMap.get("MS:1001328");
                                        if (eValue != null) {
                                            advocate = Advocate.omssa;
                                            String name = advocate.getName();
                                            if (!this.softwareVersions.containsKey(name)) {
                                                versions = this.tempSoftwareVersions.get(name);
                                                if (versions == null) {
                                                    versions = new ArrayList();
                                                }
                                                this.softwareVersions.put(name, versions);
                                            }
                                        } else {
                                            eValue = scoreMap.get("MS:1002052");
                                            if (eValue != null) {
                                                advocate = Advocate.msgf;
                                                String name = advocate.getName();
                                                if (!this.softwareVersions.containsKey(name)) {
                                                    versions = this.tempSoftwareVersions.get(name);
                                                    if (versions == null) {
                                                        versions = new ArrayList();
                                                    }
                                                    this.softwareVersions.put(name, versions);
                                                }
                                            } else {
                                                eValue = scoreMap.get("MS:1002319");
                                                if (eValue != null) {
                                                    eValue = Math.pow(10.0, eValue);
                                                    advocate = Advocate.msAmanda;
                                                    String name = advocate.getName();
                                                    if (!this.softwareVersions.containsKey(name)) {
                                                        versions = this.tempSoftwareVersions.get(name);
                                                        if (versions == null) {
                                                            versions = new ArrayList();
                                                        }
                                                        this.softwareVersions.put(name, versions);
                                                    }
                                                } else {
                                                    eValue = scoreMap.get("MS:1002338");
                                                    if (eValue != null) {
                                                        advocate = Advocate.andromeda;
                                                        String name = advocate.getName();
                                                        if (!this.softwareVersions.containsKey(name)) {
                                                            versions = this.tempSoftwareVersions.get(name);
                                                            if (versions == null) {
                                                                versions = new ArrayList();
                                                            }
                                                            this.softwareVersions.put(name, versions);
                                                        }
                                                    } else {
                                                        eValue = scoreMap.get("MS:1002262");
                                                        if (eValue != null) {
                                                            eValue = Math.pow(10.0, -eValue.doubleValue());
                                                            advocate = Advocate.byonic;
                                                            String name = advocate.getName();
                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                versions = this.tempSoftwareVersions.get(name);
                                                                if (versions == null) {
                                                                    versions = new ArrayList();
                                                                }
                                                                this.softwareVersions.put(name, versions);
                                                            }
                                                        } else {
                                                            eValue = scoreMap.get("MS:1002311");
                                                            if (eValue != null) {
                                                                eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                advocate = Advocate.byonic;
                                                                String name = advocate.getName();
                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                    if (versions == null) {
                                                                        versions = new ArrayList();
                                                                    }
                                                                    this.softwareVersions.put(name, versions);
                                                                }
                                                            } else {
                                                                eValue = scoreMap.get("MS:1002265");
                                                                if (eValue != null) {
                                                                    advocate = Advocate.byonic;
                                                                    String name = advocate.getName();
                                                                    if (!this.softwareVersions.containsKey(name)) {
                                                                        versions = this.tempSoftwareVersions.get(name);
                                                                        if (versions == null) {
                                                                            versions = new ArrayList();
                                                                        }
                                                                        this.softwareVersions.put(name, versions);
                                                                    }
                                                                } else {
                                                                    eValue = scoreMap.get("MS:1002309");
                                                                    if (eValue != null) {
                                                                        eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                        advocate = Advocate.byonic;
                                                                        String name = advocate.getName();
                                                                        if (!this.softwareVersions.containsKey(name)) {
                                                                            versions = this.tempSoftwareVersions.get(name);
                                                                            if (versions == null) {
                                                                                versions = new ArrayList();
                                                                            }
                                                                            this.softwareVersions.put(name, versions);
                                                                        }
                                                                    } else {
                                                                        eValue = scoreMap.get("MS:1002266");
                                                                        if (eValue != null) {
                                                                            eValue = Math.pow(10.0, eValue);
                                                                            advocate = Advocate.byonic;
                                                                            String name = advocate.getName();
                                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                                versions = this.tempSoftwareVersions.get(name);
                                                                                if (versions == null) {
                                                                                    versions = new ArrayList();
                                                                                }
                                                                                this.softwareVersions.put(name, versions);
                                                                            }
                                                                        } else {
                                                                            eValue = scoreMap.get("MS:1002255");
                                                                            if (eValue != null) {
                                                                                advocate = Advocate.comet;
                                                                                String name = advocate.getName();
                                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                                    if (versions == null) {
                                                                                        versions = new ArrayList();
                                                                                    }
                                                                                    this.softwareVersions.put(name, versions);
                                                                                }
                                                                            } else {
                                                                                eValue = scoreMap.get("MS:1002252");
                                                                                if (eValue != null) {
                                                                                    eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                    advocate = Advocate.comet;
                                                                                    String name = advocate.getName();
                                                                                    if (!this.softwareVersions.containsKey(name)) {
                                                                                        versions = this.tempSoftwareVersions.get(name);
                                                                                        if (versions == null) {
                                                                                            versions = new ArrayList();
                                                                                        }
                                                                                        this.softwareVersions.put(name, versions);
                                                                                    }
                                                                                } else {
                                                                                    eValue = scoreMap.get("MS:1002053");
                                                                                    if (eValue != null) {
                                                                                        advocate = Advocate.msgf;
                                                                                        String name = advocate.getName();
                                                                                        if (!this.softwareVersions.containsKey(name)) {
                                                                                            versions = this.tempSoftwareVersions.get(name);
                                                                                            if (versions == null) {
                                                                                                versions = new ArrayList();
                                                                                            }
                                                                                            this.softwareVersions.put(name, versions);
                                                                                        }
                                                                                    } else {
                                                                                        eValue = scoreMap.get("MS:1002056");
                                                                                        if (eValue != null) {
                                                                                            advocate = Advocate.msgf;
                                                                                            String name = advocate.getName();
                                                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                                                versions = this.tempSoftwareVersions.get(name);
                                                                                                if (versions == null) {
                                                                                                    versions = new ArrayList();
                                                                                                }
                                                                                                this.softwareVersions.put(name, versions);
                                                                                            }
                                                                                        } else {
                                                                                            eValue = scoreMap.get("MS:1002055");
                                                                                            if (eValue != null) {
                                                                                                advocate = Advocate.msgf;
                                                                                                String name = advocate.getName();
                                                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                                                    if (versions == null) {
                                                                                                        versions = new ArrayList();
                                                                                                    }
                                                                                                    this.softwareVersions.put(name, versions);
                                                                                                }
                                                                                            } else {
                                                                                                eValue = scoreMap.get("MS:1002054");
                                                                                                if (eValue != null) {
                                                                                                    advocate = Advocate.msgf;
                                                                                                    String name = advocate.getName();
                                                                                                    if (!this.softwareVersions.containsKey(name)) {
                                                                                                        versions = this.tempSoftwareVersions.get(name);
                                                                                                        if (versions == null) {
                                                                                                            versions = new ArrayList();
                                                                                                        }
                                                                                                        this.softwareVersions.put(name, versions);
                                                                                                    }
                                                                                                } else {
                                                                                                    eValue = scoreMap.get("MS:1002049");
                                                                                                    if (eValue != null) {
                                                                                                        advocate = Advocate.msgf;
                                                                                                        String name = advocate.getName();
                                                                                                        if (!this.softwareVersions.containsKey(name)) {
                                                                                                            versions = this.tempSoftwareVersions.get(name);
                                                                                                            if (versions == null) {
                                                                                                                versions = new ArrayList();
                                                                                                            }
                                                                                                            this.softwareVersions.put(name, versions);
                                                                                                        }
                                                                                                    } else {
                                                                                                        eValue = scoreMap.get("MS:1001501");
                                                                                                        if (eValue != null) {
                                                                                                            advocate = Advocate.msFit;
                                                                                                            String name = advocate.getName();
                                                                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                                                                versions = this.tempSoftwareVersions.get(name);
                                                                                                                if (versions == null) {
                                                                                                                    versions = new ArrayList();
                                                                                                                }
                                                                                                                this.softwareVersions.put(name, versions);
                                                                                                            }
                                                                                                        } else {
                                                                                                            eValue = scoreMap.get("MS:1001172");
                                                                                                            if (eValue != null) {
                                                                                                                advocate = Advocate.mascot;
                                                                                                                String name = advocate.getName();
                                                                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                                                                    if (versions == null) {
                                                                                                                        versions = new ArrayList();
                                                                                                                    }
                                                                                                                    this.softwareVersions.put(name, versions);
                                                                                                                }
                                                                                                            } else {
                                                                                                                eValue = scoreMap.get("MS:1001171");
                                                                                                                if (eValue != null) {
                                                                                                                    eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                    advocate = Advocate.mascot;
                                                                                                                    String name = advocate.getName();
                                                                                                                    if (!this.softwareVersions.containsKey(name)) {
                                                                                                                        versions = this.tempSoftwareVersions.get(name);
                                                                                                                        if (versions == null) {
                                                                                                                            versions = new ArrayList();
                                                                                                                        }
                                                                                                                        this.softwareVersions.put(name, versions);
                                                                                                                    }
                                                                                                                } else {
                                                                                                                    eValue = scoreMap.get("MS:1001589");
                                                                                                                    if (eValue != null) {
                                                                                                                        eValue = Math.pow(Math.E, -eValue.doubleValue());
                                                                                                                        advocate = Advocate.myriMatch;
                                                                                                                        String name = advocate.getName();
                                                                                                                        if (!this.softwareVersions.containsKey(name)) {
                                                                                                                            versions = this.tempSoftwareVersions.get(name);
                                                                                                                            if (versions == null) {
                                                                                                                                versions = new ArrayList();
                                                                                                                            }
                                                                                                                            this.softwareVersions.put(name, versions);
                                                                                                                        }
                                                                                                                    } else {
                                                                                                                        eValue = scoreMap.get("MS:1001590");
                                                                                                                        if (eValue != null) {
                                                                                                                            eValue = Math.pow(Math.E, -eValue.doubleValue());
                                                                                                                            advocate = Advocate.myriMatch;
                                                                                                                            String name = advocate.getName();
                                                                                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                versions = this.tempSoftwareVersions.get(name);
                                                                                                                                if (versions == null) {
                                                                                                                                    versions = new ArrayList();
                                                                                                                                }
                                                                                                                                this.softwareVersions.put(name, versions);
                                                                                                                            }
                                                                                                                        } else {
                                                                                                                            eValue = scoreMap.get("MS:1001329");
                                                                                                                            if (eValue != null) {
                                                                                                                                advocate = Advocate.omssa;
                                                                                                                                String name = advocate.getName();
                                                                                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                                                                                    if (versions == null) {
                                                                                                                                        versions = new ArrayList();
                                                                                                                                    }
                                                                                                                                    this.softwareVersions.put(name, versions);
                                                                                                                                }
                                                                                                                            } else {
                                                                                                                                eValue = scoreMap.get("MS:1002448");
                                                                                                                                if (eValue != null) {
                                                                                                                                    advocate = Advocate.peaks;
                                                                                                                                    String name = advocate.getName();
                                                                                                                                    if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                        versions = this.tempSoftwareVersions.get(name);
                                                                                                                                        if (versions == null) {
                                                                                                                                            versions = new ArrayList();
                                                                                                                                        }
                                                                                                                                        this.softwareVersions.put(name, versions);
                                                                                                                                    }
                                                                                                                                } else {
                                                                                                                                    eValue = scoreMap.get("MS:1001950");
                                                                                                                                    if (eValue != null) {
                                                                                                                                        eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                        advocate = Advocate.peaks;
                                                                                                                                        String name = advocate.getName();
                                                                                                                                        if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                            versions = this.tempSoftwareVersions.get(name);
                                                                                                                                            if (versions == null) {
                                                                                                                                                versions = new ArrayList();
                                                                                                                                            }
                                                                                                                                            this.softwareVersions.put(name, versions);
                                                                                                                                        }
                                                                                                                                    } else {
                                                                                                                                        eValue = scoreMap.get("MS:1001396");
                                                                                                                                        if (eValue != null) {
                                                                                                                                            advocate = Advocate.phenyx;
                                                                                                                                            String name = advocate.getName();
                                                                                                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                if (versions == null) {
                                                                                                                                                    versions = new ArrayList();
                                                                                                                                                }
                                                                                                                                                this.softwareVersions.put(name, versions);
                                                                                                                                            }
                                                                                                                                        } else {
                                                                                                                                            eValue = scoreMap.get("MS:1001395");
                                                                                                                                            if (eValue != null) {
                                                                                                                                                eValue = Math.pow(2.0, -eValue.doubleValue());
                                                                                                                                                advocate = Advocate.phenyx;
                                                                                                                                                String name = advocate.getName();
                                                                                                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                    if (versions == null) {
                                                                                                                                                        versions = new ArrayList();
                                                                                                                                                    }
                                                                                                                                                    this.softwareVersions.put(name, versions);
                                                                                                                                                }
                                                                                                                                            } else {
                                                                                                                                                eValue = scoreMap.get("MS:1001499");
                                                                                                                                                if (eValue != null) {
                                                                                                                                                    eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                                    advocate = Advocate.proFound;
                                                                                                                                                    String name = advocate.getName();
                                                                                                                                                    if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                        versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                        if (versions == null) {
                                                                                                                                                            versions = new ArrayList();
                                                                                                                                                        }
                                                                                                                                                        this.softwareVersions.put(name, versions);
                                                                                                                                                    }
                                                                                                                                                } else {
                                                                                                                                                    eValue = scoreMap.get("MS:1001498");
                                                                                                                                                    if (eValue != null) {
                                                                                                                                                        eValue = Math.pow(2.0, -eValue.doubleValue());
                                                                                                                                                        advocate = Advocate.proFound;
                                                                                                                                                        String name = advocate.getName();
                                                                                                                                                        if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                            versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                            if (versions == null) {
                                                                                                                                                                versions = new ArrayList();
                                                                                                                                                            }
                                                                                                                                                            this.softwareVersions.put(name, versions);
                                                                                                                                                        }
                                                                                                                                                    } else {
                                                                                                                                                        eValue = scoreMap.get("MS:1001570");
                                                                                                                                                        if (eValue != null) {
                                                                                                                                                            eValue = Math.pow(10.0, eValue);
                                                                                                                                                            advocate = Advocate.proteinLynx;
                                                                                                                                                            String name = advocate.getName();
                                                                                                                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                if (versions == null) {
                                                                                                                                                                    versions = new ArrayList();
                                                                                                                                                                }
                                                                                                                                                                this.softwareVersions.put(name, versions);
                                                                                                                                                            }
                                                                                                                                                        } else {
                                                                                                                                                            eValue = scoreMap.get("MS:1001569");
                                                                                                                                                            if (eValue != null) {
                                                                                                                                                                eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                                                advocate = Advocate.proteinLynx;
                                                                                                                                                                String name = advocate.getName();
                                                                                                                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                    if (versions == null) {
                                                                                                                                                                        versions = new ArrayList();
                                                                                                                                                                    }
                                                                                                                                                                    this.softwareVersions.put(name, versions);
                                                                                                                                                                }
                                                                                                                                                            } else {
                                                                                                                                                                eValue = scoreMap.get("MS:1002045");
                                                                                                                                                                if (eValue != null) {
                                                                                                                                                                    advocate = Advocate.proteinProspector;
                                                                                                                                                                    String name = advocate.getName();
                                                                                                                                                                    if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                        versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                        if (versions == null) {
                                                                                                                                                                            versions = new ArrayList();
                                                                                                                                                                        }
                                                                                                                                                                        this.softwareVersions.put(name, versions);
                                                                                                                                                                    }
                                                                                                                                                                } else {
                                                                                                                                                                    eValue = scoreMap.get("MS:1002044");
                                                                                                                                                                    if (eValue != null) {
                                                                                                                                                                        eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                                                        advocate = Advocate.proteinProspector;
                                                                                                                                                                        String name = advocate.getName();
                                                                                                                                                                        if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                            versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                            if (versions == null) {
                                                                                                                                                                                versions = new ArrayList();
                                                                                                                                                                            }
                                                                                                                                                                            this.softwareVersions.put(name, versions);
                                                                                                                                                                        }
                                                                                                                                                                    } else {
                                                                                                                                                                        eValue = scoreMap.get("MS:1001503");
                                                                                                                                                                        if (eValue != null) {
                                                                                                                                                                            advocate = Advocate.proteinScape;
                                                                                                                                                                            String name = advocate.getName();
                                                                                                                                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                if (versions == null) {
                                                                                                                                                                                    versions = new ArrayList();
                                                                                                                                                                                }
                                                                                                                                                                                this.softwareVersions.put(name, versions);
                                                                                                                                                                            }
                                                                                                                                                                        } else {
                                                                                                                                                                            eValue = scoreMap.get("MS:1001504");
                                                                                                                                                                            if (eValue != null) {
                                                                                                                                                                                eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                                                                advocate = Advocate.proteinScape;
                                                                                                                                                                                String name = advocate.getName();
                                                                                                                                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                    if (versions == null) {
                                                                                                                                                                                        versions = new ArrayList();
                                                                                                                                                                                    }
                                                                                                                                                                                    this.softwareVersions.put(name, versions);
                                                                                                                                                                                }
                                                                                                                                                                            } else {
                                                                                                                                                                                eValue = scoreMap.get("MS:1001154");
                                                                                                                                                                                if (eValue != null) {
                                                                                                                                                                                    advocate = Advocate.sequest;
                                                                                                                                                                                    String name = advocate.getName();
                                                                                                                                                                                    if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                        versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                        if (versions == null) {
                                                                                                                                                                                            versions = new ArrayList();
                                                                                                                                                                                        }
                                                                                                                                                                                        this.softwareVersions.put(name, versions);
                                                                                                                                                                                    }
                                                                                                                                                                                } else {
                                                                                                                                                                                    eValue = scoreMap.get("MS:1001155");
                                                                                                                                                                                    if (eValue != null) {
                                                                                                                                                                                        eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                                                                        advocate = Advocate.sequest;
                                                                                                                                                                                        String name = advocate.getName();
                                                                                                                                                                                        if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                            versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                            if (versions == null) {
                                                                                                                                                                                                versions = new ArrayList();
                                                                                                                                                                                            }
                                                                                                                                                                                            this.softwareVersions.put(name, versions);
                                                                                                                                                                                        }
                                                                                                                                                                                    } else {
                                                                                                                                                                                        eValue = scoreMap.get("MS:1001215");
                                                                                                                                                                                        if (eValue != null) {
                                                                                                                                                                                            advocate = Advocate.sequest;
                                                                                                                                                                                            String name = advocate.getName();
                                                                                                                                                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                if (versions == null) {
                                                                                                                                                                                                    versions = new ArrayList();
                                                                                                                                                                                                }
                                                                                                                                                                                                this.softwareVersions.put(name, versions);
                                                                                                                                                                                            }
                                                                                                                                                                                        } else {
                                                                                                                                                                                            eValue = scoreMap.get("MS:1002248");
                                                                                                                                                                                            if (eValue != null) {
                                                                                                                                                                                                eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                                                                                advocate = Advocate.sequest;
                                                                                                                                                                                                String name = advocate.getName();
                                                                                                                                                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                    if (versions == null) {
                                                                                                                                                                                                        versions = new ArrayList();
                                                                                                                                                                                                    }
                                                                                                                                                                                                    this.softwareVersions.put(name, versions);
                                                                                                                                                                                                }
                                                                                                                                                                                            } else {
                                                                                                                                                                                                eValue = scoreMap.get("MS:1001887");
                                                                                                                                                                                                if (eValue != null) {
                                                                                                                                                                                                    eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                                                                                    advocate = Advocate.sqid;
                                                                                                                                                                                                    String name = advocate.getName();
                                                                                                                                                                                                    if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                        versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                        if (versions == null) {
                                                                                                                                                                                                            versions = new ArrayList();
                                                                                                                                                                                                        }
                                                                                                                                                                                                        this.softwareVersions.put(name, versions);
                                                                                                                                                                                                    }
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    eValue = scoreMap.get("MS:1001502");
                                                                                                                                                                                                    if (eValue != null) {
                                                                                                                                                                                                        eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                                                                                        advocate = Advocate.sonar;
                                                                                                                                                                                                        String name = advocate.getName();
                                                                                                                                                                                                        if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                            versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                            if (versions == null) {
                                                                                                                                                                                                                versions = new ArrayList();
                                                                                                                                                                                                            }
                                                                                                                                                                                                            this.softwareVersions.put(name, versions);
                                                                                                                                                                                                        }
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        eValue = scoreMap.get("MS:1001417");
                                                                                                                                                                                                        if (eValue != null) {
                                                                                                                                                                                                            eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                                                                                            advocate = Advocate.spectraST;
                                                                                                                                                                                                            String name = advocate.getName();
                                                                                                                                                                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                                versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                                if (versions == null) {
                                                                                                                                                                                                                    versions = new ArrayList();
                                                                                                                                                                                                                }
                                                                                                                                                                                                                this.softwareVersions.put(name, versions);
                                                                                                                                                                                                            }
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            eValue = scoreMap.get("MS:1001572");
                                                                                                                                                                                                            if (eValue != null) {
                                                                                                                                                                                                                eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                                                                                                advocate = Advocate.spectrumMill;
                                                                                                                                                                                                                String name = advocate.getName();
                                                                                                                                                                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                                    if (versions == null) {
                                                                                                                                                                                                                        versions = new ArrayList();
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    this.softwareVersions.put(name, versions);
                                                                                                                                                                                                                }
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                eValue = scoreMap.get("MS:1001952");
                                                                                                                                                                                                                if (eValue != null) {
                                                                                                                                                                                                                    advocate = Advocate.zCore;
                                                                                                                                                                                                                    String name = advocate.getName();
                                                                                                                                                                                                                    if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                                        versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                                        if (versions == null) {
                                                                                                                                                                                                                            versions = new ArrayList();
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        this.softwareVersions.put(name, versions);
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    eValue = scoreMap.get("MS:1001491");
                                                                                                                                                                                                                    if (eValue != null) {
                                                                                                                                                                                                                        advocate = Advocate.percolator;
                                                                                                                                                                                                                        String name = advocate.getName();
                                                                                                                                                                                                                        if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                                            versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                                            if (versions == null) {
                                                                                                                                                                                                                                versions = new ArrayList();
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            this.softwareVersions.put(name, versions);
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        eValue = scoreMap.get("MS:1001493");
                                                                                                                                                                                                                        if (eValue != null) {
                                                                                                                                                                                                                            advocate = Advocate.percolator;
                                                                                                                                                                                                                            String name = advocate.getName();
                                                                                                                                                                                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                                                versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                                                if (versions == null) {
                                                                                                                                                                                                                                    versions = new ArrayList();
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                this.softwareVersions.put(name, versions);
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            eValue = scoreMap.get("MS:1001492");
                                                                                                                                                                                                                            if (eValue != null) {
                                                                                                                                                                                                                                eValue = Math.pow(10.0, -eValue.doubleValue());
                                                                                                                                                                                                                                advocate = Advocate.percolator;
                                                                                                                                                                                                                                String name = advocate.getName();
                                                                                                                                                                                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                                                    if (versions == null) {
                                                                                                                                                                                                                                        versions = new ArrayList();
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    this.softwareVersions.put(name, versions);
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                eValue = scoreMap.get("MS:1002353");
                                                                                                                                                                                                                                if (eValue != null) {
                                                                                                                                                                                                                                    advocate = this.getAdvocate();
                                                                                                                                                                                                                                    String name = advocate.getName();
                                                                                                                                                                                                                                    if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                                                        versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                                                        if (versions == null) {
                                                                                                                                                                                                                                            versions = new ArrayList();
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        this.softwareVersions.put(name, versions);
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    eValue = scoreMap.get("MS:1002354");
                                                                                                                                                                                                                                    if (eValue != null) {
                                                                                                                                                                                                                                        advocate = this.getAdvocate();
                                                                                                                                                                                                                                        String name = advocate.getName();
                                                                                                                                                                                                                                        if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                                                            versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                                                            if (versions == null) {
                                                                                                                                                                                                                                                versions = new ArrayList();
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            this.softwareVersions.put(name, versions);
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        eValue = scoreMap.get("MS:1002357");
                                                                                                                                                                                                                                        if (eValue != null) {
                                                                                                                                                                                                                                            eValue = 1.0 - eValue;
                                                                                                                                                                                                                                            advocate = this.getAdvocate();
                                                                                                                                                                                                                                            String name = advocate.getName();
                                                                                                                                                                                                                                            if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                                                                versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                                                                if (versions == null) {
                                                                                                                                                                                                                                                    versions = new ArrayList();
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                this.softwareVersions.put(name, versions);
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            eValue = scoreMap.get("MS:1002352");
                                                                                                                                                                                                                                            if (eValue != null) {
                                                                                                                                                                                                                                                eValue = 1.0 - eValue;
                                                                                                                                                                                                                                                advocate = this.getAdvocate();
                                                                                                                                                                                                                                                String name = advocate.getName();
                                                                                                                                                                                                                                                if (!this.softwareVersions.containsKey(name)) {
                                                                                                                                                                                                                                                    versions = this.tempSoftwareVersions.get(name);
                                                                                                                                                                                                                                                    if (versions == null) {
                                                                                                                                                                                                                                                        versions = new ArrayList();
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    this.softwareVersions.put(name, versions);
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (eValue == null) {
                        throw new IllegalArgumentException("No e-value found for spectrum " + spectrumTitle + " in file " + this.mzIdentMLFileName + ".");
                    }
                    Charge peptideCharge = new Charge(1, spectrumIdentItem.getChargeState());
                    PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, advocate.getIndex(), peptideCharge, eValue, this.mzIdentMLFileName);
                    currentMatch.addHit(advocate.getIndex(), peptideAssumption, false);
                    if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                    break;
                }
                if (waitingHandler != null) {
                    if (waitingHandler.isRunCanceled()) break;
                    waitingHandler.increaseSecondaryProgressCounter();
                }
                foundPeptides.add(currentMatch);
            }
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
            break;
        }
        return foundPeptides;
    }

    private HashMap<String, Double> getAccessionToEValue(SpectrumIdentificationItem spectrumIdentItem) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (CvParam cvParam : spectrumIdentItem.getCvParam()) {
            String accession = cvParam.getAccession();
            if (cvParam.getValue() == null) continue;
            Double eValue = new Double(cvParam.getValue());
            result.put(accession, eValue);
        }
        return result;
    }

    private Advocate getAdvocate() {
        for (String softwareName : this.tempSoftwareVersions.keySet()) {
            Advocate advocate = Advocate.getAdvocate(softwareName);
            if (advocate == null) continue;
            return advocate;
        }
        Iterator<String> i$ = this.tempSoftwareVersions.keySet().iterator();
        if (i$.hasNext()) {
            String softwareName;
            softwareName = i$.next();
            return Advocate.addUserAdvocate(softwareName);
        }
        return Advocate.genericMzId;
    }

    @Override
    public void close() throws IOException {
        this.mzIdentMLFile = null;
        this.unmarshaller = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        return this.softwareVersions;
    }
}

