/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.ParamList;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationProtocol;
import uk.ac.ebi.jmzidml.model.mzidml.Tolerance;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLUnmarshaller;

public class MzIdentMLIdfileSearchParametersConverter
extends ExperimentObject {
    public static String getSearchParameters(File mzIdentMLFile, SearchParameters searchParameters, String species, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, ClassNotFoundException {
        String parametersReport = "<br><b><u>Extracted Search Parameters</u></b><br>";
        MzIdentMLUnmarshaller unmarshaller = new MzIdentMLUnmarshaller(mzIdentMLFile);
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            mzIdentMLFile = null;
            unmarshaller = null;
            return null;
        }
        SpectrumIdentificationProtocol spectrumIdentificationProtocol = (SpectrumIdentificationProtocol)unmarshaller.unmarshal(SpectrumIdentificationProtocol.class);
        Double fragmentMinTolerance = null;
        Double fragmentMaxTolerance = null;
        Boolean fragmentToleranceTypeIsPpm = false;
        Tolerance tempFragmentTolerance = spectrumIdentificationProtocol.getFragmentTolerance();
        for (CvParam cvParam : tempFragmentTolerance.getCvParam()) {
            if (cvParam.getAccession().equalsIgnoreCase("MS:1001412")) {
                fragmentMaxTolerance = Double.valueOf(cvParam.getValue());
                fragmentToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
                continue;
            }
            if (!cvParam.getAccession().equalsIgnoreCase("MS:1001413")) continue;
            fragmentMinTolerance = Double.valueOf(cvParam.getValue());
            fragmentToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
        }
        parametersReport = parametersReport + "<br><b>Fragment Ion Mass Tolerance:</b> ";
        if (fragmentMinTolerance != null && fragmentMaxTolerance != null) {
            Double fragmentTolerance = Math.abs(fragmentMinTolerance) - Math.abs(fragmentMaxTolerance) < 1.0E-7 ? Double.valueOf(Math.abs(fragmentMinTolerance)) : Double.valueOf(Math.max(Math.abs(fragmentMinTolerance), Math.abs(fragmentMaxTolerance)));
            searchParameters.setPrecursorAccuracy(fragmentTolerance);
            if (fragmentToleranceTypeIsPpm.booleanValue()) {
                searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.PPM);
                parametersReport = parametersReport + fragmentTolerance + " ppm";
            } else {
                searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.DA);
                parametersReport = parametersReport + fragmentTolerance + " Da";
            }
        } else {
            parametersReport = parametersReport + searchParameters.getFragmentIonAccuracy() + " Da (default)";
        }
        Double precursorMinTolerance = null;
        Double precursorMaxTolerance = null;
        Boolean precursorToleranceTypeIsPpm = true;
        Tolerance tempPrecursorTolerance = spectrumIdentificationProtocol.getParentTolerance();
        for (CvParam cvParam : tempPrecursorTolerance.getCvParam()) {
            if (cvParam.getAccession().equalsIgnoreCase("MS:1001412")) {
                precursorMaxTolerance = Double.valueOf(cvParam.getValue());
                precursorToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
                continue;
            }
            if (!cvParam.getAccession().equalsIgnoreCase("MS:1001413")) continue;
            precursorMinTolerance = Double.valueOf(cvParam.getValue());
            precursorToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
        }
        parametersReport = parametersReport + "<br><b>Precursor Ion Mass Tolerance:</b> ";
        if (precursorMinTolerance != null && precursorMaxTolerance != null) {
            Double precursorTolerance = Math.abs(precursorMinTolerance) - Math.abs(precursorMaxTolerance) < 1.0E-7 ? Double.valueOf(Math.abs(precursorMinTolerance)) : Double.valueOf(Math.max(Math.abs(precursorMinTolerance), Math.abs(precursorMaxTolerance)));
            searchParameters.setPrecursorAccuracy(precursorTolerance);
            if (precursorToleranceTypeIsPpm.booleanValue()) {
                searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.PPM);
                parametersReport = parametersReport + precursorTolerance + " ppm";
            } else {
                searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.DA);
                parametersReport = parametersReport + precursorTolerance + " Da";
            }
        } else {
            parametersReport = parametersReport + searchParameters.getPrecursorAccuracy() + " ppm (default)";
        }
        String enzyme = null;
        Integer maxMissedCleavages = null;
        List enzymes = spectrumIdentificationProtocol.getEnzymes().getEnzyme();
        if (!enzymes.isEmpty()) {
            ParamList paramList = ((uk.ac.ebi.jmzidml.model.mzidml.Enzyme)enzymes.get(0)).getEnzymeName();
            if (!paramList.getParamGroup().isEmpty()) {
                enzyme = ((AbstractParam)paramList.getParamGroup().get(0)).getName();
            }
            if (((uk.ac.ebi.jmzidml.model.mzidml.Enzyme)enzymes.get(0)).getMissedCleavages() != null) {
                maxMissedCleavages = ((uk.ac.ebi.jmzidml.model.mzidml.Enzyme)enzymes.get(0)).getMissedCleavages();
            }
        }
        parametersReport = parametersReport + "<br><br><b>Enzyme:</b> ";
        if (enzyme != null) {
            Enzyme utilitiesEnzyme = EnzymeFactory.getUtilitiesEnzyme(enzyme);
            if (utilitiesEnzyme != null) {
                searchParameters.setEnzyme(utilitiesEnzyme);
                parametersReport = parametersReport + utilitiesEnzyme.getName() + "<br>";
            } else {
                searchParameters.setEnzyme(EnzymeFactory.getInstance().getEnzyme("Trypsin"));
                parametersReport = parametersReport + "Trypsin (assumed)<br>";
            }
        } else {
            searchParameters.setEnzyme(EnzymeFactory.getInstance().getEnzyme("Trypsin"));
            parametersReport = parametersReport + "Trypsin (assumed)<br>";
        }
        parametersReport = parametersReport + "<b>Maximum Missed Cleavages:</b> ";
        if (maxMissedCleavages != null) {
            searchParameters.setnMissedCleavages(maxMissedCleavages);
            parametersReport = parametersReport + maxMissedCleavages;
        } else {
            parametersReport = parametersReport + searchParameters.getnMissedCleavages() + " (default)";
        }
        parametersReport = parametersReport + "<br><br><b>Min Precusor Charge:</b> ";
        parametersReport = parametersReport + searchParameters.getMinChargeSearched().value + " (default)";
        parametersReport = parametersReport + "<br><b>Max Precusor Charge:</b> ";
        parametersReport = parametersReport + searchParameters.getMaxChargeSearched().value + " (default)";
        parametersReport = parametersReport + "<br><br><b>Species:</b> ";
        parametersReport = species == null || species.length() == 0 ? parametersReport + "unknown" : parametersReport + species;
        mzIdentMLFile = null;
        unmarshaller = null;
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            return null;
        }
        return parametersReport;
    }
}

