/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.export.report;

import com.compomics.util.io.export.ExportFactory;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportScheme;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;

public class ReportEditor
extends JDialog {
    private ExportFactory exportFactory;
    private String oldName;
    private boolean editable = true;
    private HashMap<String, ArrayList<ExportFeature>> selection = new HashMap();
    private String sectionName = null;
    private ArrayList<ExportFeature> featuresList;
    private JCheckBox advancedFeaturesCheck;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel columnDelimiterLabel;
    private JRadioButton commaRadioButton;
    private JCheckBox decoysCheck;
    private ButtonGroup delimiterButtonGroup;
    private JScrollPane featuresScrollPane;
    private JTable featuresTable;
    private JCheckBox headerCheckBox;
    private JCheckBox lineNumberCheckBox;
    private JTextField mainTitleTxt;
    private JCheckBox maintTitleCheckBox;
    private JLabel matchesLbl;
    private JTextField nameTxt;
    private JLabel numberOfSeparationLinesLabel;
    private JButton okButton;
    private JLabel reportTitleLabel;
    private JPanel reporterSettingsPanel;
    private JPanel reporterTypePanel;
    private JLabel rowDelimiterLabel;
    private JPanel sectionContentPanel;
    private JCheckBox sectionTitleCheckBox;
    private JPanel sectionsPanel;
    private JScrollPane sectionsScrollPane;
    private JTable sectionsTable;
    private JRadioButton semicolonRadioButton;
    private JSpinner separationLinesSpinner;
    private JRadioButton spaceRadioButton;
    private JLabel structureLabel;
    private JCheckBox subFeaturesCheck;
    private JRadioButton tabRadioButton;
    private JCheckBox validatedCheck;

    public ReportEditor(Frame parent, ExportFactory exportFactory, String exportSchemeName, boolean editable) {
        super(parent, true);
        this.exportFactory = exportFactory;
        this.editable = editable;
        this.initComponents();
        this.oldName = exportSchemeName;
        this.selection = new HashMap();
        ExportScheme exportScheme = exportFactory.getExportScheme(exportSchemeName);
        for (String section : exportScheme.getSections()) {
            if (!this.selection.containsKey(section)) {
                this.selection.put(section, new ArrayList());
            }
            this.selection.get(section).addAll(exportScheme.getExportFeatures(section));
        }
        this.setUpGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public ReportEditor(Frame parent, ExportFactory exportFactory) {
        super(parent, true);
        this.exportFactory = exportFactory;
        this.initComponents();
        this.setUpGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.sectionsTable.getTableHeader().setReorderingAllowed(false);
        this.featuresTable.getTableHeader().setReorderingAllowed(false);
        this.sectionsTable.getColumn(" ").setMaxWidth(30);
        this.sectionsTable.getColumn(" ").setMinWidth(30);
        this.featuresTable.getColumn(" ").setMaxWidth(30);
        this.featuresTable.getColumn(" ").setMinWidth(30);
        this.featuresTable.getColumn("  ").setMaxWidth(30);
        this.featuresTable.getColumn("  ").setMinWidth(30);
        this.featuresTable.getColumn("  ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.nameTxt.setEnabled(this.editable);
        this.maintTitleCheckBox.setEnabled(this.editable);
        this.tabRadioButton.setEnabled(this.editable);
        this.semicolonRadioButton.setEnabled(this.editable);
        this.commaRadioButton.setEnabled(this.editable);
        this.spaceRadioButton.setEnabled(this.editable);
        this.sectionTitleCheckBox.setEnabled(this.editable);
        this.separationLinesSpinner.setEnabled(this.editable);
        this.sectionsTable.setEnabled(this.editable);
        this.featuresTable.setEnabled(this.editable);
        this.lineNumberCheckBox.setEnabled(this.editable);
        this.headerCheckBox.setEnabled(this.editable);
        this.validatedCheck.setEnabled(this.editable);
        this.decoysCheck.setEnabled(this.editable);
        this.featuresScrollPane.getViewport().setOpaque(false);
        this.sectionsScrollPane.getViewport().setOpaque(false);
        if (this.oldName != null) {
            this.nameTxt.setText(this.oldName);
            ExportScheme exportScheme = this.exportFactory.getExportScheme(this.oldName);
            if (exportScheme.getMainTitle() != null) {
                this.maintTitleCheckBox.setSelected(true);
                this.mainTitleTxt.setText(exportScheme.getMainTitle());
            }
            if (exportScheme.getSeparator().equalsIgnoreCase("\\t")) {
                this.tabRadioButton.setSelected(true);
            } else if (exportScheme.getSeparator().equalsIgnoreCase(";")) {
                this.semicolonRadioButton.setSelected(true);
            } else if (exportScheme.getSeparator().equalsIgnoreCase(",")) {
                this.commaRadioButton.setSelected(true);
            } else if (exportScheme.getSeparator().equalsIgnoreCase(" ")) {
                this.spaceRadioButton.setSelected(true);
            }
            this.sectionTitleCheckBox.setSelected(exportScheme.isIncludeSectionTitles());
            this.separationLinesSpinner.setValue(exportScheme.getSeparationLines());
            this.lineNumberCheckBox.setSelected(exportScheme.isIndexes());
            this.headerCheckBox.setSelected(exportScheme.isHeader());
            this.validatedCheck.setSelected(exportScheme.isValidatedOnly());
            this.decoysCheck.setSelected(exportScheme.isIncludeDecoy());
        }
    }

    private void initComponents() {
        this.delimiterButtonGroup = new ButtonGroup();
        this.backgroundPanel = new JPanel();
        this.reporterTypePanel = new JPanel();
        this.nameTxt = new JTextField();
        this.reporterSettingsPanel = new JPanel();
        this.maintTitleCheckBox = new JCheckBox();
        this.sectionTitleCheckBox = new JCheckBox();
        this.separationLinesSpinner = new JSpinner();
        this.numberOfSeparationLinesLabel = new JLabel();
        this.lineNumberCheckBox = new JCheckBox();
        this.headerCheckBox = new JCheckBox();
        this.tabRadioButton = new JRadioButton();
        this.semicolonRadioButton = new JRadioButton();
        this.commaRadioButton = new JRadioButton();
        this.spaceRadioButton = new JRadioButton();
        this.columnDelimiterLabel = new JLabel();
        this.rowDelimiterLabel = new JLabel();
        this.structureLabel = new JLabel();
        this.reportTitleLabel = new JLabel();
        this.mainTitleTxt = new JTextField();
        this.matchesLbl = new JLabel();
        this.validatedCheck = new JCheckBox();
        this.decoysCheck = new JCheckBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.sectionsPanel = new JPanel();
        this.sectionsScrollPane = new JScrollPane();
        this.sectionsTable = new JTable();
        this.sectionContentPanel = new JPanel();
        this.featuresScrollPane = new JScrollPane();
        this.featuresTable = new JTable();
        this.advancedFeaturesCheck = new JCheckBox();
        this.subFeaturesCheck = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Report");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.reporterTypePanel.setBorder(BorderFactory.createTitledBorder("Report Type"));
        this.reporterTypePanel.setOpaque(false);
        GroupLayout reporterTypePanelLayout = new GroupLayout(this.reporterTypePanel);
        this.reporterTypePanel.setLayout(reporterTypePanelLayout);
        reporterTypePanelLayout.setHorizontalGroup(reporterTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, reporterTypePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.nameTxt).addContainerGap()));
        reporterTypePanelLayout.setVerticalGroup(reporterTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterTypePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.nameTxt, -2, -1, -2).addContainerGap()));
        this.reporterSettingsPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.reporterSettingsPanel.setOpaque(false);
        this.maintTitleCheckBox.setText("Report Title");
        this.maintTitleCheckBox.setIconTextGap(15);
        this.maintTitleCheckBox.setOpaque(false);
        this.maintTitleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportEditor.this.maintTitleCheckBoxActionPerformed(evt);
            }
        });
        this.sectionTitleCheckBox.setText("Section Titles");
        this.sectionTitleCheckBox.setIconTextGap(15);
        this.sectionTitleCheckBox.setOpaque(false);
        this.separationLinesSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.separationLinesSpinner.setToolTipText("Number of empty lines between each section");
        this.separationLinesSpinner.setEnabled(false);
        this.numberOfSeparationLinesLabel.setText("(number of empty lines between sections)");
        this.numberOfSeparationLinesLabel.setToolTipText("Number of empty lines between each section");
        this.lineNumberCheckBox.setSelected(true);
        this.lineNumberCheckBox.setText("Line Numbers");
        this.lineNumberCheckBox.setIconTextGap(15);
        this.lineNumberCheckBox.setOpaque(false);
        this.headerCheckBox.setSelected(true);
        this.headerCheckBox.setText("Table Headers");
        this.headerCheckBox.setIconTextGap(15);
        this.headerCheckBox.setOpaque(false);
        this.delimiterButtonGroup.add(this.tabRadioButton);
        this.tabRadioButton.setSelected(true);
        this.tabRadioButton.setText("Tab");
        this.tabRadioButton.setIconTextGap(15);
        this.tabRadioButton.setOpaque(false);
        this.delimiterButtonGroup.add(this.semicolonRadioButton);
        this.semicolonRadioButton.setText("Semicolon");
        this.semicolonRadioButton.setIconTextGap(15);
        this.semicolonRadioButton.setOpaque(false);
        this.delimiterButtonGroup.add(this.commaRadioButton);
        this.commaRadioButton.setText("Comma");
        this.commaRadioButton.setIconTextGap(15);
        this.commaRadioButton.setOpaque(false);
        this.delimiterButtonGroup.add(this.spaceRadioButton);
        this.spaceRadioButton.setText("Space");
        this.spaceRadioButton.setIconTextGap(15);
        this.spaceRadioButton.setOpaque(false);
        this.columnDelimiterLabel.setText("Column Delimiter");
        this.rowDelimiterLabel.setText("Row Delimiter");
        this.structureLabel.setText("Structure");
        this.reportTitleLabel.setText("Report Title");
        this.mainTitleTxt.setEnabled(false);
        this.matchesLbl.setText("Matches");
        this.validatedCheck.setSelected(true);
        this.validatedCheck.setText("Validated Only");
        this.validatedCheck.setOpaque(false);
        this.decoysCheck.setText("Include Decoys");
        this.decoysCheck.setOpaque(false);
        GroupLayout reporterSettingsPanelLayout = new GroupLayout(this.reporterSettingsPanel);
        this.reporterSettingsPanel.setLayout(reporterSettingsPanelLayout);
        reporterSettingsPanelLayout.setHorizontalGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.maintTitleCheckBox).addComponent(this.sectionTitleCheckBox).addComponent(this.lineNumberCheckBox)).addComponent(this.headerCheckBox))).addComponent(this.structureLabel)).addGap(46, 46, 46).addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.columnDelimiterLabel).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spaceRadioButton).addComponent(this.semicolonRadioButton).addComponent(this.tabRadioButton).addComponent(this.commaRadioButton)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 75, Short.MAX_VALUE).addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.validatedCheck).addComponent(this.decoysCheck))).addComponent(this.matchesLbl)).addGap(57, 57, 57).addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.separationLinesSpinner, -2, 46, -2).addGap(18, 18, 18).addComponent(this.numberOfSeparationLinesLabel)).addComponent(this.rowDelimiterLabel))).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addComponent(this.reportTitleLabel).addGap(18, 18, 18).addComponent(this.mainTitleTxt))).addGap(14, 14, 14)));
        reporterSettingsPanelLayout.linkSize(0, this.headerCheckBox, this.lineNumberCheckBox, this.maintTitleCheckBox, this.sectionTitleCheckBox);
        reporterSettingsPanelLayout.linkSize(0, this.semicolonRadioButton, this.tabRadioButton);
        reporterSettingsPanelLayout.setVerticalGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addComponent(this.columnDelimiterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabRadioButton).addGap(0, 0, 0).addComponent(this.semicolonRadioButton).addGap(0, 0, 0).addComponent(this.commaRadioButton)).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addComponent(this.structureLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maintTitleCheckBox).addGap(0, 0, 0).addComponent(this.sectionTitleCheckBox).addGap(0, 0, 0).addComponent(this.lineNumberCheckBox).addGap(0, 0, 0).addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.headerCheckBox).addComponent(this.spaceRadioButton))).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addComponent(this.rowDelimiterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.separationLinesSpinner, -2, -1, -2).addComponent(this.numberOfSeparationLinesLabel))).addGroup(reporterSettingsPanelLayout.createSequentialGroup().addComponent(this.matchesLbl).addGap(6, 6, 6).addComponent(this.validatedCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoysCheck))).addGap(18, 18, 18).addGroup(reporterSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reportTitleLabel).addComponent(this.mainTitleTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        reporterSettingsPanelLayout.linkSize(1, this.mainTitleTxt, this.numberOfSeparationLinesLabel);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportEditor.this.okButtonActionPerformed(evt);
            }
        });
        this.sectionsPanel.setBorder(BorderFactory.createTitledBorder("Sections"));
        this.sectionsPanel.setOpaque(false);
        this.sectionsTable.setModel(new SectionsTableModel());
        this.sectionsTable.setSelectionMode(0);
        this.sectionsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ReportEditor.this.sectionsTableMouseReleased(evt);
            }
        });
        this.sectionsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ReportEditor.this.sectionsTableKeyReleased(evt);
            }
        });
        this.sectionsScrollPane.setViewportView(this.sectionsTable);
        GroupLayout sectionsPanelLayout = new GroupLayout(this.sectionsPanel);
        this.sectionsPanel.setLayout(sectionsPanelLayout);
        sectionsPanelLayout.setHorizontalGroup(sectionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sectionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.sectionsScrollPane).addContainerGap()));
        sectionsPanelLayout.setVerticalGroup(sectionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sectionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.sectionsScrollPane, -1, 143, Short.MAX_VALUE).addContainerGap()));
        this.sectionContentPanel.setBorder(BorderFactory.createTitledBorder("Section Content"));
        this.sectionContentPanel.setOpaque(false);
        this.featuresTable.setModel(new FeaturesTableModel());
        this.featuresTable.setSelectionMode(0);
        this.featuresScrollPane.setViewportView(this.featuresTable);
        this.advancedFeaturesCheck.setText("Show advanced Features");
        this.advancedFeaturesCheck.setOpaque(false);
        this.advancedFeaturesCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportEditor.this.advancedFeaturesCheckActionPerformed(evt);
            }
        });
        this.subFeaturesCheck.setText("Show sub-features");
        this.subFeaturesCheck.setOpaque(false);
        this.subFeaturesCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportEditor.this.subFeaturesCheckActionPerformed(evt);
            }
        });
        GroupLayout sectionContentPanelLayout = new GroupLayout(this.sectionContentPanel);
        this.sectionContentPanel.setLayout(sectionContentPanelLayout);
        sectionContentPanelLayout.setHorizontalGroup(sectionContentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, sectionContentPanelLayout.createSequentialGroup().addContainerGap().addGroup(sectionContentPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(sectionContentPanelLayout.createSequentialGroup().addComponent(this.subFeaturesCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.advancedFeaturesCheck)).addComponent(this.featuresScrollPane)).addContainerGap()));
        sectionContentPanelLayout.setVerticalGroup(sectionContentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sectionContentPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.featuresScrollPane, -1, 144, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sectionContentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.advancedFeaturesCheck).addComponent(this.subFeaturesCheck))));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.reporterTypePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.sectionContentPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.sectionsPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.reporterSettingsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.reporterTypePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reporterSettingsPanel, -2, -1, -2).addGap(46, 46, 46).addComponent(this.sectionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sectionContentPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.backgroundPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.editable) {
            String newName = this.nameTxt.getText().trim();
            if (newName.trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Please provide a name for the report type.", "Report Type Missing", 1);
                this.nameTxt.requestFocus();
                return;
            }
            if (this.oldName != null && !this.oldName.contains(newName)) {
                this.exportFactory.removeExportScheme(this.oldName);
            }
            String separator = this.tabRadioButton.isSelected() ? "\t" : (this.semicolonRadioButton.isSelected() ? ";" : (this.commaRadioButton.isSelected() ? "," : " "));
            HashMap<String, ArrayList<ExportFeature>> features = new HashMap<String, ArrayList<ExportFeature>>(this.selection);
            if (this.maintTitleCheckBox.isSelected()) {
                ExportScheme exportScheme = new ExportScheme(newName, true, features, separator, this.lineNumberCheckBox.isSelected(), this.headerCheckBox.isSelected(), (Integer)this.separationLinesSpinner.getValue(), this.sectionTitleCheckBox.isSelected(), this.validatedCheck.isSelected(), this.decoysCheck.isSelected(), this.mainTitleTxt.getText().trim());
                this.exportFactory.addExportScheme(exportScheme);
            } else {
                ExportScheme exportScheme = new ExportScheme(newName, true, features, separator, this.lineNumberCheckBox.isSelected(), this.headerCheckBox.isSelected(), (Integer)this.separationLinesSpinner.getValue(), this.sectionTitleCheckBox.isSelected(), this.validatedCheck.isSelected(), this.decoysCheck.isSelected());
                this.exportFactory.addExportScheme(exportScheme);
            }
        }
        this.dispose();
    }

    private void maintTitleCheckBoxActionPerformed(ActionEvent evt) {
        this.mainTitleTxt.setEnabled(this.maintTitleCheckBox.isSelected());
    }

    private void sectionsTableMouseReleased(MouseEvent evt) {
        if (this.sectionsTable.getSelectedRow() != -1) {
            this.sectionName = (String)this.sectionsTable.getValueAt(this.sectionsTable.getSelectedRow(), 1);
            this.updateFeatureTableContent();
        }
    }

    private void sectionsTableKeyReleased(KeyEvent evt) {
        this.sectionsTableMouseReleased(null);
    }

    private void subFeaturesCheckActionPerformed(ActionEvent evt) {
        this.updateFeatureTableContent();
    }

    private void advancedFeaturesCheckActionPerformed(ActionEvent evt) {
        this.updateFeatureTableContent();
    }

    private boolean isSelected(String section, ExportFeature exportFeature) {
        ArrayList<ExportFeature> selectedSectionFeatures = this.selection.get(section);
        return selectedSectionFeatures != null && selectedSectionFeatures.contains(exportFeature);
    }

    private void setSelected(String section, ExportFeature exportFeature, Boolean selected) {
        if (selected.booleanValue()) {
            if (!this.selection.containsKey(section)) {
                this.selection.put(section, new ArrayList());
            }
            if (!this.selection.get(section).contains(exportFeature)) {
                this.selection.get(section).add(exportFeature);
            }
        } else if (this.selection.containsKey(section)) {
            this.selection.get(section).remove(exportFeature);
            if (this.selection.get(section).isEmpty()) {
                this.selection.remove(section);
            }
        }
    }

    private void updateFeatureTableContent() {
        this.featuresList = new ArrayList();
        if (this.sectionName != null) {
            if (this.advancedFeaturesCheck.isSelected()) {
                this.featuresList.addAll(this.exportFactory.getExportFeatures(this.sectionName, this.subFeaturesCheck.isSelected()));
            } else {
                for (ExportFeature exportFeature : this.exportFactory.getExportFeatures(this.sectionName, this.subFeaturesCheck.isSelected())) {
                    if (exportFeature.isAdvanced()) continue;
                    this.featuresList.add(exportFeature);
                }
            }
        }
        ((DefaultTableModel)this.featuresTable.getModel()).fireTableDataChanged();
    }

    private class FeaturesTableModel
    extends DefaultTableModel {
        @Override
        public int getRowCount() {
            if (ReportEditor.this.featuresList == null) {
                return 0;
            }
            return ReportEditor.this.featuresList.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "  ";
                }
                case 2: {
                    return "Section";
                }
                case 3: {
                    return "Name";
                }
                case 4: {
                    return "Description";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ReportEditor.this.isSelected(ReportEditor.this.sectionName, (ExportFeature)ReportEditor.this.featuresList.get(row));
                }
                case 2: {
                    return ((ExportFeature)ReportEditor.this.featuresList.get(row)).getFeatureFamily();
                }
                case 3: {
                    StringBuilder result = new StringBuilder();
                    for (String title : ((ExportFeature)ReportEditor.this.featuresList.get(row)).getTitles()) {
                        if (result.length() > 0) {
                            result.append(", ");
                        }
                        result.append(title);
                    }
                    return result.toString();
                }
                case 4: {
                    return ((ExportFeature)ReportEditor.this.featuresList.get(row)).getDescription();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            ReportEditor.this.setSelected(ReportEditor.this.sectionName, (ExportFeature)ReportEditor.this.featuresList.get(row), (Boolean)aValue);
        }
    }

    private class SectionsTableModel
    extends DefaultTableModel {
        private ArrayList<String> sectionList = new ArrayList();

        public SectionsTableModel() {
            this.sectionList.addAll(ReportEditor.this.exportFactory.getImplementedSections());
        }

        @Override
        public int getRowCount() {
            if (this.sectionList == null) {
                return 0;
            }
            return this.sectionList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return this.sectionList.get(row);
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

