/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences.gui;

import com.compomics.util.experiment.identification.ptm.PtmScore;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.preferences.PTMScoringPreferences;
import com.compomics.util.preferences.ProcessingPreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ProcessingPreferencesDialog
extends JDialog {
    private ProcessingPreferences processingPreferences;
    private PTMScoringPreferences ptmScoringPreferences;
    private JLabel aScoreLabel;
    private JPanel backgroundPanel;
    private JLabel estimateAScoreLabel;
    private JPanel fractionsPanel;
    private JButton helpJButton;
    private JComboBox neutralLossesCmb;
    private JComboBox neutralLossesCmb2;
    private JLabel neutralLossesLabel;
    private JLabel neutralLossesLabel1;
    private JLabel neutralLossesLabel2;
    private JLabel neutralLossesLabel3;
    private JButton okButton;
    private JLabel peptideFdrLabel;
    private JTextField peptideFdrTxt;
    private JLabel percentLabel;
    private JLabel percentLabel2;
    private JLabel percentLabel3;
    private JLabel percentLabel4;
    private JComboBox probabilisticScoreCmb;
    private JPanel processingParamsPanel;
    private JTextField proteinConfidenceMwTxt;
    private JLabel proteinFdrLabel;
    private JTextField proteinFdrTxt;
    private JLabel proteinMwLabel;
    private JLabel psmFdrLabel;
    private JTextField psmFdrTxt;
    private JPanel ptmScoringPanel;
    private JComboBox scoreCmb;
    private JComboBox thresholdCmb;
    private JTextField thresholdTxt;

    public ProcessingPreferencesDialog(Frame parent, boolean editable, ProcessingPreferences processingPreferences, PTMScoringPreferences ptmScoringPreferences) {
        super(parent, true);
        this.initComponents();
        this.proteinFdrTxt.setText(processingPreferences.getProteinFDR() + "");
        this.peptideFdrTxt.setText(processingPreferences.getPeptideFDR() + "");
        this.psmFdrTxt.setText(processingPreferences.getPsmFDR() + "");
        this.proteinFdrTxt.setEditable(editable);
        this.peptideFdrTxt.setEditable(editable);
        this.psmFdrTxt.setEditable(editable);
        this.proteinFdrTxt.setEnabled(editable);
        this.peptideFdrTxt.setEnabled(editable);
        this.psmFdrTxt.setEnabled(editable);
        this.probabilisticScoreCmb.setEnabled(editable);
        this.proteinConfidenceMwTxt.setEnabled(editable);
        if (ptmScoringPreferences.isProbabilitsticScoreCalculation().booleanValue()) {
            this.probabilisticScoreCmb.setSelectedIndex(0);
            this.scoreCmb.setEnabled(editable);
            if (ptmScoringPreferences.getSelectedProbabilisticScore() != null) {
                this.scoreCmb.setSelectedItem(ptmScoringPreferences.getSelectedProbabilisticScore().getName());
            }
            this.neutralLossesCmb.setEnabled(editable);
            if (ptmScoringPreferences.isProbabilisticScoreNeutralLosses().booleanValue()) {
                this.neutralLossesCmb.setSelectedIndex(0);
            } else {
                this.neutralLossesCmb.setSelectedIndex(1);
            }
            this.thresholdCmb.setEnabled(editable);
            if (ptmScoringPreferences.isEstimateFlr()) {
                this.thresholdCmb.setSelectedIndex(0);
                this.thresholdTxt.setEnabled(false);
                this.thresholdTxt.setEditable(false);
            } else {
                this.thresholdCmb.setSelectedIndex(1);
                this.thresholdTxt.setEnabled(editable);
                this.thresholdTxt.setEditable(editable);
                this.thresholdTxt.setText(ptmScoringPreferences.getProbabilisticScoreThreshold() + "");
            }
        } else {
            this.probabilisticScoreCmb.setSelectedIndex(1);
            this.scoreCmb.setEnabled(false);
            this.neutralLossesCmb.setEnabled(false);
            this.thresholdCmb.setEnabled(false);
            this.thresholdTxt.setEnabled(false);
            this.thresholdTxt.setEditable(false);
        }
        this.proteinConfidenceMwTxt.setText(processingPreferences.getProteinConfidenceMwPlots() + "");
        this.probabilisticScoreCmb.setRenderer(new AlignedListCellRenderer(0));
        this.thresholdCmb.setRenderer(new AlignedListCellRenderer(0));
        this.neutralLossesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.scoreCmb.setRenderer(new AlignedListCellRenderer(0));
        this.processingPreferences = processingPreferences;
        this.ptmScoringPreferences = ptmScoringPreferences;
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private boolean validateInput() {
        int outcome;
        Double temp;
        try {
            temp = new Double(this.proteinFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the protein FDR.", "Input Error", 0);
                this.proteinFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the protein FDR.", "Input Error", 0);
            this.proteinFdrTxt.requestFocus();
            return false;
        }
        try {
            temp = new Double(this.peptideFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the peptide FDR.", "Input Error", 0);
                this.peptideFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the peptide FDR.", "Input Error", 0);
            this.peptideFdrTxt.requestFocus();
            return false;
        }
        try {
            temp = new Double(this.psmFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the PSM FDR.", "Input Error", 0);
                this.psmFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the PSM FDR.", "Input Error", 0);
            this.psmFdrTxt.requestFocus();
            return false;
        }
        try {
            if (this.probabilisticScoreCmb.getSelectedIndex() == 0 && this.thresholdCmb.getSelectedIndex() == 1 && ((temp = new Double(this.thresholdTxt.getText().trim())) < 0.0 || temp > 100.0)) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the score threshold.", "Input Error", 0);
                this.thresholdTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the score threshold.", "Input Error", 0);
            this.thresholdTxt.requestFocus();
            return false;
        }
        try {
            temp = new Double(this.proteinConfidenceMwTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the Protein Confidence MW.", "Input Error", 0);
                this.proteinConfidenceMwTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the Protein Confidence MW.", "Input Error", 0);
            this.proteinConfidenceMwTxt.requestFocus();
            return false;
        }
        if (this.probabilisticScoreCmb.getSelectedIndex() == 1 && ((outcome = JOptionPane.showConfirmDialog(this, "Disabling the probabilistic score will impair PTM localization and thus distinction\nbetween peptides. See help for more details. Continue with this setting?", "Warning", 2)) == 2 || outcome == -1)) {
            return false;
        }
        return this.probabilisticScoreCmb.getSelectedIndex() != 0 || this.neutralLossesCmb.getSelectedIndex() != 0 || (outcome = JOptionPane.showConfirmDialog(this, "In our experience probabilistic scores perform poorely when accounting for\nneutral losses. See help for more details. Continue with this setting?", "Warning", 2)) != 2 && outcome != -1;
    }

    private void initComponents() {
        this.neutralLossesLabel2 = new JLabel();
        this.neutralLossesCmb2 = new JComboBox();
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.processingParamsPanel = new JPanel();
        this.proteinFdrLabel = new JLabel();
        this.peptideFdrLabel = new JLabel();
        this.psmFdrLabel = new JLabel();
        this.psmFdrTxt = new JTextField();
        this.percentLabel = new JLabel();
        this.peptideFdrTxt = new JTextField();
        this.percentLabel2 = new JLabel();
        this.proteinFdrTxt = new JTextField();
        this.percentLabel3 = new JLabel();
        this.ptmScoringPanel = new JPanel();
        this.scoreCmb = new JComboBox();
        this.thresholdTxt = new JTextField();
        this.aScoreLabel = new JLabel();
        this.probabilisticScoreCmb = new JComboBox();
        this.neutralLossesLabel = new JLabel();
        this.estimateAScoreLabel = new JLabel();
        this.neutralLossesLabel1 = new JLabel();
        this.neutralLossesCmb = new JComboBox();
        this.neutralLossesLabel3 = new JLabel();
        this.thresholdCmb = new JComboBox();
        this.fractionsPanel = new JPanel();
        this.proteinMwLabel = new JLabel();
        this.proteinConfidenceMwTxt = new JTextField();
        this.percentLabel4 = new JLabel();
        this.helpJButton = new JButton();
        this.neutralLossesLabel2.setText("Account Neutral Losses");
        this.neutralLossesCmb2.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.setDefaultCloseOperation(2);
        this.setTitle("Processing");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProcessingPreferencesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.processingParamsPanel.setBorder(BorderFactory.createTitledBorder("Processing Parameters"));
        this.processingParamsPanel.setOpaque(false);
        this.proteinFdrLabel.setText("Protein FDR");
        this.peptideFdrLabel.setText("Peptide FDR");
        this.psmFdrLabel.setText("PSM FDR");
        this.psmFdrTxt.setHorizontalAlignment(0);
        this.psmFdrTxt.setText("1");
        this.percentLabel.setText("%");
        this.peptideFdrTxt.setHorizontalAlignment(0);
        this.peptideFdrTxt.setText("1");
        this.percentLabel2.setText("%");
        this.proteinFdrTxt.setHorizontalAlignment(0);
        this.proteinFdrTxt.setText("1");
        this.percentLabel3.setText("%");
        GroupLayout processingParamsPanelLayout = new GroupLayout(this.processingParamsPanel);
        this.processingParamsPanel.setLayout(processingParamsPanelLayout);
        processingParamsPanelLayout.setHorizontalGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingParamsPanelLayout.createSequentialGroup().addContainerGap().addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinFdrLabel).addComponent(this.peptideFdrLabel).addComponent(this.psmFdrLabel)).addGap(32, 92, Short.MAX_VALUE).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, processingParamsPanelLayout.createSequentialGroup().addComponent(this.proteinFdrTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel3)).addGroup(GroupLayout.Alignment.TRAILING, processingParamsPanelLayout.createSequentialGroup().addComponent(this.peptideFdrTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel2)).addGroup(GroupLayout.Alignment.TRAILING, processingParamsPanelLayout.createSequentialGroup().addComponent(this.psmFdrTxt, -2, 185, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel))).addContainerGap()));
        processingParamsPanelLayout.setVerticalGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingParamsPanelLayout.createSequentialGroup().addContainerGap().addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinFdrTxt, -2, -1, -2).addComponent(this.percentLabel3).addComponent(this.proteinFdrLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideFdrTxt, -2, -1, -2).addComponent(this.percentLabel2).addComponent(this.peptideFdrLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psmFdrLabel).addComponent(this.psmFdrTxt, -2, -1, -2).addComponent(this.percentLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.ptmScoringPanel.setBorder(BorderFactory.createTitledBorder("PTM Scoring"));
        this.ptmScoringPanel.setOpaque(false);
        this.scoreCmb.setModel(new DefaultComboBoxModel<String>(PtmScore.getScoreNames()));
        this.thresholdTxt.setHorizontalAlignment(0);
        this.aScoreLabel.setText("Threshold");
        this.probabilisticScoreCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.probabilisticScoreCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProcessingPreferencesDialog.this.probabilisticScoreCmbActionPerformed(evt);
            }
        });
        this.neutralLossesLabel.setText("Score");
        this.estimateAScoreLabel.setText("Probabilistic Score");
        this.neutralLossesLabel1.setText("Account Neutral Losses");
        this.neutralLossesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.neutralLossesLabel3.setText("Threshold Auto");
        this.thresholdCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.thresholdCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProcessingPreferencesDialog.this.thresholdCmbActionPerformed(evt);
            }
        });
        GroupLayout ptmScoringPanelLayout = new GroupLayout(this.ptmScoringPanel);
        this.ptmScoringPanel.setLayout(ptmScoringPanelLayout);
        ptmScoringPanelLayout.setHorizontalGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addContainerGap().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.neutralLossesLabel1).addGroup(ptmScoringPanelLayout.createSequentialGroup().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addComponent(this.estimateAScoreLabel).addGap(10, 61, Short.MAX_VALUE).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.probabilisticScoreCmb, GroupLayout.Alignment.TRAILING, 0, 185, Short.MAX_VALUE).addComponent(this.scoreCmb, GroupLayout.Alignment.TRAILING, 0, 185, Short.MAX_VALUE).addComponent(this.neutralLossesCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE))).addGroup(ptmScoringPanelLayout.createSequentialGroup().addComponent(this.neutralLossesLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.thresholdCmb, -2, 185, -2)).addGroup(ptmScoringPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.thresholdTxt, -2, 185, -2)).addGroup(ptmScoringPanelLayout.createSequentialGroup().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.neutralLossesLabel).addComponent(this.aScoreLabel)).addGap(0, 0, Short.MAX_VALUE))).addGap(29, 29, 29)))));
        ptmScoringPanelLayout.setVerticalGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addContainerGap().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.estimateAScoreLabel).addComponent(this.probabilisticScoreCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.neutralLossesLabel).addComponent(this.scoreCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.neutralLossesLabel1).addComponent(this.neutralLossesCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.neutralLossesLabel3).addComponent(this.thresholdCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aScoreLabel).addComponent(this.thresholdTxt, -2, -1, -2)).addContainerGap()));
        this.fractionsPanel.setBorder(BorderFactory.createTitledBorder("Fractions (Beta)"));
        this.fractionsPanel.setOpaque(false);
        this.proteinMwLabel.setText("Protein Confidence MW");
        this.proteinMwLabel.setToolTipText("<html>\nThe minium protein confidence required to be included in the<br>\naverage molecular weight analysis in the Fractions tab.\n</html>");
        this.proteinConfidenceMwTxt.setHorizontalAlignment(0);
        this.proteinConfidenceMwTxt.setText("95");
        this.proteinConfidenceMwTxt.setToolTipText("<html>\nThe minium protein confidence required to be included in the<br>\naverage molecular weight analysis in the Fractions tab.\n</html>");
        this.percentLabel4.setText("%");
        GroupLayout fractionsPanelLayout = new GroupLayout(this.fractionsPanel);
        this.fractionsPanel.setLayout(fractionsPanelLayout);
        fractionsPanelLayout.setHorizontalGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fractionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinMwLabel).addGap(30, 30, 30).addComponent(this.proteinConfidenceMwTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel4).addContainerGap()));
        fractionsPanelLayout.setVerticalGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fractionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinConfidenceMwTxt, -2, -1, -2).addComponent(this.percentLabel4).addComponent(this.proteinMwLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProcessingPreferencesDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProcessingPreferencesDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProcessingPreferencesDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton)).addComponent(this.ptmScoringPanel, -1, -1, Short.MAX_VALUE).addComponent(this.fractionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.processingParamsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.processingParamsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ptmScoringPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fractionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.processingPreferences.setProteinFDR(new Double(this.proteinFdrTxt.getText().trim()));
            this.processingPreferences.setPeptideFDR(new Double(this.peptideFdrTxt.getText().trim()));
            this.processingPreferences.setPsmFDR(new Double(this.psmFdrTxt.getText().trim()));
            this.ptmScoringPreferences.setProbabilitsticScoreCalculation(this.probabilisticScoreCmb.getSelectedIndex() == 0);
            this.ptmScoringPreferences.setSelectedProbabilisticScore(PtmScore.getScore(this.scoreCmb.getSelectedItem().toString()));
            this.ptmScoringPreferences.setProbabilisticScoreNeutralLosses(this.neutralLossesCmb.getSelectedIndex() == 0);
            if (this.thresholdCmb.getSelectedIndex() == 0) {
                this.ptmScoringPreferences.setEstimateFlr(true);
            } else {
                this.ptmScoringPreferences.setEstimateFlr(false);
                this.ptmScoringPreferences.setProbabilisticScoreThreshold(new Double(this.thresholdTxt.getText().trim()));
            }
            this.processingPreferences.setProteinConfidenceMwPlots(new Double(this.proteinConfidenceMwTxt.getText().trim()));
            this.dispose();
        }
    }

    private void probabilisticScoreCmbActionPerformed(ActionEvent evt) {
        if (this.probabilisticScoreCmb.getSelectedIndex() == 0) {
            this.scoreCmb.setEnabled(true);
            this.neutralLossesCmb.setEnabled(true);
            this.thresholdCmb.setEnabled(true);
            if (this.thresholdCmb.getSelectedIndex() == 1) {
                this.thresholdTxt.setEnabled(true);
                this.thresholdTxt.setEditable(true);
            } else {
                this.thresholdTxt.setEnabled(false);
                this.thresholdTxt.setEditable(false);
            }
        } else {
            this.scoreCmb.setEnabled(false);
            this.neutralLossesCmb.setEnabled(false);
            this.thresholdCmb.setEnabled(false);
            this.thresholdTxt.setEnabled(false);
            this.thresholdTxt.setEditable(false);
        }
    }

    private void thresholdCmbActionPerformed(ActionEvent evt) {
        if (this.thresholdCmb.getSelectedIndex() == 1) {
            this.thresholdTxt.setEnabled(true);
            this.thresholdTxt.setEditable(true);
        } else {
            this.thresholdTxt.setEnabled(false);
            this.thresholdTxt.setEditable(false);
        }
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/ProcessingPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), null, "Processing Preference Help");
        this.setCursor(new Cursor(0));
    }
}

