/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.annotation.gene;

import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.protein.Header;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class GeneFactory {
    private static GeneFactory instance = null;
    private HashMap<String, String> geneNameToChromosome = new HashMap();
    private BufferedRandomAccessFile geneMappingFile = null;
    public static final String separator = "\t";
    private HashMap<String, Long> geneIdIndexes = new HashMap();
    private HashMap<String, Long> geneNameIndexes = new HashMap();
    private boolean mappingFileOpen = false;
    private HashMap<String, Integer> ensemblVersions = new HashMap();

    public static GeneFactory getInstance() {
        if (instance == null) {
            instance = new GeneFactory();
        }
        return instance;
    }

    private GeneFactory() {
    }

    public void initialize(File file, WaitingHandler waitingHandler) throws IOException {
        this.clearFactory();
        if (this.geneMappingFile != null) {
            this.geneMappingFile.close();
        }
        this.geneMappingFile = new BufferedRandomAccessFile(file, "r", 102400);
        this.mappingFileOpen = true;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        long progressUnit = this.geneMappingFile.length() / 100L;
        String line = this.geneMappingFile.readLine();
        long index = this.geneMappingFile.getFilePointer();
        while ((line = this.geneMappingFile.readLine()) != null) {
            String[] splittedLine = line.split(separator);
            if (splittedLine.length == 3 && !splittedLine[0].equals("") && !splittedLine[1].equals("")) {
                String chromosome;
                boolean realChromosome;
                block7: {
                    realChromosome = false;
                    chromosome = splittedLine[2];
                    try {
                        Integer.parseInt(splittedLine[2]);
                        realChromosome = true;
                    }
                    catch (NumberFormatException e) {
                        if (!chromosome.equalsIgnoreCase("X") && !chromosome.equalsIgnoreCase("Y") && !chromosome.equalsIgnoreCase("Z") && !chromosome.equalsIgnoreCase("W")) break block7;
                        realChromosome = true;
                    }
                }
                if (realChromosome) {
                    String accession = splittedLine[0];
                    String geneName = splittedLine[1];
                    this.geneIdIndexes.put(accession, index);
                    this.geneNameIndexes.put(geneName, index);
                    this.geneNameToChromosome.put(geneName, chromosome);
                }
            }
            index = this.geneMappingFile.getFilePointer();
            if (waitingHandler == null) continue;
            waitingHandler.setSecondaryProgressCounter((int)(index / progressUnit));
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
    }

    public String getChromosomeForGeneName(String geneName) {
        return this.geneNameToChromosome.get(geneName);
    }

    public ArrayList<String> getMappedGenes() {
        return new ArrayList<String>(this.geneIdIndexes.keySet());
    }

    public ArrayList<String> getMappedGeneNames() {
        return new ArrayList<String>(this.geneNameIndexes.keySet());
    }

    public String getGeneName(String geneID) throws IOException {
        Long index = this.geneIdIndexes.get(geneID);
        if (index != null) {
            this.geneMappingFile.seek(index.longValue());
            String line = this.geneMappingFile.getNextLine();
            String[] splittedLine = line.split(separator);
            if (splittedLine.length != 3 || !splittedLine[0].equals(geneID)) {
                throw new IllegalArgumentException("Line \"" + line + "\" at index " + index + " does not correspond to gene ID " + geneID + ".");
            }
            return splittedLine[1];
        }
        return null;
    }

    public String getGeneEnsemblId(String geneName) throws IOException {
        Long index = this.geneNameIndexes.get(geneName);
        if (index != null) {
            this.geneMappingFile.seek(index.longValue());
            String line = this.geneMappingFile.getNextLine();
            String[] splittedLine = line.split(separator);
            if (splittedLine.length != 3 || !splittedLine[1].equals(geneName)) {
                throw new IllegalArgumentException("Line \"" + line + "\" at index " + index + " does not correspond to gene name " + geneName + ".");
            }
            return splittedLine[0];
        }
        return null;
    }

    public String getChromosomeFromGeneId(String geneID) throws IOException {
        Long index = this.geneIdIndexes.get(geneID);
        if (index != null) {
            this.geneMappingFile.seek(index.longValue());
            String line = this.geneMappingFile.getNextLine();
            String[] splittedLine = line.split(separator);
            if (splittedLine.length != 3 || !splittedLine[0].equals(geneID)) {
                throw new IllegalArgumentException("Line \"" + line + "\" at index " + index + " does not correspond to gene ID " + geneID + ".");
            }
            return splittedLine[2];
        }
        return null;
    }

    public String getChromosomeFromGeneName(String geneName) throws IOException {
        Long index = this.geneNameIndexes.get(geneName);
        if (index != null) {
            this.geneMappingFile.seek(index.longValue());
            String line = this.geneMappingFile.getNextLine();
            String[] splittedLine = line.split(separator);
            if (splittedLine.length != 3 || !splittedLine[1].equals(geneName)) {
                throw new IllegalArgumentException("Line \"" + line + "\" at index " + index + " does not correspond to gene name " + geneName + ".");
            }
            return splittedLine[2];
        }
        return null;
    }

    public String getGeneNameForUniProtProtein(String proteinAccession) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        Header header = SequenceFactory.getInstance().getHeader(proteinAccession);
        return header.getGeneName();
    }

    public void closeFiles() throws IOException {
        if (this.geneMappingFile != null) {
            this.geneMappingFile.close();
            this.mappingFileOpen = false;
        }
    }

    public void clearFactory() {
        this.geneIdIndexes.clear();
        this.geneNameIndexes.clear();
        this.geneNameToChromosome.clear();
    }

    public boolean isMappingFileOpen() {
        return this.mappingFileOpen;
    }

    public Integer getCurrentEnsemblVersion(String ensemblType) {
        if (ensemblType.equalsIgnoreCase("fungi") || ensemblType.equalsIgnoreCase("plants") || ensemblType.equalsIgnoreCase("protists") || ensemblType.equalsIgnoreCase("metazoa")) {
            return 23;
        }
        return 77;
    }

    public String getEnsemblDbName(int speciesTypeIndex) {
        switch (speciesTypeIndex) {
            case 1: {
                return "fungi_mart_" + this.getCurrentEnsemblVersion("fungi");
            }
            case 2: {
                return "plants_mart_" + this.getCurrentEnsemblVersion("plants");
            }
            case 3: {
                return "protists_mart_" + this.getCurrentEnsemblVersion("protists");
            }
            case 4: {
                return "metazoa_mart_" + this.getCurrentEnsemblVersion("metazoa");
            }
            case 5: {
                return "default";
            }
        }
        return "unknown";
    }
}

