/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.aminoacids.Alanine;
import com.compomics.util.experiment.biology.aminoacids.Arginine;
import com.compomics.util.experiment.biology.aminoacids.Asparagine;
import com.compomics.util.experiment.biology.aminoacids.AsparticAcid;
import com.compomics.util.experiment.biology.aminoacids.B;
import com.compomics.util.experiment.biology.aminoacids.Cysteine;
import com.compomics.util.experiment.biology.aminoacids.GlutamicAcid;
import com.compomics.util.experiment.biology.aminoacids.Glutamine;
import com.compomics.util.experiment.biology.aminoacids.Glycine;
import com.compomics.util.experiment.biology.aminoacids.Histidine;
import com.compomics.util.experiment.biology.aminoacids.Isoleucine;
import com.compomics.util.experiment.biology.aminoacids.J;
import com.compomics.util.experiment.biology.aminoacids.Leucine;
import com.compomics.util.experiment.biology.aminoacids.Lysine;
import com.compomics.util.experiment.biology.aminoacids.Methionine;
import com.compomics.util.experiment.biology.aminoacids.Phenylalanine;
import com.compomics.util.experiment.biology.aminoacids.Proline;
import com.compomics.util.experiment.biology.aminoacids.Pyrrolysine;
import com.compomics.util.experiment.biology.aminoacids.Selenocysteine;
import com.compomics.util.experiment.biology.aminoacids.Serine;
import com.compomics.util.experiment.biology.aminoacids.Threonine;
import com.compomics.util.experiment.biology.aminoacids.Tryptophan;
import com.compomics.util.experiment.biology.aminoacids.Tyrosine;
import com.compomics.util.experiment.biology.aminoacids.Valine;
import com.compomics.util.experiment.biology.aminoacids.X;
import com.compomics.util.experiment.biology.aminoacids.Z;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AminoAcid
implements Serializable {
    static final long serialVersionUID = -3158896310928354857L;
    public static final AminoAcid A = new Alanine();
    public static final AminoAcid C = new Cysteine();
    public static final AminoAcid D = new AsparticAcid();
    public static final AminoAcid E = new GlutamicAcid();
    public static final AminoAcid F = new Phenylalanine();
    public static final AminoAcid G = new Glycine();
    public static final AminoAcid H = new Histidine();
    public static final AminoAcid I = new Isoleucine();
    public static final AminoAcid K = new Lysine();
    public static final AminoAcid L = new Leucine();
    public static final AminoAcid M = new Methionine();
    public static final AminoAcid N = new Asparagine();
    public static final AminoAcid P = new Proline();
    public static final AminoAcid Q = new Glutamine();
    public static final AminoAcid R = new Arginine();
    public static final AminoAcid S = new Serine();
    public static final AminoAcid T = new Threonine();
    public static final AminoAcid V = new Valine();
    public static final AminoAcid W = new Tryptophan();
    public static final AminoAcid Y = new Tyrosine();
    public static final AminoAcid B = new B();
    public static final AminoAcid Z = new Z();
    public static final AminoAcid X = new X();
    public static final AminoAcid U = new Selenocysteine();
    public static final AminoAcid J = new J();
    public static final AminoAcid O = new Pyrrolysine();
    public String singleLetterCode;
    public String threeLetterCode;
    public String name;
    public double averageMass;
    public double monoisotopicMass;
    private static final char[] aminoAcidChars = new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'Y', 'U', 'O', 'V', 'W', 'B', 'J', 'Z', 'X'};
    private static final char[] uniqueAminoAcidChars = new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'Y', 'U', 'O', 'V', 'W'};
    public static final String[] aminoAcidStrings = new String[]{"A", "C", "D", "E", "F", "G", "H", "I", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "Y", "U", "O", "V", "W", "B", "J", "Z", "X"};
    private ArrayList<Character> indistinguishableAACache = null;
    private Double indistinguishableAACacheMass = null;

    public static char[] getAminoAcids() {
        return aminoAcidChars;
    }

    public char getSingleLetterCodeAsChar() {
        return this.singleLetterCode.charAt(0);
    }

    public static List<String> getAminoAcidsList() {
        return Arrays.asList(aminoAcidStrings);
    }

    public static char[] getUniqueAminoAcids() {
        return uniqueAminoAcidChars;
    }

    public static AminoAcid getAminoAcid(String aa) {
        return AminoAcid.getAminoAcid(aa.toUpperCase().charAt(0));
    }

    public static AminoAcid getAminoAcid(char letter) {
        switch (letter) {
            case 'A': 
            case 'a': {
                return A;
            }
            case 'C': 
            case 'c': {
                return C;
            }
            case 'D': 
            case 'd': {
                return D;
            }
            case 'E': 
            case 'e': {
                return E;
            }
            case 'F': 
            case 'f': {
                return F;
            }
            case 'G': 
            case 'g': {
                return G;
            }
            case 'H': 
            case 'h': {
                return H;
            }
            case 'I': 
            case 'i': {
                return I;
            }
            case 'K': 
            case 'k': {
                return K;
            }
            case 'L': 
            case 'l': {
                return L;
            }
            case 'M': 
            case 'm': {
                return M;
            }
            case 'N': 
            case 'n': {
                return N;
            }
            case 'P': 
            case 'p': {
                return P;
            }
            case 'Q': 
            case 'q': {
                return Q;
            }
            case 'R': 
            case 'r': {
                return R;
            }
            case 'S': 
            case 's': {
                return S;
            }
            case 'T': 
            case 't': {
                return T;
            }
            case 'V': 
            case 'v': {
                return V;
            }
            case 'W': 
            case 'w': {
                return W;
            }
            case 'Y': 
            case 'y': {
                return Y;
            }
            case 'B': 
            case 'b': {
                return B;
            }
            case 'Z': 
            case 'z': {
                return Z;
            }
            case 'X': 
            case 'x': {
                return X;
            }
            case 'U': 
            case 'u': {
                return U;
            }
            case 'J': 
            case 'j': {
                return J;
            }
            case 'O': 
            case 'o': {
                return O;
            }
        }
        throw new IllegalArgumentException("No amino acid found for letter " + letter + ".");
    }

    public abstract boolean iscombination();

    public char[] getSubAminoAcids() {
        return this.getSubAminoAcids(true);
    }

    public abstract char[] getSubAminoAcids(boolean var1);

    public abstract char[] getCombinations();

    public ArrayList<Character> getIndistinguishableAminoAcids(Double massTolerance) {
        if (massTolerance == null || massTolerance == Double.NaN || massTolerance == Double.NEGATIVE_INFINITY || massTolerance == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Mass tolerance " + massTolerance + " not valid for amino acids comparison.");
        }
        if (this.indistinguishableAACache == null || this.indistinguishableAACacheMass.doubleValue() != massTolerance.doubleValue()) {
            this.setIndistinguishibleAACache(massTolerance);
        }
        return this.indistinguishableAACache;
    }

    public synchronized void setIndistinguishibleAACache(Double massTolerance) {
        ArrayList<Character> result = new ArrayList<Character>();
        for (char aa : AminoAcid.getAminoAcids()) {
            if (!(Math.abs(this.monoisotopicMass - AminoAcid.getAminoAcid((char)aa).monoisotopicMass) < massTolerance)) continue;
            result.add(Character.valueOf(aa));
        }
        this.indistinguishableAACache = result;
        this.indistinguishableAACacheMass = massTolerance;
    }

    public static String getMatchingAminoAcid(String aminoAcid, SequenceMatchingPreferences sequenceMatchingPreferences) {
        AminoAcid aa = AminoAcid.getAminoAcid(aminoAcid);
        AminoAcidPattern aaPattern = new AminoAcidPattern(aminoAcid);
        for (String candidateAA : aminoAcidStrings) {
            if (!aaPattern.matches(candidateAA, sequenceMatchingPreferences)) continue;
            if (!aa.iscombination()) {
                return candidateAA;
            }
            char[] subAas = aa.getSubAminoAcids();
            boolean subAa = false;
            for (char aaChar : subAas) {
                if (aaChar != candidateAA.charAt(0)) continue;
                subAa = true;
                break;
            }
            if (subAa) continue;
            return candidateAA;
        }
        throw new IllegalArgumentException("No unique amino acid found for amino acid " + aminoAcid);
    }

    public static String getMatchingSequence(String sequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        StringBuilder stringBuilder = new StringBuilder(sequence.length());
        for (int i = 0; i < sequence.length(); ++i) {
            String aa = String.valueOf(sequence.charAt(i));
            aa = AminoAcid.getMatchingAminoAcid(aa, sequenceMatchingPreferences);
            stringBuilder.append(aa);
        }
        return stringBuilder.toString();
    }

    public abstract String[] getStandardGeneticCode();

    public static AminoAcid getAminoAcidFromGeneticCode(String geneticCode) {
        if (geneticCode.equals("TTT") || geneticCode.equals("TTC")) {
            return F;
        }
        if (geneticCode.equals("TTA") || geneticCode.equals("TTG") || geneticCode.equals("CTT") || geneticCode.equals("CTC") || geneticCode.equals("CTA") || geneticCode.equals("CTG")) {
            return L;
        }
        if (geneticCode.equals("ATT") || geneticCode.equals("ATC") || geneticCode.equals("ATA")) {
            return I;
        }
        if (geneticCode.equals("ATG")) {
            return M;
        }
        if (geneticCode.startsWith("GT")) {
            return V;
        }
        if (geneticCode.startsWith("TC")) {
            return S;
        }
        if (geneticCode.startsWith("CC")) {
            return P;
        }
        if (geneticCode.startsWith("AC")) {
            return T;
        }
        if (geneticCode.startsWith("GC")) {
            return A;
        }
        if (geneticCode.equals("TAT") || geneticCode.equals("TAC")) {
            return T;
        }
        if (geneticCode.equals("CAT") || geneticCode.equals("CAC")) {
            return H;
        }
        if (geneticCode.equals("CAA") || geneticCode.equals("CAG")) {
            return Q;
        }
        if (geneticCode.equals("AAT") || geneticCode.equals("AAC")) {
            return N;
        }
        if (geneticCode.equals("AAA") || geneticCode.equals("AAG")) {
            return K;
        }
        if (geneticCode.equals("GAT") || geneticCode.equals("GAC")) {
            return D;
        }
        if (geneticCode.equals("GAA") || geneticCode.equals("GAG")) {
            return E;
        }
        if (geneticCode.equals("TGT") || geneticCode.equals("TGC")) {
            return C;
        }
        if (geneticCode.equals("TGG")) {
            return W;
        }
        if (geneticCode.startsWith("CG")) {
            return R;
        }
        if (geneticCode.equals("AGT") || geneticCode.equals("AGC")) {
            return S;
        }
        if (geneticCode.equals("AGA") || geneticCode.equals("AGG")) {
            return R;
        }
        if (geneticCode.startsWith("GG")) {
            return G;
        }
        if (geneticCode.equals("TAG")) {
            return O;
        }
        if (geneticCode.equals("TGA")) {
            return U;
        }
        throw new IllegalArgumentException("No amino acid found for genetic code " + geneticCode + ".");
    }

    public boolean equals(Object obj) {
        if (obj instanceof AminoAcid) {
            return ((AminoAcid)obj).singleLetterCode.equalsIgnoreCase(this.singleLetterCode);
        }
        return false;
    }
}

