/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.ModificationProfile;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Pattern;

public class AminoAcidPattern
extends ExperimentObject
implements TagComponent {
    static final long serialVersionUID = -2823716418631089876L;
    private Integer target = 0;
    private int length = -1;
    private HashMap<Integer, ArrayList<AminoAcid>> aaTargeted = null;
    private HashMap<Integer, ArrayList<AminoAcid>> aaExcluded = null;
    private HashMap<Integer, ArrayList<ModificationMatch>> targetModifications = null;

    public AminoAcidPattern() {
    }

    public AminoAcidPattern(String sequence) {
        this.aaTargeted = new HashMap(sequence.length());
        for (int i = 0; i < sequence.length(); ++i) {
            char letter = sequence.charAt(i);
            AminoAcid aa = AminoAcid.getAminoAcid(letter);
            ArrayList<AminoAcid> list = new ArrayList<AminoAcid>(1);
            list.add(aa);
            this.aaTargeted.put(i, list);
        }
        this.length = sequence.length();
    }

    public AminoAcidPattern(AminoAcidSequence aminoAcidSequence) {
        String sequence = aminoAcidSequence.getSequence();
        this.aaTargeted = new HashMap(sequence.length());
        for (int i = 0; i < sequence.length(); ++i) {
            char letter = sequence.charAt(i);
            AminoAcid aa = AminoAcid.getAminoAcid(letter);
            ArrayList<AminoAcid> list = new ArrayList<AminoAcid>(1);
            list.add(aa);
            this.aaTargeted.put(i, list);
        }
        this.length = sequence.length();
        this.targetModifications = aminoAcidSequence.getModificationMatches();
    }

    public AminoAcidPattern(AminoAcidPattern aminoAcidPattern) {
        HashMap<Integer, ArrayList<ModificationMatch>> modificationMatches;
        HashMap<Integer, ArrayList<AminoAcid>> otherExcluded;
        this.target = aminoAcidPattern.getTarget();
        HashMap<Integer, ArrayList<AminoAcid>> otherTargets = aminoAcidPattern.getAaTargeted();
        if (otherTargets != null) {
            this.aaTargeted = new HashMap(otherTargets.size());
            for (int index : otherTargets.keySet()) {
                this.aaTargeted.put(index, (ArrayList)otherTargets.get(index).clone());
            }
        }
        if ((otherExcluded = aminoAcidPattern.getAaExcluded()) != null) {
            for (int index : otherExcluded.keySet()) {
                this.setExcluded(index, otherExcluded.get(index));
            }
        }
        if ((modificationMatches = aminoAcidPattern.getModificationMatches()) != null) {
            this.targetModifications = new HashMap(modificationMatches.size());
            for (int index : modificationMatches.keySet()) {
                this.targetModifications.put(index, (ArrayList)modificationMatches.get(index).clone());
            }
        }
    }

    public HashMap<Integer, ArrayList<AminoAcid>> getAaTargeted() {
        return this.aaTargeted;
    }

    public HashMap<Integer, ArrayList<AminoAcid>> getAaExcluded() {
        return this.aaExcluded;
    }

    public AminoAcidPattern(ArrayList<String> targetTesidues) throws IllegalArgumentException {
        ArrayList<AminoAcid> aminoAcids = new ArrayList<AminoAcid>(targetTesidues.size());
        for (String letter : targetTesidues) {
            AminoAcid aa = AminoAcid.getAminoAcid(letter);
            if (aa != null) {
                aminoAcids.add(aa);
                continue;
            }
            throw new IllegalArgumentException("Amino acid not recognized " + letter + ".");
        }
        this.aaTargeted = new HashMap(1);
        this.aaTargeted.put(0, aminoAcids);
        this.length = 1;
    }

    public void swapRows(int fromRow, int toRow) throws IllegalArgumentException {
        if (this.aaTargeted.size() < fromRow || fromRow < 0 || toRow < 0) {
            throw new IllegalArgumentException("Illegal row index: " + fromRow);
        }
        if (this.aaTargeted.size() < toRow || toRow < 0 || fromRow < 0) {
            throw new IllegalArgumentException("Illegal row index: " + toRow);
        }
        ArrayList<AminoAcid> toRowDataTarget = this.aaTargeted.get(toRow);
        this.aaTargeted.put(toRow, this.aaTargeted.get(fromRow));
        this.aaTargeted.put(fromRow, toRowDataTarget);
        if (this.target == fromRow) {
            this.target = toRow;
        } else if (this.target == toRow) {
            this.target = fromRow;
        }
    }

    public Integer getTarget() {
        return this.target;
    }

    public void setTarget(Integer target) {
        this.target = target;
    }

    public ArrayList<AminoAcid> getAminoAcidsAtTarget() {
        return this.getTargetedAA(this.target);
    }

    public void setTargeted(int index, ArrayList<AminoAcid> targets) {
        if (this.aaTargeted == null) {
            this.aaTargeted = new HashMap(1);
        }
        this.aaTargeted.put(index, targets);
        if (index + 1 > this.length) {
            this.length = index + 1;
        }
    }

    public void setExcluded(int index, ArrayList<AminoAcid> exceptions) {
        if (this.aaTargeted == null) {
            this.aaTargeted = new HashMap(1);
        }
        if (exceptions == null || exceptions.isEmpty()) {
            this.aaTargeted.put(index, new ArrayList());
        } else {
            ArrayList<AminoAcid> notExcluded = new ArrayList<AminoAcid>();
            ArrayList<AminoAcid> targeted = this.aaTargeted.get(index);
            if (targeted == null || targeted.isEmpty()) {
                for (char aa : AminoAcid.getUniqueAminoAcids()) {
                    AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
                    if (exceptions.contains(aminoAcid)) continue;
                    notExcluded.add(aminoAcid);
                }
            } else {
                for (AminoAcid aminoAcid : targeted) {
                    if (exceptions.contains(aminoAcid)) continue;
                    notExcluded.add(aminoAcid);
                }
            }
            this.aaTargeted.put(index, notExcluded);
        }
        if (index + 1 > this.length) {
            this.length = index + 1;
        }
    }

    public ArrayList<AminoAcid> getTargetedAA(int index) {
        ArrayList<AminoAcid> result;
        if (this.aaTargeted != null && (result = this.aaTargeted.get(index)) != null) {
            return result;
        }
        return new ArrayList<AminoAcid>();
    }

    public int getNTargetedAA(int index) {
        if (this.aaTargeted == null) {
            return 0;
        }
        ArrayList<AminoAcid> aas = this.getTargetedAA(index);
        return aas.size();
    }

    public void removeAA(int index) {
        ArrayList<Integer> indexes;
        if (this.aaTargeted != null) {
            indexes = new ArrayList<Integer>(this.aaTargeted.keySet());
            Collections.sort(indexes);
            for (int aa : indexes) {
                if (aa < index) continue;
                if (aa > index) {
                    this.aaTargeted.put(aa - 1, this.aaTargeted.get(aa));
                }
                this.aaTargeted.remove(aa);
            }
        }
        if (this.targetModifications != null) {
            indexes = new ArrayList<Integer>(this.targetModifications.keySet());
            Collections.sort(indexes);
            int ptmIndex = index + 1;
            for (int aa : indexes) {
                if (aa < ptmIndex || aa <= ptmIndex) continue;
                this.targetModifications.put(aa - 1, this.targetModifications.get(aa));
            }
        }
        this.length = -1;
    }

    public Pattern getAsStringPattern(SequenceMatchingPreferences sequenceMatchingPreferences) {
        SequenceMatchingPreferences.MatchingType matchingType = sequenceMatchingPreferences.getSequenceMatchingType();
        String regex = "";
        int tempLength = this.length();
        for (int i = 0; i < tempLength; ++i) {
            ArrayList<String> toAdd = new ArrayList<String>();
            if (this.aaTargeted != null) {
                ArrayList<AminoAcid> tempTarget = this.aaTargeted.get(i);
                if (tempTarget == null || tempTarget.isEmpty()) {
                    toAdd.addAll(AminoAcid.getAminoAcidsList());
                } else {
                    for (AminoAcid aa : tempTarget) {
                        String value;
                        if (!toAdd.contains(aa.singleLetterCode)) {
                            toAdd.add(aa.singleLetterCode);
                        }
                        if (matchingType != SequenceMatchingPreferences.MatchingType.aminoAcid && matchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                        for (char tempAa : aa.getSubAminoAcids()) {
                            value = tempAa + "";
                            if (toAdd.contains(value)) continue;
                            toAdd.add(value);
                        }
                        for (char tempAa : aa.getCombinations()) {
                            value = tempAa + "";
                            if (toAdd.contains(value)) continue;
                            toAdd.add(value);
                        }
                        if (matchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                        for (char tempAa : aa.getIndistinguishableAminoAcids(sequenceMatchingPreferences.getMs2MzTolerance())) {
                            String value2 = tempAa + "";
                            if (toAdd.contains(value2)) continue;
                            toAdd.add(value2);
                        }
                    }
                }
            }
            Collections.sort(toAdd);
            regex = regex + "[";
            for (String aa : toAdd) {
                regex = regex + aa;
            }
            regex = regex + "]";
        }
        return Pattern.compile(regex, 2);
    }

    public String getPrositeFormat() {
        StringBuilder result = new StringBuilder();
        int cpt = 0;
        for (int i = 0; i < this.length(); ++i) {
            ArrayList<AminoAcid> targetedAas = this.getTargetedAA(i);
            if (targetedAas.isEmpty()) {
                ++cpt;
            } else if (targetedAas.size() > 15) {
                ArrayList<AminoAcid> excludedAas = new ArrayList<AminoAcid>();
                for (char aa : AminoAcid.getUniqueAminoAcids()) {
                    AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
                    if (targetedAas.contains(aminoAcid)) continue;
                    excludedAas.add(aminoAcid);
                }
                if (cpt > 0) {
                    result.append("(").append(cpt).append(")");
                    cpt = 0;
                }
                result.append("{");
                for (AminoAcid aa : excludedAas) {
                    result.append(aa.singleLetterCode);
                }
                result.append("}");
            } else {
                if (cpt > 0) {
                    result.append("(").append(cpt).append(")");
                    cpt = 0;
                }
                if (!targetedAas.isEmpty()) {
                    result.append("[");
                    for (AminoAcid aa : targetedAas) {
                        result.append(aa.singleLetterCode);
                    }
                    result.append("]");
                }
            }
            if (i != this.target) continue;
            result.append("!");
        }
        return result.toString();
    }

    public ArrayList<Integer> getIndexes(String input, SequenceMatchingPreferences sequenceMatchingPreferences) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = 0;
        while ((index = this.firstIndex(input, sequenceMatchingPreferences, index)) >= 0) {
            result.add(index + 1);
            ++index;
        }
        return result;
    }

    public ArrayList<Integer> getIndexes(AminoAcidPattern input, SequenceMatchingPreferences sequenceMatchingPreferences) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = 0;
        while ((index = this.firstIndex(input, sequenceMatchingPreferences, index)) >= 0) {
            result.add(index + 1);
            ++index;
        }
        return result;
    }

    public int firstIndex(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidSequence, sequenceMatchingPreferences, 0);
    }

    public int firstIndex(AminoAcidSequence aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidSequence.getSequence(), sequenceMatchingPreferences, 0);
    }

    public int firstIndex(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidPattern, sequenceMatchingPreferences, 0);
    }

    public boolean contains(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        AminoAcidPattern pattern = new AminoAcidPattern(aminoAcidSequence);
        return pattern.firstIndex(this, sequenceMatchingPreferences) >= 0;
    }

    public boolean contains(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return aminoAcidPattern.firstIndex(this, sequenceMatchingPreferences) >= 0;
    }

    public int firstIndex(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences, int startIndex) {
        int patternLength = this.length();
        int aminoAcidPatternLength = aminoAcidSequence.length();
        int lastIndex = aminoAcidPatternLength - patternLength;
        for (int i = startIndex; i <= lastIndex; ++i) {
            boolean match = true;
            for (int j = 0; j < patternLength; ++j) {
                char aa = aminoAcidSequence.charAt(i + j);
                if (!this.isTargeted(aa, j, sequenceMatchingPreferences)) {
                    match = false;
                }
                if (!match) break;
            }
            if (!match) continue;
            return i + this.target;
        }
        return -1;
    }

    public int firstIndex(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences, int startIndex) {
        int patternLength = this.length();
        int aminoAcidPatternLength = aminoAcidPattern.length();
        int lastIndex = aminoAcidPatternLength - patternLength;
        for (int i = startIndex; i <= lastIndex; ++i) {
            boolean match = true;
            for (int j = 0; j < patternLength; ++j) {
                ArrayList<AminoAcid> aminoAcids = aminoAcidPattern.getTargetedAA(i + j);
                if (aminoAcids.isEmpty()) continue;
                boolean aaMatched = false;
                for (AminoAcid aminoAcid : aminoAcids) {
                    char aa = aminoAcid.singleLetterCode.charAt(0);
                    if (!this.isTargeted(aa, j, sequenceMatchingPreferences)) continue;
                    aaMatched = true;
                    break;
                }
                if (aaMatched) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i + this.target;
        }
        return -1;
    }

    public boolean isTargeted(char aa, int index, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (this.aaTargeted != null) {
            SequenceMatchingPreferences.MatchingType matchingType = sequenceMatchingPreferences.getSequenceMatchingType();
            ArrayList<AminoAcid> aaList = this.aaTargeted.get(index);
            if (aaList != null && !aaList.isEmpty()) {
                for (AminoAcid targetedAA : aaList) {
                    if (aa == targetedAA.getSingleLetterCodeAsChar()) {
                        return true;
                    }
                    if (matchingType != SequenceMatchingPreferences.MatchingType.aminoAcid && matchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                    for (char tempAA : targetedAA.getSubAminoAcids()) {
                        if (aa != tempAA) continue;
                        return true;
                    }
                    for (char tempAA : targetedAA.getCombinations()) {
                        if (aa != tempAA) continue;
                        return true;
                    }
                    if (matchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                    for (char tempAA : targetedAA.getIndistinguishableAminoAcids(sequenceMatchingPreferences.getMs2MzTolerance())) {
                        if (aa != tempAA) continue;
                        return true;
                    }
                }
            } else if (aaList != null) {
                return true;
            }
        }
        return false;
    }

    public boolean matchesIn(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidSequence, sequenceMatchingPreferences) >= 0;
    }

    public boolean matchesIn(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidPattern, sequenceMatchingPreferences) >= 0;
    }

    public boolean matches(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.length() == aminoAcidSequence.length() && this.firstIndex(aminoAcidSequence, sequenceMatchingPreferences) >= 0;
    }

    public boolean matches(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.length() == aminoAcidPattern.length() && this.firstIndex(aminoAcidPattern, sequenceMatchingPreferences) >= 0;
    }

    public boolean isStarting(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidSequence.substring(0, patternLength), sequenceMatchingPreferences);
    }

    public boolean isStarting(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidPattern.getSubPattern(0, patternLength, false), sequenceMatchingPreferences);
    }

    public boolean isEnding(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidPattern.getSubPattern(aminoAcidPattern.length() - patternLength, false), sequenceMatchingPreferences);
    }

    public boolean isEnding(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidSequence.substring(aminoAcidSequence.length() - patternLength), sequenceMatchingPreferences);
    }

    public boolean isSameAs(AminoAcidPattern anotherPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!this.matches(anotherPattern, sequenceMatchingPreferences)) {
            return false;
        }
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> mods1 = this.getModificationsAt(i);
            ArrayList<ModificationMatch> mods2 = anotherPattern.getModificationsAt(i);
            if (mods1.size() != mods2.size()) {
                return false;
            }
            for (ModificationMatch modificationMatch1 : mods1) {
                PTM ptm1 = ptmFactory.getPTM(modificationMatch1.getTheoreticPtm());
                boolean found = false;
                for (ModificationMatch modificationMatch2 : mods2) {
                    PTM ptm2 = ptmFactory.getPTM(modificationMatch2.getTheoreticPtm());
                    if (ptm1.getMass() != ptm2.getMass()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSameSequenceAndModificationStatusAs(AminoAcidPattern anotherPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!this.matches(anotherPattern, sequenceMatchingPreferences)) {
            return false;
        }
        PTMFactory ptmFactory = PTMFactory.getInstance();
        HashMap<Double, Integer> masses1 = new HashMap<Double, Integer>();
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> modifications = this.getModificationsAt(i);
            for (ModificationMatch modMatch : modifications) {
                PTM ptm = ptmFactory.getPTM(modMatch.getTheoreticPtm());
                double mass = ptm.getMass();
                Integer occurrence = (Integer)masses1.get(mass);
                if (occurrence == null) {
                    masses1.put(mass, 1);
                    continue;
                }
                masses1.put(mass, occurrence + 1);
            }
        }
        HashMap<Double, Integer> masses2 = new HashMap<Double, Integer>();
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> modifications = anotherPattern.getModificationsAt(i);
            for (ModificationMatch modMatch : modifications) {
                PTM ptm = ptmFactory.getPTM(modMatch.getTheoreticPtm());
                double mass = ptm.getMass();
                Integer occurrence = (Integer)masses2.get(mass);
                if (occurrence == null) {
                    masses2.put(mass, 1);
                    continue;
                }
                masses2.put(mass, occurrence + 1);
            }
        }
        if (masses1.size() != masses2.size()) {
            return false;
        }
        for (Double mass : masses1.keySet()) {
            Integer occurrence1 = (Integer)masses1.get(mass);
            Integer occurrence2 = (Integer)masses2.get(mass);
            if (occurrence2 != null && occurrence2 == occurrence1) continue;
            return false;
        }
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> mods1 = this.getModificationsAt(i);
            ArrayList<ModificationMatch> mods2 = anotherPattern.getModificationsAt(i);
            if (mods1.size() != mods2.size()) {
                return false;
            }
            for (int j = 0; j < mods1.size(); ++j) {
                ModificationMatch modificationMatch2;
                ModificationMatch modificationMatch1 = mods1.get(j);
                if (modificationMatch1.equals(modificationMatch2 = mods2.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public int length() {
        if (this.length == -1 || this.length == 0) {
            this.length = this.aaTargeted == null || this.aaTargeted.isEmpty() ? 0 : Collections.max(this.aaTargeted.keySet()) + 1;
        }
        return this.length;
    }

    public AminoAcidPattern getStandardSearchPattern() {
        AminoAcidPattern result = new AminoAcidPattern();
        result.setTarget(this.target);
        result.setTargeted(this.target, this.getAminoAcidsAtTarget());
        return result;
    }

    public static AminoAcidPattern getTrypsinExample() {
        AminoAcidPattern example = new AminoAcidPattern();
        example.setTarget(0);
        ArrayList<AminoAcid> target = new ArrayList<AminoAcid>();
        target.add(AminoAcid.K);
        target.add(AminoAcid.R);
        example.setTargeted(0, target);
        ArrayList<AminoAcid> exclusion = new ArrayList<AminoAcid>();
        exclusion.add(AminoAcid.P);
        example.setExcluded(1, exclusion);
        return example;
    }

    public void merge(AminoAcidPattern otherPattern) {
        HashMap<Integer, ArrayList<ModificationMatch>> modificationMatches;
        HashMap<Integer, ArrayList<AminoAcid>> otherInclusionMap = otherPattern.getAaTargeted();
        if (otherInclusionMap != null) {
            for (int i : otherInclusionMap.keySet()) {
                ArrayList<AminoAcid> targetedAA;
                ArrayList<AminoAcid> otherAAs = otherPattern.getTargetedAA(i);
                if (this.aaTargeted == null) {
                    this.aaTargeted = new HashMap(otherInclusionMap.size());
                }
                if ((targetedAA = this.aaTargeted.get(i)) == null) {
                    this.aaTargeted.put(i, (ArrayList)otherAAs.clone());
                } else if (!otherAAs.isEmpty()) {
                    for (AminoAcid aa : otherAAs) {
                        if (targetedAA.contains(aa)) continue;
                        targetedAA.add(aa);
                    }
                } else {
                    targetedAA.clear();
                }
                if (i + 1 <= this.length) continue;
                this.length = i + 1;
            }
        }
        if ((modificationMatches = otherPattern.getModificationMatches()) != null) {
            for (int i : modificationMatches.keySet()) {
                this.addModificationMatches(i, otherPattern.getModificationMatches().get(i));
                if (i + 1 <= this.length) continue;
                this.length = i + 1;
            }
        }
    }

    public void append(AminoAcidPattern otherPattern) {
        HashMap<Integer, ArrayList<ModificationMatch>> modificationMatches;
        int patternLength = this.length();
        HashMap<Integer, ArrayList<AminoAcid>> otherTargetedMap = otherPattern.getAaTargeted();
        if (otherTargetedMap != null) {
            if (this.aaTargeted == null) {
                this.aaTargeted = new HashMap(otherTargetedMap.size());
            }
            for (int i : otherTargetedMap.keySet()) {
                int index = patternLength + i;
                this.aaTargeted.put(index, (ArrayList)otherTargetedMap.get(i).clone());
            }
        }
        if ((modificationMatches = otherPattern.getModificationMatches()) != null) {
            for (int i : modificationMatches.keySet()) {
                int newIndex = i + patternLength;
                for (ModificationMatch oldModificationMatch : modificationMatches.get(i)) {
                    ModificationMatch newModificationMatch = new ModificationMatch(oldModificationMatch.getTheoreticPtm(), oldModificationMatch.isVariable(), newIndex);
                    this.addModificationMatch(newIndex, newModificationMatch);
                }
            }
        }
        this.length = patternLength + otherPattern.length();
    }

    public static AminoAcidPattern merge(AminoAcidPattern pattern1, AminoAcidPattern pattern2) {
        AminoAcidPattern result = new AminoAcidPattern(pattern1);
        result.merge(pattern2);
        return result;
    }

    public String toString() {
        return this.asSequence();
    }

    public StringBuilder asStringBuilder() {
        StringBuilder result = new StringBuilder(this.length());
        for (int i = 0; i < this.length(); ++i) {
            if (this.getNTargetedAA(i) == 1) {
                result.append(this.getTargetedAA((int)i).get((int)0).singleLetterCode);
                continue;
            }
            int nTargetedAas = this.getNTargetedAA(i);
            if (nTargetedAas == 0) {
                result.append("X");
                continue;
            }
            if (nTargetedAas == 1) {
                result.append(this.getTargetedAA((int)i).get((int)0).singleLetterCode);
                continue;
            }
            result.append("[");
            for (AminoAcid aa : this.getTargetedAA(i)) {
                result.append(aa.singleLetterCode);
            }
            result.append("]");
        }
        return result;
    }

    @Override
    public String asSequence() {
        return this.asStringBuilder().toString();
    }

    public String asSequence(int index) {
        return this.asStringBuilder().toString();
    }

    public HashMap<Integer, ArrayList<ModificationMatch>> getModificationMatches() {
        return this.targetModifications;
    }

    public ArrayList<Integer> getModificationIndexes() {
        if (this.targetModifications == null) {
            return new ArrayList<Integer>();
        }
        return new ArrayList<Integer>(this.targetModifications.keySet());
    }

    public ArrayList<ModificationMatch> getModificationsAt(int localization) {
        ArrayList<ModificationMatch> result;
        if (this.targetModifications != null && (result = this.targetModifications.get(localization)) != null) {
            return result;
        }
        return new ArrayList<ModificationMatch>();
    }

    public void removeModificationMatch(int localisation, ModificationMatch modificationMatch) {
        ArrayList<ModificationMatch> modificationMatches = this.targetModifications.get(localisation);
        if (modificationMatches != null) {
            modificationMatches.remove(modificationMatch);
            if (modificationMatches.isEmpty()) {
                this.targetModifications.remove(localisation);
            }
        }
    }

    public void clearModificationMatches() {
        if (this.targetModifications != null) {
            this.targetModifications.clear();
        }
    }

    public void addModificationMatch(int localization, ModificationMatch modificationMatch) {
        ArrayList<ModificationMatch> modificationMatches;
        int index = localization - 1;
        if (index < 0) {
            throw new IllegalArgumentException("Wrong modification target index " + localization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.targetModifications == null) {
            this.targetModifications = new HashMap();
        }
        if ((modificationMatches = this.targetModifications.get(localization)) == null) {
            modificationMatches = new ArrayList();
            this.targetModifications.put(localization, modificationMatches);
        }
        modificationMatches.add(modificationMatch);
    }

    public void addModificationMatches(int localization, ArrayList<ModificationMatch> modificationMatches) {
        ArrayList<ModificationMatch> modificationMatchesAtIndex;
        int index = localization - 1;
        if (index < 0) {
            throw new IllegalArgumentException("Wrong modification target index " + localization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.targetModifications == null) {
            this.targetModifications = new HashMap();
        }
        if ((modificationMatchesAtIndex = this.targetModifications.get(localization)) == null) {
            modificationMatchesAtIndex = new ArrayList();
            this.targetModifications.put(localization, modificationMatchesAtIndex);
        }
        modificationMatches.addAll(modificationMatches);
    }

    public void changeModificationSite(ModificationMatch modificationMatch, int oldLocalization, int newLocalization) {
        int oldIndex = oldLocalization - 1;
        if (oldIndex < 0) {
            throw new IllegalArgumentException("Wrong modification old target index " + oldLocalization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.targetModifications == null || !this.targetModifications.containsKey(oldIndex) || !this.targetModifications.get(oldIndex).contains(modificationMatch)) {
            throw new IllegalArgumentException("Modification match " + modificationMatch + " not found at index " + oldLocalization + ".");
        }
        this.targetModifications.get(oldIndex).remove(modificationMatch);
        this.addModificationMatch(newLocalization, modificationMatch);
    }

    public String getTaggedModifiedSequence(ModificationProfile modificationProfile, boolean useHtmlColorCoding, boolean useShortName, boolean excludeAllFixedPtms) {
        HashMap<Integer, ArrayList<String>> mainModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> secondaryModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> fixedModificationSites = new HashMap<Integer, ArrayList<String>>();
        if (this.targetModifications != null) {
            for (int modSite : this.targetModifications.keySet()) {
                for (ModificationMatch modificationMatch : this.targetModifications.get(modSite)) {
                    String modName = modificationMatch.getTheoreticPtm();
                    if (modificationMatch.isVariable()) {
                        if (modificationMatch.isConfident()) {
                            if (!mainModificationSites.containsKey(modSite)) {
                                mainModificationSites.put(modSite, new ArrayList());
                            }
                            mainModificationSites.get(modSite).add(modName);
                            continue;
                        }
                        if (!secondaryModificationSites.containsKey(modSite)) {
                            secondaryModificationSites.put(modSite, new ArrayList());
                        }
                        secondaryModificationSites.get(modSite).add(modName);
                        continue;
                    }
                    if (excludeAllFixedPtms) continue;
                    if (!fixedModificationSites.containsKey(modSite)) {
                        fixedModificationSites.put(modSite, new ArrayList());
                    }
                    fixedModificationSites.get(modSite).add(modName);
                }
            }
        }
        return AminoAcidPattern.getTaggedModifiedSequence(modificationProfile, this, mainModificationSites, secondaryModificationSites, fixedModificationSites, useHtmlColorCoding, useShortName);
    }

    public static String getTaggedModifiedSequence(ModificationProfile modificationProfile, AminoAcidPattern aminoAcidPattern, HashMap<Integer, ArrayList<String>> mainModificationSites, HashMap<Integer, ArrayList<String>> secondaryModificationSites, HashMap<Integer, ArrayList<String>> fixedModificationSites, boolean useHtmlColorCoding, boolean useShortName) {
        if (mainModificationSites == null) {
            mainModificationSites = new HashMap();
        }
        if (secondaryModificationSites == null) {
            secondaryModificationSites = new HashMap();
        }
        if (fixedModificationSites == null) {
            fixedModificationSites = new HashMap();
        }
        String modifiedSequence = "";
        for (int aa = 1; aa <= aminoAcidPattern.length(); ++aa) {
            int patternIndex = aa - 1;
            if (aminoAcidPattern.getNTargetedAA(patternIndex) > 1) {
                modifiedSequence = modifiedSequence + "[";
            }
            if (aminoAcidPattern.getNTargetedAA(patternIndex) == 0) {
                if (mainModificationSites.containsKey(aa) && !mainModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : mainModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue("X", ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                } else if (secondaryModificationSites.containsKey(aa) && !secondaryModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : secondaryModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue("X", ptmName, modificationProfile, false, useHtmlColorCoding, useShortName);
                    }
                } else if (fixedModificationSites.containsKey(aa) && !fixedModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : fixedModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue("X", ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                } else {
                    modifiedSequence = modifiedSequence + "X";
                }
            }
            for (AminoAcid aminoAcid : aminoAcidPattern.getTargetedAA(patternIndex)) {
                if (mainModificationSites.containsKey(aa) && !mainModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : mainModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue(aminoAcid.singleLetterCode, ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                    continue;
                }
                if (secondaryModificationSites.containsKey(aa) && !secondaryModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : secondaryModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue(aminoAcid.singleLetterCode, ptmName, modificationProfile, false, useHtmlColorCoding, useShortName);
                    }
                    continue;
                }
                if (fixedModificationSites.containsKey(aa) && !fixedModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : fixedModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue(aminoAcid.singleLetterCode, ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                    continue;
                }
                modifiedSequence = modifiedSequence + aminoAcid.singleLetterCode;
            }
            if (aminoAcidPattern.getNTargetedAA(aa) <= 1) continue;
            modifiedSequence = modifiedSequence + "]";
        }
        return modifiedSequence;
    }

    private static String getTaggedResidue(String residue, String ptmName, ModificationProfile modificationProfile, boolean mainPtm, boolean useHtmlColorCoding, boolean useShortName) {
        String taggedResidue = "";
        PTMFactory ptmFactory = PTMFactory.getInstance();
        PTM ptm = ptmFactory.getPTM(ptmName);
        if (ptm.getType() == 0) {
            if (!useHtmlColorCoding) {
                taggedResidue = useShortName ? taggedResidue + residue + "<" + ptmFactory.getShortName(ptmName) + ">" : taggedResidue + residue + "<" + ptmName + ">";
            } else {
                Color ptmColor = modificationProfile.getColor(ptmName);
                taggedResidue = mainPtm ? taggedResidue + "<span style=\"color:#" + Util.color2Hex(Color.WHITE) + ";background:#" + Util.color2Hex(ptmColor) + "\">" + residue + "</span>" : taggedResidue + "<span style=\"color:#" + Util.color2Hex(ptmColor) + ";background:#" + Util.color2Hex(Color.WHITE) + "\">" + residue + "</span>";
            }
        } else {
            taggedResidue = taggedResidue + residue;
        }
        return taggedResidue;
    }

    public ArrayList<String> getAllPossibleSequences() {
        ArrayList<StringBuilder> stringBuilders = new ArrayList<StringBuilder>();
        for (int i = 0; i < this.length(); ++i) {
            if (stringBuilders.isEmpty()) {
                if (this.aaTargeted != null) {
                    ArrayList<AminoAcid> aminoAcids = this.aaTargeted.get(i);
                    if (aminoAcids != null && !aminoAcids.isEmpty()) {
                        for (AminoAcid aminoAcid : aminoAcids) {
                            stringBuilders.add(new StringBuilder(aminoAcid.singleLetterCode));
                        }
                        continue;
                    }
                    stringBuilders.add(new StringBuilder("X"));
                    continue;
                }
                stringBuilders.add(new StringBuilder("X"));
                continue;
            }
            ArrayList<StringBuilder> newBuilders = new ArrayList<StringBuilder>();
            for (StringBuilder stringBuilder : stringBuilders) {
                StringBuilder newBuilder = new StringBuilder(stringBuilder);
                if (this.aaTargeted != null) {
                    ArrayList<AminoAcid> aminoAcids = this.aaTargeted.get(i);
                    if (aminoAcids != null && !aminoAcids.isEmpty()) {
                        for (AminoAcid aminoAcid : this.aaTargeted.get(i)) {
                            newBuilder.append(aminoAcid.singleLetterCode);
                            newBuilders.add(newBuilder);
                        }
                        continue;
                    }
                    newBuilder.append("X");
                    newBuilders.add(newBuilder);
                    continue;
                }
                newBuilder.append("X");
                newBuilders.add(newBuilder);
            }
            stringBuilders = newBuilders;
        }
        ArrayList<String> results = new ArrayList<String>(stringBuilders.size());
        for (StringBuilder stringBuilder : stringBuilders) {
            results.add(stringBuilder.toString());
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Double getMass() {
        double mass = 0.0;
        for (int i = 0; i < this.length(); ++i) {
            ArrayList<ModificationMatch> modificationAtIndex;
            if (this.aaTargeted == null) throw new IllegalArgumentException("Impossible to estimate the mass of the amino acid pattern " + this.asSequence() + ". null as targeted amino acid map.");
            ArrayList<AminoAcid> aminoAcids = this.aaTargeted.get(i);
            if (aminoAcids.size() != 1) throw new IllegalArgumentException("Impossible to estimate the mass of the amino acid pattern " + this.asSequence() + ". " + aminoAcids.size() + " amino acids at target position " + i + " as targeted amino acid.");
            mass += this.getTargetedAA((int)i).get((int)0).monoisotopicMass;
            if (this.targetModifications == null || (modificationAtIndex = this.targetModifications.get(i + 1)) == null) continue;
            for (ModificationMatch modificationMatch : modificationAtIndex) {
                PTM ptm = PTMFactory.getInstance().getPTM(modificationMatch.getTheoreticPtm());
                mass += ptm.getMass();
            }
        }
        return mass;
    }

    public AminoAcidPattern getSubPattern(int startIndex, int endIndex, boolean updateTarget) {
        AminoAcidPattern aminoAcidPattern = new AminoAcidPattern();
        if (this.aaTargeted != null) {
            for (int i : this.aaTargeted.keySet()) {
                if (i < startIndex || i > endIndex) continue;
                ArrayList aminoAcids = (ArrayList)this.aaTargeted.get(i).clone();
                aminoAcidPattern.setTargeted(i - startIndex, aminoAcids);
            }
        }
        if (updateTarget) {
            aminoAcidPattern.setTarget(this.getTarget() - startIndex);
        } else {
            aminoAcidPattern.setTarget(this.getTarget());
        }
        if (this.targetModifications != null) {
            for (int i : this.targetModifications.keySet()) {
                if (i <= startIndex || i > endIndex + 1) continue;
                int index = i - startIndex;
                ArrayList<ModificationMatch> modificationMatches = this.targetModifications.get(i);
                ArrayList<ModificationMatch> newMatches = new ArrayList<ModificationMatch>(modificationMatches.size());
                for (ModificationMatch modificationMatch : modificationMatches) {
                    newMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), index));
                }
                aminoAcidPattern.addModificationMatches(index, newMatches);
            }
        }
        return aminoAcidPattern;
    }

    public AminoAcidPattern getSubPattern(int startIndex, boolean updateTarget) {
        return this.getSubPattern(startIndex, this.length(), updateTarget);
    }

    public AminoAcidPattern reverse() {
        int reversed;
        AminoAcidPattern newPattern = new AminoAcidPattern();
        if (this.aaTargeted != null) {
            for (int i : this.aaTargeted.keySet()) {
                reversed = this.length() - i - 1;
                newPattern.setTargeted(reversed, (ArrayList)this.aaTargeted.get(i).clone());
            }
        }
        if (this.targetModifications != null) {
            for (int i : this.targetModifications.keySet()) {
                reversed = this.length() - i + 1;
                for (ModificationMatch modificationMatch : this.targetModifications.get(i)) {
                    ModificationMatch newMatch = new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), reversed);
                    if (modificationMatch.isConfident()) {
                        newMatch.setConfident(true);
                    }
                    if (modificationMatch.isInferred()) {
                        newMatch.setInferred(true);
                    }
                    newPattern.addModificationMatch(reversed, newMatch);
                }
            }
        }
        if (this.target > -1) {
            newPattern.setTarget(this.length() - this.target - 1);
        }
        return newPattern;
    }

    @Override
    public boolean isSameAs(TagComponent anotherCompontent, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!(anotherCompontent instanceof AminoAcidPattern)) {
            return false;
        }
        AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)anotherCompontent;
        return this.isSameAs(aminoAcidPattern, sequenceMatchingPreferences);
    }

    @Override
    public boolean isSameSequenceAndModificationStatusAs(TagComponent anotherCompontent, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!(anotherCompontent instanceof AminoAcidPattern)) {
            return false;
        }
        AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)anotherCompontent;
        return this.isSameSequenceAndModificationStatusAs(aminoAcidPattern, sequenceMatchingPreferences);
    }
}

