/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.ModificationProfile;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;

public class AminoAcidSequence
extends ExperimentObject
implements TagComponent {
    private String sequence;
    private StringBuilder sequenceStringBuilder = null;
    private AminoAcidPattern aminoAcidPattern = null;
    private HashMap<Integer, ArrayList<ModificationMatch>> modifications = null;

    public AminoAcidSequence() {
    }

    public AminoAcidSequence(String sequence) {
        this.sequence = sequence;
    }

    public AminoAcidSequence(String sequence, HashMap<Integer, ArrayList<ModificationMatch>> modifications) {
        this.sequence = sequence;
        this.modifications = modifications;
    }

    public AminoAcidSequence(AminoAcidSequence sequence) {
        this.sequence = sequence.getSequence();
        HashMap<Integer, ArrayList<ModificationMatch>> modificationMatches = sequence.getModificationMatches();
        if (modificationMatches != null) {
            this.modifications = new HashMap(modificationMatches.size());
            for (int index : modificationMatches.keySet()) {
                this.modifications.put(index, (ArrayList)modificationMatches.get(index).clone());
            }
        }
    }

    public String getSequence() {
        this.setSequenceStringBuilder(false);
        if (this.sequence != null) {
            return this.sequence;
        }
        return "";
    }

    public char charAt(int aa) {
        this.setSequenceStringBuilder(false);
        return this.sequence.charAt(aa);
    }

    public AminoAcid getAminoAcidAt(int aa) {
        return AminoAcid.getAminoAcid(this.charAt(aa));
    }

    public void setSequence(String aminoAcidSequence) {
        this.sequenceStringBuilder = null;
        this.sequence = aminoAcidSequence;
    }

    public void setAaAtIndex(int index, char aa) {
        this.setSequenceStringBuilder(true);
        this.sequenceStringBuilder.setCharAt(index, aa);
    }

    public AminoAcidPattern getAsAminoAcidPattern() {
        this.setSequenceStringBuilder(false);
        if (this.aminoAcidPattern == null) {
            this.aminoAcidPattern = new AminoAcidPattern(this.sequence);
        }
        return this.aminoAcidPattern;
    }

    private void setSequenceStringBuilder(boolean stringbuilder) {
        if (stringbuilder && this.sequenceStringBuilder == null) {
            if (this.sequence != null) {
                this.sequenceStringBuilder = new StringBuilder(this.sequence);
                this.sequence = null;
            } else {
                this.sequenceStringBuilder = new StringBuilder();
            }
        } else if (this.sequence == null && this.sequenceStringBuilder != null) {
            this.sequence = this.sequenceStringBuilder.toString();
        }
    }

    public void emptyInternalCaches() {
        this.sequenceStringBuilder = null;
        this.aminoAcidPattern = null;
    }

    public boolean matchesIn(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidSequence, sequenceMatchingPreferences) >= 0;
    }

    public boolean matchesIn(AminoAcidSequence aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.matchesIn(aminoAcidSequence.getSequence(), sequenceMatchingPreferences);
    }

    public boolean matches(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.length() == aminoAcidSequence.length() && this.firstIndex(aminoAcidSequence, sequenceMatchingPreferences) >= 0;
    }

    public boolean matches(AminoAcidSequence aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.matches(aminoAcidSequence.getSequence(), sequenceMatchingPreferences);
    }

    public int firstIndex(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.getAsAminoAcidPattern().firstIndex(aminoAcidSequence, sequenceMatchingPreferences, 0);
    }

    public boolean isSameSequenceAndModificationStatusAs(AminoAcidPattern anotherPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!anotherPattern.matches(anotherPattern, sequenceMatchingPreferences)) {
            return false;
        }
        PTMFactory ptmFactory = PTMFactory.getInstance();
        HashMap<Double, Integer> masses1 = new HashMap<Double, Integer>();
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> tempModifications = this.getModificationsAt(i);
            for (ModificationMatch modMatch : tempModifications) {
                PTM ptm = ptmFactory.getPTM(modMatch.getTheoreticPtm());
                double mass = ptm.getMass();
                Integer occurrence = (Integer)masses1.get(mass);
                if (occurrence == null) {
                    masses1.put(mass, 1);
                    continue;
                }
                masses1.put(mass, occurrence + 1);
            }
        }
        HashMap<Double, Integer> masses2 = new HashMap<Double, Integer>();
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> tempModifications = anotherPattern.getModificationsAt(i);
            for (ModificationMatch modMatch : tempModifications) {
                PTM ptm = ptmFactory.getPTM(modMatch.getTheoreticPtm());
                double mass = ptm.getMass();
                Integer occurrence = (Integer)masses2.get(mass);
                if (occurrence == null) {
                    masses2.put(mass, 1);
                    continue;
                }
                masses2.put(mass, occurrence + 1);
            }
        }
        if (masses1.size() != masses2.size()) {
            return false;
        }
        for (Double mass : masses1.keySet()) {
            Integer occurrence1 = (Integer)masses1.get(mass);
            Integer occurrence2 = (Integer)masses2.get(mass);
            if (occurrence2 != null && occurrence2 == occurrence1) continue;
            return false;
        }
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> mods1 = this.getModificationsAt(i);
            ArrayList<ModificationMatch> mods2 = anotherPattern.getModificationsAt(i);
            if (mods1.size() != mods2.size()) {
                return false;
            }
            for (int j = 0; j < mods1.size(); ++j) {
                ModificationMatch modificationMatch2;
                ModificationMatch modificationMatch1 = mods1.get(j);
                if (modificationMatch1.equals(modificationMatch2 = mods2.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public int length() {
        if (this.sequence != null) {
            return this.sequence.length();
        }
        if (this.sequenceStringBuilder != null) {
            return this.sequenceStringBuilder.length();
        }
        return 0;
    }

    public void append(AminoAcidSequence otherSequence) {
        this.setSequenceStringBuilder(true);
        int previousLength = this.length();
        this.sequenceStringBuilder.append(otherSequence.getSequence());
        HashMap<Integer, ArrayList<ModificationMatch>> modificationMatches = otherSequence.getModificationMatches();
        if (modificationMatches != null) {
            for (int i : modificationMatches.keySet()) {
                int newIndex = i + previousLength;
                for (ModificationMatch oldModificationMatch : modificationMatches.get(i)) {
                    ModificationMatch newModificationMatch = new ModificationMatch(oldModificationMatch.getTheoreticPtm(), oldModificationMatch.isVariable(), newIndex);
                    this.addModificationMatch(newIndex, newModificationMatch);
                }
            }
        }
    }

    public void append(String otherSequence) {
        this.setSequenceStringBuilder(true);
        this.sequenceStringBuilder.append(otherSequence);
    }

    public HashMap<Integer, ArrayList<ModificationMatch>> getModificationMatches() {
        return this.modifications;
    }

    public ArrayList<Integer> getModificationIndexes() {
        if (this.modifications == null) {
            return new ArrayList<Integer>();
        }
        return new ArrayList<Integer>(this.modifications.keySet());
    }

    public ArrayList<ModificationMatch> getModificationsAt(int localization) {
        ArrayList<ModificationMatch> result;
        if (this.modifications != null && (result = this.modifications.get(localization)) != null) {
            return result;
        }
        return new ArrayList<ModificationMatch>();
    }

    public void removeModificationMatch(int localisation, ModificationMatch modificationMatch) {
        ArrayList<ModificationMatch> modificationMatches = this.modifications.get(localisation);
        if (modificationMatches != null) {
            modificationMatches.remove(modificationMatch);
            if (modificationMatches.isEmpty()) {
                this.modifications.remove(localisation);
            }
        }
    }

    public void clearModificationMatches() {
        if (this.modifications != null) {
            this.modifications.clear();
        }
    }

    public void addModificationMatch(int localization, ModificationMatch modificationMatch) {
        ArrayList<ModificationMatch> modificationMatches;
        int index = localization - 1;
        if (index < 0) {
            throw new IllegalArgumentException("Wrong modification target index " + localization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.modifications == null) {
            this.modifications = new HashMap();
        }
        if ((modificationMatches = this.modifications.get(localization)) == null) {
            modificationMatches = new ArrayList();
            this.modifications.put(localization, modificationMatches);
        }
        modificationMatches.add(modificationMatch);
    }

    public void addModificationMatches(int localization, ArrayList<ModificationMatch> modificationMatches) {
        ArrayList<ModificationMatch> modificationMatchesAtIndex;
        int index = localization - 1;
        if (index < 0) {
            throw new IllegalArgumentException("Wrong modification target index " + localization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.modifications == null) {
            this.modifications = new HashMap();
        }
        if ((modificationMatchesAtIndex = this.modifications.get(localization)) == null) {
            modificationMatchesAtIndex = new ArrayList();
            this.modifications.put(localization, modificationMatchesAtIndex);
        }
        modificationMatches.addAll(modificationMatches);
    }

    public void changeModificationSite(ModificationMatch modificationMatch, int oldLocalization, int newLocalization) {
        int oldIndex = oldLocalization - 1;
        if (oldIndex < 0) {
            throw new IllegalArgumentException("Wrong modification old target index " + oldLocalization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.modifications == null || !this.modifications.containsKey(oldIndex) || !this.modifications.get(oldIndex).contains(modificationMatch)) {
            throw new IllegalArgumentException("Modification match " + modificationMatch + " not found at index " + oldLocalization + ".");
        }
        this.modifications.get(oldIndex).remove(modificationMatch);
        this.addModificationMatch(newLocalization, modificationMatch);
    }

    public String getTaggedModifiedSequence(ModificationProfile modificationProfile, boolean useHtmlColorCoding, boolean useShortName, boolean excludeAllFixedPtms) {
        HashMap<Integer, ArrayList<String>> confidentModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> representativeModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> secondaryModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> fixedModificationSites = new HashMap<Integer, ArrayList<String>>();
        if (this.modifications != null) {
            for (int modSite : this.modifications.keySet()) {
                for (ModificationMatch modificationMatch : this.modifications.get(modSite)) {
                    String modName = modificationMatch.getTheoreticPtm();
                    if (modificationMatch.isVariable()) {
                        if (modificationMatch.isConfident()) {
                            if (!confidentModificationSites.containsKey(modSite)) {
                                confidentModificationSites.put(modSite, new ArrayList());
                            }
                            confidentModificationSites.get(modSite).add(modName);
                            continue;
                        }
                        if (!representativeModificationSites.containsKey(modSite)) {
                            representativeModificationSites.put(modSite, new ArrayList());
                        }
                        representativeModificationSites.get(modSite).add(modName);
                        continue;
                    }
                    if (excludeAllFixedPtms) continue;
                    if (!fixedModificationSites.containsKey(modSite)) {
                        fixedModificationSites.put(modSite, new ArrayList());
                    }
                    fixedModificationSites.get(modSite).add(modName);
                }
            }
        }
        this.setSequenceStringBuilder(false);
        return AminoAcidSequence.getTaggedModifiedSequence(modificationProfile, this.sequence, confidentModificationSites, representativeModificationSites, secondaryModificationSites, fixedModificationSites, useHtmlColorCoding, useShortName);
    }

    public static String getTaggedModifiedSequence(ModificationProfile modificationProfile, String sequence, HashMap<Integer, ArrayList<String>> confidentModificationSites, HashMap<Integer, ArrayList<String>> representativeAmbiguousModificationSites, HashMap<Integer, ArrayList<String>> secondaryAmbiguousModificationSites, HashMap<Integer, ArrayList<String>> fixedModificationSites, boolean useHtmlColorCoding, boolean useShortName) {
        if (confidentModificationSites == null) {
            confidentModificationSites = new HashMap();
        }
        if (representativeAmbiguousModificationSites == null) {
            representativeAmbiguousModificationSites = new HashMap();
        }
        if (secondaryAmbiguousModificationSites == null) {
            secondaryAmbiguousModificationSites = new HashMap();
        }
        if (fixedModificationSites == null) {
            fixedModificationSites = new HashMap();
        }
        StringBuilder modifiedSequence = new StringBuilder(sequence.length());
        for (int aa = 1; aa <= sequence.length(); ++aa) {
            int aaIndex = aa - 1;
            char aminoAcid = sequence.charAt(aaIndex);
            if (confidentModificationSites.containsKey(aa) && !confidentModificationSites.get(aa).isEmpty()) {
                for (String ptmName : confidentModificationSites.get(aa)) {
                    modifiedSequence.append(AminoAcidSequence.getTaggedResidue(aminoAcid, ptmName, modificationProfile, 1, useHtmlColorCoding, useShortName));
                }
                continue;
            }
            if (representativeAmbiguousModificationSites.containsKey(aa) && !representativeAmbiguousModificationSites.get(aa).isEmpty()) {
                for (String ptmName : representativeAmbiguousModificationSites.get(aa)) {
                    modifiedSequence.append(AminoAcidSequence.getTaggedResidue(aminoAcid, ptmName, modificationProfile, 2, useHtmlColorCoding, useShortName));
                }
                continue;
            }
            if (secondaryAmbiguousModificationSites.containsKey(aa) && !secondaryAmbiguousModificationSites.get(aa).isEmpty()) {
                for (String ptmName : secondaryAmbiguousModificationSites.get(aa)) {
                    modifiedSequence.append(AminoAcidSequence.getTaggedResidue(aminoAcid, ptmName, modificationProfile, 3, useHtmlColorCoding, useShortName));
                }
                continue;
            }
            if (fixedModificationSites.containsKey(aa) && !fixedModificationSites.get(aa).isEmpty()) {
                for (String ptmName : fixedModificationSites.get(aa)) {
                    modifiedSequence.append(AminoAcidSequence.getTaggedResidue(aminoAcid, ptmName, modificationProfile, 1, useHtmlColorCoding, useShortName));
                }
                continue;
            }
            modifiedSequence.append(aminoAcid);
        }
        return modifiedSequence.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getTaggedResidue(char residue, String ptmName, ModificationProfile modificationProfile, int localizationConfidenceLevel, boolean useHtmlColorCoding, boolean useShortName) {
        StringBuilder taggedResidue = new StringBuilder();
        PTMFactory ptmFactory = PTMFactory.getInstance();
        PTM ptm = ptmFactory.getPTM(ptmName);
        if (ptm.getType() == 0) {
            if (!useHtmlColorCoding) {
                if (localizationConfidenceLevel != 1 && localizationConfidenceLevel != 2) return taggedResidue.toString();
                if (useShortName) {
                    taggedResidue.append(residue).append("<").append(ptmFactory.getShortName(ptmName)).append(">");
                    return taggedResidue.toString();
                } else {
                    taggedResidue.append(residue).append("<").append(ptmName).append(">");
                }
                return taggedResidue.toString();
            } else {
                Color ptmColor = modificationProfile.getColor(ptmName);
                if (localizationConfidenceLevel == 1) {
                    taggedResidue.append("<span style=\"color:#").append(Util.color2Hex(Color.WHITE)).append(";background:#").append(Util.color2Hex(ptmColor)).append("\">").append(residue).append("</span>");
                    return taggedResidue.toString();
                } else if (localizationConfidenceLevel == 2) {
                    taggedResidue.append("<span style=\"color:#").append(Util.color2Hex(ptmColor)).append(";background:#").append(Util.color2Hex(Color.WHITE)).append("\">").append(residue).append("</span>");
                    return taggedResidue.toString();
                } else {
                    if (localizationConfidenceLevel != 3) throw new IllegalArgumentException("No formatting implemented for localization confidence level " + localizationConfidenceLevel + ".");
                    taggedResidue.append(residue);
                }
            }
            return taggedResidue.toString();
        } else {
            taggedResidue.append(residue);
        }
        return taggedResidue.toString();
    }

    public boolean isSameAs(AminoAcidSequence anotherSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!this.matches(anotherSequence, sequenceMatchingPreferences)) {
            return false;
        }
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> mods1 = this.getModificationsAt(i);
            ArrayList<ModificationMatch> mods2 = anotherSequence.getModificationsAt(i);
            if (mods1.size() != mods2.size()) {
                return false;
            }
            for (ModificationMatch modificationMatch1 : mods1) {
                PTM ptm1 = ptmFactory.getPTM(modificationMatch1.getTheoreticPtm());
                boolean found = false;
                for (ModificationMatch modificationMatch2 : mods2) {
                    PTM ptm2 = ptmFactory.getPTM(modificationMatch2.getTheoreticPtm());
                    if (ptm1.getMass() != ptm2.getMass()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSameSequenceAndModificationStatusAs(AminoAcidSequence anotherSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!this.matches(anotherSequence, sequenceMatchingPreferences)) {
            return false;
        }
        PTMFactory ptmFactory = PTMFactory.getInstance();
        HashMap<Double, Integer> masses1 = new HashMap<Double, Integer>();
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> tempModifications = this.getModificationsAt(i);
            for (ModificationMatch modMatch : tempModifications) {
                PTM ptm = ptmFactory.getPTM(modMatch.getTheoreticPtm());
                double mass = ptm.getMass();
                Integer occurrence = (Integer)masses1.get(mass);
                if (occurrence == null) {
                    masses1.put(mass, 1);
                    continue;
                }
                masses1.put(mass, occurrence + 1);
            }
        }
        HashMap<Double, Integer> masses2 = new HashMap<Double, Integer>();
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> tempModifications = anotherSequence.getModificationsAt(i);
            for (ModificationMatch modMatch : tempModifications) {
                PTM ptm = ptmFactory.getPTM(modMatch.getTheoreticPtm());
                double mass = ptm.getMass();
                Integer occurrence = (Integer)masses2.get(mass);
                if (occurrence == null) {
                    masses2.put(mass, 1);
                    continue;
                }
                masses2.put(mass, occurrence + 1);
            }
        }
        if (masses1.size() != masses2.size()) {
            return false;
        }
        for (Double mass : masses1.keySet()) {
            Integer occurrence1 = (Integer)masses1.get(mass);
            Integer occurrence2 = (Integer)masses2.get(mass);
            if (occurrence2 != null && occurrence2 == occurrence1) continue;
            return false;
        }
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> mods1 = this.getModificationsAt(i);
            ArrayList<ModificationMatch> mods2 = anotherSequence.getModificationsAt(i);
            if (mods1.size() != mods2.size()) {
                return false;
            }
            for (int j = 0; j < mods1.size(); ++j) {
                ModificationMatch modificationMatch2;
                ModificationMatch modificationMatch1 = mods1.get(j);
                if (modificationMatch1.equals(modificationMatch2 = mods2.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public AminoAcidSequence reverse() {
        this.setSequenceStringBuilder(false);
        AminoAcidSequence newSequence = new AminoAcidSequence(new StringBuilder(this.sequence).reverse().toString());
        if (this.modifications != null) {
            for (int i : this.modifications.keySet()) {
                int reversed = this.length() - i + 1;
                for (ModificationMatch modificationMatch : this.modifications.get(i)) {
                    ModificationMatch newMatch = new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), reversed);
                    if (modificationMatch.isConfident()) {
                        newMatch.setConfident(true);
                    }
                    if (modificationMatch.isInferred()) {
                        newMatch.setInferred(true);
                    }
                    newSequence.addModificationMatch(reversed, newMatch);
                }
            }
        }
        return newSequence;
    }

    public static boolean hasCombination(String sequence) {
        for (int i = 0; i < sequence.length(); ++i) {
            char aa = sequence.charAt(i);
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            if (!aminoAcid.iscombination()) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<StringBuilder> getCombinations(String sequence) {
        ArrayList<StringBuilder> combination = new ArrayList<StringBuilder>();
        for (int i = 0; i < sequence.length(); ++i) {
            ArrayList<StringBuilder> newCombination = new ArrayList<StringBuilder>();
            char aa = sequence.charAt(i);
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            for (char newAa : aminoAcid.getSubAminoAcids(false)) {
                if (combination.isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder(sequence.length());
                    stringBuilder.append(newAa);
                    newCombination.add(stringBuilder);
                    continue;
                }
                for (StringBuilder stringBuilder : combination) {
                    StringBuilder newStringBuilder = new StringBuilder(sequence.length());
                    newStringBuilder.append((CharSequence)stringBuilder);
                    newStringBuilder.append(newAa);
                    newCombination.add(newStringBuilder);
                }
            }
            combination = newCombination;
        }
        return combination;
    }

    public String toString() {
        this.setSequenceStringBuilder(false);
        return this.sequence;
    }

    @Override
    public String asSequence() {
        this.setSequenceStringBuilder(false);
        return this.sequence;
    }

    @Override
    public Double getMass() {
        this.setSequenceStringBuilder(false);
        double mass = 0.0;
        for (int i = 0; i < this.length(); ++i) {
            ArrayList<ModificationMatch> modificationAtIndex;
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(this.sequence.charAt(i));
            mass += aminoAcid.monoisotopicMass;
            if (this.modifications == null || (modificationAtIndex = this.modifications.get(i + 1)) == null) continue;
            for (ModificationMatch modificationMatch : modificationAtIndex) {
                PTM ptm = PTMFactory.getInstance().getPTM(modificationMatch.getTheoreticPtm());
                mass += ptm.getMass();
            }
        }
        return mass;
    }

    @Override
    public boolean isSameAs(TagComponent anotherCompontent, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!(anotherCompontent instanceof AminoAcidSequence)) {
            return false;
        }
        AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)anotherCompontent;
        return this.isSameAs(aminoAcidSequence, sequenceMatchingPreferences);
    }

    @Override
    public boolean isSameSequenceAndModificationStatusAs(TagComponent anotherCompontent, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!(anotherCompontent instanceof AminoAcidSequence)) {
            return false;
        }
        AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)anotherCompontent;
        return this.isSameSequenceAndModificationStatusAs(aminoAcidSequence, sequenceMatchingPreferences);
    }
}

