/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MutationMatrix
implements Serializable {
    private String name;
    private String description;
    private final HashMap<Character, HashSet<Character>> mutations = new HashMap(26);
    private final HashMap<Character, HashSet<Character>> mutationsReverse = new HashMap(26);
    public final MutationMatrix singleBaseSubstitution = MutationMatrix.singleBaseSubstitution();
    public final MutationMatrix transitionsSingleBaseSubstitution = MutationMatrix.transitionsSingleBaseSubstitution();
    public final MutationMatrix transversalSingleBaseSubstitution = MutationMatrix.transversalSingleBaseSubstitution();
    public final MutationMatrix synonymousMutation = MutationMatrix.synonymousMutation();
    public final MutationMatrix[] defaultMutationMatrices = new MutationMatrix[]{this.singleBaseSubstitution, this.transitionsSingleBaseSubstitution, this.transversalSingleBaseSubstitution};

    public MutationMatrix(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public void addMutation(Character originalAa, Character mutatedAa) {
        HashSet<Character> originalAas;
        HashSet<Character> mutatedAas = this.mutations.get(originalAa);
        if (mutatedAas == null) {
            mutatedAas = new HashSet();
            this.mutations.put(originalAa, mutatedAas);
        }
        if (!mutatedAas.contains(mutatedAa)) {
            mutatedAas.add(mutatedAa);
        }
        if ((originalAas = this.mutationsReverse.get(originalAa)) == null) {
            originalAas = new HashSet();
            this.mutationsReverse.put(mutatedAa, originalAas);
        }
        if (!originalAas.contains(originalAa)) {
            originalAas.add(originalAa);
        }
    }

    public HashSet<Character> getMutatedAminoAcids(Character originalAminoAcid) {
        return this.mutations.get(originalAminoAcid);
    }

    public HashSet<Character> getOriginalAminoAcids(Character mutatedAminoAcid) {
        return this.mutationsReverse.get(mutatedAminoAcid);
    }

    public Set<Character> getOriginalAminoAcids() {
        return this.mutations.keySet();
    }

    public Set<Character> getMutatedAminoAcids() {
        return this.mutations.keySet();
    }

    public void add(MutationMatrix otherMatrix) {
        for (Character originalAa : otherMatrix.getOriginalAminoAcids()) {
            for (Character mutatedAa : otherMatrix.getMutatedAminoAcids(originalAa)) {
                this.addMutation(originalAa, mutatedAa);
            }
        }
    }

    private static MutationMatrix singleBaseSubstitution() {
        MutationMatrix result = new MutationMatrix("Single Base Mutation", "Single base substitutions");
        char[] bases = new char[]{'A', 'T', 'G', 'C'};
        for (char originalAa : AminoAcid.getAminoAcids()) {
            if (originalAa == 'X') continue;
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(originalAa);
            for (String geneCode : aminoAcid.getStandardGeneticCode()) {
                StringBuilder geneCodeStringBuilder = new StringBuilder(geneCode);
                for (int i = 0; i < geneCode.length(); ++i) {
                    char originalBase = geneCode.charAt(i);
                    for (char base : bases) {
                        geneCodeStringBuilder.setCharAt(i, base);
                        String newCode = geneCodeStringBuilder.toString();
                        AminoAcid mutatedAminoAcid = AminoAcid.getAminoAcidFromGeneticCode(newCode);
                        char mutatedAa = mutatedAminoAcid.getSingleLetterCodeAsChar();
                        if (originalAa == mutatedAa) continue;
                        result.addMutation(Character.valueOf(originalAa), Character.valueOf(mutatedAa));
                    }
                    geneCodeStringBuilder.setCharAt(i, originalBase);
                }
            }
        }
        return result;
    }

    private static MutationMatrix transitionsSingleBaseSubstitution() {
        MutationMatrix result = new MutationMatrix("Transition Mutation", "Single base transitions substitutions.");
        char[] purines = new char[]{'A', 'G'};
        char[] pyrimidines = new char[]{'T', 'C'};
        for (char originalAa : AminoAcid.getAminoAcids()) {
            if (originalAa == 'X') continue;
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(originalAa);
            for (String geneCode : aminoAcid.getStandardGeneticCode()) {
                StringBuilder geneCodeStringBuilder = new StringBuilder(geneCode);
                for (int i = 0; i < geneCode.length(); ++i) {
                    char[] bases;
                    char originalBase = geneCode.charAt(i);
                    if (originalBase == purines[0] || originalBase == purines[1]) {
                        bases = purines;
                    } else if (originalBase == pyrimidines[0] || originalBase == pyrimidines[1]) {
                        bases = pyrimidines;
                    } else {
                        throw new IllegalArgumentException(originalBase + " not recognized for transitions substitution.");
                    }
                    for (char base : bases) {
                        geneCodeStringBuilder.setCharAt(i, base);
                        String newCode = geneCodeStringBuilder.toString();
                        AminoAcid mutatedAminoAcid = AminoAcid.getAminoAcidFromGeneticCode(newCode);
                        char mutatedAa = mutatedAminoAcid.getSingleLetterCodeAsChar();
                        if (originalAa == mutatedAa) continue;
                        result.addMutation(Character.valueOf(originalAa), Character.valueOf(mutatedAa));
                    }
                    geneCodeStringBuilder.setCharAt(i, originalBase);
                }
            }
        }
        return result;
    }

    private static MutationMatrix transversalSingleBaseSubstitution() {
        MutationMatrix result = new MutationMatrix("Transversion Mutation", "Single base transversion substitutions.");
        char[] purines = new char[]{'A', 'G'};
        char[] pyrimidines = new char[]{'T', 'C'};
        for (char originalAa : AminoAcid.getAminoAcids()) {
            if (originalAa == 'X') continue;
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(originalAa);
            for (String geneCode : aminoAcid.getStandardGeneticCode()) {
                StringBuilder geneCodeStringBuilder = new StringBuilder(geneCode);
                for (int i = 0; i < geneCode.length(); ++i) {
                    char[] bases;
                    char originalBase = geneCode.charAt(i);
                    if (originalBase == purines[0] || originalBase == purines[1]) {
                        bases = pyrimidines;
                    } else if (originalBase == pyrimidines[0] || originalBase == pyrimidines[1]) {
                        bases = purines;
                    } else {
                        throw new IllegalArgumentException(originalBase + " not recognized for transversion substitutions.");
                    }
                    for (char base : bases) {
                        geneCodeStringBuilder.setCharAt(i, base);
                        String newCode = geneCodeStringBuilder.toString();
                        AminoAcid mutatedAminoAcid = AminoAcid.getAminoAcidFromGeneticCode(newCode);
                        char mutatedAa = mutatedAminoAcid.getSingleLetterCodeAsChar();
                        if (originalAa == mutatedAa) continue;
                        result.addMutation(Character.valueOf(originalAa), Character.valueOf(mutatedAa));
                    }
                    geneCodeStringBuilder.setCharAt(i, originalBase);
                }
            }
        }
        return result;
    }

    private static MutationMatrix synonymousMutation() {
        char[] acidic;
        char[] basic;
        char[] polarNeutral;
        char[] aromatic;
        char[] nonPolarAliphatic;
        MutationMatrix result = new MutationMatrix("Synonymous Mutation", "Mutations keeping amino acid properties.");
        for (char originalAminoAcid : nonPolarAliphatic = new char[]{'G', 'A', 'V', 'L', 'M', 'I'}) {
            for (char mutatedAminoAcid : nonPolarAliphatic) {
                if (originalAminoAcid == mutatedAminoAcid) continue;
                result.addMutation(Character.valueOf(originalAminoAcid), Character.valueOf(mutatedAminoAcid));
            }
            result.addMutation(Character.valueOf('J'), Character.valueOf(originalAminoAcid));
        }
        for (char originalAminoAcid : aromatic = new char[]{'F', 'Y', 'W'}) {
            for (char mutatedAminoAcid : aromatic) {
                if (originalAminoAcid == mutatedAminoAcid) continue;
                result.addMutation(Character.valueOf(originalAminoAcid), Character.valueOf(mutatedAminoAcid));
            }
        }
        for (char originalAminoAcid : polarNeutral = new char[]{'S', 'T', 'C', 'P', 'N', 'Q'}) {
            for (char mutatedAminoAcid : polarNeutral) {
                if (originalAminoAcid == mutatedAminoAcid) continue;
                result.addMutation(Character.valueOf(originalAminoAcid), Character.valueOf(mutatedAminoAcid));
            }
            result.addMutation(Character.valueOf('B'), Character.valueOf(originalAminoAcid));
            result.addMutation(Character.valueOf('Z'), Character.valueOf(originalAminoAcid));
        }
        for (char originalAminoAcid : basic = new char[]{'K', 'R', 'H'}) {
            for (char mutatedAminoAcid : basic) {
                if (originalAminoAcid == mutatedAminoAcid) continue;
                result.addMutation(Character.valueOf(originalAminoAcid), Character.valueOf(mutatedAminoAcid));
            }
        }
        for (char originalAminoAcid : acidic = new char[]{'D', 'E'}) {
            for (char mutatedAminoAcid : acidic) {
                if (originalAminoAcid == mutatedAminoAcid) continue;
                result.addMutation(Character.valueOf(originalAminoAcid), Character.valueOf(mutatedAminoAcid));
            }
            result.addMutation(Character.valueOf('B'), Character.valueOf(originalAminoAcid));
            result.addMutation(Character.valueOf('Z'), Character.valueOf(originalAminoAcid));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isSameAs(MutationMatrix mutationMatrix) {
        if (this.equals(mutationMatrix)) {
            return true;
        }
        if (!this.name.equals(mutationMatrix.getName())) {
            return false;
        }
        if (!this.description.equals(mutationMatrix.getDescription())) {
            return false;
        }
        for (Character aa : this.mutations.keySet()) {
            HashSet<Character> aaMutations = this.mutations.get(aa);
            HashSet<Character> otherMutations = mutationMatrix.getMutatedAminoAcids(aa);
            if (otherMutations == null || aaMutations.size() != otherMutations.size()) {
                return false;
            }
            for (Character mutatedAa : aaMutations) {
                if (otherMutations.contains(mutatedAa)) continue;
                return false;
            }
        }
        return true;
    }
}

