/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.aminoacids;

import com.compomics.util.experiment.biology.AminoAcid;
import java.util.ArrayList;

public class B
extends AminoAcid {
    static final long serialVersionUID = -584166511231722270L;

    public B() {
        this.singleLetterCode = "B";
        this.threeLetterCode = "Asx";
        this.name = "Asparagine or Aspartic Acid";
        this.averageMass = 114.595;
        this.monoisotopicMass = 114.534935;
    }

    @Override
    public char[] getSubAminoAcids(boolean includeCombinations) {
        return new char[]{'N', 'D'};
    }

    @Override
    public char[] getCombinations() {
        return new char[]{'X'};
    }

    @Override
    public String[] getStandardGeneticCode() {
        ArrayList<String> uniqueCodes = new ArrayList<String>();
        for (char aa : this.getSubAminoAcids()) {
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            for (String code : aminoAcid.getStandardGeneticCode()) {
                if (uniqueCodes.contains(code)) continue;
                uniqueCodes.add(code);
            }
        }
        return (String[])uniqueCodes.toArray();
    }

    @Override
    public boolean iscombination() {
        return true;
    }
}

