/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.aminoacids;

import com.compomics.util.experiment.biology.AminoAcid;
import java.util.ArrayList;

public class J
extends AminoAcid {
    static final long serialVersionUID = 1963175809911841522L;

    public J() {
        this.singleLetterCode = "J";
        this.threeLetterCode = "I/L";
        this.name = "Isoleucine or Leucine";
        this.averageMass = 113.1598;
        this.monoisotopicMass = 113.08407;
    }

    @Override
    public char[] getSubAminoAcids(boolean includeCombinations) {
        return new char[]{'I', 'L'};
    }

    @Override
    public char[] getCombinations() {
        return new char[]{'X'};
    }

    @Override
    public String[] getStandardGeneticCode() {
        ArrayList<String> uniqueCodes = new ArrayList<String>();
        for (char aa : this.getSubAminoAcids()) {
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            for (String code : aminoAcid.getStandardGeneticCode()) {
                if (uniqueCodes.contains(code)) continue;
                uniqueCodes.add(code);
            }
        }
        return (String[])uniqueCodes.toArray();
    }

    @Override
    public boolean iscombination() {
        return true;
    }
}

