/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.aminoacids;

import com.compomics.util.experiment.biology.AminoAcid;
import java.util.ArrayList;

public class X
extends AminoAcid {
    static final long serialVersionUID = -2618109862080991929L;

    public X() {
        this.singleLetterCode = "X";
        this.threeLetterCode = "Xaa";
        this.name = "X";
        this.averageMass = 110.0;
        this.monoisotopicMass = 110.0;
    }

    @Override
    public char[] getSubAminoAcids(boolean includeCombinations) {
        if (includeCombinations) {
            return new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'Y', 'U', 'O', 'V', 'W', 'Z'};
        }
        return new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'Y', 'U', 'O', 'V', 'W'};
    }

    @Override
    public char[] getCombinations() {
        return new char[0];
    }

    @Override
    public String[] getStandardGeneticCode() {
        ArrayList<String> uniqueCodes = new ArrayList<String>();
        for (char aa : this.getSubAminoAcids()) {
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            for (String code : aminoAcid.getStandardGeneticCode()) {
                if (uniqueCodes.contains(code)) continue;
                uniqueCodes.add(code);
            }
        }
        return (String[])uniqueCodes.toArray();
    }

    @Override
    public boolean iscombination() {
        return true;
    }
}

