/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.aminoacids;

import com.compomics.util.experiment.biology.AminoAcid;
import java.util.ArrayList;

public class Z
extends AminoAcid {
    static final long serialVersionUID = -7714841171012071337L;

    public Z() {
        this.singleLetterCode = "Z";
        this.threeLetterCode = "Glx";
        this.name = "Glutamine or Glutamic Acid";
        this.averageMass = 128.6216;
        this.monoisotopicMass = 128.5505855;
    }

    @Override
    public char[] getSubAminoAcids(boolean includeCombinations) {
        return new char[]{'Q', 'E'};
    }

    @Override
    public char[] getCombinations() {
        return new char[]{'X'};
    }

    @Override
    public String[] getStandardGeneticCode() {
        ArrayList<String> uniqueCodes = new ArrayList<String>();
        for (char aa : this.getSubAminoAcids()) {
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            for (String code : aminoAcid.getStandardGeneticCode()) {
                if (uniqueCodes.contains(code)) continue;
                uniqueCodes.add(code);
            }
        }
        return (String[])uniqueCodes.toArray();
    }

    @Override
    public boolean iscombination() {
        return true;
    }
}

