/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.protein.Header;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;

public class FastaIndex
extends ExperimentObject {
    private HashMap<String, Long> indexes;
    private HashSet<String> decoyAccessions;
    private String fileName = null;
    private String name;
    private Long lastModified;
    private boolean isDefaultReversed;
    private int nTarget;
    private Header.DatabaseType mainDatabaseType = Header.DatabaseType.Unknown;
    private HashMap<Header.DatabaseType, Integer> databaseTypes = new HashMap();
    private String version;
    private boolean concatenatedTargetDecoy;
    private String decoyTag;
    private ArrayList<String> species;

    public FastaIndex(HashMap<String, Long> indexes, HashSet<String> decoyAccessions, String fileName, String name, boolean concatenatedTargetDecoy, boolean isDefaultReversed, int nTarget, long lastModified, Header.DatabaseType mainDatabaseType, HashMap<Header.DatabaseType, Integer> databaseTypes, String decoyTag, String version) {
        this.indexes = indexes;
        this.decoyAccessions = decoyAccessions;
        this.fileName = fileName;
        this.name = name;
        this.concatenatedTargetDecoy = concatenatedTargetDecoy;
        this.isDefaultReversed = isDefaultReversed;
        this.nTarget = nTarget;
        this.lastModified = lastModified;
        this.mainDatabaseType = mainDatabaseType;
        this.databaseTypes = databaseTypes;
        this.decoyTag = decoyTag;
        this.version = version;
    }

    public HashMap<String, Long> getIndexes() {
        return this.indexes;
    }

    public boolean isDecoy(String accession) {
        return this.decoyAccessions.contains(accession);
    }

    public HashSet<String> getDecoyAccesions() {
        return this.decoyAccessions;
    }

    public Long getIndex(String accession) {
        return this.indexes.get(accession);
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isDefaultReversed() {
        return this.isDefaultReversed;
    }

    public int getNTarget() {
        return this.nTarget;
    }

    public int getNSequences() {
        return this.indexes.size();
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public Header.DatabaseType getMainDatabaseType() {
        return this.mainDatabaseType;
    }

    public void setMainDatabaseType(Header.DatabaseType mainDatabaseType) {
        this.mainDatabaseType = mainDatabaseType;
    }

    public HashMap<Header.DatabaseType, Integer> getDatabaseTypes() {
        return this.databaseTypes;
    }

    public void setDatabaseTypes(HashMap<Header.DatabaseType, Integer> databaseTypes) {
        this.databaseTypes = databaseTypes;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isConcatenatedTargetDecoy() {
        return this.concatenatedTargetDecoy;
    }

    public void setConcatenatedTargetDecoy(boolean concatenatedTargetDecoy) {
        this.concatenatedTargetDecoy = concatenatedTargetDecoy;
    }

    public String getDecoyTag() {
        return this.decoyTag;
    }

    public void setDecoyTag(String decoyTag) {
        this.decoyTag = decoyTag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getDefaultVersion(long lastModified) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(lastModified);
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        return day + "." + month + "." + year;
    }

    public ArrayList<String> getSpecies() {
        return this.species;
    }

    public void setSpecies(ArrayList<String> species) {
        this.species = species;
    }
}

