/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.IdentificationAlgorithmParameter;

public class CometParameters
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -2996752557726296967L;
    private Integer numberOfSpectrumMatches = 10;
    private Integer maxVariableMods = 10;
    private Integer minPeaks = 10;
    private Double minPeakIntensity = 0.0;
    private Integer removePrecursor = 0;
    private Double removePrecursorTolerance = 1.5;
    private Double lowerClearMzRange = 0.0;
    private Double upperClearMzRange = 0.0;
    private Integer enzymeType = 2;
    private Integer isotopeCorrection = 1;
    private Double minPrecursorMass = 0.0;
    private Double maxPrecursorMass = 10000.0;
    private Integer maxFragmentCharge = 3;
    private Boolean removeMethionine = false;
    private Integer batchSize = 0;
    private Boolean theoreticalFragmentIonsSumOnly = false;
    private Double fragmentBinOffset = 0.0;
    private Boolean useSparseMatrix = true;

    @Override
    public Advocate getAlgorithm() {
        return Advocate.comet;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof CometParameters) {
            CometParameters cometParameters = (CometParameters)identificationAlgorithmParameter;
            if (this.numberOfSpectrumMatches != cometParameters.getNumberOfSpectrumMatches()) {
                return false;
            }
            if (this.maxVariableMods != cometParameters.getMaxVariableMods()) {
                return false;
            }
            if (this.minPeaks != cometParameters.getMinPeaks()) {
                return false;
            }
            double diff = Math.abs(this.minPeakIntensity - cometParameters.getMinPeakIntensity());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.removePrecursor != cometParameters.getRemovePrecursor()) {
                return false;
            }
            diff = Math.abs(this.removePrecursorTolerance - cometParameters.getRemovePrecursorTolerance());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.lowerClearMzRange - cometParameters.getLowerClearMzRange());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.upperClearMzRange - cometParameters.getUpperClearMzRange());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.enzymeType != cometParameters.getEnzymeType()) {
                return false;
            }
            if (this.isotopeCorrection != cometParameters.getIsotopeCorrection()) {
                return false;
            }
            diff = Math.abs(this.minPrecursorMass - cometParameters.getMinPrecursorMass());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.maxPrecursorMass - cometParameters.getMaxPrecursorMass());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.maxFragmentCharge != cometParameters.getMaxFragmentCharge()) {
                return false;
            }
            if (this.removeMethionine != cometParameters.getRemoveMethionine()) {
                return false;
            }
            if (this.batchSize != cometParameters.getBatchSize()) {
                return false;
            }
            if (this.theoreticalFragmentIonsSumOnly != cometParameters.getTheoreticalFragmentIonsSumOnly()) {
                return false;
            }
            diff = Math.abs(this.fragmentBinOffset - cometParameters.getFragmentBinOffset());
            if (diff > 1.0E-13) {
                return false;
            }
            return this.useSparseMatrix == cometParameters.getUseSparseMatrix();
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("NUMBER_SPECTRUM_MATCHES=");
        output.append(this.numberOfSpectrumMatches);
        output.append(newLine);
        output.append("MAX_VARIABLE_MODS=");
        output.append(this.maxVariableMods);
        output.append(newLine);
        output.append("MIN_PEAKS=");
        output.append(this.minPeaks);
        output.append(newLine);
        output.append("MIN_PEAKS_INTENSITY=");
        output.append(this.minPeakIntensity);
        output.append(newLine);
        output.append("REMOVE_PRECURSOR=");
        output.append(this.removePrecursor);
        output.append(newLine);
        output.append("REMOVE_PRECURSOR_TOLERANCE=");
        output.append(this.removePrecursorTolerance);
        output.append(newLine);
        output.append("LOWER_CLEAR_MZ_RANGE=");
        output.append(this.lowerClearMzRange);
        output.append(newLine);
        output.append("UPPER_CLEAR_MZ_RANGE=");
        output.append(this.upperClearMzRange);
        output.append(newLine);
        output.append("ENZYME_TYPE=");
        output.append(this.enzymeType);
        output.append(newLine);
        output.append("ISOTOPE_CORRECTION=");
        output.append(this.isotopeCorrection);
        output.append(newLine);
        output.append("MIN_PRECURSOR_MASS=");
        output.append(this.minPrecursorMass);
        output.append(newLine);
        output.append("MAX_PRECURSOR_MASS=");
        output.append(this.maxPrecursorMass);
        output.append(newLine);
        output.append("MAX_FRAGMENT_CHARGE=");
        output.append(this.maxFragmentCharge);
        output.append(newLine);
        output.append("REMOVE_METHIONINE=");
        output.append(this.removeMethionine);
        output.append(newLine);
        output.append("BATCH_SIZE=");
        output.append(this.batchSize);
        output.append(newLine);
        output.append("THEORETICAL_FRAGMENT_IONS_SUM_ONLY=");
        output.append(this.theoreticalFragmentIonsSumOnly);
        output.append(newLine);
        output.append("FRAGMENT_BIN_OFFSET=");
        output.append(this.fragmentBinOffset);
        output.append(newLine);
        output.append(newLine);
        output.append("USE_SPARSE_MATRIX=");
        output.append(this.useSparseMatrix);
        output.append(newLine);
        return output.toString();
    }

    public Integer getNumberOfSpectrumMatches() {
        if (this.numberOfSpectrumMatches == null) {
            this.numberOfSpectrumMatches = 10;
        }
        return this.numberOfSpectrumMatches;
    }

    public void setNumberOfSpectrumMatches(Integer numberOfSpectrumMarches) {
        this.numberOfSpectrumMatches = numberOfSpectrumMarches;
    }

    public Integer getMaxVariableMods() {
        return this.maxVariableMods;
    }

    public void setMaxVariableMods(Integer maxVariableMods) {
        this.maxVariableMods = maxVariableMods;
    }

    public Integer getMinPeaks() {
        return this.minPeaks;
    }

    public void setMinPeaks(Integer minPeaks) {
        this.minPeaks = minPeaks;
    }

    public Double getMinPeakIntensity() {
        return this.minPeakIntensity;
    }

    public void setMinPeakIntensity(Double minPeakIntensity) {
        this.minPeakIntensity = minPeakIntensity;
    }

    public Integer getRemovePrecursor() {
        return this.removePrecursor;
    }

    public void setRemovePrecursor(Integer removePrecursor) {
        this.removePrecursor = removePrecursor;
    }

    public Double getRemovePrecursorTolerance() {
        return this.removePrecursorTolerance;
    }

    public void setRemovePrecursorTolerance(Double removePrecursorTolerance) {
        this.removePrecursorTolerance = removePrecursorTolerance;
    }

    public Double getLowerClearMzRange() {
        return this.lowerClearMzRange;
    }

    public void setLowerClearMzRange(Double lowerClearMzRange) {
        this.lowerClearMzRange = lowerClearMzRange;
    }

    public Double getUpperClearMzRange() {
        return this.upperClearMzRange;
    }

    public void setUpperClearMzRange(Double upperClearMzRange) {
        this.upperClearMzRange = upperClearMzRange;
    }

    public Integer getEnzymeType() {
        return this.enzymeType;
    }

    public void setEnzymeType(Integer enzymeType) {
        this.enzymeType = enzymeType;
    }

    public Integer getIsotopeCorrection() {
        return this.isotopeCorrection;
    }

    public void setIsotopeCorrection(Integer isotopeCorrection) {
        this.isotopeCorrection = isotopeCorrection;
    }

    public Double getMinPrecursorMass() {
        return this.minPrecursorMass;
    }

    public void setMinPrecursorMass(Double minPrecursorMass) {
        this.minPrecursorMass = minPrecursorMass;
    }

    public Double getMaxPrecursorMass() {
        return this.maxPrecursorMass;
    }

    public void setMaxPrecursorMass(Double maxPrecursorMass) {
        this.maxPrecursorMass = maxPrecursorMass;
    }

    public Integer getMaxFragmentCharge() {
        return this.maxFragmentCharge;
    }

    public void setMaxFragmentCharge(Integer maxFragmentCharge) {
        this.maxFragmentCharge = maxFragmentCharge;
    }

    public Boolean getRemoveMethionine() {
        return this.removeMethionine;
    }

    public void setRemoveMethionine(Boolean removeMethionine) {
        this.removeMethionine = removeMethionine;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Boolean getTheoreticalFragmentIonsSumOnly() {
        return this.theoreticalFragmentIonsSumOnly;
    }

    public void setTheoreticalFragmentIonsSumOnly(Boolean theoreticalFragmentIonsSumOnly) {
        this.theoreticalFragmentIonsSumOnly = theoreticalFragmentIonsSumOnly;
    }

    public Double getFragmentBinOffset() {
        return this.fragmentBinOffset;
    }

    public void setFragmentBinOffset(Double fragmentBinOffset) {
        this.fragmentBinOffset = fragmentBinOffset;
    }

    public Boolean getUseSparseMatrix() {
        return this.useSparseMatrix;
    }

    public void setUseSparseMatrix(Boolean useSparseMatrix) {
        this.useSparseMatrix = useSparseMatrix;
    }
}

