/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.AAIntensityRankScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.AAMS2MzFidelityScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.ComplementarityScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.IntensityRankScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.MS2MzFidelityScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.PrecursorAccuracy;
import com.compomics.util.experiment.identification.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public enum PsmScores {
    native_score(-1, "native", false),
    precursor_accuracy(0, "precursor accuracy", false),
    ms2_mz_fidelity(1, "fragment ion mz fildelity", false),
    aa_ms2_mz_fidelity(2, "AA fragment ion mz fildelity", false),
    intensity(3, "intensity", true),
    aa_intensity(4, "AA intensity", false),
    complementarity(5, "complementarity", true);

    public final String name;
    public final int index;
    public final boolean increasing;
    private static PeptideSpectrumAnnotator peptideSpectrumAnnotator;

    private PsmScores(int index, String name, boolean increasing) {
        this.index = index;
        this.name = name;
        this.increasing = increasing;
    }

    public static PsmScores getScore(int scoreIndex) {
        for (PsmScores psmScore : PsmScores.values()) {
            if (psmScore.index != scoreIndex) continue;
            return psmScore;
        }
        return null;
    }

    public static double getDecreasingScore(Peptide peptide, MSnSpectrum spectrum, HashMap<Ion.IonType, HashSet<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int identificationCharge, SearchParameters searchParameters, int scoreIndex) {
        PsmScores psmScore = PsmScores.getScore(scoreIndex);
        double score = PsmScores.getScore(peptide, spectrum, iontypes, neutralLosses, charges, identificationCharge, searchParameters, psmScore);
        if (psmScore.increasing) {
            return -score;
        }
        return score;
    }

    public static double getScore(Peptide peptide, MSnSpectrum spectrum, HashMap<Ion.IonType, HashSet<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int identificationCharge, SearchParameters searchParameters, int scoreIndex) {
        PsmScores psmScore = PsmScores.getScore(scoreIndex);
        return PsmScores.getScore(peptide, spectrum, iontypes, neutralLosses, charges, identificationCharge, searchParameters, psmScore);
    }

    public static double getScore(Peptide peptide, MSnSpectrum spectrum, HashMap<Ion.IonType, HashSet<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int identificationCharge, SearchParameters searchParameters, PsmScores psmScore) {
        switch (psmScore) {
            case native_score: {
                throw new IllegalArgumentException("Impossible to compute the native score of an algorithm");
            }
            case precursor_accuracy: {
                return PrecursorAccuracy.getScore(peptide, identificationCharge, spectrum.getPrecursor(), searchParameters.isPrecursorAccuracyTypePpm());
            }
            case ms2_mz_fidelity: {
                return MS2MzFidelityScore.getScore(peptide, spectrum, iontypes, neutralLosses, charges, identificationCharge, searchParameters.getFragmentIonAccuracy(), peptideSpectrumAnnotator);
            }
            case aa_ms2_mz_fidelity: {
                return AAMS2MzFidelityScore.getScore(peptide, spectrum, iontypes, neutralLosses, charges, identificationCharge, searchParameters.getFragmentIonAccuracy(), peptideSpectrumAnnotator);
            }
            case intensity: {
                return IntensityRankScore.getScore(peptide, spectrum, iontypes, neutralLosses, charges, identificationCharge, searchParameters.getFragmentIonAccuracy(), peptideSpectrumAnnotator);
            }
            case aa_intensity: {
                return AAIntensityRankScore.getScore(peptide, spectrum, iontypes, neutralLosses, charges, identificationCharge, searchParameters.getFragmentIonAccuracy(), peptideSpectrumAnnotator);
            }
            case complementarity: {
                return ComplementarityScore.getScore(peptide, spectrum, iontypes, neutralLosses, charges, identificationCharge, searchParameters.getFragmentIonAccuracy(), peptideSpectrumAnnotator);
            }
        }
        throw new UnsupportedOperationException("Score not implemented.");
    }

    static {
        peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
    }
}

