/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotators;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.SpectrumAnnotator;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.Tag;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.identification.tags.tagcomponents.MassGap;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class TagSpectrumAnnotator
extends SpectrumAnnotator {
    private Tag tag;

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag newTag, int precursorCharge) {
        if (this.tag == null || !this.tag.isSameAs(newTag, SequenceMatchingPreferences.defaultStringMatching) || this.precursorCharge != precursorCharge) {
            this.tag = newTag;
            this.precursorCharge = precursorCharge;
            this.theoreticalFragmentIons = this.fragmentFactory.getFragmentIons(newTag);
            if (this.massShift != 0.0 || this.massShiftNTerm != 0.0 || this.massShiftCTerm != 0.0) {
                this.updateMassShifts();
            }
            this.spectrumAnnotation.clear();
            this.unmatchedIons.clear();
        }
    }

    public static NeutralLossesMap getDefaultLosses(Tag tag, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        AminoAcidSequence aminoAcidSequence;
        int index;
        int i;
        AminoAcidPattern aminoAcidPattern;
        int tagLength;
        PTMFactory pTMFactory = PTMFactory.getInstance();
        NeutralLossesMap neutralLossesMap = new NeutralLossesMap();
        int aaMin = tagLength = tag.getLengthInAminoAcid();
        int aaMax = 0;
        int offset = 0;
        for (TagComponent component : tag.getContent()) {
            if (component instanceof AminoAcidPattern) {
                aminoAcidPattern = (AminoAcidPattern)component;
                for (i = 0; i < aminoAcidPattern.length(); ++i) {
                    if (!aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.D) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.E) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.S) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.T)) continue;
                    index = i + offset;
                    aaMin = Math.min(index, aaMin);
                    aaMax = Math.max(index, aaMax);
                }
                offset += aminoAcidPattern.length();
                continue;
            }
            if (component instanceof AminoAcidSequence) {
                aminoAcidSequence = (AminoAcidSequence)component;
                for (i = 0; i < aminoAcidSequence.length(); ++i) {
                    if (aminoAcidSequence.charAt(i) != 'D' && aminoAcidSequence.charAt(i) != 'E' && aminoAcidSequence.charAt(i) != 'S' && aminoAcidSequence.charAt(i) != 'T') continue;
                    index = i + offset;
                    aaMin = Math.min(index, aaMin);
                    aaMax = Math.max(index, aaMax);
                }
                offset += aminoAcidSequence.length();
                continue;
            }
            if (component instanceof MassGap) {
                ++offset;
                continue;
            }
            throw new UnsupportedOperationException("Spectrum annotator not implemented for " + component.getClass() + ".");
        }
        if (aaMin < tagLength) {
            neutralLossesMap.addNeutralLoss(NeutralLoss.H2O, aaMin + 1, tagLength - aaMax);
        }
        aaMin = tagLength;
        aaMax = 0;
        offset = 0;
        for (TagComponent component : tag.getContent()) {
            if (component instanceof AminoAcidPattern) {
                aminoAcidPattern = (AminoAcidPattern)component;
                for (i = 0; i < aminoAcidPattern.length(); ++i) {
                    if (!aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.K) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.N) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.Q) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.R)) continue;
                    index = i + offset;
                    aaMin = Math.min(index, aaMin);
                    aaMax = Math.max(index, aaMax);
                }
                offset += aminoAcidPattern.length();
                continue;
            }
            if (component instanceof AminoAcidSequence) {
                aminoAcidSequence = (AminoAcidSequence)component;
                for (i = 0; i < aminoAcidSequence.length(); ++i) {
                    if (aminoAcidSequence.charAt(i) != 'K' && aminoAcidSequence.charAt(i) != 'N' && aminoAcidSequence.charAt(i) != 'Q' && aminoAcidSequence.charAt(i) != 'R') continue;
                    index = i + offset;
                    aaMin = Math.min(index, aaMin);
                    aaMax = Math.max(index, aaMax);
                }
                offset += aminoAcidSequence.length();
                continue;
            }
            if (component instanceof MassGap) {
                ++offset;
                continue;
            }
            throw new UnsupportedOperationException("Spectrum annotator not implemented for " + component.getClass() + ".");
        }
        if (aaMin < tagLength) {
            neutralLossesMap.addNeutralLoss(NeutralLoss.NH3, aaMin + 1, tagLength - aaMax);
        }
        int modMin = tagLength;
        int modMax = 0;
        offset = 0;
        for (TagComponent component : tag.getContent()) {
            if (component instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern2 = (AminoAcidPattern)component;
                for (int i2 = 1; i2 <= aminoAcidPattern2.length(); ++i2) {
                    for (ModificationMatch modificationMatch : aminoAcidPattern2.getModificationsAt(i2)) {
                        PTM ptm = pTMFactory.getPTM(modificationMatch.getTheoreticPtm());
                        if (ptm == null) {
                            throw new IllegalArgumentException("PTM " + modificationMatch.getTheoreticPtm() + " not loaded in PTM factory.");
                        }
                        for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
                            ArrayList<Integer> indexes = tag.getPotentialModificationSites(ptm, sequenceMatchingPreferences);
                            if (!indexes.isEmpty()) {
                                Collections.sort(indexes);
                                modMin = indexes.get(0);
                                modMax = indexes.get(indexes.size() - 1);
                            }
                            neutralLossesMap.addNeutralLoss(neutralLoss, modMin, tag.getLengthInAminoAcid() - modMax + 1);
                        }
                    }
                }
                offset += aminoAcidPattern2.length();
                continue;
            }
            ++offset;
        }
        return neutralLossesMap;
    }

    public ArrayList<IonMatch> getSpectrumAnnotation(HashMap<Ion.IonType, HashSet<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, MSnSpectrum spectrum, Tag tag, double intensityLimit, double mzTolerance, boolean isPpm, boolean pickMostAccuratePeak) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        if (spectrum != null) {
            this.setSpectrum(spectrum, intensityLimit);
        }
        this.setTag(tag, precursorCharge);
        this.setMassTolerance(mzTolerance, isPpm, pickMostAccuratePeak);
        ArrayList<Integer> precursorCharges = new ArrayList<Integer>();
        for (int i = 1; i <= precursorCharge; ++i) {
            precursorCharges.add(i);
        }
        if (this.theoreticalFragmentIons != null) {
            for (Ion.IonType ionType : iontypes.keySet()) {
                HashMap ionMap = (HashMap)this.theoreticalFragmentIons.get(ionType.index);
                if (ionMap == null) continue;
                HashSet<Integer> subtypes = iontypes.get((Object)ionType);
                for (int subType : subtypes) {
                    ArrayList ions = (ArrayList)ionMap.get(subType);
                    if (ions == null) continue;
                    for (Ion ion : ions) {
                        if (!this.lossesValidated(neutralLosses, ion)) continue;
                        ArrayList<Object> tempCharges = ionType == Ion.IonType.PRECURSOR_ION ? precursorCharges : charges;
                        Iterator<Object> i$ = tempCharges.iterator();
                        while (i$.hasNext()) {
                            int charge = (Integer)i$.next();
                            if (!this.chargeValidated(ion, charge, precursorCharge)) continue;
                            String key = IonMatch.getMatchKey(ion, charge);
                            boolean matchFound = false;
                            boolean alreadyAnnotated = this.spectrumAnnotation.containsKey(key);
                            if (!alreadyAnnotated && !this.unmatchedIons.contains(key)) {
                                matchFound = this.matchInSpectrum(ion, charge);
                            }
                            if (!alreadyAnnotated && !matchFound) continue;
                            result.add((IonMatch)this.spectrumAnnotation.get(key));
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public ArrayList<IonMatch> getCurrentAnnotation(MSnSpectrum spectrum, HashMap<Ion.IonType, HashSet<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, boolean pickMostAccuratePeak) {
        return this.getSpectrumAnnotation(iontypes, neutralLosses, charges, this.precursorCharge, spectrum, this.tag, this.intensityLimit, this.mzTolerance, this.isPpm, pickMostAccuratePeak);
    }
}

