/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.tags.matchers;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.Tag;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.identification.tags.tagcomponents.MassGap;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TagMatcher {
    public static HashMap<Integer, ArrayList<Peptide>> getPeptideMatches(Tag tag, String sequence, int tagIndex, int componentIndex, SequenceMatchingPreferences sequenceMatchingPreferences, double massTolerance, ArrayList<String> fixedModifications, ArrayList<String> variableModifications, boolean reportFixedPtms) {
        boolean found;
        PTM ptm;
        int componentAtIndexLength;
        PTM ptm2;
        AminoAcidPattern ptmPattern;
        PTM ptm3;
        ArrayList<TagComponent> content = tag.getContent();
        HashMap<Integer, ArrayList<Peptide>> result = new HashMap<Integer, ArrayList<Peptide>>();
        double minMod = 0.0;
        for (String modificationName : variableModifications) {
            PTM ptm4 = PTMFactory.getInstance().getPTM(modificationName);
            if (!(ptm4.getMass() < minMod)) continue;
            minMod = ptm4.getMass();
        }
        int sequenceLastIndex = sequence.length() - 1;
        ArrayList<AminoAcidSequence> nTermPossibleSequences = new ArrayList<AminoAcidSequence>();
        ArrayList<Integer> nTermPossibleIndexes = new ArrayList<Integer>();
        nTermPossibleSequences.add(new AminoAcidSequence());
        nTermPossibleIndexes.add(tagIndex);
        for (int i = componentIndex - 1; i >= 0; --i) {
            PTM ptm5;
            AminoAcidSequence newSequence;
            int startIndex;
            TagComponent tagComponent = content.get(i);
            ArrayList<AminoAcidSequence> newSequences = new ArrayList<AminoAcidSequence>();
            ArrayList<Integer> newIndexes = new ArrayList<Integer>();
            Iterator nTermPossibleIndexesIterator = nTermPossibleIndexes.iterator();
            if (tagComponent instanceof AminoAcidPattern) {
                for (AminoAcidSequence nTermSequence : nTermPossibleSequences) {
                    String subSequence;
                    AminoAcidPattern aminoAcidPattern;
                    int aaIndex = (Integer)nTermPossibleIndexesIterator.next();
                    startIndex = aaIndex - (aminoAcidPattern = (AminoAcidPattern)tagComponent).length();
                    if (startIndex < 0 || !aminoAcidPattern.matches(subSequence = sequence.substring(startIndex, aaIndex), sequenceMatchingPreferences)) continue;
                    newSequence = new AminoAcidSequence(subSequence, aminoAcidPattern.getModificationMatches());
                    boolean goodTerminalPTms = true;
                    if (i == 0) {
                        for (String modificationName : fixedModifications) {
                            boolean found2;
                            ptm5 = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm5.getType() == 5 || ptm5.getType() == 1 && startIndex == 0) {
                                found2 = false;
                                for (ModificationMatch modificationMatch : newSequence.getModificationsAt(1)) {
                                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                    found2 = true;
                                    break;
                                }
                                if (found2) continue;
                                goodTerminalPTms = false;
                                break;
                            }
                            if (ptm5.getType() != 6 && (ptm5.getType() != 2 || startIndex != 0)) continue;
                            if (ptm5.getPattern().firstIndex(subSequence, sequenceMatchingPreferences) != 0) {
                                goodTerminalPTms = false;
                                break;
                            }
                            found2 = false;
                            for (ModificationMatch modificationMatch : newSequence.getModificationsAt(1)) {
                                if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                found2 = true;
                                break;
                            }
                            if (found2) continue;
                            goodTerminalPTms = false;
                            break;
                        }
                    }
                    if (!goodTerminalPTms) continue;
                    newSequence.append(nTermSequence);
                    newIndexes.add(startIndex);
                    newSequences.add(newSequence);
                }
            } else if (tagComponent instanceof AminoAcidSequence) {
                for (AminoAcidSequence nTermSequence : nTermPossibleSequences) {
                    String subSequence;
                    AminoAcidSequence aminoAcidSequence;
                    int aaIndex = (Integer)nTermPossibleIndexesIterator.next();
                    startIndex = aaIndex - (aminoAcidSequence = (AminoAcidSequence)tagComponent).length();
                    if (startIndex < 0 || !aminoAcidSequence.matches(subSequence = sequence.substring(startIndex, aaIndex), sequenceMatchingPreferences)) continue;
                    newSequence = new AminoAcidSequence(subSequence, aminoAcidSequence.getModificationMatches());
                    boolean goodTerminalPTms = true;
                    if (i == 0) {
                        for (String modificationName : fixedModifications) {
                            boolean found3;
                            ptm5 = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm5.getType() == 5 || ptm5.getType() == 1 && startIndex == 0) {
                                found3 = false;
                                for (ModificationMatch modificationMatch : newSequence.getModificationsAt(1)) {
                                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                    found3 = true;
                                    break;
                                }
                                if (found3) continue;
                                goodTerminalPTms = false;
                                break;
                            }
                            if (ptm5.getType() != 6 && (ptm5.getType() != 2 || startIndex != 0)) continue;
                            if (ptm5.getPattern().firstIndex(subSequence, sequenceMatchingPreferences) != 0) {
                                goodTerminalPTms = false;
                                break;
                            }
                            found3 = false;
                            for (ModificationMatch modificationMatch : newSequence.getModificationsAt(1)) {
                                if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                found3 = true;
                                break;
                            }
                            if (found3) continue;
                            goodTerminalPTms = false;
                            break;
                        }
                    }
                    if (!goodTerminalPTms) continue;
                    newSequence.append(nTermSequence);
                    newIndexes.add(startIndex);
                    newSequences.add(newSequence);
                }
            } else if (tagComponent instanceof MassGap) {
                double massGap = tagComponent.getMass();
                for (AminoAcidSequence nTermSequence : nTermPossibleSequences) {
                    int aaIndex;
                    int currentIndex = aaIndex = ((Integer)nTermPossibleIndexesIterator.next()).intValue();
                    ArrayList<Double> possiblePatternsMasses = new ArrayList<Double>();
                    ArrayList<AminoAcidSequence> possibleSequences = new ArrayList<AminoAcidSequence>();
                    ArrayList<AminoAcidSequence> validSequences = new ArrayList<AminoAcidSequence>();
                    while (--aaIndex >= 0) {
                        PTM ptm6;
                        char aa = sequence.charAt(aaIndex);
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
                        double fixedMass = 0.0;
                        ArrayList<ModificationMatch> fixedModificationMatches = new ArrayList<ModificationMatch>();
                        for (String modificationName : fixedModifications) {
                            ptm3 = PTMFactory.getInstance().getPTM(modificationName);
                            AminoAcidPattern ptmPattern2 = ptm3.getPattern();
                            if (ptm3.getType() != 0 || !ptmPattern2.isTargeted(aa, ptmPattern2.getTarget(), sequenceMatchingPreferences)) continue;
                            fixedMass += ptm3.getMass();
                            fixedModificationMatches.add(new ModificationMatch(modificationName, false, 1));
                        }
                        if (possiblePatternsMasses.isEmpty()) {
                            AminoAcidSequence newPattern = new AminoAcidSequence(aminoAcid.singleLetterCode);
                            if (reportFixedPtms) {
                                for (ModificationMatch modificationMatch : fixedModificationMatches) {
                                    newPattern.addModificationMatch(1, modificationMatch);
                                }
                            }
                            double noModMass = aminoAcid.monoisotopicMass + fixedMass;
                            possibleSequences.add(newPattern);
                            possiblePatternsMasses.add(noModMass);
                            for (String modificationName : variableModifications) {
                                ptm6 = PTMFactory.getInstance().getPTM(modificationName);
                                AminoAcidPattern ptmPattern3 = ptm6.getPattern();
                                if (ptm6.getType() != 0 || !ptmPattern3.isTargeted(aa, ptmPattern3.getTarget(), sequenceMatchingPreferences)) continue;
                                newPattern = new AminoAcidSequence(aminoAcid.singleLetterCode);
                                newPattern.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                double newMass = noModMass + ptm6.getMass();
                                possibleSequences.add(newPattern);
                                possiblePatternsMasses.add(newMass);
                            }
                        } else {
                            ArrayList<Double> newPossibleSequencesMasses = new ArrayList<Double>();
                            ArrayList<AminoAcidSequence> newPossibleSequences = new ArrayList<AminoAcidSequence>();
                            Iterator newPossibleSequencesMassesIterator = possibleSequences.iterator();
                            Iterator<Object> i$ = possiblePatternsMasses.iterator();
                            while (i$.hasNext()) {
                                double mass = (Double)i$.next();
                                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)newPossibleSequencesMassesIterator.next();
                                AminoAcidSequence newSequence2 = new AminoAcidSequence(aminoAcid.singleLetterCode);
                                double noModMass = aminoAcid.monoisotopicMass + fixedMass + mass;
                                newSequence2.append(aminoAcidSequence);
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : fixedModificationMatches) {
                                        newSequence2.addModificationMatch(1, modificationMatch);
                                    }
                                }
                                newPossibleSequences.add(newSequence2);
                                newPossibleSequencesMasses.add(noModMass);
                                for (String modificationName : variableModifications) {
                                    PTM ptm7 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern = ptm7.getPattern();
                                    if (ptm7.getType() != 0 || !ptmPattern.isTargeted(aa, ptmPattern.getTarget(), sequenceMatchingPreferences)) continue;
                                    newSequence2 = new AminoAcidSequence(aminoAcid.singleLetterCode);
                                    newSequence2.append(aminoAcidSequence);
                                    newSequence2.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                    double newMass = noModMass + ptm7.getMass();
                                    newPossibleSequences.add(newSequence2);
                                    newPossibleSequencesMasses.add(newMass);
                                }
                            }
                            possibleSequences.clear();
                            possiblePatternsMasses.clear();
                            possibleSequences = newPossibleSequences;
                            possiblePatternsMasses = newPossibleSequencesMasses;
                        }
                        ArrayList<ModificationMatch> nTermModifications = new ArrayList<ModificationMatch>();
                        double fixedNTermModifications = 0.0;
                        for (String modificationName : fixedModifications) {
                            ptm6 = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm6.getType() != 5) continue;
                            fixedNTermModifications = ptm6.getMass();
                            nTermModifications.add(new ModificationMatch(modificationName, false, 1));
                            break;
                        }
                        if (aaIndex == 0) {
                            for (String modificationName : fixedModifications) {
                                ptm6 = PTMFactory.getInstance().getPTM(modificationName);
                                if (ptm6.getType() != 1) continue;
                                fixedNTermModifications = ptm6.getMass();
                                nTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                break;
                            }
                        }
                        Iterator possibleSequencesIterator = possibleSequences.iterator();
                        Iterator possiblePatternsMassesIterator = possiblePatternsMasses.iterator();
                        block20: while (possibleSequencesIterator.hasNext()) {
                            AminoAcidPattern ptmPattern4;
                            AminoAcidPattern ptmPattern5;
                            PTM ptm8;
                            AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)possibleSequencesIterator.next();
                            double mass = (Double)possiblePatternsMassesIterator.next();
                            for (String modificationName : fixedModifications) {
                                ptm8 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern5 = ptm8.getPattern();
                                if (ptm8.getType() != 6 || !ptmPattern5.isTargeted(aminoAcidSequence.charAt(0), ptmPattern5.getTarget(), sequenceMatchingPreferences)) continue;
                                fixedNTermModifications = ptm8.getMass();
                                nTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                break;
                            }
                            if (aaIndex == 0) {
                                for (String modificationName : fixedModifications) {
                                    ptm8 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern5 = ptm8.getPattern();
                                    if (ptm8.getType() != 2 || !ptmPattern5.isTargeted(aminoAcidSequence.charAt(0), ptmPattern5.getTarget(), sequenceMatchingPreferences)) continue;
                                    fixedNTermModifications = ptm8.getMass();
                                    nTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                    break;
                                }
                            }
                            if (mass + fixedNTermModifications + minMod > massGap + massTolerance) {
                                possibleSequencesIterator.remove();
                                possiblePatternsMassesIterator.remove();
                                continue;
                            }
                            if (Math.abs(mass + fixedNTermModifications - massGap) <= massTolerance) {
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : nTermModifications) {
                                        aminoAcidSequence.addModificationMatch(1, modificationMatch);
                                    }
                                }
                                validSequences.add(aminoAcidSequence);
                                possibleSequencesIterator.remove();
                                possiblePatternsMassesIterator.remove();
                                continue;
                            }
                            boolean found4 = false;
                            if (aaIndex == 0) {
                                for (String modificationName : variableModifications) {
                                    ptm2 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern4 = ptm2.getPattern();
                                    if (ptm2.getType() != 1 && (ptm2.getType() != 2 || !ptmPattern4.isTargeted(aminoAcidSequence.charAt(0), ptmPattern4.getTarget(), sequenceMatchingPreferences)) || !(Math.abs(mass + fixedNTermModifications + ptm2.getMass() - massGap) <= massTolerance)) continue;
                                    aminoAcidSequence.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                    if (reportFixedPtms) {
                                        for (ModificationMatch modificationMatch : nTermModifications) {
                                            aminoAcidSequence.addModificationMatch(1, modificationMatch);
                                        }
                                    }
                                    validSequences.add(aminoAcidSequence);
                                    possibleSequencesIterator.remove();
                                    possiblePatternsMassesIterator.remove();
                                    found4 = true;
                                    break;
                                }
                            }
                            if (found4) continue;
                            for (String modificationName : variableModifications) {
                                ptm2 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern4 = ptm2.getPattern();
                                if (ptm2.getType() != 5 && (ptm2.getType() != 6 || !ptmPattern4.isTargeted(aminoAcidSequence.charAt(0), ptmPattern4.getTarget(), sequenceMatchingPreferences)) || !(Math.abs(mass + fixedNTermModifications + ptm2.getMass() - massGap) <= massTolerance)) continue;
                                aminoAcidSequence.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : nTermModifications) {
                                        aminoAcidSequence.addModificationMatch(1, modificationMatch);
                                    }
                                }
                                validSequences.add(aminoAcidSequence);
                                possibleSequencesIterator.remove();
                                possiblePatternsMassesIterator.remove();
                                continue block20;
                            }
                        }
                        if (!possibleSequences.isEmpty()) continue;
                        break;
                    }
                    for (AminoAcidSequence aminoAcidSequence : validSequences) {
                        aminoAcidSequence.append(nTermSequence);
                        int newIndex = currentIndex - aminoAcidSequence.length();
                        newIndexes.add(newIndex);
                        newSequences.add(aminoAcidSequence);
                    }
                }
            } else {
                throw new IllegalArgumentException("Tag component " + tagComponent.getClass() + " not implemented for sequence matching.");
            }
            if (newIndexes.isEmpty()) {
                return result;
            }
            nTermPossibleIndexes.clear();
            nTermPossibleSequences.clear();
            nTermPossibleIndexes = newIndexes;
            nTermPossibleSequences = newSequences;
        }
        TagComponent componentAtIndex = content.get(componentIndex);
        int endTagIndex = tagIndex - 1;
        HashMap<Integer, ArrayList<ModificationMatch>> modificationsAtIndex = null;
        if (componentAtIndex instanceof AminoAcidPattern) {
            AminoAcidPattern tagPattern = (AminoAcidPattern)componentAtIndex;
            componentAtIndexLength = tagPattern.length();
            modificationsAtIndex = tagPattern.getModificationMatches();
            endTagIndex += componentAtIndexLength;
            if (componentIndex == 0) {
                boolean goodTerminalPTms = true;
                for (String modificationName : fixedModifications) {
                    ptm = PTMFactory.getInstance().getPTM(modificationName);
                    if (ptm.getType() == 5 || ptm.getType() == 1 && tagIndex == 0) {
                        found = false;
                        for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(1)) {
                            if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        goodTerminalPTms = false;
                        break;
                    }
                    if (ptm.getType() != 6 && (ptm.getType() != 2 || tagIndex != 0)) continue;
                    if (ptm.getPattern().firstIndex(tagPattern, sequenceMatchingPreferences) != 0) {
                        goodTerminalPTms = false;
                        break;
                    }
                    found = false;
                    for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(1)) {
                        if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    goodTerminalPTms = false;
                    break;
                }
                if (!goodTerminalPTms) {
                    return result;
                }
            }
            if (componentIndex == content.size() - 1) {
                boolean goodTerminalPTms = true;
                for (String modificationName : fixedModifications) {
                    ptm = PTMFactory.getInstance().getPTM(modificationName);
                    if (ptm.getType() == 7 || ptm.getType() == 3 && endTagIndex == sequenceLastIndex) {
                        found = false;
                        for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(tagPattern.length())) {
                            if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        goodTerminalPTms = false;
                        break;
                    }
                    if (ptm.getType() != 8 && (ptm.getType() != 4 || endTagIndex != sequenceLastIndex)) continue;
                    if (ptm.getPattern().firstIndex(tagPattern, sequenceMatchingPreferences) != 0) {
                        goodTerminalPTms = false;
                        break;
                    }
                    found = false;
                    for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(tagPattern.length())) {
                        if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    goodTerminalPTms = false;
                    break;
                }
                if (!goodTerminalPTms) {
                    return result;
                }
            }
        } else if (componentAtIndex instanceof AminoAcidSequence) {
            AminoAcidSequence tagSequence = (AminoAcidSequence)componentAtIndex;
            componentAtIndexLength = tagSequence.length();
            modificationsAtIndex = tagSequence.getModificationMatches();
            endTagIndex += componentAtIndexLength;
            if (componentIndex == 0) {
                boolean goodTerminalPTms = true;
                for (String modificationName : fixedModifications) {
                    ptm = PTMFactory.getInstance().getPTM(modificationName);
                    if (ptm.getType() == 5 || ptm.getType() == 1 && tagIndex == 0) {
                        found = false;
                        for (ModificationMatch modificationMatch : tagSequence.getModificationsAt(1)) {
                            if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        goodTerminalPTms = false;
                        break;
                    }
                    if (ptm.getType() != 6 && (ptm.getType() != 2 || tagIndex != 0)) continue;
                    if (ptm.getPattern().firstIndex(tagSequence, sequenceMatchingPreferences) != 0) {
                        goodTerminalPTms = false;
                        break;
                    }
                    found = false;
                    for (ModificationMatch modificationMatch : tagSequence.getModificationsAt(1)) {
                        if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    goodTerminalPTms = false;
                    break;
                }
                if (!goodTerminalPTms) {
                    return result;
                }
            }
            if (componentIndex == content.size() - 1) {
                boolean goodTerminalPTms = true;
                for (String modificationName : fixedModifications) {
                    ptm = PTMFactory.getInstance().getPTM(modificationName);
                    if (ptm.getType() == 7 || ptm.getType() == 3 && endTagIndex == sequenceLastIndex) {
                        found = false;
                        for (ModificationMatch modificationMatch : tagSequence.getModificationsAt(tagSequence.length())) {
                            if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        goodTerminalPTms = false;
                        break;
                    }
                    if (ptm.getType() != 8 && (ptm.getType() != 4 || endTagIndex != sequenceLastIndex)) continue;
                    if (ptm.getPattern().firstIndex(tagSequence, sequenceMatchingPreferences) != 0) {
                        goodTerminalPTms = false;
                        break;
                    }
                    found = false;
                    for (ModificationMatch modificationMatch : tagSequence.getModificationsAt(tagSequence.length())) {
                        if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    goodTerminalPTms = false;
                    break;
                }
                if (!goodTerminalPTms) {
                    return result;
                }
            }
        } else {
            throw new UnsupportedOperationException("Tag mapping not supported for tag component " + componentAtIndex.getClass() + ".");
        }
        ArrayList<AminoAcidSequence> cTermPossibleSequences = new ArrayList<AminoAcidSequence>();
        ArrayList<Integer> cTermPossibleIndexes = new ArrayList<Integer>();
        cTermPossibleSequences.add(new AminoAcidSequence());
        cTermPossibleIndexes.add(endTagIndex);
        for (int i = componentIndex + 1; i < content.size(); ++i) {
            AminoAcidSequence newSequence;
            int endIndex;
            TagComponent tagComponent = content.get(i);
            ArrayList<AminoAcidSequence> newSequences = new ArrayList<AminoAcidSequence>();
            ArrayList<Integer> newIndexes = new ArrayList<Integer>();
            Iterator cTermPossibleIndexesIterator = cTermPossibleIndexes.iterator();
            if (tagComponent instanceof AminoAcidPattern) {
                for (AminoAcidSequence cTermSequence : cTermPossibleSequences) {
                    String subSequence;
                    AminoAcidPattern aminoAcidPattern;
                    int aaIndex = (Integer)cTermPossibleIndexesIterator.next();
                    endIndex = aaIndex + (aminoAcidPattern = (AminoAcidPattern)tagComponent).length();
                    if (endIndex > sequenceLastIndex || !aminoAcidPattern.matches(subSequence = sequence.substring(aaIndex, endIndex), sequenceMatchingPreferences)) continue;
                    newSequence = new AminoAcidSequence(subSequence, aminoAcidPattern.getModificationMatches());
                    boolean goodTerminalPTms = true;
                    if (i == 0) {
                        for (String modificationName : fixedModifications) {
                            boolean found5;
                            ptm3 = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm3.getType() == 7 || ptm3.getType() == 3 && endIndex == sequenceLastIndex) {
                                found5 = false;
                                for (ModificationMatch modificationMatch : newSequence.getModificationsAt(newSequence.length())) {
                                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                    found5 = true;
                                    break;
                                }
                                if (found5) continue;
                                goodTerminalPTms = false;
                                break;
                            }
                            if (ptm3.getType() != 8 && (ptm3.getType() != 4 || endIndex != sequenceLastIndex)) continue;
                            if (ptm3.getPattern().firstIndex(subSequence, sequenceMatchingPreferences) != 0) {
                                goodTerminalPTms = false;
                                break;
                            }
                            found5 = false;
                            for (ModificationMatch modificationMatch : newSequence.getModificationsAt(newSequence.length())) {
                                if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                found5 = true;
                                break;
                            }
                            if (found5) continue;
                            goodTerminalPTms = false;
                            break;
                        }
                    }
                    if (!goodTerminalPTms) continue;
                    cTermSequence.append(newSequence);
                    newIndexes.add(endIndex);
                    newSequences.add(cTermSequence);
                }
            } else if (tagComponent instanceof AminoAcidSequence) {
                for (AminoAcidSequence cTermSequence : cTermPossibleSequences) {
                    String subSequence;
                    AminoAcidSequence aminoAcidSequence;
                    int aaIndex = (Integer)cTermPossibleIndexesIterator.next();
                    endIndex = aaIndex + (aminoAcidSequence = (AminoAcidSequence)tagComponent).length();
                    if (endIndex > sequenceLastIndex || !aminoAcidSequence.matches(subSequence = sequence.substring(aaIndex, endIndex), sequenceMatchingPreferences)) continue;
                    newSequence = new AminoAcidSequence(subSequence, aminoAcidSequence.getModificationMatches());
                    boolean goodTerminalPTms = true;
                    if (i == 0) {
                        for (String modificationName : fixedModifications) {
                            boolean found6;
                            ptm3 = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm3.getType() == 7 || ptm3.getType() == 3 && endIndex == sequenceLastIndex) {
                                found6 = false;
                                for (ModificationMatch modificationMatch : newSequence.getModificationsAt(newSequence.length())) {
                                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                    found6 = true;
                                    break;
                                }
                                if (found6) continue;
                                goodTerminalPTms = false;
                                break;
                            }
                            if (ptm3.getType() != 8 && (ptm3.getType() != 4 || endIndex != sequenceLastIndex)) continue;
                            if (ptm3.getPattern().firstIndex(subSequence, sequenceMatchingPreferences) != 0) {
                                goodTerminalPTms = false;
                                break;
                            }
                            found6 = false;
                            for (ModificationMatch modificationMatch : newSequence.getModificationsAt(newSequence.length())) {
                                if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                found6 = true;
                                break;
                            }
                            if (found6) continue;
                            goodTerminalPTms = false;
                            break;
                        }
                    }
                    if (!goodTerminalPTms) continue;
                    cTermSequence.append(newSequence);
                    newIndexes.add(endIndex);
                    newSequences.add(cTermSequence);
                }
            } else if (tagComponent instanceof MassGap) {
                double massGap = tagComponent.getMass();
                for (AminoAcidSequence cTermSequence : cTermPossibleSequences) {
                    int aaIndex;
                    int currentIndex = aaIndex = ((Integer)cTermPossibleIndexesIterator.next()).intValue();
                    ArrayList<Double> possibleSequencesMasses = new ArrayList<Double>();
                    ArrayList<AminoAcidSequence> possibleSequences = new ArrayList<AminoAcidSequence>();
                    ArrayList<AminoAcidSequence> validSequences = new ArrayList<AminoAcidSequence>();
                    while (++aaIndex <= sequenceLastIndex) {
                        AminoAcidPattern ptmPattern6;
                        PTM ptm9;
                        char aa = sequence.charAt(aaIndex);
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
                        double fixedMass = 0.0;
                        ArrayList<ModificationMatch> fixedModificationMatches = new ArrayList<ModificationMatch>();
                        for (String modificationName : fixedModifications) {
                            PTM ptm10 = PTMFactory.getInstance().getPTM(modificationName);
                            AminoAcidPattern ptmPattern7 = ptm10.getPattern();
                            if (ptm10.getType() != 0 || !ptmPattern7.isTargeted(aa, ptmPattern7.getTarget(), sequenceMatchingPreferences)) continue;
                            fixedMass += ptm10.getMass();
                            fixedModificationMatches.add(new ModificationMatch(modificationName, false, 1));
                        }
                        if (possibleSequencesMasses.isEmpty()) {
                            AminoAcidSequence newSequence3 = new AminoAcidSequence(aminoAcid.singleLetterCode);
                            int modIndex = newSequence3.length();
                            if (reportFixedPtms) {
                                for (ModificationMatch modificationMatch : fixedModificationMatches) {
                                    modificationMatch.setModificationSite(modIndex);
                                    newSequence3.addModificationMatch(modIndex, modificationMatch);
                                }
                            }
                            double noModMass = aminoAcid.monoisotopicMass + fixedMass;
                            possibleSequences.add(newSequence3);
                            possibleSequencesMasses.add(noModMass);
                            for (String modificationName : variableModifications) {
                                PTM ptm11 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern = ptm11.getPattern();
                                if (ptm11.getType() != 0 || !ptmPattern.isTargeted(aa, ptmPattern.getTarget(), sequenceMatchingPreferences)) continue;
                                newSequence3 = new AminoAcidSequence(aminoAcid.singleLetterCode);
                                newSequence3.addModificationMatch(modIndex, new ModificationMatch(modificationName, true, modIndex));
                                double newMass = noModMass + ptm11.getMass();
                                possibleSequences.add(newSequence3);
                                possibleSequencesMasses.add(newMass);
                            }
                        } else {
                            ArrayList<Double> newPossiblePatternsMasses = new ArrayList<Double>();
                            ArrayList<AminoAcidSequence> newPossibleSequences = new ArrayList<AminoAcidSequence>();
                            Iterator newPossibleSequencesMassesIterator = possibleSequences.iterator();
                            Iterator<Object> i$ = possibleSequencesMasses.iterator();
                            while (i$.hasNext()) {
                                double mass = (Double)i$.next();
                                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)newPossibleSequencesMassesIterator.next();
                                AminoAcidSequence newSequence4 = new AminoAcidSequence(aminoAcidSequence);
                                double noModMass = aminoAcid.monoisotopicMass + fixedMass + mass;
                                newSequence4.append(aminoAcid.singleLetterCode);
                                int modIndex = newSequence4.length();
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : fixedModificationMatches) {
                                        modificationMatch.setModificationSite(modIndex);
                                        newSequence4.addModificationMatch(modIndex, modificationMatch);
                                    }
                                }
                                newPossibleSequences.add(newSequence4);
                                newPossiblePatternsMasses.add(noModMass);
                                for (String modificationName : variableModifications) {
                                    ptm9 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern6 = ptm9.getPattern();
                                    if (ptm9.getType() != 0 || !ptmPattern6.isTargeted(aa, ptmPattern6.getTarget(), sequenceMatchingPreferences)) continue;
                                    newSequence4 = new AminoAcidSequence(aminoAcidSequence);
                                    newSequence4.append(aminoAcid.singleLetterCode);
                                    newSequence4.addModificationMatch(modIndex, new ModificationMatch(modificationName, true, modIndex));
                                    double newMass = noModMass + ptm9.getMass();
                                    newPossibleSequences.add(newSequence4);
                                    newPossiblePatternsMasses.add(newMass);
                                }
                            }
                            possibleSequences.clear();
                            possibleSequencesMasses.clear();
                            possibleSequences = newPossibleSequences;
                            possibleSequencesMasses = newPossiblePatternsMasses;
                        }
                        double fixedCTermModifications = 0.0;
                        ArrayList<ModificationMatch> cTermModifications = new ArrayList<ModificationMatch>();
                        for (String modificationName : fixedModifications) {
                            ptm2 = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm2.getType() != 7) continue;
                            fixedCTermModifications = ptm2.getMass();
                            cTermModifications.add(new ModificationMatch(modificationName, false, 1));
                            break;
                        }
                        if (aaIndex == sequenceLastIndex) {
                            for (String modificationName : fixedModifications) {
                                ptm2 = PTMFactory.getInstance().getPTM(modificationName);
                                if (ptm2.getType() != 3) continue;
                                fixedCTermModifications = ptm2.getMass();
                                cTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                break;
                            }
                        }
                        Iterator possibleSequencesIterator = possibleSequences.iterator();
                        Iterator possibleSequencesMassesIterator = possibleSequencesMasses.iterator();
                        block60: while (possibleSequencesIterator.hasNext()) {
                            AminoAcidPattern ptmPattern8;
                            PTM ptm12;
                            AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)possibleSequencesIterator.next();
                            double mass = (Double)possibleSequencesMassesIterator.next();
                            int lastAminoAcidIndex = aminoAcidSequence.length() - 1;
                            for (String modificationName : fixedModifications) {
                                ptm12 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern8 = ptm12.getPattern();
                                if (ptm12.getType() != 8 || !ptmPattern8.isTargeted(aminoAcidSequence.charAt(lastAminoAcidIndex), ptmPattern8.getTarget(), sequenceMatchingPreferences)) continue;
                                fixedCTermModifications = ptm12.getMass();
                                cTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                break;
                            }
                            if (aaIndex == lastAminoAcidIndex) {
                                for (String modificationName : fixedModifications) {
                                    ptm12 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern8 = ptm12.getPattern();
                                    if (ptm12.getType() != 4 || !ptmPattern8.isTargeted(aminoAcidSequence.charAt(lastAminoAcidIndex), ptmPattern8.getTarget(), sequenceMatchingPreferences)) continue;
                                    fixedCTermModifications = ptm12.getMass();
                                    cTermModifications.add(new ModificationMatch(modificationName, false, 1));
                                    break;
                                }
                            }
                            if (mass + fixedCTermModifications + minMod > massGap + massTolerance) {
                                possibleSequencesIterator.remove();
                                possibleSequencesMassesIterator.remove();
                                continue;
                            }
                            int modIndex = aminoAcidSequence.length();
                            if (Math.abs(mass + fixedCTermModifications - massGap) <= massTolerance) {
                                validSequences.add(aminoAcidSequence);
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : cTermModifications) {
                                        modificationMatch.setModificationSite(modIndex);
                                        aminoAcidSequence.addModificationMatch(modIndex, modificationMatch);
                                    }
                                }
                                possibleSequencesIterator.remove();
                                possibleSequencesMassesIterator.remove();
                                continue;
                            }
                            boolean found7 = false;
                            if (aaIndex == lastAminoAcidIndex) {
                                for (String modificationName : variableModifications) {
                                    ptm9 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern6 = ptm9.getPattern();
                                    if (ptm9.getType() != 3 && (ptm9.getType() != 4 || !ptmPattern6.isTargeted(aminoAcidSequence.charAt(lastAminoAcidIndex), ptmPattern6.getTarget(), sequenceMatchingPreferences)) || !(Math.abs(mass + fixedCTermModifications + ptm9.getMass() - massGap) <= massTolerance)) continue;
                                    aminoAcidSequence.addModificationMatch(lastAminoAcidIndex, new ModificationMatch(modificationName, true, modIndex));
                                    validSequences.add(aminoAcidSequence);
                                    if (reportFixedPtms) {
                                        for (ModificationMatch modificationMatch : cTermModifications) {
                                            modificationMatch.setModificationSite(modIndex);
                                            aminoAcidSequence.addModificationMatch(modIndex, modificationMatch);
                                        }
                                    }
                                    possibleSequencesIterator.remove();
                                    possibleSequencesMassesIterator.remove();
                                    found7 = true;
                                    break;
                                }
                            }
                            if (found7) continue;
                            for (String modificationName : variableModifications) {
                                ptm9 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern6 = ptm9.getPattern();
                                if (ptm9.getType() != 7 && (ptm9.getType() != 8 || !ptmPattern6.isTargeted(aminoAcidSequence.charAt(lastAminoAcidIndex), ptmPattern6.getTarget(), sequenceMatchingPreferences)) || !(Math.abs(mass + fixedCTermModifications + ptm9.getMass() - massGap) <= massTolerance)) continue;
                                aminoAcidSequence.addModificationMatch(lastAminoAcidIndex, new ModificationMatch(modificationName, true, modIndex));
                                if (reportFixedPtms) {
                                    for (ModificationMatch modificationMatch : cTermModifications) {
                                        modificationMatch.setModificationSite(modIndex);
                                        aminoAcidSequence.addModificationMatch(modIndex, modificationMatch);
                                    }
                                }
                                validSequences.add(aminoAcidSequence);
                                possibleSequencesIterator.remove();
                                possibleSequencesMassesIterator.remove();
                                continue block60;
                            }
                        }
                        if (!possibleSequencesMasses.isEmpty()) continue;
                        break;
                    }
                    for (AminoAcidSequence validSequence : validSequences) {
                        AminoAcidSequence newSequence5 = new AminoAcidSequence(cTermSequence);
                        newSequence5.append(validSequence);
                        int newIndex = currentIndex + validSequence.length();
                        newIndexes.add(newIndex);
                        newSequences.add(validSequence);
                    }
                }
            } else {
                throw new IllegalArgumentException("Tag component " + tagComponent.getClass() + " not implemented for sequence mating.");
            }
            if (newIndexes.isEmpty()) {
                return result;
            }
            cTermPossibleIndexes.clear();
            cTermPossibleSequences.clear();
            cTermPossibleIndexes = newIndexes;
            cTermPossibleSequences = newSequences;
        }
        String seedSequence = sequence.substring(tagIndex, tagIndex + componentAtIndexLength);
        Iterator nTermPossibleIndexesIterator = nTermPossibleIndexes.iterator();
        for (AminoAcidSequence nTermPattern : nTermPossibleSequences) {
            int nTermIndex = (Integer)nTermPossibleIndexesIterator.next();
            StringBuilder nTermSequence = new StringBuilder(nTermPattern.length() + seedSequence.length());
            nTermSequence.append(nTermPattern.getSequence());
            nTermSequence.append(seedSequence);
            for (AminoAcidSequence cTermPattern : cTermPossibleSequences) {
                Iterator<Serializable> i$;
                StringBuilder peptideSequence = new StringBuilder(nTermPattern.length() + seedSequence.length() + cTermPattern.length());
                peptideSequence.append((CharSequence)nTermSequence);
                ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>();
                HashMap<Integer, ArrayList<ModificationMatch>> nTermModifications = nTermPattern.getModificationMatches();
                if (nTermModifications != null) {
                    i$ = nTermModifications.keySet().iterator();
                    while (i$.hasNext()) {
                        int i = (Integer)i$.next();
                        for (ModificationMatch modificationMatch : nTermModifications.get(i)) {
                            modificationMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), i));
                        }
                    }
                }
                if (modificationsAtIndex != null) {
                    i$ = modificationsAtIndex.keySet().iterator();
                    while (i$.hasNext()) {
                        int i = (Integer)i$.next();
                        for (ModificationMatch modificationMatch : modificationsAtIndex.get(i)) {
                            modificationMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), nTermPattern.length() + i));
                        }
                    }
                }
                peptideSequence.append(cTermPattern.getSequence());
                HashMap<Integer, ArrayList<ModificationMatch>> cTermModifications = cTermPattern.getModificationMatches();
                if (cTermModifications != null) {
                    for (int i : cTermModifications.keySet()) {
                        for (ModificationMatch modificationMatch : cTermModifications.get(i)) {
                            modificationMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), nTermPattern.length() + componentAtIndexLength + i));
                        }
                    }
                }
                Peptide peptide = new Peptide(peptideSequence.toString(), modificationMatches);
                ArrayList<Peptide> peptides = result.get(nTermIndex);
                if (peptides == null) {
                    peptides = new ArrayList();
                    result.put(nTermIndex, peptides);
                }
                peptides.add(peptide);
            }
        }
        return result;
    }
}

