/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.identification.TagAssumption;
import com.compomics.util.experiment.identification.identification_parameters.PepnovoParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.tags.Tag;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.refinementparameters.PepnovoAssumptionDetails;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class PepNovoIdfileReader
extends ExperimentObject
implements IdfileReader {
    private HashMap<String, Long> index;
    private BufferedRandomAccessFile bufferedRandomAccessFile = null;
    private String fileName;
    public static final String tableHeader = "#Index\tRnkScr\tPnvScr\tN-Gap\tC-Gap\t[M+H]\tCharge\tSequence";
    public final double cTermCorrection = Atom.O.getMonoisotopicMass() + Atom.H.getMonoisotopicMass() + 2.0 * ElementaryIon.proton.getTheoreticMass();
    public final double nTermCorrection = 0.0;
    private HashMap<String, LinkedList<SpectrumMatch>> tagsMap;

    public PepNovoIdfileReader() {
    }

    public PepNovoIdfileReader(File identificationFile) throws FileNotFoundException, IOException {
        this(identificationFile, null);
    }

    public PepNovoIdfileReader(File identificationFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        String line;
        long progressUnit;
        this.bufferedRandomAccessFile = new BufferedRandomAccessFile(identificationFile, "r", 102400);
        this.fileName = Util.getFileName(identificationFile);
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        if ((progressUnit = this.bufferedRandomAccessFile.length() / 100L) == 0L) {
            progressUnit = 1L;
        }
        this.index = new HashMap();
        while ((line = this.bufferedRandomAccessFile.readLine()) != null) {
            if (!line.startsWith(">>")) continue;
            long currentIndex = this.bufferedRandomAccessFile.getFilePointer();
            String[] temp = line.split("\\s+");
            String formatted = "";
            for (int i = 3; i < temp.length; ++i) {
                formatted = formatted + temp[i] + " ";
            }
            int endIndex = formatted.lastIndexOf("#Problem");
            if (endIndex == -1) {
                endIndex = formatted.lastIndexOf("(SQS");
            }
            if (endIndex > -1) {
                String spectrumTitle = formatted.substring(0, endIndex).trim();
                this.index.put(spectrumTitle, currentIndex);
            }
            if (waitingHandler == null) continue;
            if (waitingHandler.isRunCanceled()) break;
            waitingHandler.setSecondaryProgressCounter((int)(currentIndex / progressUnit));
        }
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(waitingHandler, null, false);
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        int tagMapKeyLength = 0;
        if (sequenceMatchingPreferences != null) {
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            tagMapKeyLength = sequenceFactory.getDefaultProteinTree().getInitialTagSize();
            this.tagsMap = new HashMap(1024);
        }
        if (this.bufferedRandomAccessFile == null) {
            throw new IllegalStateException("The identification file was not set. Please use the appropriate constructor.");
        }
        LinkedList<SpectrumMatch> spectrumMatches = new LinkedList<SpectrumMatch>();
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(this.index.size());
        }
        for (String title : this.index.keySet()) {
            String decodedTitle = URLDecoder.decode(title, "utf-8");
            SpectrumMatch currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(this.getMgfFileName(), decodedTitle));
            int cpt = 1;
            this.bufferedRandomAccessFile.seek(this.index.get(title).longValue());
            String line = this.bufferedRandomAccessFile.getNextLine().trim();
            boolean solutionsFound = true;
            if (line.startsWith("# No") || line.startsWith("# Charge") || line.startsWith("#Problem") || line.startsWith("# too")) {
                solutionsFound = false;
            } else if (!line.equals(tableHeader)) {
                throw new IllegalArgumentException("Unrecognized table format. Expected: \"#Index\tRnkScr\tPnvScr\tN-Gap\tC-Gap\t[M+H]\tCharge\tSequence\", found:\"" + line + "\".");
            }
            while ((line = this.bufferedRandomAccessFile.getNextLine()) != null && !line.equals("") && !line.startsWith(">>")) {
                currentMatch.addHit(Advocate.pepnovo.getIndex(), this.getAssumptionFromLine(line, cpt), true);
                ++cpt;
            }
            if (solutionsFound) {
                if (sequenceMatchingPreferences != null) {
                    HashMap<Integer, HashMap<String, ArrayList<TagAssumption>>> matchTagMap = currentMatch.getTagAssumptionsMap(tagMapKeyLength, sequenceMatchingPreferences);
                    for (HashMap<String, ArrayList<TagAssumption>> advocateMap : matchTagMap.values()) {
                        for (String key : advocateMap.keySet()) {
                            LinkedList<SpectrumMatch> tagMatches = this.tagsMap.get(key);
                            if (tagMatches == null) {
                                tagMatches = new LinkedList();
                                this.tagsMap.put(key, tagMatches);
                            }
                            tagMatches.add(currentMatch);
                        }
                    }
                }
                spectrumMatches.add(currentMatch);
            }
            if (waitingHandler == null) continue;
            if (waitingHandler.isRunCanceled()) break;
            waitingHandler.increaseSecondaryProgressCounter();
        }
        return spectrumMatches;
    }

    public String getMgfFileName() {
        return this.fileName.substring(0, this.fileName.length() - 4);
    }

    @Override
    public String getExtension() {
        return ".out";
    }

    @Override
    public void close() throws IOException {
        this.bufferedRandomAccessFile.close();
    }

    private TagAssumption getAssumptionFromLine(String line, int rank) {
        String[] lineComponents = line.trim().split("\t");
        Double rankScore = new Double(lineComponents[1]);
        Double pepNovoScore = new Double(lineComponents[2]);
        Double nGap = new Double(lineComponents[3]);
        Double cGap = new Double(lineComponents[4]);
        if (cGap > 0.0 && cGap < this.cTermCorrection) {
            throw new IllegalArgumentException("Incompatible c-term gap " + cGap);
        }
        if (cGap > 0.0) {
            cGap = cGap - this.cTermCorrection;
        }
        Double mH = new Double(lineComponents[5]);
        Integer charge = new Integer(lineComponents[6]);
        String pepNovoSequence = lineComponents[7];
        String sequence = "";
        ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>();
        String modificationMass = "";
        String currentAA = "";
        int currentPtmLocation = 0;
        boolean nTermPtm = false;
        boolean cTermPtm = false;
        String ptmTag = "";
        for (int i = 0; i < pepNovoSequence.length(); ++i) {
            String aa = pepNovoSequence.charAt(i) + "";
            if (aa.equals("^") || aa.equals("$")) {
                ptmTag = aa;
                if (aa.equals("^")) {
                    nTermPtm = true;
                    continue;
                }
                cTermPtm = true;
                continue;
            }
            if (aa.equals("+") || aa.equals("-")) {
                modificationMass = modificationMass + aa;
                continue;
            }
            try {
                new Integer(aa);
                modificationMass = modificationMass + aa;
                continue;
            }
            catch (Exception e) {
                AminoAcid aminoAcid;
                if (!modificationMass.equals("")) {
                    String pepNovoPtmTag = "";
                    pepNovoPtmTag = nTermPtm || cTermPtm ? pepNovoPtmTag + ptmTag : pepNovoPtmTag + currentAA;
                    pepNovoPtmTag = pepNovoPtmTag + modificationMass;
                    ModificationMatch modMatch = new ModificationMatch(pepNovoPtmTag, true, currentPtmLocation);
                    modMatch.setConfident(true);
                    modificationMatches.add(modMatch);
                    modificationMass = "";
                    nTermPtm = false;
                }
                if ((aminoAcid = AminoAcid.getAminoAcid(aa)) == null) {
                    throw new IllegalArgumentException("Attempting to parse " + aa + " as amino acid in " + pepNovoSequence + ".");
                }
                sequence = sequence + aa;
                currentAA = aa;
                ++currentPtmLocation;
            }
        }
        if (!modificationMass.equals("")) {
            String pepNovoPtmTag = "";
            pepNovoPtmTag = nTermPtm || cTermPtm ? pepNovoPtmTag + ptmTag : pepNovoPtmTag + currentAA;
            pepNovoPtmTag = pepNovoPtmTag + modificationMass;
            ModificationMatch modMatch = new ModificationMatch(pepNovoPtmTag, true, currentPtmLocation);
            modificationMatches.add(modMatch);
        }
        AminoAcidSequence aminoAcidSequence = new AminoAcidSequence(sequence);
        for (ModificationMatch modificationMatch : modificationMatches) {
            aminoAcidSequence.addModificationMatch(modificationMatch.getModificationSite(), modificationMatch);
        }
        Tag tag = new Tag((double)nGap, aminoAcidSequence, (double)cGap);
        TagAssumption tagAssumption = new TagAssumption(Advocate.pepnovo.getIndex(), rank, tag, new Charge(1, charge), pepNovoScore);
        PepnovoAssumptionDetails pepnovoAssumptionDetails = new PepnovoAssumptionDetails();
        pepnovoAssumptionDetails.setRankScore(rankScore);
        pepnovoAssumptionDetails.setMH(mH);
        tagAssumption.addUrParam(pepnovoAssumptionDetails);
        return tagAssumption;
    }

    public static String getPTM(PepnovoParameters pepnovoParameters, String pepNovoModification) {
        Map<String, String> invertedPtmMap = pepnovoParameters.getPepNovoPtmMap();
        if (invertedPtmMap == null) {
            throw new IllegalArgumentException("Unsupported de novo search result. Please reprocess the data.");
        }
        String utilitesPtmName = invertedPtmMap.get(pepNovoModification);
        if (utilitesPtmName != null) {
            return utilitesPtmName;
        }
        throw new IllegalArgumentException("An error occurred while parsing the modification " + pepNovoModification + ".");
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add("3.1 (beta)");
        result.put("PepNovo+", versions);
        return result;
    }

    @Override
    public HashMap<String, LinkedList<Peptide>> getPeptidesMap() {
        return new HashMap<String, LinkedList<Peptide>>();
    }

    @Override
    public HashMap<String, LinkedList<SpectrumMatch>> getTagsMap() {
        return this.tagsMap;
    }

    @Override
    public void clearTagsMap() {
        if (this.tagsMap != null) {
            this.tagsMap.clear();
        }
    }

    @Override
    public void clearPeptidesMap() {
    }
}

