/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.general;

import com.compomics.util.general.UnknownElementMassException;
import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MassCalc {
    static Logger logger = Logger.getLogger(MassCalc.class);
    private int iChosen = -1;
    private HashMap masses = null;
    private static Vector allMaps = new Vector(2);
    private static final int ELEMENT = 0;
    private static final int MULTIPLICITY = 1;
    public static final int MONOELEMENTS = 0;
    public static final int MONOAA = 1;
    public static final int MONONUCLEOTIDES = 2;
    public static final int SELFDEFINED = -1;

    public MassCalc() {
        this(0);
    }

    public MassCalc(int aMassListIdentifier) {
        if (allMaps.isEmpty()) {
            allMaps.add(0, this.loadMassesFromPropFile("MonoElementMasses.properties"));
            allMaps.add(1, this.loadMassesFromPropFile("MonoAAMasses.properties"));
            allMaps.add(2, this.loadMassesFromPropFile("MonoNucleotideMasses.properties"));
        }
        if (aMassListIdentifier > allMaps.size()) {
            throw new IllegalArgumentException("No such elementlist defined (" + aMassListIdentifier + ").\n");
        }
        this.masses = (HashMap)((HashMap)allMaps.elementAt(aMassListIdentifier)).clone();
        this.iChosen = aMassListIdentifier;
    }

    public MassCalc(String aFilename) {
        this.masses = this.loadMassesFromPropFile(aFilename);
    }

    public MassCalc(HashMap aElementList) {
        this.masses = aElementList;
    }

    public MassCalc(int aMassListIdentifier, HashMap aSupplElementList) {
        this(aMassListIdentifier);
        this.masses.putAll(aSupplElementList);
    }

    public double calculateMass(String aFormula) throws UnknownElementMassException {
        char currentChar;
        StringCharacterIterator sci = new StringCharacterIterator(aFormula);
        double mass = 0.0;
        HashMap bruto = new HashMap(sci.getEndIndex());
        while ((currentChar = sci.current()) != '\uffff') {
            if (Character.isLetter(currentChar) || '_' == currentChar || '*' == currentChar) {
                Object[] result = this.getElement(sci);
                this.addResultToBrutoFormula((String)result[0], (Integer)result[1], bruto);
                continue;
            }
            if (currentChar == '(') {
                mass += this.getInnerFormulaMass(sci);
                continue;
            }
            throw new IllegalArgumentException("Formula '" + aFormula + "' could not be parsed due to the following unrecognized character: '" + currentChar + "'!\n");
        }
        for (String key : bruto.keySet()) {
            if (this.masses.containsKey(key)) {
                double tempMass = (Double)this.masses.get(key);
                int multiplicity = (Integer)bruto.get(key);
                mass += (double)multiplicity * tempMass;
                continue;
            }
            throw new UnknownElementMassException(key);
        }
        MassCalc innerMC = new MassCalc(0);
        if (this.iChosen == 1) {
            mass += innerMC.calculateMass("H2O");
        } else if (this.iChosen == 2) {
            mass += innerMC.calculateMass("H");
            mass -= innerMC.calculateMass("PO2");
        }
        return mass;
    }

    private void addResultToBrutoFormula(String aElement, int aMultiplicity, HashMap aBruto) {
        if (aBruto.containsKey(aElement)) {
            int tempValue = (Integer)aBruto.get(aElement);
            aBruto.put(aElement, tempValue += aMultiplicity);
        } else {
            aBruto.put(aElement, aMultiplicity);
        }
    }

    private Object[] getElement(StringCharacterIterator aSCI) {
        Object[] result = new Object[2];
        String element = Character.toString(aSCI.current());
        int multiplicity = 1;
        char next = aSCI.next();
        if (next != '\uffff') {
            if (Character.isLetter(next) && Character.isLowerCase(next)) {
                element = element + Character.toString(next);
                next = aSCI.next();
            } else if (next == '<') {
                element = element + this.isolateInnerPartString(aSCI, '<', '>', true);
            }
            multiplicity = next != '\uffff' && Character.isDigit(next) ? this.getMultiplicity(aSCI) : 1;
        }
        result[0] = element;
        result[1] = multiplicity;
        return result;
    }

    private int getMultiplicity(StringCharacterIterator aSCI) {
        int mp = 0;
        if (!Character.isDigit(aSCI.current())) {
            mp = 1;
        } else {
            String number = Character.toString(aSCI.current());
            char next = aSCI.next();
            while (next != '\uffff' && Character.isDigit(next)) {
                number = number + Character.toString(next);
                next = aSCI.next();
            }
            mp = Integer.parseInt(number);
        }
        return mp;
    }

    private double getInnerFormulaMass(StringCharacterIterator aSCI) throws UnknownElementMassException {
        String inner = this.isolateInnerPartString(aSCI, '(', ')', false);
        double mass = this.calculateMass(inner);
        int multiplicity = this.getMultiplicity(aSCI);
        return mass *= (double)multiplicity;
    }

    private String isolateInnerPartString(StringCharacterIterator aSCI, char aOpener, char aCloser, boolean aKeepTokens) {
        String innerFormula = "";
        int tokenCount = 1;
        char next = aSCI.next();
        int startPosition = aSCI.getIndex();
        int endPosition = -1;
        while (tokenCount > 0) {
            if (next == aOpener) {
                ++tokenCount;
            } else if (next == aCloser) {
                --tokenCount;
            }
            next = aSCI.next();
        }
        int imPosition = aSCI.getIndex();
        endPosition = imPosition - 2;
        for (int i = startPosition; i <= endPosition; ++i) {
            aSCI.setIndex(i);
            innerFormula = innerFormula + Character.valueOf(aSCI.current());
        }
        aSCI.setIndex(imPosition);
        return (aKeepTokens ? Character.valueOf(aOpener) : "") + innerFormula + (aKeepTokens ? Character.toString(aCloser) : "");
    }

    private HashMap loadMassesFromPropFile(String aFilename) {
        Properties tMasses = new Properties();
        HashMap<Object, Double> lMasses = new HashMap<Object, Double>();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(aFilename);
            if (is == null) {
                throw new IOException();
            }
            tMasses.load(is);
            for (Object o : tMasses.keySet()) {
                lMasses.put(o, new Double((String)tMasses.get(o)));
            }
        }
        catch (IOException ioe) {
            logger.error((Object)("\n**********************\nUnable to load file '" + aFilename + "' from the classpath."));
            logger.error((Object)"All mass calculations based on these masses will throw Exceptions!\n**********************\n");
        }
        return lMasses;
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            logger.error((Object)"\nUsage: MassCalc [-a|n] <formula1> [<formula2> ...]\n");
        } else {
            int start = 0;
            int elementlist = 0;
            if (args[0].equals("-a")) {
                start = 1;
                elementlist = 1;
                if (args.length < 2) {
                    logger.error((Object)"\nUsage: MassCalc [-a] <formula1> [<formula2> ...]\n");
                }
            } else if (args[0].equals("-n")) {
                start = 1;
                elementlist = 2;
                if (args.length < 2) {
                    logger.error((Object)"\nUsage: MassCalc [-n] <formula1> [<formula2> ...]\n");
                }
            }
            MassCalc mc = new MassCalc(elementlist);
            try {
                for (int i = start; i < args.length; ++i) {
                    logger.info((Object)("\nMass for '" + args[i] + "': " + mc.calculateMass(args[i]) + "."));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

