/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.protein;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.identification.FastaIndex;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.gui.protein.AdvancedProteinDatabaseDialog;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.protein.Header;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class SequenceDbDetailsDialog
extends JDialog {
    private static ProgressDialogX progressDialog;
    private SequenceFactory sequenceFactory = SequenceFactory.getInstance();
    private String lastSelectedFolder = null;
    private boolean dbEditable = true;
    private Image waitingImage;
    private Image normalImange;
    private Frame parentFrame;
    private UtilitiesUserPreferences utilitiesUserPreferences = null;
    private JSpinner accessionsSpinner;
    private JButton advancedButton;
    private JPanel backgroundPanel;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel databaseHelpSettingsJLabel;
    private JPanel databaseInformationPanel;
    private JTextField dbNameTxt;
    private JButton decoyButton;
    private JTextField decoyFlagTxt;
    private JLabel decoyTagLabel;
    private JLabel fileLabel;
    private JTextField fileTxt;
    private JLabel lastModifiedLabel;
    private JTextField lastModifiedTxt;
    private JLabel nameLabel;
    private JButton okButton;
    private JPanel previewPanel;
    private JLabel proteinLabel;
    private JTextArea proteinTxt;
    private JScrollPane proteinYxtScrollPane;
    private JLabel sizeLabel;
    private JTextField sizeTxt;
    private JLabel targetDecoyTxt;
    private JTextField typeJTextField;
    private JLabel typeLabel;
    private JLabel versionLabel;
    private JTextField versionTxt;

    public SequenceDbDetailsDialog(Frame parent, String lastSelectedFolder, boolean dbEditable, Image normalImange, Image waitingImage) {
        super(parent, true);
        this.initComponents();
        this.parentFrame = parent;
        this.lastSelectedFolder = lastSelectedFolder;
        this.dbEditable = dbEditable;
        this.waitingImage = waitingImage;
        this.normalImange = normalImange;
        this.loadUserPreferences();
        this.setUpGUI();
        this.setLocationRelativeTo(parent);
    }

    private void setUpGUI() {
        FastaIndex fastaIndex = this.sequenceFactory.getCurrentFastaIndex();
        if (fastaIndex != null) {
            this.fileTxt.setText(this.sequenceFactory.getCurrentFastaFile().getAbsolutePath());
            this.utilitiesUserPreferences.setDbFolder(this.sequenceFactory.getCurrentFastaFile());
            this.dbNameTxt.setText(fastaIndex.getName());
            if (fastaIndex.getDatabaseTypes().size() == 1) {
                this.typeJTextField.setText(Header.getDatabaseTypeAsString(fastaIndex.getMainDatabaseType()));
            } else {
                Iterator<Header.DatabaseType> iterator = fastaIndex.getDatabaseTypes().keySet().iterator();
                TreeMap<Integer, ArrayList<Header.DatabaseType>> sortedDatabaseTypes = new TreeMap<Integer, ArrayList<Header.DatabaseType>>();
                while (iterator.hasNext()) {
                    Header.DatabaseType tempDatabaseType = iterator.next();
                    Integer counter = fastaIndex.getDatabaseTypes().get((Object)tempDatabaseType);
                    ArrayList<Header.DatabaseType> tempList = (ArrayList<Header.DatabaseType>)sortedDatabaseTypes.get(counter);
                    if (tempList == null) {
                        tempList = new ArrayList<Header.DatabaseType>();
                    }
                    tempList.add(tempDatabaseType);
                    sortedDatabaseTypes.put(counter, tempList);
                }
                String tempText = "";
                for (Integer tempInt : sortedDatabaseTypes.descendingKeySet()) {
                    for (int i = 0; i < ((ArrayList)sortedDatabaseTypes.get(tempInt)).size(); ++i) {
                        if (!tempText.isEmpty()) {
                            tempText = tempText + ", ";
                        }
                        tempText = tempText + Header.getDatabaseTypeAsString((Header.DatabaseType)((Object)((ArrayList)sortedDatabaseTypes.get(tempInt)).get(i))) + " (" + tempInt + ")";
                    }
                }
                this.typeJTextField.setText(tempText);
            }
            this.versionTxt.setText(fastaIndex.getVersion());
            this.lastModifiedTxt.setText(new Date(fastaIndex.getLastModified()).toString());
            String nSequences = fastaIndex.getNSequences() + " sequences";
            if (fastaIndex.isConcatenatedTargetDecoy()) {
                nSequences = nSequences + " (" + fastaIndex.getNTarget() + " target)";
            }
            this.sizeTxt.setText(nSequences);
            if (fastaIndex.isConcatenatedTargetDecoy()) {
                this.decoyFlagTxt.setEditable(true);
                this.decoyFlagTxt.setText(fastaIndex.getDecoyTag());
            } else {
                this.decoyFlagTxt.setText("");
                this.decoyFlagTxt.setEditable(false);
            }
            this.decoyButton.setEnabled(!this.sequenceFactory.concatenatedTargetDecoy() && this.dbEditable);
            this.browseButton.setEnabled(this.dbEditable);
            this.decoyFlagTxt.setEditable(this.dbEditable);
            if (!this.sequenceFactory.getAccessions().isEmpty()) {
                this.accessionsSpinner.setEnabled(true);
                ArrayList<String> accessionsAsList = new ArrayList<String>();
                for (String anAcession : this.sequenceFactory.getAccessions()) {
                    accessionsAsList.add(anAcession);
                }
                this.accessionsSpinner.setModel(new SpinnerListModel(accessionsAsList));
                this.accessionsSpinner.setValue(accessionsAsList.get(0));
                this.updateSequence();
            } else {
                this.accessionsSpinner.setEnabled(false);
            }
        }
    }

    private void updateSequence() {
        String accession = this.accessionsSpinner.getValue().toString();
        try {
            if (this.sequenceFactory.isClosed()) {
                this.sequenceFactory.resetConnection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Protein protein = this.sequenceFactory.getProtein(accession);
            this.proteinTxt.setText(this.sequenceFactory.getHeader(accession).toString() + System.getProperty("line.separator") + protein.getSequence());
            this.proteinTxt.setCaretPosition(0);
            String decoyFlag = this.decoyFlagTxt.getText().trim();
            if (!decoyFlag.equals("")) {
                if (SequenceFactory.isDecoy(accession, decoyFlag)) {
                    this.targetDecoyTxt.setText("(Decoy)");
                } else {
                    this.targetDecoyTxt.setText("(Target)");
                }
            } else {
                this.targetDecoyTxt.setText("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "An error occured while looking for protein " + accession + ".", "Error", 0);
        }
    }

    public String getLastSelectedFolder() {
        return this.lastSelectedFolder;
    }

    public boolean selectDB(boolean userCanDispose) {
        if (this.sequenceFactory.getFileName() == null || !userCanDispose) {
            File startLocation = new File(this.lastSelectedFolder);
            if (this.utilitiesUserPreferences.getDbFolder() != null && this.utilitiesUserPreferences.getDbFolder().exists()) {
                startLocation = this.utilitiesUserPreferences.getDbFolder();
            }
            JFileChooser fc = new JFileChooser(startLocation);
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File myFile) {
                    return myFile.getName().toLowerCase().endsWith("fasta") || myFile.getName().toLowerCase().endsWith("fas") || myFile.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "FASTA (.fasta or .fas)";
                }
            };
            fc.setFileFilter(filter);
            int result = fc.showOpenDialog(this);
            if (result == 0) {
                File file = fc.getSelectedFile();
                this.lastSelectedFolder = file.getParent();
                this.utilitiesUserPreferences.setDbFolder(file.getParentFile());
                if (file.getName().indexOf(" ") != -1 && (file = this.renameFastaFileName(file)) == null) {
                    return false;
                }
                try {
                    this.sequenceFactory.clearFactory();
                    this.loadFastaFile(file);
                    return true;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "An error occurred while clearing the sequence factory.", "Import error", 2);
                    e.printStackTrace();
                }
            } else if (userCanDispose) {
                this.dispose();
            }
            return false;
        }
        return true;
    }

    private void loadFastaFile(File file) {
        final File finalFile = file;
        progressDialog = new ProgressDialogX(this, this.parentFrame, this.normalImange, this.waitingImage, true);
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Loading Database. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("importThread"){

            @Override
            public void run() {
                try {
                    progressDialog.setTitle("Importing Database. Please Wait...");
                    progressDialog.setPrimaryProgressCounterIndeterminate(false);
                    SequenceDbDetailsDialog.this.sequenceFactory.loadFastaFile(finalFile, progressDialog);
                }
                catch (IOException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(SequenceDbDetailsDialog.this, new String[]{"FASTA Import Error.", "File " + finalFile.getAbsolutePath() + " not found."}, "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                catch (ClassNotFoundException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(SequenceDbDetailsDialog.this, new String[]{"FASTA Import Error.", "File index of " + finalFile.getName() + " could not be imported. Please contact the developers."}, "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                catch (StringIndexOutOfBoundsException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(SequenceDbDetailsDialog.this, e.getMessage(), "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                catch (IllegalArgumentException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(SequenceDbDetailsDialog.this, e.getMessage(), "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                if (!progressDialog.isRunCanceled() && !SequenceDbDetailsDialog.this.sequenceFactory.concatenatedTargetDecoy()) {
                    SequenceDbDetailsDialog.this.setIconImage(SequenceDbDetailsDialog.this.normalImange);
                    int value = JOptionPane.showConfirmDialog(SequenceDbDetailsDialog.this, "The selected FASTA file does not seem to contain decoy sequences.\nAdd decoys?", "Add Decoy Sequences?", 0);
                    SequenceDbDetailsDialog.this.setIconImage(SequenceDbDetailsDialog.this.waitingImage);
                    if (value == 1) {
                        SequenceDbDetailsDialog.this.decoyFlagTxt.setEditable(false);
                    } else if (value == 0) {
                        SequenceDbDetailsDialog.this.generateTargetDecoyDatabase(finalFile, progressDialog);
                    }
                }
                if (!progressDialog.isRunCanceled()) {
                    SequenceDbDetailsDialog.this.setUpGUI();
                }
                progressDialog.setRunFinished();
            }
        }.start();
    }

    public void generateTargetDecoyDatabase(File targetFile, ProgressDialogX progressDialog) {
        String fastaInput;
        String newFasta = fastaInput = targetFile.getAbsolutePath();
        if (fastaInput.lastIndexOf(".") != -1) {
            newFasta = fastaInput.substring(0, fastaInput.lastIndexOf("."));
        }
        newFasta = newFasta + SequenceFactory.getTargetDecoyFileNameTag();
        try {
            File newFile = new File(newFasta);
            progressDialog.setTitle("Appending Decoy Sequences. Please Wait...");
            this.sequenceFactory.appendDecoySequences(newFile, progressDialog);
            this.sequenceFactory.clearFactory();
            progressDialog.setTitle("Getting Database Details. Please Wait...");
            this.sequenceFactory.loadFastaFile(newFile, progressDialog);
        }
        catch (OutOfMemoryError error) {
            Runtime.getRuntime().gc();
            JOptionPane.showMessageDialog(this, "The tool used up all the available memory and had to be stopped.\nMemory boundaries are set in the Edit menu (Edit > Java Options).", "Out Of Memory Error", 0);
            System.out.println("Ran out of memory!");
            error.printStackTrace();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, new String[]{"FASTA Import Error.", "File " + fastaInput + " not found."}, "FASTA Import Error", 2);
            e.printStackTrace();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, new String[]{"FASTA Import Error.", "File " + fastaInput + " could not be imported."}, "FASTA Import Error", 2);
            e.printStackTrace();
        }
    }

    public File renameFastaFileName(File file) {
        String tempName = file.getName();
        tempName = tempName.replaceAll(" ", "_");
        File renamedFile = new File(file.getParentFile().getAbsolutePath() + File.separator + tempName);
        boolean success = false;
        try {
            success = renamedFile.createNewFile();
            if (success) {
                Util.copyFile(file, renamedFile);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "An error occurred while renaming the file.", "Please Rename File", 2);
            e.printStackTrace();
            success = false;
        }
        if (success) {
            JOptionPane.showMessageDialog(this, "Your FASTA file name contained white space and has been renamed to:\n" + file.getParentFile().getAbsolutePath() + File.separator + tempName, "Renamed File", 2);
            return renamedFile;
        }
        return null;
    }

    private boolean saveChanges() {
        String decoyFlag;
        String version;
        boolean change = false;
        FastaIndex fastaIndex = this.sequenceFactory.getCurrentFastaIndex();
        String name = this.dbNameTxt.getText().trim();
        if (!name.equals(fastaIndex.getName())) {
            fastaIndex.setName(name);
            change = true;
        }
        if (!(version = this.versionTxt.getText().trim()).equals(fastaIndex.getVersion())) {
            fastaIndex.setVersion(version);
            change = true;
        }
        if (!(decoyFlag = this.decoyFlagTxt.getText().trim()).equals(fastaIndex.getDecoyTag())) {
            fastaIndex.setDecoyTag(decoyFlag);
            change = true;
        }
        if (change) {
            try {
                this.sequenceFactory.saveIndex();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occurred while attempting to save the database index file.", "Renamed File", 2);
                return false;
            }
        }
        return true;
    }

    public void loadUserPreferences() {
        try {
            this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.databaseInformationPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.dbNameTxt = new JTextField();
        this.typeLabel = new JLabel();
        this.fileTxt = new JTextField();
        this.decoyFlagTxt = new JTextField();
        this.decoyTagLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.versionTxt = new JTextField();
        this.lastModifiedLabel = new JLabel();
        this.lastModifiedTxt = new JTextField();
        this.sizeLabel = new JLabel();
        this.sizeTxt = new JTextField();
        this.decoyButton = new JButton();
        this.browseButton = new JButton();
        this.fileLabel = new JLabel();
        this.advancedButton = new JButton();
        this.typeJTextField = new JTextField();
        this.previewPanel = new JPanel();
        this.proteinYxtScrollPane = new JScrollPane();
        this.proteinTxt = new JTextArea();
        this.proteinLabel = new JLabel();
        this.accessionsSpinner = new JSpinner();
        this.targetDecoyTxt = new JLabel();
        this.databaseHelpSettingsJLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Database");
        this.setMinimumSize(new Dimension(500, 500));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDbDetailsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDbDetailsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.databaseInformationPanel.setBorder(BorderFactory.createTitledBorder("Database Details"));
        this.databaseInformationPanel.setOpaque(false);
        this.nameLabel.setText("Name");
        this.dbNameTxt.setEditable(false);
        this.dbNameTxt.setHorizontalAlignment(0);
        this.typeLabel.setText("Type(s)");
        this.fileTxt.setEditable(false);
        this.fileTxt.setHorizontalAlignment(2);
        this.decoyFlagTxt.setEditable(false);
        this.decoyFlagTxt.setHorizontalAlignment(0);
        this.decoyTagLabel.setText("Decoy Tag");
        this.versionLabel.setText("Version");
        this.versionTxt.setEditable(false);
        this.versionTxt.setHorizontalAlignment(0);
        this.lastModifiedLabel.setText("Modified");
        this.lastModifiedTxt.setEditable(false);
        this.lastModifiedTxt.setHorizontalAlignment(0);
        this.sizeLabel.setText("Size");
        this.sizeTxt.setEditable(false);
        this.sizeTxt.setHorizontalAlignment(0);
        this.decoyButton.setText("Decoy");
        this.decoyButton.setPreferredSize(new Dimension(75, 25));
        this.decoyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDbDetailsDialog.this.decoyButtonActionPerformed(evt);
            }
        });
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDbDetailsDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.fileLabel.setText("File");
        this.advancedButton.setText("Advanced");
        this.advancedButton.setPreferredSize(new Dimension(90, 25));
        this.advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDbDetailsDialog.this.advancedButtonActionPerformed(evt);
            }
        });
        this.typeJTextField.setEditable(false);
        this.typeJTextField.setHorizontalAlignment(0);
        GroupLayout databaseInformationPanelLayout = new GroupLayout(this.databaseInformationPanel);
        this.databaseInformationPanel.setLayout(databaseInformationPanelLayout);
        databaseInformationPanelLayout.setHorizontalGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(databaseInformationPanelLayout.createSequentialGroup().addContainerGap().addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, databaseInformationPanelLayout.createSequentialGroup().addComponent(this.fileLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileTxt, -1, 336, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoyButton, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.advancedButton, -2, -1, -2)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.sizeLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sizeTxt)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.typeLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeJTextField)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.decoyTagLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoyFlagTxt)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.versionLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionTxt)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.nameLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dbNameTxt)).addGroup(databaseInformationPanelLayout.createSequentialGroup().addComponent(this.lastModifiedLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastModifiedTxt))).addContainerGap()));
        databaseInformationPanelLayout.linkSize(0, this.decoyTagLabel, this.fileLabel, this.lastModifiedLabel, this.nameLabel, this.sizeLabel, this.typeLabel, this.versionLabel);
        databaseInformationPanelLayout.linkSize(0, this.advancedButton, this.browseButton, this.decoyButton);
        databaseInformationPanelLayout.setVerticalGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(databaseInformationPanelLayout.createSequentialGroup().addContainerGap().addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileTxt, -2, -1, -2).addComponent(this.decoyButton, -2, -1, -2).addComponent(this.browseButton).addComponent(this.fileLabel).addComponent(this.advancedButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.dbNameTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.typeJTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionTxt, -2, -1, -2).addComponent(this.versionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoyTagLabel).addComponent(this.decoyFlagTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeLabel).addComponent(this.sizeTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(databaseInformationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lastModifiedLabel).addComponent(this.lastModifiedTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        databaseInformationPanelLayout.linkSize(1, this.advancedButton, this.browseButton, this.decoyButton);
        this.previewPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.previewPanel.setOpaque(false);
        this.proteinTxt.setEditable(false);
        this.proteinTxt.setColumns(20);
        this.proteinTxt.setLineWrap(true);
        this.proteinTxt.setRows(5);
        this.proteinTxt.setWrapStyleWord(true);
        this.proteinYxtScrollPane.setViewportView(this.proteinTxt);
        this.proteinLabel.setText("Protein");
        this.accessionsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SequenceDbDetailsDialog.this.accessionsSpinnerStateChanged(evt);
            }
        });
        this.targetDecoyTxt.setText("(target/decoy)");
        GroupLayout previewPanelLayout = new GroupLayout(this.previewPanel);
        this.previewPanel.setLayout(previewPanelLayout);
        previewPanelLayout.setHorizontalGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(previewPanelLayout.createSequentialGroup().addContainerGap().addGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinYxtScrollPane).addGroup(previewPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.proteinLabel).addGap(18, 18, 18).addComponent(this.accessionsSpinner, -2, 192, -2).addGap(18, 18, 18).addComponent(this.targetDecoyTxt).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        previewPanelLayout.setVerticalGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(previewPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinYxtScrollPane, -1, 155, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinLabel).addComponent(this.accessionsSpinner, -2, -1, -2).addComponent(this.targetDecoyTxt)).addContainerGap()));
        this.databaseHelpSettingsJLabel.setForeground(new Color(0, 0, 255));
        this.databaseHelpSettingsJLabel.setHorizontalAlignment(0);
        this.databaseHelpSettingsJLabel.setText("<html><u><i>Database?</i></u></html>");
        this.databaseHelpSettingsJLabel.setToolTipText("Open Database Help");
        this.databaseHelpSettingsJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SequenceDbDetailsDialog.this.databaseHelpSettingsJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SequenceDbDetailsDialog.this.databaseHelpSettingsJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SequenceDbDetailsDialog.this.databaseHelpSettingsJLabelMouseExited(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.databaseHelpSettingsJLabel, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 75, -2)).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE).addComponent(this.databaseInformationPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.databaseInformationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.databaseHelpSettingsJLabel, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.saveChanges()) {
            if (this.utilitiesUserPreferences != null) {
                UtilitiesUserPreferences.saveUserPreferences(this.utilitiesUserPreferences);
            }
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        this.selectDB(false);
    }

    private void decoyButtonActionPerformed(ActionEvent evt) {
        progressDialog = new ProgressDialogX(this, this.parentFrame, this.normalImange, this.waitingImage, true);
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Creating Decoy. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("DecoyThread"){

            @Override
            public void run() {
                SequenceDbDetailsDialog.this.generateTargetDecoyDatabase(SequenceDbDetailsDialog.this.sequenceFactory.getCurrentFastaFile(), progressDialog);
                progressDialog.setRunFinished();
            }
        }.start();
    }

    private void accessionsSpinnerStateChanged(ChangeEvent evt) {
        this.updateSequence();
    }

    private void databaseHelpSettingsJLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://code.google.com/p/searchgui/wiki/DatabaseHelp");
        this.setCursor(new Cursor(0));
    }

    private void databaseHelpSettingsJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void databaseHelpSettingsJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void advancedButtonActionPerformed(ActionEvent evt) {
        new AdvancedProteinDatabaseDialog(this.parentFrame);
        this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
    }
}

