/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.renderers;

import java.awt.Component;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;

public class TimestampRenderer
extends DefaultTableCellRenderer {
    Logger logger = Logger.getLogger(TimestampRenderer.class);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            String text = sdf.format(ts);
            this.setText(text);
            if (table != null) {
                this.setFont(table.getFont());
            }
        } else {
            this.logger.error((Object)("Got a " + value.getClass().getName() + " for the renderer instead of a java.sql.Timestamp."));
        }
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(noFocusBorder);
        }
        return this;
    }
}

