/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.searchsettings.algorithm_settings;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.identification.identification_parameters.CometParameters;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class CometSettingsDialog
extends JDialog {
    private CometParameters cometParameters;
    private boolean cancelled = false;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JLabel batchSizeLabel;
    private JTextField batchSizeTxt;
    private JLabel clearMzRangeDividerLabel;
    private JLabel clearMzRangeLabel;
    private JTextField clearMzRangeLowerTxt;
    private JTextField clearMzRangeUpperTxt;
    private JButton closeButton;
    private JComboBox correlationScoreTypeCmb;
    private JLabel correlationScoreTypeLabel;
    private JComboBox enzymeTypeCmb;
    private JLabel enzymeTypeLabel;
    private JLabel fragmentBinOffsetLabel;
    private JTextField fragmentBinOffsetTxt;
    private JPanel fragmentIonsPanel;
    private JComboBox isotopeCorrectionCmb;
    private JLabel isotopeCorrectionLabel;
    private JLabel maxFragmentChargeLabel;
    private JTextField maxFragmentChargeTxt;
    private JTextField maxPrecursorMassTxt;
    private JLabel maxPtmsLabel;
    private JTextField maxPtmsTxt;
    private JLabel minPeakIntensityLbl;
    private JTextField minPeakIntensityTxt;
    private JLabel minPeaksLbl;
    private JTextField minPeaksTxt;
    private JTextField minPrecursorMassTxt;
    private JLabel numberMatchesLabel;
    private JTextField numberMatchesTxt;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JLabel precursorMassDividerLabel;
    private JLabel precursorMassLabel;
    private JComboBox removeMethionineCmb;
    private JLabel removeMethionineLabel;
    private JComboBox removePrecursorPeakCombo;
    private JLabel removePrecursorPeakLabel;
    private JLabel removePrecursorPeakToleranceLbl;
    private JTextField removePrecursorPeakToleranceTxt;
    private JPanel searchSettingsPanel;
    private JPanel spectrumProcessingPanel;
    private JTabbedPane tabbedPane;
    private JComboBox useSparseMatrixCmb;
    private JLabel useSparseMatrixLabel;

    public CometSettingsDialog(Frame parent, CometParameters cometParameters) {
        super(parent, true);
        this.cometParameters = cometParameters != null ? cometParameters : new CometParameters();
        this.initComponents();
        this.setUpGUI();
        this.fillGUI();
        this.validateInput(false);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.removePrecursorPeakCombo.setRenderer(new AlignedListCellRenderer(0));
        this.enzymeTypeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.isotopeCorrectionCmb.setRenderer(new AlignedListCellRenderer(0));
        this.removePrecursorPeakCombo.setRenderer(new AlignedListCellRenderer(0));
        this.correlationScoreTypeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.useSparseMatrixCmb.setRenderer(new AlignedListCellRenderer(0));
        this.removeMethionineCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void fillGUI() {
        if (this.cometParameters.getNumberOfSpectrumMatches() != null) {
            this.numberMatchesTxt.setText(this.cometParameters.getNumberOfSpectrumMatches() + "");
        }
        if (this.cometParameters.getMinPeaks() != null) {
            this.minPeaksTxt.setText(this.cometParameters.getMinPeaks() + "");
        }
        if (this.cometParameters.getMinPeakIntensity() != null) {
            this.minPeakIntensityTxt.setText(this.cometParameters.getMinPeakIntensity() + "");
        }
        if (this.cometParameters.getRemovePrecursor() != null) {
            this.removePrecursorPeakCombo.setSelectedIndex(this.cometParameters.getRemovePrecursor());
        }
        if (this.cometParameters.getRemovePrecursorTolerance() != null) {
            this.removePrecursorPeakToleranceTxt.setText(this.cometParameters.getRemovePrecursorTolerance() + "");
        }
        if (this.cometParameters.getLowerClearMzRange() != null) {
            this.clearMzRangeLowerTxt.setText(this.cometParameters.getLowerClearMzRange() + "");
        }
        if (this.cometParameters.getUpperClearMzRange() != null) {
            this.clearMzRangeUpperTxt.setText(this.cometParameters.getUpperClearMzRange() + "");
        }
        if (this.cometParameters.getEnzymeType() != null) {
            if (this.cometParameters.getEnzymeType() == 1) {
                this.enzymeTypeCmb.setSelectedIndex(0);
            } else if (this.cometParameters.getEnzymeType() == 2) {
                this.enzymeTypeCmb.setSelectedIndex(1);
            } else if (this.cometParameters.getEnzymeType() == 8) {
                this.enzymeTypeCmb.setSelectedIndex(2);
            } else if (this.cometParameters.getEnzymeType() == 9) {
                this.enzymeTypeCmb.setSelectedIndex(3);
            }
        }
        if (this.cometParameters.getIsotopeCorrection() != null) {
            this.isotopeCorrectionCmb.setSelectedIndex(this.cometParameters.getIsotopeCorrection());
        }
        if (this.cometParameters.getMinPrecursorMass() != null) {
            this.minPrecursorMassTxt.setText(this.cometParameters.getMinPrecursorMass() + "");
        }
        if (this.cometParameters.getMaxPrecursorMass() != null) {
            this.maxPrecursorMassTxt.setText(this.cometParameters.getMaxPrecursorMass() + "");
        }
        if (this.cometParameters.getMaxFragmentCharge() != null) {
            this.maxFragmentChargeTxt.setText(this.cometParameters.getMaxFragmentCharge() + "");
        }
        if (this.cometParameters.getRemoveMethionine().booleanValue()) {
            this.removeMethionineCmb.setSelectedIndex(0);
        } else {
            this.removeMethionineCmb.setSelectedIndex(1);
        }
        if (this.cometParameters.getBatchSize() != null) {
            this.batchSizeTxt.setText(this.cometParameters.getBatchSize() + "");
        }
        if (this.cometParameters.getMaxVariableMods() != null) {
            this.maxPtmsTxt.setText(this.cometParameters.getMaxVariableMods() + "");
        }
        if (this.cometParameters.getTheoreticalFragmentIonsSumOnly().booleanValue()) {
            this.correlationScoreTypeCmb.setSelectedIndex(1);
        } else {
            this.correlationScoreTypeCmb.setSelectedIndex(0);
        }
        if (this.cometParameters.getFragmentBinOffset() != null) {
            this.fragmentBinOffsetTxt.setText(this.cometParameters.getFragmentBinOffset() + "");
        }
        if (this.cometParameters.getUseSparseMatrix().booleanValue()) {
            this.useSparseMatrixCmb.setSelectedIndex(0);
        } else {
            this.useSparseMatrixCmb.setSelectedIndex(1);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public CometParameters getInput() {
        int selectedIndex;
        CometParameters result = new CometParameters();
        String input = this.minPeaksTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPeaks(new Integer(input));
        }
        if (!(input = this.minPeakIntensityTxt.getText().trim()).equals("")) {
            result.setMinPeakIntensity(new Double(input));
        }
        result.setRemovePrecursor(this.removePrecursorPeakCombo.getSelectedIndex());
        input = this.removePrecursorPeakToleranceTxt.getText().trim();
        if (!input.equals("")) {
            result.setRemovePrecursorTolerance(new Double(input));
        }
        if (!(input = this.clearMzRangeLowerTxt.getText().trim()).equals("")) {
            result.setLowerClearMzRange(new Double(input));
        }
        if (!(input = this.clearMzRangeUpperTxt.getText().trim()).equals("")) {
            result.setUpperClearMzRange(new Double(input));
        }
        if ((selectedIndex = this.enzymeTypeCmb.getSelectedIndex()) == 0) {
            result.setEnzymeType(1);
        } else if (selectedIndex == 1) {
            result.setEnzymeType(2);
        } else if (selectedIndex == 2) {
            result.setEnzymeType(8);
        } else if (selectedIndex == 3) {
            result.setEnzymeType(9);
        }
        result.setIsotopeCorrection(this.isotopeCorrectionCmb.getSelectedIndex());
        input = this.minPrecursorMassTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPrecursorMass(new Double(input));
        }
        if (!(input = this.maxPrecursorMassTxt.getText().trim()).equals("")) {
            result.setMaxPrecursorMass(new Double(input));
        }
        if (!(input = this.numberMatchesTxt.getText().trim()).equals("")) {
            result.setNumberOfSpectrumMatches(new Integer(input));
        }
        if (!(input = this.maxFragmentChargeTxt.getText().trim()).equals("")) {
            result.setMaxFragmentCharge(new Integer(input));
        }
        result.setRemoveMethionine(this.removeMethionineCmb.getSelectedIndex() == 0);
        input = this.batchSizeTxt.getText().trim();
        if (!input.equals("")) {
            result.setBatchSize(new Integer(input));
        }
        if (!(input = this.maxPtmsTxt.getText().trim()).equals("")) {
            result.setMaxVariableMods(new Integer(input));
        }
        result.setTheoreticalFragmentIonsSumOnly(this.correlationScoreTypeCmb.getSelectedIndex() == 1);
        input = this.fragmentBinOffsetTxt.getText().trim();
        if (!input.equals("")) {
            result.setFragmentBinOffset(new Double(input));
        }
        if (!(input = this.fragmentBinOffsetTxt.getText().trim()).equals("")) {
            result.setFragmentBinOffset(new Double(input));
        }
        result.setUseSparseMatrix(this.useSparseMatrixCmb.getSelectedIndex() == 0);
        return result;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.spectrumProcessingPanel = new JPanel();
        this.minPeaksLbl = new JLabel();
        this.minPeaksTxt = new JTextField();
        this.minPeakIntensityLbl = new JLabel();
        this.minPeakIntensityTxt = new JTextField();
        this.removePrecursorPeakLabel = new JLabel();
        this.removePrecursorPeakCombo = new JComboBox();
        this.removePrecursorPeakToleranceLbl = new JLabel();
        this.removePrecursorPeakToleranceTxt = new JTextField();
        this.clearMzRangeLabel = new JLabel();
        this.clearMzRangeLowerTxt = new JTextField();
        this.clearMzRangeDividerLabel = new JLabel();
        this.clearMzRangeUpperTxt = new JTextField();
        this.searchSettingsPanel = new JPanel();
        this.enzymeTypeLabel = new JLabel();
        this.enzymeTypeCmb = new JComboBox();
        this.isotopeCorrectionLabel = new JLabel();
        this.isotopeCorrectionCmb = new JComboBox();
        this.precursorMassLabel = new JLabel();
        this.minPrecursorMassTxt = new JTextField();
        this.precursorMassDividerLabel = new JLabel();
        this.maxPrecursorMassTxt = new JTextField();
        this.numberMatchesLabel = new JLabel();
        this.numberMatchesTxt = new JTextField();
        this.maxFragmentChargeLabel = new JLabel();
        this.maxFragmentChargeTxt = new JTextField();
        this.removeMethionineLabel = new JLabel();
        this.removeMethionineCmb = new JComboBox();
        this.batchSizeLabel = new JLabel();
        this.batchSizeTxt = new JTextField();
        this.maxPtmsLabel = new JLabel();
        this.maxPtmsTxt = new JTextField();
        this.fragmentIonsPanel = new JPanel();
        this.correlationScoreTypeLabel = new JLabel();
        this.correlationScoreTypeCmb = new JComboBox();
        this.fragmentBinOffsetLabel = new JLabel();
        this.fragmentBinOffsetTxt = new JTextField();
        this.useSparseMatrixLabel = new JLabel();
        this.useSparseMatrixCmb = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Advanced Comet Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CometSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CometSettingsDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CometSettingsDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CometSettingsDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CometSettingsDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Click to open the Comet help page.");
        this.tabbedPane.setBackground(new Color(230, 230, 230));
        this.tabbedPane.setOpaque(true);
        this.spectrumProcessingPanel.setBackground(new Color(230, 230, 230));
        this.spectrumProcessingPanel.setPreferredSize(new Dimension(518, 143));
        this.minPeaksLbl.setText("Minimum Number of Peaks");
        this.minPeaksTxt.setHorizontalAlignment(0);
        this.minPeaksTxt.setText("10");
        this.minPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.minPeaksTxtKeyReleased(evt);
            }
        });
        this.minPeakIntensityLbl.setText("Minimal Peak Intensity");
        this.minPeakIntensityTxt.setHorizontalAlignment(0);
        this.minPeakIntensityTxt.setText("0.0");
        this.minPeakIntensityTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.minPeakIntensityTxtKeyReleased(evt);
            }
        });
        this.removePrecursorPeakLabel.setText("Remove Precursor Peak");
        this.removePrecursorPeakCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"No", "Yes", "Yes + Charge Reduced "}));
        this.removePrecursorPeakToleranceLbl.setText("Remove Precursor Peak Tolerance (Da)");
        this.removePrecursorPeakToleranceTxt.setHorizontalAlignment(0);
        this.removePrecursorPeakToleranceTxt.setText("0.0");
        this.removePrecursorPeakToleranceTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.removePrecursorPeakToleranceTxtKeyReleased(evt);
            }
        });
        this.clearMzRangeLabel.setText("Clear m/z Range");
        this.clearMzRangeLowerTxt.setHorizontalAlignment(0);
        this.clearMzRangeLowerTxt.setText("0.0");
        this.clearMzRangeLowerTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.clearMzRangeLowerTxtKeyReleased(evt);
            }
        });
        this.clearMzRangeDividerLabel.setHorizontalAlignment(0);
        this.clearMzRangeDividerLabel.setText("-");
        this.clearMzRangeUpperTxt.setHorizontalAlignment(0);
        this.clearMzRangeUpperTxt.setText("0.0");
        this.clearMzRangeUpperTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.clearMzRangeUpperTxtKeyReleased(evt);
            }
        });
        GroupLayout spectrumProcessingPanelLayout = new GroupLayout(this.spectrumProcessingPanel);
        this.spectrumProcessingPanel.setLayout(spectrumProcessingPanelLayout);
        spectrumProcessingPanelLayout.setHorizontalGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, spectrumProcessingPanelLayout.createSequentialGroup().addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.minPeaksLbl, -1, 250, Short.MAX_VALUE).addComponent(this.minPeakIntensityLbl, -1, 250, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.minPeakIntensityTxt, -1, 189, Short.MAX_VALUE).addComponent(this.minPeaksTxt)).addGap(0, 0, Short.MAX_VALUE)).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.clearMzRangeLabel, GroupLayout.Alignment.LEADING, -1, 250, Short.MAX_VALUE).addComponent(this.removePrecursorPeakLabel, GroupLayout.Alignment.LEADING, -1, 250, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addComponent(this.removePrecursorPeakToleranceLbl, -1, 229, Short.MAX_VALUE).addGap(25, 25, 25))).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addComponent(this.removePrecursorPeakToleranceTxt).addGap(30, 30, 30)).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.removePrecursorPeakCombo, -2, 189, -2).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addComponent(this.clearMzRangeLowerTxt, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearMzRangeDividerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearMzRangeUpperTxt, -2, 77, -2))).addContainerGap(30, Short.MAX_VALUE)))))));
        spectrumProcessingPanelLayout.linkSize(0, this.clearMzRangeLowerTxt, this.clearMzRangeUpperTxt);
        spectrumProcessingPanelLayout.linkSize(0, this.minPeakIntensityTxt, this.minPeaksTxt, this.removePrecursorPeakCombo);
        spectrumProcessingPanelLayout.setVerticalGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPeaksLbl).addComponent(this.minPeaksTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPeakIntensityLbl).addComponent(this.minPeakIntensityTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removePrecursorPeakLabel).addComponent(this.removePrecursorPeakCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removePrecursorPeakToleranceLbl).addComponent(this.removePrecursorPeakToleranceTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearMzRangeLowerTxt, -2, -1, -2).addComponent(this.clearMzRangeUpperTxt, -2, -1, -2).addComponent(this.clearMzRangeDividerLabel).addComponent(this.clearMzRangeLabel)).addContainerGap(159, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Spectrum", this.spectrumProcessingPanel);
        this.searchSettingsPanel.setBackground(new Color(230, 230, 230));
        this.searchSettingsPanel.setPreferredSize(new Dimension(518, 143));
        this.enzymeTypeLabel.setText("Enzyme Type");
        this.enzymeTypeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Full-enzyme", "Semi-specific", "Unspecific peptide N-term", "Unspecific peptide C-term"}));
        this.isotopeCorrectionLabel.setText("Isotope Correction");
        this.isotopeCorrectionCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"No Correction", "-1, 0, +1, +2, and +3", "-8, -4, 0, +4 and +8"}));
        this.precursorMassLabel.setText("Precursor Mass (min - max)");
        this.minPrecursorMassTxt.setHorizontalAlignment(0);
        this.minPrecursorMassTxt.setText("0");
        this.minPrecursorMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.minPrecursorMassTxtKeyReleased(evt);
            }
        });
        this.precursorMassDividerLabel.setHorizontalAlignment(0);
        this.precursorMassDividerLabel.setText("-");
        this.maxPrecursorMassTxt.setHorizontalAlignment(0);
        this.maxPrecursorMassTxt.setText("10000");
        this.maxPrecursorMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.maxPrecursorMassTxtKeyReleased(evt);
            }
        });
        this.numberMatchesLabel.setText("Number of Spectrum Matches");
        this.numberMatchesTxt.setHorizontalAlignment(0);
        this.numberMatchesTxt.setText("10");
        this.numberMatchesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.numberMatchesTxtKeyReleased(evt);
            }
        });
        this.maxFragmentChargeLabel.setText("Max Fragment Charge");
        this.maxFragmentChargeTxt.setHorizontalAlignment(0);
        this.maxFragmentChargeTxt.setText("3");
        this.maxFragmentChargeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.maxFragmentChargeTxtKeyReleased(evt);
            }
        });
        this.removeMethionineLabel.setText("Remove Starting Methionine");
        this.removeMethionineCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.removeMethionineCmb.setSelectedIndex(1);
        this.batchSizeLabel.setText("Spectrum Batch Size");
        this.batchSizeTxt.setHorizontalAlignment(0);
        this.batchSizeTxt.setText("0");
        this.batchSizeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.batchSizeTxtKeyReleased(evt);
            }
        });
        this.maxPtmsLabel.setText("Max Variable PTMs per Peptide");
        this.maxPtmsTxt.setHorizontalAlignment(0);
        this.maxPtmsTxt.setText("10");
        this.maxPtmsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.maxPtmsTxtKeyReleased(evt);
            }
        });
        GroupLayout searchSettingsPanelLayout = new GroupLayout(this.searchSettingsPanel);
        this.searchSettingsPanel.setLayout(searchSettingsPanelLayout);
        searchSettingsPanelLayout.setHorizontalGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchSettingsPanelLayout.createSequentialGroup().addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(searchSettingsPanelLayout.createSequentialGroup().addComponent(this.precursorMassLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(searchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxFragmentChargeLabel, -2, 250, -2).addGap(4, 4, 4))).addGroup(GroupLayout.Alignment.TRAILING, searchSettingsPanelLayout.createSequentialGroup().addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.isotopeCorrectionLabel, GroupLayout.Alignment.TRAILING, -2, 250, -2).addComponent(this.enzymeTypeLabel, GroupLayout.Alignment.TRAILING, -2, 250, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(searchSettingsPanelLayout.createSequentialGroup().addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removeMethionineLabel, -1, -1, Short.MAX_VALUE).addComponent(this.batchSizeLabel, -2, 250, -2)).addComponent(this.maxPtmsLabel, -2, 250, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.enzymeTypeCmb, 0, 190, Short.MAX_VALUE).addComponent(this.isotopeCorrectionCmb, 0, -1, Short.MAX_VALUE).addComponent(this.numberMatchesTxt).addComponent(this.maxFragmentChargeTxt).addComponent(this.removeMethionineCmb, 0, -1, Short.MAX_VALUE).addComponent(this.batchSizeTxt).addComponent(this.maxPtmsTxt, -2, 189, -2).addGroup(searchSettingsPanelLayout.createSequentialGroup().addComponent(this.minPrecursorMassTxt, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.precursorMassDividerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPrecursorMassTxt))).addGap(137, 137, 137)).addGroup(searchSettingsPanelLayout.createSequentialGroup().addComponent(this.numberMatchesLabel, -2, 250, -2).addGap(223, 223, 223)))));
        searchSettingsPanelLayout.linkSize(0, this.batchSizeTxt, this.enzymeTypeCmb, this.isotopeCorrectionCmb, this.maxFragmentChargeTxt, this.maxPtmsTxt, this.numberMatchesTxt, this.removeMethionineCmb);
        searchSettingsPanelLayout.setVerticalGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enzymeTypeLabel).addComponent(this.enzymeTypeCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.isotopeCorrectionLabel).addComponent(this.isotopeCorrectionCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPrecursorMassTxt, -2, -1, -2).addComponent(this.maxPrecursorMassTxt, -2, -1, -2).addComponent(this.precursorMassDividerLabel).addComponent(this.precursorMassLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberMatchesLabel).addComponent(this.numberMatchesTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxFragmentChargeLabel).addComponent(this.maxFragmentChargeTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeMethionineLabel).addComponent(this.removeMethionineCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.batchSizeLabel).addComponent(this.batchSizeTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPtmsLabel).addComponent(this.maxPtmsTxt, -2, -1, -2)).addContainerGap(81, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Search", this.searchSettingsPanel);
        this.fragmentIonsPanel.setBackground(new Color(230, 230, 230));
        this.correlationScoreTypeLabel.setText("Correlation Score Type");
        this.correlationScoreTypeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Summed Intensities +  Flanking", "Summed Intensities"}));
        this.fragmentBinOffsetLabel.setText("Fragment Bin Offset");
        this.fragmentBinOffsetTxt.setHorizontalAlignment(0);
        this.fragmentBinOffsetTxt.setText("0.4");
        this.fragmentBinOffsetTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CometSettingsDialog.this.fragmentBinOffsetTxtKeyReleased(evt);
            }
        });
        this.useSparseMatrixLabel.setText("Use Sparse Matrix");
        this.useSparseMatrixCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.useSparseMatrixCmb.setSelectedIndex(1);
        GroupLayout fragmentIonsPanelLayout = new GroupLayout(this.fragmentIonsPanel);
        this.fragmentIonsPanel.setLayout(fragmentIonsPanelLayout);
        fragmentIonsPanelLayout.setHorizontalGroup(fragmentIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fragmentIonsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(fragmentIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fragmentIonsPanelLayout.createSequentialGroup().addComponent(this.fragmentBinOffsetLabel, -2, 250, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fragmentBinOffsetTxt, -2, 189, -2)).addGroup(GroupLayout.Alignment.TRAILING, fragmentIonsPanelLayout.createSequentialGroup().addComponent(this.correlationScoreTypeLabel, -2, 250, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.correlationScoreTypeCmb, -2, 189, -2)).addGroup(GroupLayout.Alignment.TRAILING, fragmentIonsPanelLayout.createSequentialGroup().addComponent(this.useSparseMatrixLabel, -2, 250, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.useSparseMatrixCmb, -2, 189, -2))).addGap(30, 30, 30)));
        fragmentIonsPanelLayout.setVerticalGroup(fragmentIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fragmentIonsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(fragmentIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.correlationScoreTypeLabel).addComponent(this.correlationScoreTypeCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fragmentIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragmentBinOffsetLabel).addComponent(this.fragmentBinOffsetTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(fragmentIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useSparseMatrixLabel).addComponent(this.useSparseMatrixCmb, -2, -1, -2)).addContainerGap(206, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Fragment Ions", this.fragmentIonsPanel);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addGap(10, 10, 10)).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -2, 503, -2).addContainerGap(-1, Short.MAX_VALUE)));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -2, 336, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://comet-ms.sourceforge.net");
        this.setCursor(new Cursor(0));
    }

    private void clearMzRangeLowerTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void clearMzRangeUpperTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void numberMatchesTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPtmsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPrecursorMassTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPrecursorMassTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void batchSizeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxFragmentChargeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void fragmentBinOffsetTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPeakIntensityTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void removePrecursorPeakToleranceTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    public boolean validateInput(boolean showMessage) {
        double highValue;
        double lowValue;
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.minPeaksLbl, this.minPeaksTxt, "minimum number of peaks", "Minimum Number of Peaks Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.minPeakIntensityLbl, this.minPeakIntensityTxt, "minimum peak intensity", "Minimim Peak Intensity Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.removePrecursorPeakLabel, this.removePrecursorPeakToleranceTxt, "remove precursor peak tolerance", "Precursor Peak Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.clearMzRangeLabel, this.clearMzRangeLowerTxt, "lower clear mz range", "Clear MZ Range Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.clearMzRangeLabel, this.clearMzRangeUpperTxt, "upper clear mz range", "Clear MZ Range Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.precursorMassLabel, this.minPrecursorMassTxt, "minimum precursor mass", "Precursor Mass Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.precursorMassLabel, this.maxPrecursorMassTxt, "maximum precursor mass", "Precursor Mass Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numberMatchesLabel, this.numberMatchesTxt, "number of spectrum matches", "Number of Spectrum Matches Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxFragmentChargeLabel, this.maxFragmentChargeTxt, "maximum fragment charge", "Maximum Fragment Charge Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.batchSizeLabel, this.batchSizeTxt, "batch size", "Batch Size Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxPtmsLabel, this.maxPtmsTxt, "maximum number of variable PTMs", "Variable PTMs Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.fragmentBinOffsetLabel, this.fragmentBinOffsetTxt, "fragment bin offset", "Fragment Bin Offset Error", true, showMessage, valid);
        try {
            lowValue = Double.parseDouble(this.clearMzRangeLowerTxt.getText().trim());
            highValue = Double.parseDouble(this.clearMzRangeUpperTxt.getText().trim());
            if (lowValue > highValue) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The lower range value has to be smaller than the upper range value.", "Clear MZ Range Error", 2);
                }
                valid = false;
                this.clearMzRangeLabel.setForeground(Color.RED);
                this.clearMzRangeLabel.setToolTipText("Please select a valid range (upper <= higher)");
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            lowValue = Double.parseDouble(this.minPrecursorMassTxt.getText().trim());
            highValue = Double.parseDouble(this.maxPrecursorMassTxt.getText().trim());
            if (lowValue > highValue) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The lower range value has to be smaller than the upper range value.", "Precursor Mass Range Error", 2);
                }
                valid = false;
                this.precursorMassLabel.setForeground(Color.RED);
                this.precursorMassLabel.setToolTipText("Please select a valid range (upper <= higher)");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.okButton.setEnabled(valid);
        return valid;
    }
}

