/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export;

public enum ExportFormat {
    text(0, "Text", "txt", "Tab separated text format"),
    excel(1, "Excel", "xls", "Microsoft Excel format");

    public final int index;
    public final String name;
    public final String extention;
    public final String description;
    public static final ExportFormat commandLineDefaultOption;
    public static final ExportFormat guiDefaultOption;

    private ExportFormat(int index, String name, String extention, String description) {
        this.index = index;
        this.name = name;
        this.extention = extention;
        this.description = description;
    }

    public static String getCommandLineOption() {
        StringBuilder options = new StringBuilder();
        for (ExportFormat exportFormat : ExportFormat.values()) {
            if (options.length() == 0) {
                options.append("The format to use for the export: ");
            } else {
                options.append(", ");
            }
            options.append(exportFormat.extention).append(": ").append(exportFormat.description);
            if (exportFormat != commandLineDefaultOption) continue;
            options.append(" (default)");
        }
        return options.toString();
    }

    public static ExportFormat getFormatFromCommandLineOption(String commandLineOption) {
        for (ExportFormat exportFormat : ExportFormat.values()) {
            if (!commandLineOption.equals(exportFormat.extention)) continue;
            return exportFormat;
        }
        return null;
    }

    static {
        commandLineDefaultOption = text;
        guiDefaultOption = excel;
    }
}

