/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.matrix;

import java.util.ArrayList;

public class DoubleMatrix {
    private int nLines = 0;
    private ArrayList<ArrayList<Double>> content;

    public DoubleMatrix() {
        this.content = new ArrayList();
    }

    public DoubleMatrix(int nColumns) {
        this.content = new ArrayList(nColumns);
    }

    public DoubleMatrix(DoubleMatrix matrix) {
        this.nLines = matrix.getNLines();
        for (ArrayList<Double> column : matrix.getColumns()) {
            ArrayList<Double> newColumn = new ArrayList<Double>(column);
            this.content.add(newColumn);
        }
    }

    public void addColumn(ArrayList<Double> column) {
        if (column == null) {
            throw new IllegalArgumentException("Attempting to add null column to matrix.");
        }
        int columnsize = column.size();
        if (columnsize == 0) {
            throw new IllegalArgumentException("Attempting to add empty column to matrix");
        }
        if (this.nLines == 0) {
            this.nLines = columnsize;
        } else if (columnsize != this.nLines) {
            throw new IllegalArgumentException("Impossible to add column of length " + column.size() + " in matrix of length " + this.nLines + ".");
        }
        this.content.add(column);
    }

    public void addLine(ArrayList<Double> line) {
        if (line == null) {
            throw new IllegalArgumentException("Attempting to add null line to matrix.");
        }
        int lineSize = line.size();
        if (lineSize != this.getNColumns()) {
            throw new IllegalArgumentException("Impossible to add line of length " + lineSize + " in matrix of width " + this.getNColumns() + ".");
        }
        for (int i = 0; i < this.getNColumns(); ++i) {
            ArrayList<Double> column = this.content.get(i);
            column.add(line.get(i));
        }
        ++this.nLines;
    }

    public void setLine(int lineIndex, ArrayList<Double> line) {
        if (line == null) {
            throw new IllegalArgumentException("Attempting to add null line to matrix.");
        }
        int lineSize = line.size();
        if (lineSize != this.getNColumns()) {
            throw new IllegalArgumentException("Impossible to add line of length " + lineSize + " in matrix of width " + this.getNColumns() + ".");
        }
        if (lineIndex >= this.nLines) {
            throw new IllegalArgumentException("Impossible to add line at index " + lineIndex + " in matrix of length " + this.nLines + ".");
        }
        for (int i = 0; i < this.getNColumns(); ++i) {
            ArrayList<Double> column = this.content.get(i);
            column.set(lineIndex, line.get(i));
        }
    }

    public void setColumn(int columnIndex, ArrayList<Double> column) {
        if (column == null) {
            throw new IllegalArgumentException("Attempting to add null column to matrix.");
        }
        int columnSize = column.size();
        if (columnSize != this.getNLines()) {
            throw new IllegalArgumentException("Impossible to add line of length " + columnSize + " in matrix of width " + this.getNLines() + ".");
        }
        if (columnIndex >= this.getNColumns()) {
            throw new IllegalArgumentException("Impossible to add line at index " + columnIndex + " in matrix of length " + this.getNColumns() + ".");
        }
        this.content.set(columnIndex, column);
    }

    public int getNColumns() {
        return this.content.size();
    }

    public int getNLines() {
        return this.nLines;
    }

    public boolean isSquare() {
        return this.getNLines() == this.getNColumns();
    }

    public ArrayList<Double> getColumn(int columnIndex) {
        return this.content.get(columnIndex);
    }

    public ArrayList<ArrayList<Double>> getColumns() {
        return new ArrayList<ArrayList<Double>>(this.content);
    }

    public ArrayList<ArrayList<Double>> getLines() {
        ArrayList<ArrayList<Double>> lines = new ArrayList<ArrayList<Double>>(this.nLines);
        for (int i = 0; i < this.nLines; ++i) {
            lines.add(this.getLine(i));
        }
        return lines;
    }

    public ArrayList<Double> getLine(int lineIndex) {
        if (lineIndex < 0 || lineIndex >= this.nLines) {
            throw new IllegalArgumentException("Invalid index " + lineIndex + " for matrix of size " + this.nLines + ".");
        }
        ArrayList<Double> result = new ArrayList<Double>(this.nLines);
        for (ArrayList<Double> column : this.content) {
            result.add(column.get(lineIndex));
        }
        return result;
    }

    public Double getValueAt(int lineIndex, int columnIndex) {
        return this.content.get(columnIndex).get(lineIndex);
    }

    public void setValueAt(int lineIndex, int columnIndex, Double value) {
        if (columnIndex >= this.content.size()) {
            throw new IllegalArgumentException("Column index " + columnIndex + " larger than matrix capacity " + this.content.size() + ".");
        }
        if (lineIndex >= this.nLines) {
            throw new IllegalArgumentException("Line index " + columnIndex + " larger than matrix capacity " + this.nLines + ".");
        }
        this.content.get(columnIndex).set(lineIndex, value);
    }

    public static DoubleMatrix transpose(DoubleMatrix matrix) {
        int nLines = matrix.getNLines();
        DoubleMatrix transposedMatrix = new DoubleMatrix(nLines);
        for (int i = 0; i < nLines; ++i) {
            transposedMatrix.addColumn(matrix.getLine(i));
        }
        return transposedMatrix;
    }

    public boolean equals(DoubleMatrix anotherMatrix) {
        if (anotherMatrix.getNColumns() != this.getNColumns() || anotherMatrix.getNLines() != this.getNLines()) {
            return false;
        }
        for (int i = 0; i < this.getNLines(); ++i) {
            for (int j = 0; j < this.getNColumns(); ++j) {
                if (this.getValueAt(i, j).equals(anotherMatrix.getValueAt(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public static DoubleMatrix getIdentityMatrix(int n) {
        DoubleMatrix identityMatrix = new DoubleMatrix(n);
        for (int i = 0; i < n; ++i) {
            ArrayList<Double> column = new ArrayList<Double>(n);
            for (int j = 0; j < n; ++j) {
                if (i == j) {
                    column.add(1.0);
                    continue;
                }
                column.add(0.0);
            }
            identityMatrix.addColumn(column);
        }
        return identityMatrix;
    }

    public double getTrace() {
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Attempting to estimate the trace on a non-square matrix (" + this.getNLines() + " lines, " + this.getNColumns() + " columns).");
        }
        double result = 0.0;
        for (int i = 0; i < this.nLines; ++i) {
            result += this.getValueAt(i, i).doubleValue();
        }
        return result;
    }

    public DoubleMatrix getSubMatrix(int lineStart, int lineStop, int columnStart, int columnStop) {
        if (lineStop < lineStart) {
            throw new IllegalArgumentException("End line index smaller than start index.");
        }
        if (columnStop < columnStart) {
            throw new IllegalArgumentException("End column index smaller than start index.");
        }
        if (columnStop + 1 == columnStart) {
            return new DoubleMatrix();
        }
        DoubleMatrix subMatrix = new DoubleMatrix(columnStop + 1 - columnStart);
        for (int i = columnStart; i <= columnStop; ++i) {
            ArrayList<Double> column = this.getColumn(i);
            ArrayList<Double> subColumn = new ArrayList<Double>(column.subList(lineStart, lineStop + 1));
            subMatrix.addColumn(subColumn);
        }
        return subMatrix;
    }

    public void appendColumns(DoubleMatrix columns) {
        if (columns.getNLines() != this.getNLines()) {
            throw new IllegalArgumentException("Attempting to appennd columns with different number of lines.");
        }
        for (ArrayList<Double> column : columns.getColumns()) {
            ArrayList<Double> newColumn = new ArrayList<Double>(column);
            this.addColumn(newColumn);
        }
    }

    public void appendLines(DoubleMatrix lines) {
        if (lines.getNColumns() != this.getNColumns()) {
            throw new IllegalArgumentException("Attempting to appennd lines with different number of columns.");
        }
        for (ArrayList<Double> line : lines.getLines()) {
            ArrayList<Double> newLine = new ArrayList<Double>(line);
            this.addLine(newLine);
        }
    }

    public double getDeterminant() {
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Attempting to estimate the determinant on a non-square matrix (" + this.getNLines() + " lines, " + this.getNColumns() + " columns).");
        }
        if (this.nLines == 0) {
            throw new IllegalArgumentException("Attempting to estimate the determinant on an empty matrix.");
        }
        if (this.nLines == 1) {
            return this.getValueAt(0, 0);
        }
        if (this.nLines == 2) {
            return this.getValueAt(0, 0) * this.getValueAt(1, 1) - this.getValueAt(0, 1) * this.getValueAt(1, 0);
        }
        double determinant = 0.0;
        for (int i = 0; i < this.getNLines(); ++i) {
            DoubleMatrix subMatrix;
            int line = i + 1;
            System.out.println(line + " in " + this.nLines);
            if (i == this.nLines - 1) {
                subMatrix = this.getSubMatrix(0, this.nLines - 2, 1, this.nLines - 1);
            } else {
                subMatrix = this.getSubMatrix(i + 1, this.nLines - 1, 1, this.nLines - 1);
                if (i > 0) {
                    DoubleMatrix topMatrix = this.getSubMatrix(0, i - 1, 1, this.nLines - 1);
                    subMatrix.appendLines(topMatrix);
                }
            }
            determinant += Math.pow(-1.0, i) * this.getValueAt(i, 0) * subMatrix.getDeterminant();
        }
        return determinant;
    }

    public double getNonDiagonalScore() {
        if (!this.isSquare()) {
            throw new IllegalArgumentException("The non diagonal score can only be computed on square matrices (" + this.getNLines() + " lines, " + this.getNColumns() + " columns).");
        }
        if (this.nLines < 2) {
            return 0.0;
        }
        double score = 0.0;
        for (int i = 0; i < this.nLines; ++i) {
            for (int j = 0; j < this.nLines; ++j) {
                if (i == j) continue;
                int distance = Math.abs(i - j);
                int nValues = this.nLines - distance;
                score += this.getValueAt(i, j) / (double)nValues;
            }
        }
        return score / (double)this.nLines;
    }

    public void linePermutation(int line1, int line2) {
        ArrayList<Double> tempLine = this.getLine(line2);
        this.setLine(line2, this.getLine(line1));
        this.setLine(line1, tempLine);
    }

    public void columnPermutation(int column1, int column2) {
        ArrayList<Double> tempColumn = this.getColumn(column2);
        this.setColumn(column2, this.getColumn(column1));
        this.setColumn(column1, tempColumn);
    }
}

