/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.SpectrumAnnotator;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class AnnotationPreferences
implements Serializable {
    static final long serialVersionUID = -524156803097913546L;
    private boolean yAxisZoomExcludesBackgroundPeaks = true;
    private boolean intensityIonTable = true;
    private boolean showBars = false;
    private boolean showAllPeaks = false;
    private double intensityLimit = 0.75;
    private boolean automaticAnnotation = true;
    private HashMap<Ion.IonType, ArrayList<Integer>> selectedIons = new HashMap();
    private HashMap<Ion.IonType, HashSet<Integer>> selectedIonsMap = new HashMap();
    private NeutralLossesMap neutralLossesMap = new NeutralLossesMap();
    private boolean neutralLossesSequenceDependant = true;
    private ArrayList<Integer> selectedCharges = new ArrayList();
    private double fragmentIonAccuracy;
    private Peptide currentPeptide;
    private SpectrumIdentificationAssumption spectrumIdentificationAssumption;
    private int currentPrecursorCharge = 0;
    private boolean showForwardIonDeNovoTags = false;
    private boolean showRewindIonDeNovoTags = false;
    private int deNovoCharge = 1;
    private Boolean highResolutionAnnotation = true;

    public void setPreferencesFromSearchParameters(SearchParameters searchParameters) {
        this.clearIonTypes();
        this.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, searchParameters.getIonSearched1());
        this.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, searchParameters.getIonSearched2());
        this.addIonType(Ion.IonType.TAG_FRAGMENT_ION, searchParameters.getIonSearched1());
        this.addIonType(Ion.IonType.TAG_FRAGMENT_ION, searchParameters.getIonSearched2());
        this.addIonType(Ion.IonType.PRECURSOR_ION);
        this.addIonType(Ion.IonType.IMMONIUM_ION);
        this.addIonType(Ion.IonType.REPORTER_ION);
        this.setFragmentIonAccuracy(searchParameters.getFragmentIonAccuracy());
    }

    public void setCurrentSettings(SpectrumIdentificationAssumption spectrumIdentificationAssumption, boolean newSpectrum, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        this.spectrumIdentificationAssumption = spectrumIdentificationAssumption;
        if (newSpectrum && this.automaticAnnotation) {
            this.resetAutomaticAnnotation(sequenceMatchingPreferences);
        } else if (this.neutralLossesSequenceDependant) {
            this.neutralLossesMap = SpectrumAnnotator.getDefaultLosses(spectrumIdentificationAssumption, sequenceMatchingPreferences);
        }
    }

    public void resetAutomaticAnnotation(SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        this.selectedCharges.clear();
        int precusorCharge = this.spectrumIdentificationAssumption.getIdentificationCharge().value;
        if (precusorCharge == 1) {
            this.selectedCharges.add(precusorCharge);
        } else {
            for (int charge = 1; charge < precusorCharge; ++charge) {
                this.selectedCharges.add(charge);
            }
        }
        this.neutralLossesMap = SpectrumAnnotator.getDefaultLosses(this.spectrumIdentificationAssumption, sequenceMatchingPreferences);
    }

    public boolean areNeutralLossesSequenceDependant() {
        return this.neutralLossesSequenceDependant;
    }

    public void setNeutralLossesSequenceDependant(boolean neutralLossesSequenceDependant) {
        this.neutralLossesSequenceDependant = neutralLossesSequenceDependant;
    }

    public ArrayList<Integer> getValidatedCharges() {
        return this.selectedCharges;
    }

    public void clearCharges() {
        this.selectedCharges.clear();
    }

    public void addSelectedCharge(int selectedCharge) {
        if (!this.selectedCharges.contains(selectedCharge)) {
            this.selectedCharges.add(selectedCharge);
        }
    }

    public void clearNeutralLosses() {
        this.neutralLossesMap.clearNeutralLosses();
    }

    public NeutralLossesMap getNeutralLosses() {
        return this.neutralLossesMap;
    }

    public void addNeutralLoss(NeutralLoss neutralLoss) {
        this.neutralLossesMap.addNeutralLoss(neutralLoss, 1, 1);
    }

    public HashMap<Ion.IonType, HashSet<Integer>> getIonTypes() {
        if (this.selectedIonsMap == null && this.selectedIons != null) {
            this.backwardsCompatibilitySelectedIonsFix();
        }
        return this.selectedIonsMap;
    }

    private void backwardsCompatibilitySelectedIonsFix() {
        this.selectedIonsMap = new HashMap();
        for (Ion.IonType tempIonType : this.selectedIons.keySet()) {
            ArrayList<Integer> tempIntegers = this.selectedIons.get((Object)tempIonType);
            HashSet<Integer> tempSet = new HashSet<Integer>();
            for (Integer temp : tempIntegers) {
                tempSet.add(temp);
            }
            this.selectedIonsMap.put(tempIonType, tempSet);
        }
    }

    public HashSet<Integer> getFragmentIonTypes() {
        if (this.selectedIonsMap == null && this.selectedIons != null) {
            this.backwardsCompatibilitySelectedIonsFix();
        }
        if (this.selectedIonsMap.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) == null) {
            return new HashSet<Integer>();
        }
        return this.selectedIonsMap.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION);
    }

    public void clearIonTypes() {
        this.selectedIonsMap.clear();
    }

    public void addIonType(Ion.IonType ionType, int subType) {
        if (this.selectedIonsMap == null && this.selectedIons != null) {
            this.backwardsCompatibilitySelectedIonsFix();
        }
        if (!this.selectedIonsMap.containsKey((Object)ionType)) {
            this.selectedIonsMap.put(ionType, new HashSet());
        }
        this.selectedIonsMap.get((Object)ionType).add(subType);
    }

    public void addIonType(Ion.IonType ionType) {
        if (this.selectedIonsMap == null && this.selectedIons != null) {
            this.backwardsCompatibilitySelectedIonsFix();
        }
        if (!this.selectedIonsMap.containsKey((Object)ionType)) {
            this.selectedIonsMap.put(ionType, new HashSet());
        }
        for (int subType : Ion.getPossibleSubtypes(ionType)) {
            this.selectedIonsMap.get((Object)ionType).add(subType);
        }
    }

    public void useAutomaticAnnotation(boolean automaticAnnotation) {
        this.automaticAnnotation = automaticAnnotation;
        if (automaticAnnotation) {
            this.neutralLossesSequenceDependant = true;
        }
    }

    public boolean useAutomaticAnnotation() {
        return this.automaticAnnotation;
    }

    public double getFragmentIonAccuracy() {
        return this.fragmentIonAccuracy;
    }

    public void setFragmentIonAccuracy(double fragmentIonAccuracy) {
        this.fragmentIonAccuracy = fragmentIonAccuracy;
    }

    public int getCurrentPrecursorCharge() {
        return this.spectrumIdentificationAssumption.getIdentificationCharge().value;
    }

    public double getAnnotationIntensityLimit() {
        return this.intensityLimit;
    }

    public void setAnnotationLevel(double intensityLimit) {
        this.intensityLimit = intensityLimit;
    }

    public boolean showAllPeaks() {
        return this.showAllPeaks;
    }

    public void setShowAllPeaks(boolean showAllPeaks) {
        this.showAllPeaks = showAllPeaks;
    }

    public boolean showBars() {
        return this.showBars;
    }

    public void setShowBars(boolean showBars) {
        this.showBars = showBars;
    }

    public boolean useIntensityIonTable() {
        return this.intensityIonTable;
    }

    public void setIntensityIonTable(boolean intensityIonTable) {
        this.intensityIonTable = intensityIonTable;
    }

    public boolean yAxisZoomExcludesBackgroundPeaks() {
        return this.yAxisZoomExcludesBackgroundPeaks;
    }

    public void setYAxisZoomExcludesBackgroundPeaks(boolean yAxisZoomExcludesBackgroundPeaks) {
        this.yAxisZoomExcludesBackgroundPeaks = yAxisZoomExcludesBackgroundPeaks;
    }

    public boolean showForwardIonDeNovoTags() {
        return this.showForwardIonDeNovoTags;
    }

    public void setShowForwardIonDeNovoTags(boolean showForwardIonDeNovoTags) {
        this.showForwardIonDeNovoTags = showForwardIonDeNovoTags;
    }

    public boolean showRewindIonDeNovoTags() {
        return this.showRewindIonDeNovoTags;
    }

    public void setShowRewindIonDeNovoTags(boolean showRewindIonDeNovoTags) {
        this.showRewindIonDeNovoTags = showRewindIonDeNovoTags;
    }

    public int getDeNovoCharge() {
        return this.deNovoCharge;
    }

    public void setDeNovoCharge(int deNovoCharge) {
        this.deNovoCharge = deNovoCharge;
    }

    public boolean isHighResolutionAnnotation() {
        if (this.highResolutionAnnotation == null) {
            this.highResolutionAnnotation = true;
        }
        return this.highResolutionAnnotation;
    }

    public void setHighResolutionAnnotation(boolean highResolutionAnnotation) {
        this.highResolutionAnnotation = highResolutionAnnotation;
    }
}

