/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein;

import com.compomics.util.experiment.identification.SequenceFactory;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Header
implements Cloneable,
Serializable {
    static final long serialVersionUID = 7665784733371863163L;
    static Logger logger = Logger.getLogger(Header.class);
    private String iID = null;
    private String iForeignID = null;
    private String iAccession = null;
    private DatabaseType databaseType = DatabaseType.Unknown;
    private String iForeignAccession = null;
    private String iDescription = null;
    private String iDescriptionShort = null;
    private String iDescriptionProteinName = null;
    private String iGeneName = null;
    private String iProteinEvidence = null;
    private String iTaxonomy = null;
    private String iForeignDescription = null;
    private String iRest = null;
    private StringBuffer iAddenda = null;
    private int iStart = -1;
    private int iEnd = -1;

    private Header() {
    }

    public static Header parseFromFASTA(String aFASTAHeader) throws StringIndexOutOfBoundsException {
        Header result;
        block98: {
            result = null;
            if (aFASTAHeader != null) {
                if (aFASTAHeader.trim().equals("")) {
                    result = new Header();
                    result.iRest = "";
                } else {
                    int liPos;
                    result = new Header();
                    if (aFASTAHeader.startsWith(">")) {
                        aFASTAHeader = aFASTAHeader.substring(1);
                    }
                    if ((liPos = aFASTAHeader.indexOf("^A")) >= 0) {
                        result.iAddenda = new StringBuffer(aFASTAHeader.substring(liPos));
                        aFASTAHeader = aFASTAHeader.substring(0, liPos);
                    }
                    try {
                        if (aFASTAHeader.startsWith("sw|") || aFASTAHeader.startsWith("SW|")) {
                            StringTokenizer lSt = new StringTokenizer(aFASTAHeader, "|");
                            if (lSt.countTokens() < 3) {
                                throw new IllegalArgumentException("Non-standard or false SwissProt header passed. Expecting something like: '>sw|Pxxxx|ACTB_HUMAN xxxx xxx xxxx ...', received '" + aFASTAHeader + "'.");
                            }
                            result.databaseType = DatabaseType.UniProt;
                            result.iID = lSt.nextToken();
                            result.iAccession = lSt.nextToken();
                            int index = result.iAccession.indexOf(" (");
                            if (index > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            result.iDescription = lSt.nextToken();
                            Header.parseUniProtDescription(result);
                            if (lSt.hasMoreTokens()) {
                                StringBuilder lBuffer = new StringBuilder();
                                while (lSt.hasMoreTokens()) {
                                    lBuffer.append(lSt.nextToken());
                                }
                                result.iRest = lBuffer.toString();
                            }
                            break block98;
                        }
                        if (aFASTAHeader.startsWith("gi|") || aFASTAHeader.startsWith("GI|")) {
                            StringTokenizer lSt = new StringTokenizer(aFASTAHeader, "|");
                            int tokenCount = lSt.countTokens();
                            if (tokenCount == 3) {
                                result.databaseType = DatabaseType.NCBI;
                                result.iID = lSt.nextToken();
                                result.iAccession = lSt.nextToken();
                                int index = result.iAccession.indexOf(" (");
                                if (index > 0) {
                                    String temp = result.iAccession.substring(index);
                                    result.iAccession = result.iAccession.substring(0, index);
                                    int open = 2;
                                    int minus = temp.indexOf("-");
                                    int end = temp.indexOf(")");
                                    result.iStart = Integer.parseInt(temp.substring(open, minus));
                                    result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                                }
                                result.iDescription = lSt.nextToken().trim();
                            } else {
                                if (tokenCount < 4) {
                                    throw new IllegalArgumentException("Non-standard or false NCBInr header passed. Expecting something like: '>gi|xxxxx|xx|xxxxx|(x) xxxx xxx xxxx ...', received '" + aFASTAHeader + "'.");
                                }
                                result.databaseType = DatabaseType.NCBI;
                                result.iID = lSt.nextToken();
                                result.iAccession = lSt.nextToken();
                                int index = result.iAccession.indexOf(" (");
                                if (index > 0) {
                                    String temp = result.iAccession.substring(index);
                                    result.iAccession = result.iAccession.substring(0, index);
                                    int open = 2;
                                    int minus = temp.indexOf("-");
                                    int end = temp.indexOf(")");
                                    result.iStart = Integer.parseInt(temp.substring(open, minus));
                                    result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                                }
                                result.iForeignID = lSt.nextToken();
                                if (tokenCount >= 5) {
                                    result.iForeignAccession = lSt.nextToken();
                                }
                                StringBuilder lSB = new StringBuilder();
                                while (lSt.hasMoreTokens()) {
                                    lSB.append(lSt.nextToken());
                                }
                                String temp = lSB.toString();
                                if (temp.startsWith(" ")) {
                                    result.iDescription = temp.substring(1);
                                } else {
                                    int location = temp.indexOf(" ");
                                    result.iForeignDescription = temp.substring(0, location);
                                    result.iDescription = temp.substring(location + 1);
                                }
                            }
                            break block98;
                        }
                        if (aFASTAHeader.startsWith("IPI:") || aFASTAHeader.startsWith("ipi:") || aFASTAHeader.startsWith("IPI|") || aFASTAHeader.startsWith("ipi|")) {
                            result.databaseType = DatabaseType.IPI;
                            result.iID = "IPI";
                            result.iAccession = aFASTAHeader.substring(4, aFASTAHeader.indexOf("|", 4));
                            int index = result.iAccession.indexOf(" (");
                            if (index > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            result.iDescription = aFASTAHeader.substring(aFASTAHeader.indexOf("|", 5) + 1);
                            break block98;
                        }
                        if (aFASTAHeader.startsWith("HIT")) {
                            try {
                                result.databaseType = DatabaseType.H_Invitation;
                                result.iID = "";
                                result.iAccession = aFASTAHeader.substring(0, aFASTAHeader.indexOf("|"));
                                int index = result.iAccession.indexOf(" (");
                                if (index > 0) {
                                    String temp = result.iAccession.substring(index);
                                    result.iAccession = result.iAccession.substring(0, index);
                                    int open = 2;
                                    int minus = temp.indexOf("-");
                                    int end = temp.indexOf(")");
                                    result.iStart = Integer.parseInt(temp.substring(open, minus));
                                    result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                                }
                                result.iDescription = aFASTAHeader.substring(aFASTAHeader.indexOf("|") + 1);
                            }
                            catch (Exception excep) {
                                logger.error((Object)excep.getMessage(), (Throwable)excep);
                                logger.info((Object)aFASTAHeader);
                            }
                            break block98;
                        }
                        if (aFASTAHeader.startsWith("OE")) {
                            int accessionEndLoc = aFASTAHeader.indexOf(" ");
                            if (accessionEndLoc < 0 || aFASTAHeader.length() < accessionEndLoc + 4) {
                                throw new IllegalArgumentException("Non-standard Halobacterium (Max Planck) header passed. Expecting something like '>OExyz (OExyz) xxx xxx xxx', but was '" + aFASTAHeader + "'!");
                            }
                            if (aFASTAHeader.charAt(accessionEndLoc + 1) == '(' && Character.isDigit(aFASTAHeader.charAt(accessionEndLoc + 2))) {
                                accessionEndLoc = aFASTAHeader.indexOf(")", accessionEndLoc) + 1;
                            }
                            result.databaseType = DatabaseType.Halobacterium;
                            result.iID = "";
                            result.iAccession = aFASTAHeader.substring(0, accessionEndLoc).trim();
                            int index = result.iAccession.indexOf(" (");
                            if (index > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            result.iDescription = aFASTAHeader.substring(accessionEndLoc).trim();
                            break block98;
                        }
                        if (aFASTAHeader.startsWith("hflu_")) {
                            int accessionEndLoc = aFASTAHeader.indexOf(" ");
                            if (accessionEndLoc < 0) {
                                throw new IllegalArgumentException("Non-standard H Influenza (Novartis) header passed. Expecting something like '>hflu_lsi_xxxx xxx xxx xxx', but was '" + aFASTAHeader + "'!");
                            }
                            if (aFASTAHeader.charAt(accessionEndLoc + 1) == '(' && Character.isDigit(aFASTAHeader.charAt(accessionEndLoc + 2))) {
                                accessionEndLoc = aFASTAHeader.indexOf(")", accessionEndLoc) + 1;
                            }
                            result.databaseType = DatabaseType.H_Influenza;
                            result.iID = "";
                            result.iAccession = aFASTAHeader.substring(0, accessionEndLoc).trim();
                            int index = result.iAccession.indexOf(" (");
                            if (index > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            result.iDescription = aFASTAHeader.substring(accessionEndLoc).trim();
                            break block98;
                        }
                        if (aFASTAHeader.startsWith("C.tr_") || aFASTAHeader.startsWith("C_trachomatis_")) {
                            int accessionEndLoc = aFASTAHeader.indexOf(" ");
                            if (accessionEndLoc < 0) {
                                throw new IllegalArgumentException("Non-standard C trachomatis header passed. Expecting something like '>C_tr_Lx_x [xxx - xxx] | xxx xxx ', but was '" + aFASTAHeader + "'!");
                            }
                            if (aFASTAHeader.charAt(accessionEndLoc + 1) == '(' && Character.isDigit(aFASTAHeader.charAt(accessionEndLoc + 2))) {
                                accessionEndLoc = aFASTAHeader.indexOf(")", accessionEndLoc) + 1;
                            }
                            result.databaseType = DatabaseType.C_Trachomatis;
                            result.iID = "";
                            result.iAccession = aFASTAHeader.substring(0, accessionEndLoc).trim();
                            int index = result.iAccession.indexOf(" (");
                            if (index > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            result.iDescription = aFASTAHeader.substring(accessionEndLoc).trim();
                            break block98;
                        }
                        if (aFASTAHeader.startsWith(" M. tub.")) {
                            int accessionStartLoc = aFASTAHeader.indexOf("|") + 1;
                            int accessionEndLoc = aFASTAHeader.indexOf("|", accessionStartLoc);
                            if (accessionEndLoc < 0) {
                                throw new IllegalArgumentException("Non-standard M tuberculosis header passed. Expecting something like '>M. tub.xxx|Rvxxx| xxx xxx', but was '" + aFASTAHeader + "'!");
                            }
                            result.databaseType = DatabaseType.M_Tuberculosis;
                            result.iID = aFASTAHeader.substring(0, accessionStartLoc - 1);
                            result.iAccession = aFASTAHeader.substring(accessionStartLoc, accessionEndLoc).trim();
                            int index = result.iAccession.indexOf(" (");
                            if (index > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            result.iDescription = aFASTAHeader.substring(accessionEndLoc + 1).trim();
                            break block98;
                        }
                        if (aFASTAHeader.matches("^CG.* pep:.*")) {
                            int index;
                            int pepLoc = aFASTAHeader.indexOf(" pep:");
                            result.databaseType = DatabaseType.Drosophile;
                            result.iID = "";
                            result.iAccession = aFASTAHeader.substring(0, pepLoc).trim();
                            String possibleDescriptionPrefix = "";
                            if (result.iAccession.indexOf("(*") > 0) {
                                possibleDescriptionPrefix = result.iAccession.substring(result.iAccession.indexOf("(*"), result.iAccession.indexOf("*)") + 2) + " ";
                                result.iAccession = result.iAccession.substring(0, result.iAccession.indexOf("(*"));
                            }
                            if ((index = result.iAccession.indexOf(" (")) > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            result.iDescription = possibleDescriptionPrefix + aFASTAHeader.substring(pepLoc).trim();
                            break block98;
                        }
                        if (aFASTAHeader.matches(".*SGDID:[^\\s]+,.*")) {
                            int accessionEndLoc = aFASTAHeader.indexOf(" ");
                            if (accessionEndLoc < 0) {
                                throw new IllegalArgumentException("Non-standard SGD header passed. Expecting something like '>xxxx xxx SGDID:xxxx xxx', but was '" + aFASTAHeader + "'!");
                            }
                            if (aFASTAHeader.charAt(accessionEndLoc + 1) == '(' && Character.isDigit(aFASTAHeader.charAt(accessionEndLoc + 2))) {
                                accessionEndLoc = aFASTAHeader.indexOf(")", accessionEndLoc) + 1;
                            }
                            result.databaseType = DatabaseType.SGD;
                            result.iID = "";
                            result.iAccession = aFASTAHeader.substring(0, accessionEndLoc).trim();
                            int index = result.iAccession.indexOf(" (");
                            if (index > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            result.iDescription = aFASTAHeader.substring(accessionEndLoc).trim();
                            break block98;
                        }
                        if (aFASTAHeader.startsWith("generic")) {
                            result.databaseType = DatabaseType.Generic_Split_Header;
                            result.iID = aFASTAHeader.substring(0, aFASTAHeader.indexOf("|"));
                            String subHeader = aFASTAHeader.substring(aFASTAHeader.indexOf("|") + 1);
                            if (subHeader.indexOf("|") != -1) {
                                result.iAccession = subHeader.substring(0, subHeader.indexOf("|"));
                                result.iDescription = subHeader.substring(subHeader.indexOf("|") + 1).trim();
                            } else {
                                result.iAccession = subHeader;
                                result.iDescription = "";
                            }
                            break block98;
                        }
                        if (aFASTAHeader.matches("^[^\\s]+_[^\\s]+ \\([PQOA][^\\s]+\\) .*") && aFASTAHeader.lastIndexOf("|") == -1) {
                            int start = aFASTAHeader.indexOf(" (");
                            int end = aFASTAHeader.indexOf(") ");
                            result.iAccession = aFASTAHeader.substring(start + 2, end);
                            result.databaseType = DatabaseType.UniProt;
                            result.iID = "sw";
                            result.iDescription = aFASTAHeader.substring(0, start) + " " + aFASTAHeader.substring(end + 2);
                            break block98;
                        }
                        if (aFASTAHeader.matches("^sp\\|[^|]*\\|[^\\s]+_[^\\s]+ .*")) {
                            String tempHeader = aFASTAHeader.substring(3);
                            result.iAccession = tempHeader.substring(0, tempHeader.indexOf("|")).trim();
                            if (result.iAccession.matches("[^\\(]+\\([\\d]+ [\\d]\\)$")) {
                                int openBracket = result.iAccession.indexOf("(");
                                result.iStart = Integer.parseInt(result.iAccession.substring(openBracket, result.iAccession.indexOf(" ", openBracket)).trim());
                                result.iEnd = Integer.parseInt(result.iAccession.substring(result.iAccession.indexOf(" ", openBracket), result.iAccession.indexOf(")")).trim());
                                result.iAccession = result.iAccession.substring(0, openBracket).trim();
                            } else if (result.iAccession.matches("[^\\(]+\\([\\d]+-[\\d]+\\)$")) {
                                int openBracket = result.iAccession.indexOf("(");
                                result.iStart = Integer.parseInt(result.iAccession.substring(openBracket + 1, result.iAccession.indexOf("-", openBracket)).trim());
                                result.iEnd = Integer.parseInt(result.iAccession.substring(result.iAccession.indexOf("-", openBracket) + 1, result.iAccession.indexOf(")")).trim());
                                result.iAccession = result.iAccession.substring(0, openBracket).trim();
                            }
                            result.databaseType = DatabaseType.UniProt;
                            result.iID = "sp";
                            result.iDescription = tempHeader.substring(tempHeader.indexOf("|") + 1);
                            Header.parseUniProtDescription(result);
                            break block98;
                        }
                        if (aFASTAHeader.matches("^tr\\|[^|]*\\|[^\\s]+_[^\\s]+ .*")) {
                            String tempHeader = aFASTAHeader.substring(3);
                            result.iAccession = tempHeader.substring(0, tempHeader.indexOf("|")).trim();
                            if (result.iAccession.matches("[^\\(]+\\([\\d]+ [\\d]+\\)$")) {
                                int openBracket = result.iAccession.indexOf("(");
                                result.iStart = Integer.parseInt(result.iAccession.substring(openBracket + 1, result.iAccession.indexOf(" ", openBracket)).trim());
                                result.iEnd = Integer.parseInt(result.iAccession.substring(result.iAccession.indexOf(" ", openBracket), result.iAccession.indexOf(")")).trim());
                                result.iAccession = result.iAccession.substring(0, openBracket).trim();
                            } else if (result.iAccession.matches("[^\\(]+\\([\\d]+-[\\d]+\\)$")) {
                                int openBracket = result.iAccession.indexOf("(");
                                result.iStart = Integer.parseInt(result.iAccession.substring(openBracket + 1, result.iAccession.indexOf("-", openBracket)).trim());
                                result.iEnd = Integer.parseInt(result.iAccession.substring(result.iAccession.indexOf("-", openBracket) + 1, result.iAccession.indexOf(")")).trim());
                                result.iAccession = result.iAccession.substring(0, openBracket).trim();
                            }
                            result.databaseType = DatabaseType.UniProt;
                            result.iID = "tr";
                            result.iDescription = tempHeader.substring(tempHeader.indexOf("|") + 1);
                            Header.parseUniProtDescription(result);
                            break block98;
                        }
                        if (aFASTAHeader.matches("^[^\\s]*\\|[^\\s]+_[^\\s]+ .*")) {
                            result.iAccession = aFASTAHeader.substring(0, aFASTAHeader.indexOf("|")).trim();
                            if (aFASTAHeader.matches("[^\\(]+\\([\\d]+ [\\d]\\)$")) {
                                int openBracket = aFASTAHeader.indexOf("(");
                                result.iAccession = aFASTAHeader.substring(0, openBracket).trim();
                                result.iStart = Integer.parseInt(aFASTAHeader.substring(openBracket, aFASTAHeader.indexOf(" ", openBracket)).trim());
                                result.iEnd = Integer.parseInt(aFASTAHeader.substring(aFASTAHeader.indexOf(" ", openBracket), aFASTAHeader.indexOf(")")).trim());
                            }
                            result.databaseType = DatabaseType.UniProt;
                            result.iID = "sw";
                            result.iDescription = aFASTAHeader.substring(aFASTAHeader.indexOf("|") + 1);
                            Header.parseUniProtDescription(result);
                            break block98;
                        }
                        if (aFASTAHeader.matches("^FB.+\\stype=.*")) {
                            result.iAccession = aFASTAHeader.substring(0, aFASTAHeader.indexOf("type")).trim();
                            if (result.iAccession.matches("[^\\(]+\\([\\d]+-[\\d]+\\)$")) {
                                int openBracket = result.iAccession.indexOf("(");
                                result.iStart = Integer.parseInt(result.iAccession.substring(openBracket + 1, result.iAccession.indexOf("-", openBracket)).trim());
                                result.iEnd = Integer.parseInt(result.iAccession.substring(result.iAccession.indexOf("-", openBracket) + 1, result.iAccession.indexOf(")")).trim());
                                result.iAccession = result.iAccession.substring(0, openBracket).trim();
                            }
                            result.databaseType = DatabaseType.Flybase;
                            result.iID = "";
                            result.iDescription = aFASTAHeader.substring(aFASTAHeader.indexOf("type="));
                            break block98;
                        }
                        if (aFASTAHeader.matches(".* [.]*\\[[\\d]+[ ]?\\-[ ]?[\\d]+\\].*")) {
                            int accessionEndLoc = aFASTAHeader.indexOf(" ");
                            if (accessionEndLoc < 0) {
                                throw new IllegalArgumentException("Incorrect genome to protein sequence header. Expected something like '>dm345_3L-sense (something) [234353-234359] (something)', but found '" + aFASTAHeader + "'!");
                            }
                            result.databaseType = DatabaseType.GenomeTranslation;
                            result.iID = aFASTAHeader.substring(0, accessionEndLoc).trim();
                            result.iAccession = aFASTAHeader.substring(0, accessionEndLoc).trim();
                            int index1 = aFASTAHeader.lastIndexOf("[");
                            int index2 = aFASTAHeader.indexOf("]", index1);
                            int separation = aFASTAHeader.indexOf("-", index1);
                            if (index1 > 0 && index2 > 0 && separation > 0) {
                                try {
                                    result.iStart = Integer.parseInt(aFASTAHeader.substring(index1 + 1, separation).trim());
                                    result.iEnd = Integer.parseInt(aFASTAHeader.substring(separation + 1, index2).trim());
                                }
                                catch (NumberFormatException e) {
                                    throw new IllegalArgumentException("Incorrect genome to protein sequence header. Expected something like '>dm345_3L-sense (something) [234353-234359] (something)', but found '" + aFASTAHeader + "'!");
                                }
                            }
                            result.iDescription = aFASTAHeader.substring(accessionEndLoc + 1).trim();
                            break block98;
                        }
                        if (aFASTAHeader.matches("^[^|\t]* [|] Symbol[^|]*[|] [^|]* [|].*")) {
                            int firstPipeLoc = aFASTAHeader.indexOf("|");
                            result.databaseType = DatabaseType.Arabidopsis_thaliana_TAIR;
                            result.iAccession = aFASTAHeader.substring(0, firstPipeLoc).trim();
                            result.iID = "";
                            int secondPipeLoc = aFASTAHeader.indexOf("|", firstPipeLoc + 1);
                            int thirdPipeLoc = aFASTAHeader.indexOf("|", secondPipeLoc + 1);
                            result.iDescription = aFASTAHeader.substring(secondPipeLoc + 1, thirdPipeLoc).trim();
                            result.iID = "";
                            int index = result.iAccession.indexOf(" (");
                            if (index > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            break block98;
                        }
                        if (aFASTAHeader.matches("^nrAt[^\t]*\t.*")) {
                            int openBracketLoc = aFASTAHeader.indexOf("(");
                            int closeBracketLoc = aFASTAHeader.indexOf(")");
                            int tempLoc = closeBracketLoc + 1;
                            if (aFASTAHeader.length() > tempLoc && aFASTAHeader.charAt(tempLoc) == ')') {
                                closeBracketLoc = tempLoc;
                            }
                            result.databaseType = DatabaseType.PSB_Arabidopsis_thaliana;
                            result.iAccession = aFASTAHeader.substring(openBracketLoc + 1, closeBracketLoc).trim();
                            result.iID = aFASTAHeader.substring(0, openBracketLoc).trim();
                            result.iDescription = aFASTAHeader.substring(closeBracketLoc + 1).trim();
                            int index = result.iAccession.indexOf(" (");
                            if (index > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            break block98;
                        }
                        if (aFASTAHeader.matches("^L. monocytogenes[^|]*[|][^|]*[|].*")) {
                            int firstPipe = aFASTAHeader.indexOf("|");
                            int secondPipe = aFASTAHeader.indexOf("|", firstPipe + 1);
                            result.databaseType = DatabaseType.Listeria;
                            result.iID = aFASTAHeader.substring(0, firstPipe).trim();
                            result.iAccession = aFASTAHeader.substring(firstPipe + 1, secondPipe).trim();
                            result.iDescription = aFASTAHeader.substring(secondPipe + 1).trim();
                            int index = result.iAccession.indexOf(" (");
                            if (index > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            break block98;
                        }
                        if (aFASTAHeader.toLowerCase().startsWith("gaffa")) {
                            result.databaseType = DatabaseType.GAFFA;
                            try {
                                result.iAccession = aFASTAHeader.substring(aFASTAHeader.indexOf("|") + 1, aFASTAHeader.lastIndexOf("|"));
                                result.iDescription = aFASTAHeader.substring(aFASTAHeader.lastIndexOf("|") + 1);
                            }
                            catch (IndexOutOfBoundsException e) {
                                result.iAccession = aFASTAHeader.substring(aFASTAHeader.indexOf("|") + 1);
                                result.iDescription = "";
                            }
                            result.iID = "GAFFA";
                            break block98;
                        }
                        if (aFASTAHeader.contains("_HUMAN_UPS")) {
                            int accessionEndLoc = aFASTAHeader.indexOf(" ");
                            if (accessionEndLoc < 0) {
                                throw new IllegalArgumentException("Non-standard UPS header passed. Expecting something like '>xxxx xxxxx_HUMAN_UPS xxxxxxx xxx', but was '" + aFASTAHeader + "'.");
                            }
                            if (aFASTAHeader.charAt(accessionEndLoc + 1) == '(' && Character.isDigit(aFASTAHeader.charAt(accessionEndLoc + 2))) {
                                accessionEndLoc = aFASTAHeader.indexOf(")", accessionEndLoc) + 1;
                            }
                            result.databaseType = DatabaseType.UPS;
                            result.iID = "";
                            result.iAccession = aFASTAHeader.substring(0, accessionEndLoc).trim();
                            int index = result.iAccession.indexOf(" (");
                            if (index > 0) {
                                String temp = result.iAccession.substring(index);
                                result.iAccession = result.iAccession.substring(0, index);
                                int open = 2;
                                int minus = temp.indexOf("-");
                                int end = temp.indexOf(")");
                                result.iStart = Integer.parseInt(temp.substring(open, minus));
                                result.iEnd = Integer.parseInt(temp.substring(minus + 1, end));
                            }
                            result.iDescription = aFASTAHeader.substring(accessionEndLoc).trim();
                        } else {
                            int end;
                            int minus;
                            int open;
                            result.databaseType = DatabaseType.Generic_Header;
                            int accessionEndLoc = aFASTAHeader.indexOf(" ");
                            int startSecAcc = -1;
                            int endSecAcc = -1;
                            String testAccession = null;
                            String testDescription = null;
                            int testStart = -1;
                            int testEnd = -1;
                            if (accessionEndLoc > 0 && aFASTAHeader.indexOf("(") >= 0 && aFASTAHeader.indexOf(")", aFASTAHeader.indexOf("(") + 1) >= 0) {
                                int index;
                                if (aFASTAHeader.substring(accessionEndLoc + 1, aFASTAHeader.indexOf(")", accessionEndLoc + 2) + 1).matches("[(][0-9]+-[0-9]+[)]") && !aFASTAHeader.substring(accessionEndLoc + 2, aFASTAHeader.indexOf(")", accessionEndLoc + 2)).equals(aFASTAHeader.substring(0, accessionEndLoc).trim())) {
                                    accessionEndLoc = aFASTAHeader.indexOf(")", accessionEndLoc) + 1;
                                }
                                if ((index = (testAccession = aFASTAHeader.substring(0, accessionEndLoc).trim()).indexOf(" (")) > 0) {
                                    String temp = testAccession.substring(index);
                                    testAccession = testAccession.substring(0, index);
                                    open = 2;
                                    minus = temp.indexOf("-");
                                    end = temp.indexOf(")");
                                    testStart = Integer.parseInt(temp.substring(open, minus));
                                    testEnd = Integer.parseInt(temp.substring(minus + 1, end));
                                }
                                testDescription = aFASTAHeader.substring(accessionEndLoc).trim();
                                int enzymicity = -1;
                                if (testDescription.indexOf("(*") >= 0 && testDescription.indexOf("*)", testDescription.indexOf("(*4")) > 0) {
                                    enzymicity = testDescription.indexOf("*)") + 2;
                                }
                                startSecAcc = testDescription.indexOf("(", enzymicity);
                                endSecAcc = testDescription.indexOf(")", startSecAcc + 2);
                            }
                            if (startSecAcc >= 0 && endSecAcc >= 0 && testDescription != null && testDescription.substring(startSecAcc + 1, endSecAcc).trim().equals(testAccession.trim())) {
                                result.iID = "";
                                result.iAccession = testAccession;
                                result.iDescription = testDescription;
                                if (testStart >= 0 && testEnd >= 0) {
                                    result.iStart = testStart;
                                    result.iEnd = testEnd;
                                }
                            } else {
                                String end2;
                                if (aFASTAHeader.lastIndexOf("|") >= 0 && (end2 = aFASTAHeader.substring(aFASTAHeader.indexOf("|") + 1)).indexOf("|") >= 0) {
                                    result.iAccession = end2.substring(0, end2.indexOf("|"));
                                    result.iDescription = end2.substring(end2.indexOf("|") + 1);
                                }
                                result.iRest = aFASTAHeader;
                                int index = result.iRest.lastIndexOf(" (");
                                if (index > 0 && result.iRest.lastIndexOf(")") > 0 && result.iRest.lastIndexOf("-") > index) {
                                    String temp = result.iRest.substring(index);
                                    open = 2;
                                    minus = temp.indexOf("-");
                                    end = temp.lastIndexOf(")");
                                    try {
                                        int tempStart = Integer.parseInt(temp.substring(open, minus));
                                        int tempEnd = Integer.parseInt(temp.substring(minus + 1, end));
                                        result.iStart = tempStart;
                                        result.iEnd = tempEnd;
                                        result.iRest = result.iRest.substring(0, index);
                                    }
                                    catch (Exception e) {}
                                }
                            }
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new StringIndexOutOfBoundsException("Unable to process FASTA header line:\n'" + aFASTAHeader + "'\n" + "as a '" + (Object)((Object)result.databaseType) + "' header.\n" + "Process cancelled.");
                    }
                    catch (RuntimeException excep) {
                        logger.error((Object)(" * Unable to process FASTA header line:\n\t" + aFASTAHeader + "\n\n"));
                        throw excep;
                    }
                }
            }
        }
        return result;
    }

    public String getID() {
        return this.iID;
    }

    public void setID(String aID) {
        this.iID = aID;
    }

    public String getForeignID() {
        return this.iForeignID;
    }

    public void setForeignID(String aForeignID) {
        this.iForeignID = aForeignID;
    }

    public String getAccession() {
        return this.iAccession;
    }

    public void setAccession(String aAccession) {
        this.iAccession = aAccession;
    }

    public String getAccessionOrRest() {
        if (this.iAccession == null) {
            return this.iRest;
        }
        return this.iAccession;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(DatabaseType aDatabaseType) {
        this.databaseType = aDatabaseType;
    }

    public String getForeignAccession() {
        return this.iForeignAccession;
    }

    public void setForeignAccession(String aForeignAccession) {
        this.iForeignAccession = aForeignAccession;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String aDescription) {
        this.iDescription = aDescription;
    }

    public String getDescriptionShort() {
        return this.iDescriptionShort;
    }

    public void setDescriptionShort(String aDescriptionShort) {
        this.iDescriptionShort = aDescriptionShort;
    }

    public String getDescriptionProteinName() {
        return this.iDescriptionProteinName;
    }

    public void setDescriptionProteinName(String aDescriptionProteinName) {
        this.iDescriptionProteinName = aDescriptionProteinName;
    }

    public String getGeneName() {
        return this.iGeneName;
    }

    public void setGeneName(String aGeneName) {
        this.iGeneName = aGeneName;
    }

    public String getProteinEvidence() {
        return this.iProteinEvidence;
    }

    public void setProteinEvidence(String aProteinEvidence) {
        this.iProteinEvidence = aProteinEvidence;
    }

    public String getTaxonomy() {
        return this.iTaxonomy;
    }

    public void setTaxonomy(String aTaxonomy) {
        this.iTaxonomy = aTaxonomy;
    }

    public String getForeignDescription() {
        return this.iForeignDescription;
    }

    public void setForeignDescription(String aForeignDescription) {
        this.iForeignDescription = aForeignDescription;
    }

    public String getRest() {
        return this.iRest;
    }

    public void setRest(String aRest) {
        this.iRest = aRest;
    }

    public String getSimpleProteinDescription() {
        if (this.databaseType == DatabaseType.UniProt) {
            String temp = this.iDescriptionShort + " (" + this.iDescriptionProteinName + ")";
            if (SequenceFactory.getInstance().isDecoyAccession(this.iAccession)) {
                temp = SequenceFactory.getDefaultDecoyDescription(temp);
            }
            return temp;
        }
        return this.iDescription;
    }

    public String getAbbreviatedFASTAHeader() {
        return this.getAbbreviatedFASTAHeader("");
    }

    public String getAbbreviatedFASTAHeader(String decoyTag) {
        StringBuffer result = new StringBuffer(">" + this.getCoreHeader() + decoyTag);
        if (this.iID != null && this.databaseType != DatabaseType.Unknown) {
            if (!this.iID.equals("")) {
                if (this.databaseType == DatabaseType.UniProt || this.databaseType == DatabaseType.IPI || this.databaseType == DatabaseType.Listeria) {
                    result.append("|").append(this.iDescription);
                } else if (this.databaseType == DatabaseType.NCBI) {
                    result.append("|");
                    if (this.iForeignID != null) {
                        result.append(this.iForeignID).append("|").append(this.iForeignAccession).append("|");
                        if (this.iForeignDescription != null) {
                            result.append(this.iForeignDescription);
                        }
                    }
                    result.append(" ").append(this.iDescription);
                } else if (this.databaseType == DatabaseType.M_Tuberculosis) {
                    result.append("|").append(this.iDescription);
                } else if (this.databaseType == DatabaseType.GenomeTranslation) {
                    result = new StringBuffer(">" + this.iAccession + decoyTag + " " + this.iDescription);
                } else if (this.databaseType == DatabaseType.PSB_Arabidopsis_thaliana) {
                    result.append(" ").append(this.iDescription);
                }
            } else if (this.iID.equals("")) {
                if (this.databaseType == DatabaseType.H_Invitation) {
                    result.append("|").append(this.iDescription);
                } else {
                    result.append(" ").append(this.iDescription);
                }
            }
        }
        return result.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String decoyTag) {
        String result;
        if (this.databaseType == DatabaseType.Generic_Split_Header) {
            result = ">" + this.iID + decoyTag + "|" + this.iAccession + "|" + this.iDescription;
        } else if (this.iID == null) {
            result = this.getAbbreviatedFASTAHeader(decoyTag);
        } else {
            result = this.getAbbreviatedFASTAHeader(decoyTag);
            if (this.iRest != null) {
                result = result + " " + this.iRest;
            }
        }
        result = result + decoyTag;
        return result;
    }

    public int getScore() {
        int score = -1;
        if (this.iID == null || this.iID.equals("") || this.iID.startsWith(" M. tub.") || this.iID.startsWith("nrAt") || this.iID.startsWith("L. monocytogenes")) {
            score = 0;
        } else if (this.iID.equalsIgnoreCase("sw") || this.iID.equalsIgnoreCase("sp")) {
            score = 4;
        } else if (this.iID.equalsIgnoreCase("tr")) {
            score = 2;
        } else if (this.iID.equalsIgnoreCase("ipi")) {
            score = this.iDescription != null && this.iDescription.toUpperCase().indexOf("SWISS-PROT") >= 0 ? 3 : (this.iDescription != null && (this.iDescription.toUpperCase().indexOf("TREMBL") >= 0 || this.iDescription.toUpperCase().indexOf("REFSEQ_NP") >= 0) ? 2 : 1);
        } else if (this.iID.equalsIgnoreCase("gi")) {
            score = this.iForeignID != null && this.iForeignID.equals("sp") ? 2 : 1;
        }
        return score;
    }

    public String getCoreHeader() {
        String result = null;
        if (this.iID != null && this.iID.startsWith("nrAt")) {
            result = this.getID() + " \t(" + this.getAccession();
        } else if (this.iID != null && !this.iID.equals("")) {
            result = this.getID() + "|" + this.getAccession();
        } else if (this.iID != null && this.iID.equals("")) {
            result = this.getAccession();
        } else if (this.iID == null) {
            result = this.iRest;
        }
        if (this.iStart >= 0) {
            result = result + " (" + Integer.toString(this.iStart) + "-" + Integer.toString(this.iEnd) + ")";
        }
        if (this.iID != null && this.iID.startsWith("nrAt")) {
            result = result + ")";
        }
        return result;
    }

    public void addAddendum(String aAddendum) {
        if (this.iAddenda == null) {
            this.iAddenda = new StringBuffer();
        }
        if (aAddendum.startsWith("^A")) {
            this.iAddenda.append(aAddendum);
        } else {
            this.iAddenda.append("^A").append(aAddendum);
        }
    }

    public String getAddenda() {
        String result = null;
        if (this.iAddenda != null) {
            result = this.iAddenda.toString();
        }
        return result;
    }

    public boolean hasAddenda() {
        boolean result = false;
        if (this.iAddenda != null) {
            result = true;
        }
        return result;
    }

    public String getFullHeaderWithAddenda() {
        String result = this.toString();
        if (this.iAddenda != null) {
            result = result + this.iAddenda.toString();
        }
        return result;
    }

    public String getAbbreviatedFASTAHeaderWithAddenda() {
        String result = this.getAbbreviatedFASTAHeader();
        if (this.iAddenda != null) {
            result = result + this.iAddenda.toString();
        }
        return result;
    }

    public void setLocation(int aStart, int aEnd) {
        this.iStart = aStart;
        this.iEnd = aEnd;
    }

    public int getStartLocation() {
        return this.iStart;
    }

    public int getEndLocation() {
        return this.iEnd;
    }

    public Object clone() {
        Object result = null;
        try {
            result = super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            logger.error((Object)cnse.getMessage(), (Throwable)cnse);
        }
        return result;
    }

    public static String[] getDatabaseTypesAsString() {
        DatabaseType[] enumValues = DatabaseType.values();
        String[] result = new String[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            result[i] = Header.getDatabaseTypeAsString(enumValues[i]);
        }
        return result;
    }

    public static String getDatabaseTypeAsString(DatabaseType databaseType) {
        switch (databaseType) {
            case UniProt: {
                return "UniProtKB";
            }
            case Unknown: {
                return "Unknown";
            }
            case NCBI: {
                return "NCBI";
            }
            case IPI: {
                return "IPI (deprecated)";
            }
            case H_Invitation: {
                return "H_Invitation";
            }
            case Halobacterium: {
                return "Halobacterium";
            }
            case H_Influenza: {
                return "H_Influenza";
            }
            case C_Trachomatis: {
                return "C_Trachomatis";
            }
            case M_Tuberculosis: {
                return "M_Tuberculosis";
            }
            case Drosophile: {
                return "M_Tuberculosis";
            }
            case SGD: {
                return "SGD";
            }
            case Flybase: {
                return "Flybase";
            }
            case GenomeTranslation: {
                return "Genome to protein translation";
            }
            case Arabidopsis_thaliana_TAIR: {
                return "Arabidopsis thaliana TAIR";
            }
            case PSB_Arabidopsis_thaliana: {
                return "PSB Arabidopsis thaliana";
            }
            case Listeria: {
                return "Listeria";
            }
            case Generic_Header: {
                return "User Defined";
            }
            case Generic_Split_Header: {
                return "Generic Header";
            }
            case GAFFA: {
                return "GAFFA";
            }
            case UPS: {
                return "Universal Proteomic Standard";
            }
        }
        throw new IllegalArgumentException("Database type not implemented: " + (Object)((Object)databaseType) + ".");
    }

    private static void parseUniProtDescription(Header header) {
        if (header.iDescription.indexOf(" GN=") != -1) {
            int geneStartIndex = header.iDescription.indexOf(" GN=") + 4;
            int geneEndIndex = header.iDescription.indexOf(" ", geneStartIndex);
            header.iGeneName = geneEndIndex != -1 ? header.iDescription.substring(geneStartIndex, geneEndIndex) : header.iDescription.substring(geneStartIndex);
        }
        if (header.iDescription.indexOf(" PE=") != -1) {
            int evidenceStartIndex = header.iDescription.indexOf(" PE=") + 4;
            int evidenceEndIndex = header.iDescription.indexOf(" ", evidenceStartIndex);
            header.iProteinEvidence = evidenceEndIndex != -1 ? header.iDescription.substring(evidenceStartIndex, evidenceEndIndex) : header.iDescription.substring(evidenceStartIndex);
        }
        if (header.iDescription.indexOf(" OS=") != -1) {
            int taxonomyStartIndex = header.iDescription.indexOf(" OS=") + 4;
            int taxonomyEndIndex = header.iDescription.indexOf(" GN=");
            if (taxonomyEndIndex == -1) {
                taxonomyEndIndex = header.iDescription.indexOf(" PE=") != -1 ? header.iDescription.indexOf(" PE=") : header.iDescription.length();
            }
            header.iTaxonomy = header.iDescription.substring(taxonomyStartIndex, taxonomyEndIndex);
            String tempShortHeader = header.iDescription.substring(0, taxonomyStartIndex - 3);
            header.iDescriptionShort = tempShortHeader.substring(tempShortHeader.indexOf(" ") + 1).trim();
            header.iDescriptionProteinName = tempShortHeader.substring(0, tempShortHeader.indexOf(" "));
        }
    }

    public static enum DatabaseType {
        UniProt("UniProtKB", "14681372"),
        SGD("Saccharomyces Genome Database (SGD)", "9399804"),
        Arabidopsis_thaliana_TAIR("The Arabidopsis Information Resource (TAIR)", "12519987"),
        PSB_Arabidopsis_thaliana("PSB Arabidopsis thaliana", null),
        Drosophile("Drosophile", null),
        Flybase("Flybase", null),
        NCBI("NCBI Reference Sequences (RefSeq)", "22121212"),
        M_Tuberculosis("TBDatabase (TBDB)", "18835847"),
        H_Invitation("H_Invitation", null),
        Halobacterium("Halobacterium", null),
        H_Influenza("H_Influenza", null),
        C_Trachomatis("C_Trachomatis", null),
        GenomeTranslation("Genome Translation", null),
        Listeria("Listeria", null),
        GAFFA("GAFFA", null),
        UPS("Universal Proteomic Standard (UPS)", null),
        Generic_Header(null, null),
        IPI("International Protein Index (IPI)", "15221759"),
        Generic_Split_Header(null, null),
        Unknown(null, null);

        String fullName;
        String pmid;

        private DatabaseType(String fullName, String pmid) {
            this.fullName = fullName;
            this.pmid = pmid;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getPmid() {
            return this.pmid;
        }
    }
}

