package eu.isas.peptideshaker.gui.export;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.utils.user_choice.list_choosers.ModificationChooser;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.followup.FastaExport;
import eu.isas.peptideshaker.followup.InclusionListExport;
import eu.isas.peptideshaker.followup.PepXmlExport;
import eu.isas.peptideshaker.followup.SpectrumExporter;
import eu.isas.peptideshaker.followup.ProgenesisExport;
import eu.isas.peptideshaker.followup.RecalibrationExporter;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.io.flat.SimpleFileWriter;
import eu.isas.peptideshaker.export.PSExportFactory;
import eu.isas.peptideshaker.export.UnipeptExport;
import eu.isas.peptideshaker.followup.ProteoformExport;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.*;

/**
 * This class allows generating exports for follow up analysis.
 *
 * @author Marc Vaudel
 * @author Harald Barsnes
 */
public class FollowUpExportDialog extends javax.swing.JDialog {

    /**
     * The main GUI.
     */
    private final PeptideShakerGUI peptideShakerGUI;
    /**
     * A simple progress dialog.
     */
    private static ProgressDialogX progressDialog;

    /**
     * Creates a new FollowupPreferencesDialog.
     *
     * @param peptideShakerGUI the PeptideShakerGUI parent
     */
    public FollowUpExportDialog(PeptideShakerGUI peptideShakerGUI) {
        super(peptideShakerGUI, true);
        this.peptideShakerGUI = peptideShakerGUI;
        initComponents();

        spectrumRecalibrationCmb.setRenderer(new AlignedListCellRenderer(SwingConstants.CENTER));
        spectrumValidationCmb.setRenderer(new AlignedListCellRenderer(SwingConstants.CENTER));
        inclusionListFormat.setRenderer(new AlignedListCellRenderer(SwingConstants.CENTER));
        proteinExportCmb1.setRenderer(new AlignedListCellRenderer(SwingConstants.CENTER));
        proteinExportCmb2.setRenderer(new AlignedListCellRenderer(SwingConstants.CENTER));
        psmSelectionComboBox.setRenderer(new AlignedListCellRenderer(SwingConstants.CENTER));
        graphDatabaseFormat.setRenderer(new AlignedListCellRenderer(SwingConstants.CENTER));
        skylineExportCmb.setRenderer(new AlignedListCellRenderer(SwingConstants.CENTER));
        tppExportCmb.setRenderer(new AlignedListCellRenderer(SwingConstants.CENTER));
        proteoformsExportCmb.setRenderer(new AlignedListCellRenderer(SwingConstants.CENTER));
        unipeptiExportCmb.setRenderer(new AlignedListCellRenderer(SwingConstants.CENTER));

        this.setLocationRelativeTo(peptideShakerGUI);

        setVisible(true);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        backgroundPanel = new javax.swing.JPanel();
        scrollPane = new javax.swing.JScrollPane();
        scrollPanel = new javax.swing.JPanel();
        tppPanel = new javax.swing.JPanel();
        tppExportButton = new javax.swing.JButton();
        tppExportCmb = new javax.swing.JComboBox();
        tppLabel = new javax.swing.JLabel();
        progenesisPanel = new javax.swing.JPanel();
        exportProgenesisButton = new javax.swing.JButton();
        psmSelectionComboBox = new javax.swing.JComboBox();
        exportToProgenesisLinkLabel = new javax.swing.JLabel();
        proteinsPanel = new javax.swing.JPanel();
        exportAllIdentifiedProteinsAsFastaLabel = new javax.swing.JLabel();
        exportIdentifiedProteinsAsFastaButton = new javax.swing.JButton();
        exportAllIdentifiedProteinAccessionsLabel = new javax.swing.JLabel();
        exportIdentifiedProteinAccessionNumbersAsCsvButton = new javax.swing.JButton();
        proteinExportCmb1 = new javax.swing.JComboBox();
        proteinExportCmb2 = new javax.swing.JComboBox();
        proteoformsLabel = new javax.swing.JLabel();
        proteoformsExportCmb = new javax.swing.JComboBox();
        exportProteformsAsTxtButton = new javax.swing.JButton();
        inclusionListPanel = new javax.swing.JPanel();
        includeValidatedPsmsLabel = new javax.swing.JLabel();
        inclusionListFormat = new javax.swing.JComboBox();
        inclusionListButton = new javax.swing.JButton();
        graphDatabasesPanel = new javax.swing.JPanel();
        graphDatabasesLabel = new javax.swing.JLabel();
        graphDatabaseFormat = new javax.swing.JComboBox();
        graphDatabasetButton = new javax.swing.JButton();
        spectraPanel = new javax.swing.JPanel();
        exportSpectraLabel = new javax.swing.JLabel();
        spectrumValidationCmb = new javax.swing.JComboBox();
        exportMgfButton = new javax.swing.JButton();
        recalibrateSpectraLabel = new javax.swing.JLabel();
        spectrumRecalibrationCmb = new javax.swing.JComboBox();
        recalibrateMgfButton = new javax.swing.JButton();
        skylinePanel = new javax.swing.JPanel();
        skylineExportButton = new javax.swing.JButton();
        skylineExportCmb = new javax.swing.JComboBox();
        skylineExportLabel = new javax.swing.JLabel();
        unipeptPanel = new javax.swing.JPanel();
        unipeptExportButton = new javax.swing.JButton();
        unipeptiExportCmb = new javax.swing.JComboBox();
        unipeptLabel = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Export - Follow Up Analysis");

        backgroundPanel.setBackground(new java.awt.Color(230, 230, 230));

        tppPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("TPP Export (beta)"));
        tppPanel.setOpaque(false);

        tppExportButton.setText("Export as pepXML");
        tppExportButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tppExportButtonActionPerformed(evt);
            }
        });

        tppExportCmb.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "(no filters yet supported)" }));
        tppExportCmb.setEnabled(false);

        tppLabel.setText("pepXML Format");
        tppLabel.setToolTipText("Click for Progenesis LC-MS export help");

        javax.swing.GroupLayout tppPanelLayout = new javax.swing.GroupLayout(tppPanel);
        tppPanel.setLayout(tppPanelLayout);
        tppPanelLayout.setHorizontalGroup(
            tppPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, tppPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(tppLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tppExportCmb, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addComponent(tppExportButton, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        tppPanelLayout.setVerticalGroup(
            tppPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(tppPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(tppPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tppExportCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(tppExportButton)
                    .addComponent(tppLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        progenesisPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Label Free Quantification"));
        progenesisPanel.setOpaque(false);

        exportProgenesisButton.setText("Export TXT");
        exportProgenesisButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportProgenesisButtonActionPerformed(evt);
            }
        });

        psmSelectionComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Validated PSMs of Validated Peptides of Validated Proteins", "Validated PSMs of Validated Peptides", "Validated PSMs", "Validated PSMs Containing Confidently Localized PTMs" }));

        exportToProgenesisLinkLabel.setText("<html><a href=\\\"http://www.nonlinear.com/products/progenesis/lc-ms/overview/\\\">Progenesis LC-MS</a></html>");
        exportToProgenesisLinkLabel.setToolTipText("Click for Progenesis LC-MS export help");
        exportToProgenesisLinkLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                exportToProgenesisLinkLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                exportToProgenesisLinkLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                exportToProgenesisLinkLabelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout progenesisPanelLayout = new javax.swing.GroupLayout(progenesisPanel);
        progenesisPanel.setLayout(progenesisPanelLayout);
        progenesisPanelLayout.setHorizontalGroup(
            progenesisPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, progenesisPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(exportToProgenesisLinkLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(psmSelectionComboBox, 0, 434, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addComponent(exportProgenesisButton, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        progenesisPanelLayout.setVerticalGroup(
            progenesisPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(progenesisPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(progenesisPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(psmSelectionComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(exportProgenesisButton)
                    .addComponent(exportToProgenesisLinkLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        proteinsPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Proteins"));
        proteinsPanel.setOpaque(false);

        exportAllIdentifiedProteinsAsFastaLabel.setText("Export Sequences");

        exportIdentifiedProteinsAsFastaButton.setText("Export as FASTA");
        exportIdentifiedProteinsAsFastaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportIdentifiedProteinsAsFastaButtonActionPerformed(evt);
            }
        });

        exportAllIdentifiedProteinAccessionsLabel.setText("Export Accession Numbers");

        exportIdentifiedProteinAccessionNumbersAsCsvButton.setText("Export as TXT");
        exportIdentifiedProteinAccessionNumbersAsCsvButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportIdentifiedProteinAccessionNumbersAsCsvButtonActionPerformed(evt);
            }
        });

        proteinExportCmb1.setModel(new DefaultComboBoxModel(FastaExport.ExportType.getPossibilities()));

        proteinExportCmb2.setModel(new DefaultComboBoxModel(FastaExport.ExportType.getPossibilities()));

        proteoformsLabel.setText("Proteoforms");

        proteoformsExportCmb.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "(no filters yet supported)" }));
        proteoformsExportCmb.setEnabled(false);

        exportProteformsAsTxtButton.setText("Export as TXT");
        exportProteformsAsTxtButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportProteformsAsTxtButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout proteinsPanelLayout = new javax.swing.GroupLayout(proteinsPanel);
        proteinsPanel.setLayout(proteinsPanelLayout);
        proteinsPanelLayout.setHorizontalGroup(
            proteinsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(proteinsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(proteinsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(proteinsPanelLayout.createSequentialGroup()
                        .addGroup(proteinsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(exportAllIdentifiedProteinAccessionsLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(exportAllIdentifiedProteinsAsFastaLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(proteinsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(proteinExportCmb2, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(proteinExportCmb1, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addGroup(proteinsPanelLayout.createSequentialGroup()
                        .addComponent(proteoformsLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(proteoformsExportCmb, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addGap(18, 18, 18)
                .addGroup(proteinsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(exportProteformsAsTxtButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(exportIdentifiedProteinAccessionNumbersAsCsvButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(exportIdentifiedProteinsAsFastaButton, javax.swing.GroupLayout.DEFAULT_SIZE, 180, Short.MAX_VALUE))
                .addContainerGap())
        );
        proteinsPanelLayout.setVerticalGroup(
            proteinsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(proteinsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(proteinsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(exportAllIdentifiedProteinAccessionsLabel)
                    .addComponent(exportIdentifiedProteinAccessionNumbersAsCsvButton)
                    .addComponent(proteinExportCmb1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, 0)
                .addGroup(proteinsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(exportAllIdentifiedProteinsAsFastaLabel)
                    .addComponent(exportIdentifiedProteinsAsFastaButton)
                    .addComponent(proteinExportCmb2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, 0)
                .addGroup(proteinsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(proteoformsLabel)
                    .addComponent(exportProteformsAsTxtButton)
                    .addComponent(proteoformsExportCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        inclusionListPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Inclusion/Exclusion List (beta)"));
        inclusionListPanel.setOpaque(false);

        includeValidatedPsmsLabel.setText("Instrument Format");

        inclusionListFormat.setModel(new DefaultComboBoxModel(InclusionListExport.ExportFormat.getPossibilities()));

        inclusionListButton.setText("Export as List");
        inclusionListButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                inclusionListButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout inclusionListPanelLayout = new javax.swing.GroupLayout(inclusionListPanel);
        inclusionListPanel.setLayout(inclusionListPanelLayout);
        inclusionListPanelLayout.setHorizontalGroup(
            inclusionListPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(inclusionListPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(includeValidatedPsmsLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(inclusionListFormat, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addComponent(inclusionListButton, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        inclusionListPanelLayout.setVerticalGroup(
            inclusionListPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(inclusionListPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(inclusionListPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(inclusionListFormat, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(includeValidatedPsmsLabel)
                    .addComponent(inclusionListButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        graphDatabasesPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Graph Databases"));
        graphDatabasesPanel.setOpaque(false);

        graphDatabasesLabel.setText("Database Format");

        graphDatabaseFormat.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Cytoscape", "Gephi", "Neo4j" }));

        graphDatabasetButton.setText("Export Database");
        graphDatabasetButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                graphDatabasetButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout graphDatabasesPanelLayout = new javax.swing.GroupLayout(graphDatabasesPanel);
        graphDatabasesPanel.setLayout(graphDatabasesPanelLayout);
        graphDatabasesPanelLayout.setHorizontalGroup(
            graphDatabasesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(graphDatabasesPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(graphDatabasesLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(graphDatabaseFormat, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addComponent(graphDatabasetButton, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        graphDatabasesPanelLayout.setVerticalGroup(
            graphDatabasesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(graphDatabasesPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(graphDatabasesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(graphDatabaseFormat, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(graphDatabasesLabel)
                    .addComponent(graphDatabasetButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        spectraPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Spectra"));
        spectraPanel.setOpaque(false);

        exportSpectraLabel.setText("Export Spectra");

        spectrumValidationCmb.setModel(new DefaultComboBoxModel(SpectrumExporter.ExportType.getPossibilities()));

        exportMgfButton.setText("Export as MGF");
        exportMgfButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportMgfButtonActionPerformed(evt);
            }
        });

        recalibrateSpectraLabel.setText("Recalibrate Spectra (beta)");

        spectrumRecalibrationCmb.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Precursor and Fragment Ions", "Precursor Ions", "Fragment Ions" }));

        recalibrateMgfButton.setText("Export as MGF");
        recalibrateMgfButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                recalibrateMgfButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout spectraPanelLayout = new javax.swing.GroupLayout(spectraPanel);
        spectraPanel.setLayout(spectraPanelLayout);
        spectraPanelLayout.setHorizontalGroup(
            spectraPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(spectraPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(spectraPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(spectraPanelLayout.createSequentialGroup()
                        .addComponent(exportSpectraLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(spectrumValidationCmb, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(spectraPanelLayout.createSequentialGroup()
                        .addComponent(recalibrateSpectraLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(spectrumRecalibrationCmb, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addGroup(spectraPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(spectraPanelLayout.createSequentialGroup()
                        .addGap(17, 17, 17)
                        .addComponent(recalibrateMgfButton, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, spectraPanelLayout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(exportMgfButton, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        spectraPanelLayout.setVerticalGroup(
            spectraPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(spectraPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(spectraPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(exportSpectraLabel)
                    .addComponent(spectrumValidationCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(exportMgfButton))
                .addGap(0, 0, 0)
                .addGroup(spectraPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(recalibrateSpectraLabel)
                    .addComponent(spectrumRecalibrationCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(recalibrateMgfButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        skylinePanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Skyline Export (beta)"));
        skylinePanel.setOpaque(false);

        skylineExportButton.setText("Export as mzid");
        skylineExportButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                skylineExportButtonActionPerformed(evt);
            }
        });

        skylineExportCmb.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "(no filters yet supported)" }));
        skylineExportCmb.setEnabled(false);

        skylineExportLabel.setText("mzIdentML Format");
        skylineExportLabel.setToolTipText("Click for Progenesis LC-MS export help");

        javax.swing.GroupLayout skylinePanelLayout = new javax.swing.GroupLayout(skylinePanel);
        skylinePanel.setLayout(skylinePanelLayout);
        skylinePanelLayout.setHorizontalGroup(
            skylinePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, skylinePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(skylineExportLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(skylineExportCmb, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addComponent(skylineExportButton, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        skylinePanelLayout.setVerticalGroup(
            skylinePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(skylinePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(skylinePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(skylineExportCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(skylineExportButton)
                    .addComponent(skylineExportLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        unipeptPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Unipept Export"));
        unipeptPanel.setOpaque(false);

        unipeptExportButton.setText("Export to Unipept");
        unipeptExportButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                unipeptExportButtonActionPerformed(evt);
            }
        });

        unipeptiExportCmb.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Validated Peptides", "All Peptides", "Validated PSMs", "All PSMs" }));

        unipeptLabel.setText("Peptide Sequences");

        javax.swing.GroupLayout unipeptPanelLayout = new javax.swing.GroupLayout(unipeptPanel);
        unipeptPanel.setLayout(unipeptPanelLayout);
        unipeptPanelLayout.setHorizontalGroup(
            unipeptPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, unipeptPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(unipeptLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(unipeptiExportCmb, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addComponent(unipeptExportButton, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        unipeptPanelLayout.setVerticalGroup(
            unipeptPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(unipeptPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(unipeptPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(unipeptiExportCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(unipeptExportButton)
                    .addComponent(unipeptLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout scrollPanelLayout = new javax.swing.GroupLayout(scrollPanel);
        scrollPanel.setLayout(scrollPanelLayout);
        scrollPanelLayout.setHorizontalGroup(
            scrollPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(scrollPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(scrollPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(unipeptPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(tppPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(skylinePanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(inclusionListPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(graphDatabasesPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(progenesisPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(proteinsPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(spectraPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        scrollPanelLayout.setVerticalGroup(
            scrollPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(scrollPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(spectraPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(proteinsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(progenesisPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(graphDatabasesPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(inclusionListPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(skylinePanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(tppPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(unipeptPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        scrollPane.setViewportView(scrollPanel);

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addComponent(scrollPane)
                .addGap(0, 0, 0))
        );
        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(scrollPane)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void tppExportButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tppExportButtonActionPerformed

        JOptionPane.showMessageDialog(
                FollowUpExportDialog.this, 
                "PepXML does not allow the storage of all PeptideShaker results and should thus be used carefully." + System.getProperty("line.separator")
                + "For third party tools we recommend using mzIdentML, the standard format of proteomics identification results.", 
                "Warning", 
                JOptionPane.WARNING_MESSAGE
        );

        final File finalOutputFile = peptideShakerGUI.getUserSelectedFile("tpp_psm_export.pep.xml", ".pep.xml", "PepXML (*.pep.xml)", "Select Destination File", false);;

        if (finalOutputFile != null) {

            progressDialog = new ProgressDialogX(this, peptideShakerGUI,
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker-orange.gif")),
                    true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting PepXML. Please Wait...");

            new Thread(new Runnable() {
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    } catch (IndexOutOfBoundsException e) {
                        // ignore
                    }
                }
            }, "ProgressDialog").start();

            new Thread("PepXmlThread") {
                @Override
                public void run() {
                    try {
                        PepXmlExport pepXmlExport = new PepXmlExport();
                        pepXmlExport.writePepXmlFile(
                                peptideShakerGUI.getIdentification(),
                                peptideShakerGUI.getIdentificationParameters(),
                                peptideShakerGUI.getSpectrumProvider(),
                                finalOutputFile,
                                PeptideShaker.getVersion(),
                                progressDialog,
                                peptideShakerGUI.getExceptionHandler()
                        );

                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();

                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(
                                    FollowUpExportDialog.this,
                                    "Results exported to \'"
                                    + finalOutputFile.getName() + "\'.",
                                    "Export Complete",
                                    JOptionPane.INFORMATION_MESSAGE
                            );
                        }
                    } catch (Exception e) {
                        progressDialog.setRunFinished();
                        peptideShakerGUI.catchException(e);
                    }
                }
            }.start();
        }
    }//GEN-LAST:event_tppExportButtonActionPerformed

    /**
     * Exports the identifications to Skyline.
     *
     * @param evt
     */
    private void skylineExportButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_skylineExportButtonActionPerformed
        skylineExport();
    }//GEN-LAST:event_skylineExportButtonActionPerformed

    /**
     * Export the data as a graph database.
     *
     * @param evt
     */
    private void graphDatabasetButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_graphDatabasetButtonActionPerformed

        final File selectedFolder = FileChooserUtil.getUserSelectedFolder(
                this,
                "Select Result Folder",
                getLastSelectedFolder(),
                "Database Folder",
                "Save",
                false
        );

        if (selectedFolder != null) {

            setLastSelectedFolder(selectedFolder.getAbsolutePath());

            progressDialog = new ProgressDialogX(
                    peptideShakerGUI,
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker-orange.gif")),
                    true
            );
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting. Please Wait...");

            new Thread(new Runnable() {
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    } catch (IndexOutOfBoundsException e) {
                        // ignore
                    }
                }
            }, "ProgressDialog").start();

            new Thread("ExportThread") {
                @Override
                public void run() {

                    // @TODO: move code below to a gui independent export option!
                    boolean exported = false;

                    // database graph formats info:
                    // cytoscape: http://cytoscape.org/manual/Cytoscape2_6Manual.html#Import Free-Format Table Files
                    // gephi: https://gephi.org/users/supported-graph-formats/spreadsheet/
                    // neo4j: http://blog.neo4j.org/2013/03/importing-data-into-neo4j-spreadsheet.html
                    // make a list of the proteins added as nodes, as to not add them more than once
                    HashSet<Long> proteinsAdded = new HashSet<>();

                    // write the nodes
                    try ( SimpleFileWriter nodeWriter = new SimpleFileWriter(new File(selectedFolder, "nodes.txt"), false)) {
                        try ( SimpleFileWriter edgeWriter = new SimpleFileWriter(new File(selectedFolder, "edges.txt"), false)) {

                            // write the header
                            if (((String) graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Cytoscape")) {
                                nodeWriter.writeLine("id\tlabel\ttype\tvalidated\tdecoy");
                                edgeWriter.writeLine("source\ttarget\tinteraction");
                            } else if (((String) graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Gephi")) {
                                nodeWriter.writeLine("id\tlabel\ttype\tvalidated\tdecoy");
                                edgeWriter.writeLine("source\ttarget\tlabel");
                            } else if (((String) graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {
                                nodeWriter.writeLine("BEGIN");
                                edgeWriter.writeLine("BEGIN");
                            }

                            //                        // write the protein nodes
                            //                        progressDialog.setTitle("Getting Protein Details. Please Wait...");
                            //                        progressDialog.setPrimaryProgressCounterIndeterminate(true);
                            //                        peptideShakerGUI.getIdentification().loadProteinMatches(progressDialog);
                            //
                            // @TODO: the below code couldn't be used as it deals with protein groups and not individual proteins
                            //                        progressDialog.setTitle("Writing Protein Details. Please Wait...");
                            //                        progressDialog.resetPrimaryProgressCounter();
                            //                        progressDialog.setMaxPrimaryProgressCounter(peptideShakerGUI.getIdentification().getProteinIdentification().size());
                            //
                            //                        for (String proteinKey : peptideShakerGUI.getIdentification().getProteinIdentification()) {
                            //                            PSParameter probabilities = new PSParameter();
                            //                            probabilities = (PSParameter) peptideShakerGUI.getIdentification().getProteinMatchParameter(proteinKey, probabilities);
                            //                            ProteinMatch proteinMatch = peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
                            //                            nodeWriter.write(proteinKey + "\t" + proteinMatch.getMainMatch() + "\tprotein" + "\t" + probabilities.isValidated() + "\t" + proteinMatch.isDecoy() + "\n"); // @TODO: add more information?
                            //                            progressDialog.increasePrimaryProgressCounter();
                            //                        }
                            // write the peptide nodes
                            progressDialog.setTitle("Writing Peptide Details. Please Wait...");
                            progressDialog.resetPrimaryProgressCounter();
                            progressDialog.setMaxPrimaryProgressCounter(peptideShakerGUI.getIdentification().getPeptideIdentification().size());

                            PeptideMatchesIterator peptideMatchesIterator = peptideShakerGUI.getIdentification().getPeptideMatchesIterator(progressDialog);
                            PeptideMatch peptideMatch;

                            while ((peptideMatch = peptideMatchesIterator.next()) != null) {

                                long peptideKey = peptideMatch.getKey();
                                PSParameter psParameter = (PSParameter) peptideMatch.getUrParam(PSParameter.dummy);

                                IdentificationParameters identificationParameters = peptideShakerGUI.getIdentificationParameters();
                                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                                String modifiedSequence = peptideMatch.getPeptide().getTaggedModifiedSequence(modificationParameters, peptideShakerGUI.getSequenceProvider(),
                                        modificationSequenceMatchingParameters, false, false, true, peptideShakerGUI.getDisplayParameters().getDisplayedModifications());

                                // write the peptide node
                                if (((String) graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {
                                    String node = String.join("",
                                            "create n={id:'",
                                            Long.toString(peptideKey),
                                            "', name:'",
                                            modifiedSequence,
                                            "', type:'Peptide'};");
                                    nodeWriter.writeLine(node);

                                } else {

                                    nodeWriter.writeLine(
                                            Long.toString(peptideKey),
                                            modifiedSequence,
                                            "peptide",
                                            psParameter.getMatchValidationLevel().getName(),
                                            Boolean.toString(PeptideUtils.isDecoy(peptideMatch.getPeptide(), peptideShakerGUI.getSequenceProvider()))
                                    );

                                }

                                // write the peptide to protein edge and the protein nodes
                                for (String proteinAccession : peptideMatch.getPeptide().getProteinMapping().keySet()) {

                                    long proteinKey = ExperimentObject.asLong(proteinAccession);

                                    // write the protein node
                                    if (!proteinsAdded.contains(proteinKey)) {

                                        proteinsAdded.add(proteinKey);
                                        ProteinMatch proteinMatch = (ProteinMatch) peptideShakerGUI.getIdentification().retrieveObject(proteinKey);

                                        if (proteinMatch != null) {

                                            psParameter = (PSParameter) proteinMatch.getUrParam(PSParameter.dummy);

                                            if (((String) graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {

                                                nodeWriter.writeLine("create n={id:'" + proteinKey + "', name:'" + proteinAccession + "', type:'Protein'};");

                                            } else {

                                                nodeWriter.writeLine( // @TODO: add more information?
                                                        proteinAccession,
                                                        Long.toString(proteinKey),
                                                        "protein",
                                                        psParameter.getMatchValidationLevel().getName(),
                                                        Boolean.toString(proteinMatch.isDecoy())
                                                );

                                            }

                                        } else {

                                            if (((String) graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {

                                                nodeWriter.writeLine("create n={id:'" + proteinAccession + "', name:'" + proteinAccession + "', type:'Protein'};");

                                            } else {

                                                nodeWriter.writeLine( // @TODO: add more information?
                                                        proteinAccession,
                                                        proteinAccession,
                                                        "protein",
                                                        "shared",
                                                        Boolean.toString(ProteinUtils.isDecoy(proteinAccession, peptideShakerGUI.getSequenceProvider()))
                                                );

                                            }
                                        }
                                    }

                                    // write the peptide to protein edge
                                    if (((String) graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {

                                        edgeWriter.writeLine("start n1=node:node_auto_index(id='" + peptideKey + "'),n2=node:node_auto_index(id='" + proteinAccession + "') create unique n1-[:MAPS_TO]->n2;");

                                    } else {

                                        edgeWriter.writeLine(
                                                Long.toString(peptideKey),
                                                proteinAccession,
                                                "peptide_to_protein"
                                        );
                                    }
                                }

                                progressDialog.increasePrimaryProgressCounter();
                            }

                            if (((String) graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {

                                nodeWriter.writeLine("COMMIT");
                                edgeWriter.writeLine("COMMIT");

                            }

                            // write the spectrum nodes
                            // @TODO: implement me
                            // @TODO: implement other node types
                            proteinsAdded.clear();

                            exported = true;

                        }

                    } catch (Exception e) {
                        progressDialog.setRunCanceled();
                        peptideShakerGUI.catchException(e);
                    }

                    boolean processCancelled = progressDialog.isRunCanceled();
                    progressDialog.setRunFinished();

                    if (!processCancelled) {

                        if (exported) {
                            JOptionPane.showMessageDialog(FollowUpExportDialog.this,
                                    "Graph database saved to folder \'" + selectedFolder.getAbsolutePath() + "\'.",
                                    "Save Complete", JOptionPane.INFORMATION_MESSAGE);
                        } else {
                            JOptionPane.showMessageDialog(FollowUpExportDialog.this,
                                    "An error occurred during exporting. See resources/PeptideShaker.log for details.",
                                    "Export Error", JOptionPane.ERROR_MESSAGE);
                        }
                    }
                }
            }
                    .start();
        }
    }//GEN-LAST:event_graphDatabasetButtonActionPerformed

    /**
     * Export all the identified protein accession numbers to a tab separated
     * text file.
     *
     * @param evt
     */
    private void exportIdentifiedProteinAccessionNumbersAsCsvButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportIdentifiedProteinAccessionNumbersAsCsvButtonActionPerformed
        exportFasta(true);
    }//GEN-LAST:event_exportIdentifiedProteinAccessionNumbersAsCsvButtonActionPerformed

    /**
     * Export all the identified proteins to a FASTA file.
     *
     * @param evt
     */
    private void exportIdentifiedProteinsAsFastaButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportIdentifiedProteinsAsFastaButtonActionPerformed
        exportFasta(false);
    }//GEN-LAST:event_exportIdentifiedProteinsAsFastaButtonActionPerformed

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void exportToProgenesisLinkLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exportToProgenesisLinkLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_exportToProgenesisLinkLabelMouseExited

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void exportToProgenesisLinkLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exportToProgenesisLinkLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_exportToProgenesisLinkLabelMouseEntered

    /**
     * Open the Progenesis home page.
     *
     * @param evt
     */
    private void exportToProgenesisLinkLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exportToProgenesisLinkLabelMouseClicked
        JOptionPane.showMessageDialog(
                this,
                JOptionEditorPane.getJOptionEditorPane(
                        "<a href=\"http://www.nonlinear.com/products/progenesis/lc-ms/overview/\">Progenesis</a> does not yet have a specific PeptideShaker import. In order to get the<br>"
                        + "identifications back into Progenesis one therefore has to rely on the Phenyx import<br>"
                        + "format, i.e., select 'Phenyx' when importing the results back into Progenesis.<br><br>"
                        + "Note that converting to the 'Phenyx' format simplifies the identification results.<br><br>"
                        + "If you would like to see a proper PeptideShaker import please contact <a href=\"http://www.nonlinear.com/products/progenesis/lc-ms/overview/\">Progenesis</a>."
                ),
                "Progenesis Help",
                JOptionPane.WARNING_MESSAGE
        );
    }//GEN-LAST:event_exportToProgenesisLinkLabelMouseClicked

    /**
     * Export the Spectrum IDs as a Phenyx tab separated text file for input to
     * Progenesis. Only works if the mgf files came from Progenesis in the first
     * place.
     *
     * @param evt
     */
    private void exportProgenesisButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportProgenesisButtonActionPerformed

        final File finalOutputFile = peptideShakerGUI.getUserSelectedFile(
                "progenesis_psm_export.txt",
                ".txt",
                "Tab Separated Text File (*.txt)",
                "Select Destination File",
                false
        );

        if (finalOutputFile != null) {

            progressDialog = new ProgressDialogX(
                    this,
                    peptideShakerGUI,
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker-orange.gif")),
                    true
            );
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting PSMs. Please Wait...");

            final int userChoice = psmSelectionComboBox.getSelectedIndex();
            HashSet<String> modifications = new HashSet<>(0);
            if (userChoice == 3) {
                ModificationChooser modificationChooser = new ModificationChooser(
                        peptideShakerGUI,
                        peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getAllNotFixedModifications(),
                        true
                );
                if (modificationChooser.isCanceled()) {
                    return;
                }
                modifications = modificationChooser.getSelectedItems();
            }
            final HashSet<String> modificationSelection = modifications;

            new Thread(new Runnable() {
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    } catch (IndexOutOfBoundsException e) {
                        // ignore
                    }
                }
            }, "ProgressDialog").start();

            new Thread("ProgenesisPsmThread") {
                @Override
                public void run() {
                    try {

                        ProgenesisExport.writeProgenesisExport(
                                finalOutputFile,
                                peptideShakerGUI.getSequenceProvider(),
                                peptideShakerGUI.getProteinDetailsProvider(),
                                peptideShakerGUI.getIdentification(),
                                ProgenesisExport.ExportType.getTypeFromIndex(userChoice),
                                progressDialog,
                                modificationSelection,
                                peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters()
                        );

                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();

                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(
                                    FollowUpExportDialog.this,
                                    "Results exported to \'" + finalOutputFile.getName() + "\'.",
                                    "Export Complete",
                                    JOptionPane.INFORMATION_MESSAGE
                            );
                        }
                    } catch (Exception e) {
                        progressDialog.setRunFinished();
                        peptideShakerGUI.catchException(e);
                    }
                }
            }.start();
        }
    }//GEN-LAST:event_exportProgenesisButtonActionPerformed

    /**
     * Export the inclusion list to file.
     *
     * @param evt
     */
    private void inclusionListButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inclusionListButtonActionPerformed
        new InclusionListExportDialog(
                this, 
                InclusionListExport.ExportFormat.getTypeFromIndex(inclusionListFormat.getSelectedIndex()), 
                true
        );
    }//GEN-LAST:event_inclusionListButtonActionPerformed

    /**
     * Recalibrate the spectra.
     *
     * @param evt
     */
    private void recalibrateMgfButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_recalibrateMgfButtonActionPerformed
        recalibrateSpectra();
    }//GEN-LAST:event_recalibrateMgfButtonActionPerformed

    /**
     * Export the given spectra as an mgf file.
     *
     * @param evt
     */
    private void exportMgfButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportMgfButtonActionPerformed

        final File selectedFolder = FileChooserUtil.getUserSelectedFolder(
                this, 
                "Select Output Folder", 
                getLastSelectedFolder(), 
                "Output Folder", 
                "Select", 
                false
        );

        if (selectedFolder != null) {

            setLastSelectedFolder(selectedFolder.getAbsolutePath());

            progressDialog = new ProgressDialogX(
                    this, 
                    peptideShakerGUI,
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker-orange.gif")),
                    true
            );
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting Spectra. Please Wait...");

            new Thread(new Runnable() {
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    } catch (IndexOutOfBoundsException e) {
                        // ignore
                    }
                }
            }, "ProgressDialog").start();

            new Thread("SaveThread") {
                @Override
                public void run() {

                    try {
                        
                        SpectrumExporter spectrumExporter = new SpectrumExporter(
                                peptideShakerGUI.getIdentification(),
                                peptideShakerGUI.getSpectrumProvider()
                        );
                        spectrumExporter.exportSpectra(
                                selectedFolder, 
                                progressDialog, 
                                SpectrumExporter.ExportType.getTypeFromIndex(spectrumValidationCmb.getSelectedIndex()), 
                                peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters()
                        );

                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();

                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(
                                    FollowUpExportDialog.this, 
                                    "Spectra saved to " + selectedFolder.getAbsolutePath() + ".", 
                                    "Save Complete", 
                                    JOptionPane.INFORMATION_MESSAGE
                            );
                        }
                    } catch (Exception e) {
                        
                        progressDialog.setRunFinished();
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(
                                FollowUpExportDialog.this, 
                                "An error occurred when saving the file.", 
                                "Saving Failed", 
                                JOptionPane.ERROR_MESSAGE
                        );
                    }
                }
            }.start();
        }
    }//GEN-LAST:event_exportMgfButtonActionPerformed

    /**
     * Export the proteoforms in the format compatible with PathwayMatcher.
     *
     * @param evt
     */
    private void exportProteformsAsTxtButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportProteformsAsTxtButtonActionPerformed

        final File finalOutputFile = peptideShakerGUI.getUserSelectedFile(
                "proteoforms.txt", 
                ".txt", 
                "Tab Separated Text File (*.txt)", 
                "Select Destination File", 
                false
        );

        if (finalOutputFile != null) {

            progressDialog = new ProgressDialogX(
                    this, 
                    peptideShakerGUI,
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker-orange.gif")),
                    true
            );
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting Proteoforms. Please Wait...");

            new Thread(new Runnable() {
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    } catch (IndexOutOfBoundsException e) {
                        // ignore
                    }
                }
            }, "ProgressDialog").start();

            new Thread("ProteoformsThread") {
                @Override
                public void run() {
                    try {

                        ProteoformExport.writeProteoforms(
                                finalOutputFile, 
                                peptideShakerGUI.getIdentification(), 
                                progressDialog
                        );

                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();

                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(
                                    FollowUpExportDialog.this, 
                                    "Results exported to \'" + finalOutputFile.getName() + "\'.", 
                                    "Export Complete", 
                                    JOptionPane.INFORMATION_MESSAGE
                            );
                        }
                    } catch (Exception e) {
                        progressDialog.setRunFinished();
                        peptideShakerGUI.catchException(e);
                    }
                }
            }.start();
        }
    }//GEN-LAST:event_exportProteformsAsTxtButtonActionPerformed

    /**
     * Export the peptide sequences to Unipept.
     *
     * @param evt
     */
    private void unipeptExportButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_unipeptExportButtonActionPerformed

        progressDialog = new ProgressDialogX(
                this, 
                peptideShakerGUI,
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker-orange.gif")),
                true
        );
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Exporting Peptide Sequences. Please Wait...");

        final int PEPTIDE_EXPORT_TYPE = unipeptiExportCmb.getSelectedIndex();

        new Thread(new Runnable() {
            public void run() {
                try {
                    progressDialog.setVisible(true);
                } catch (IndexOutOfBoundsException e) {
                    // ignore
                }
            }
        }, "ProgressDialog").start();

        new Thread("UnipeptExportThread") {
            @Override
            public void run() {
                try {

                    ArrayList<String> peptideSequences = new ArrayList<>();

                    PSParameter psParameter = new PSParameter();
                    ArrayList<UrParameter> parameters = new ArrayList<>(1);
                    parameters.add(psParameter);

                    if (PEPTIDE_EXPORT_TYPE == 0 || PEPTIDE_EXPORT_TYPE == 1) {

                        progressDialog.resetPrimaryProgressCounter();
                        progressDialog.setMaxPrimaryProgressCounter(peptideShakerGUI.getIdentification().getPeptideIdentification().size());

                        PeptideMatchesIterator peptideMatchesIterator = peptideShakerGUI.getIdentification().getPeptideMatchesIterator(progressDialog);
                        PeptideMatch peptideMatch;

                        while ((peptideMatch = peptideMatchesIterator.next()) != null) {

                            if (progressDialog.isRunCanceled()) {
                                break;
                            }

                            Peptide peptide = peptideMatch.getPeptide();
                            psParameter = (PSParameter) peptideMatch.getUrParam(PSParameter.dummy);

                            if (!PeptideUtils.isDecoy(peptide, peptideShakerGUI.getSequenceProvider())) {
                                if (PEPTIDE_EXPORT_TYPE == 1 || psParameter.getMatchValidationLevel().isValidated()) {
                                    peptideSequences.add(peptide.getSequence()); // @TODO: support filtering for unique sequences?
                                }
                            }

                            progressDialog.increasePrimaryProgressCounter();
                        }

                    } else {

                        progressDialog.resetPrimaryProgressCounter();
                        progressDialog.setMaxPrimaryProgressCounter(peptideShakerGUI.getIdentification().getPeptideIdentification().size());

                        SpectrumMatchesIterator spectrumMatchIerator = peptideShakerGUI.getIdentification().getSpectrumMatchesIterator(progressDialog);
                        SpectrumMatch spectrumMatch;

                        while ((spectrumMatch = spectrumMatchIerator.next()) != null) {

                            if (progressDialog.isRunCanceled()) {
                                break;
                            }

                            psParameter = (PSParameter) spectrumMatch.getUrParam(PSParameter.dummy);

                            if (PEPTIDE_EXPORT_TYPE == 3 || psParameter.getMatchValidationLevel().isValidated()) {

                                PeptideAssumption bestAssumption = spectrumMatch.getBestPeptideAssumption();

                                if (!PeptideUtils.isDecoy(bestAssumption.getPeptide(), peptideShakerGUI.getSequenceProvider())) {
                                    peptideSequences.add(bestAssumption.getPeptide().getSequence()); // @TODO: support filtering for unique sequences?
                                }
                            }

                            progressDialog.increasePrimaryProgressCounter();
                        }
                    }

                    if (!progressDialog.isRunCanceled()) {
                        UnipeptExport.analyzeInUnipept(
                                peptideSequences, 
                                true, 
                                true, 
                                false, // @TODO: allow the user to alter the boolean variables?
                                new File(PSExportFactory.getJsonFolder(), "UnipeptExport.html"), 
                                progressDialog
                        );
                    }

                    progressDialog.setRunFinished();

                } catch (Exception e) {
                    progressDialog.setRunCanceled();
                    peptideShakerGUI.catchException(e);
                }
            }
        }.start();
    }//GEN-LAST:event_unipeptExportButtonActionPerformed

    /**
     * Creates an mzIdentML file for Skyline.
     */
    private void skylineExport() {
        new MzIdentMLExportDialog(
                peptideShakerGUI, 
                true
        );
    }

    /**
     * Export proteins.
     *
     * @param accessionsOnly if true, only accession numbers are exported
     */
    private void exportFasta(boolean accessionsOnly) {

        // get the file to send the output to
        final File selectedFile;
        
        if (accessionsOnly) {
        
            selectedFile = peptideShakerGUI.getUserSelectedFile(
                    "proteins.txt", 
                    ".txt", 
                    "Supported formats: text format (.txt)", 
                    "Select Destination File", 
                    false
            );
        
        } else {
        
            selectedFile = peptideShakerGUI.getUserSelectedFile(
                    "proteins.fasta", 
                    ".fasta", 
                    "Supported formats: FASTA format (.fasta)", 
                    "Select Destination File", 
                    false
            );
        }
        
        final boolean finalAccessionsOnly = accessionsOnly;

        if (selectedFile != null) {

            progressDialog = new ProgressDialogX(
                    this, 
                    peptideShakerGUI,
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker-orange.gif")),
                    true
            );
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting. Please Wait...");

            new Thread(new Runnable() {
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    } catch (IndexOutOfBoundsException e) {
                        // ignore
                    }
                }
            }, "ProgressDialog").start();

            new Thread("ExportThread") {
                @Override
                public void run() {

                    try {

                        SequenceProvider sequenceProvider = peptideShakerGUI.getSequenceProvider();

                        FastaExport.ExportType exportType = finalAccessionsOnly
                                ? FastaExport.ExportType.getTypeFromIndex(proteinExportCmb1.getSelectedIndex())
                                : FastaExport.ExportType.getTypeFromIndex(proteinExportCmb2.getSelectedIndex());

                        IdentificationFeaturesGenerator identificationFeaturesGenerator = peptideShakerGUI.getIdentificationFeaturesGenerator();

                        progressDialog.setPrimaryProgressCounterIndeterminate(false);

                        if (exportType == FastaExport.ExportType.non_validated) {

                            progressDialog.setMaxPrimaryProgressCounter(sequenceProvider.getAccessions().size());

                        } else {

                            progressDialog.setMaxPrimaryProgressCounter(identificationFeaturesGenerator.getNValidatedProteins());

                        }

                        FastaExport.export(
                                selectedFile, 
                                sequenceProvider, 
                                peptideShakerGUI.getIdentification(), 
                                exportType, 
                                progressDialog, 
                                finalAccessionsOnly
                        );

                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();

                        if (!processCancelled) {

                            JOptionPane.showMessageDialog(
                                    FollowUpExportDialog.this, 
                                    "Identified proteins exported to " + selectedFile.getPath() + ".", 
                                    "Export Complete", 
                                    JOptionPane.INFORMATION_MESSAGE
                            );

                        }
                    } catch (Exception e) {

                        progressDialog.setRunFinished();
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(
                                FollowUpExportDialog.this, 
                                "An error occurred when exporting the data.", 
                                "Export Failed", 
                                JOptionPane.ERROR_MESSAGE
                        );
                    }
                }
            }.start();
        }
    }

    /**
     * Lets the user select an output folder and starts the recalibration of
     * spectra.
     */
    public void recalibrateSpectra() {

        final File selectedFolder = FileChooserUtil.getUserSelectedFolder(
                this, 
                "Select Output Folder", 
                getLastSelectedFolder(), 
                "Output Folder", 
                "Select", 
                false
        );

        if (selectedFolder != null) {

            setLastSelectedFolder(selectedFolder.getAbsolutePath());

            for (String fileName : peptideShakerGUI.getSpectrumProvider().getOrderedFileNamesWithoutExtensions()) {
                
                String newName = RecalibrationExporter.getRecalibratedFileName(fileName);
                File testFile = new File(selectedFolder, newName);
                
                if (testFile.exists()) {
                
                    int outcome = JOptionPane.showConfirmDialog(
                            this,
                            "File(s) already exist, shall it be overwritten?", 
                            "Selected File(s) Already Exists",
                            JOptionPane.YES_NO_OPTION, 
                            JOptionPane.WARNING_MESSAGE
                    );
                    
                    if (outcome != JOptionPane.YES_OPTION) {
                    
                        return;
                    
                    } else {
                    
                        break;
                    
                    }
                }
            }

            progressDialog = new ProgressDialogX(
                    this, 
                    peptideShakerGUI,
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker-orange.gif")),
                    true
            );
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting. Please Wait...");

            int selection = spectrumRecalibrationCmb.getSelectedIndex();
            final boolean precursors = selection == 0 || selection == 1;
            final boolean fragments = selection == 0 || selection == 2;

            new Thread(new Runnable() {
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    } catch (IndexOutOfBoundsException e) {
                        // ignore
                    }
                }
            }, "ProgressDialog").start();

            new Thread("SaveThread") {
                @Override
                public void run() {
                    try {
                        RecalibrationExporter.writeRecalibratedSpectra(
                                precursors, 
                                fragments, 
                                selectedFolder,
                                peptideShakerGUI.getIdentification(), 
                                peptideShakerGUI.getSequenceProvider(),
                                peptideShakerGUI.getSpectrumProvider(),
                                peptideShakerGUI.getIdentificationParameters(), 
                                progressDialog
                        );

                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();

                        if (!processCancelled) {
                            
                            JOptionPane.showMessageDialog(
                                    FollowUpExportDialog.this,
                                    "Recalibrated spectra saved to " + selectedFolder.getAbsolutePath() + ".", 
                                    "Save Complete", 
                                    JOptionPane.INFORMATION_MESSAGE
                            );
                        }
                    } catch (Exception e) {
                        peptideShakerGUI.catchException(e);
                    } finally {
                        progressDialog.setRunFinished();
                    }
                }
            }.start();
        }
    }

    /**
     * Returns the last selected folder.
     *
     * @return the last selected folder
     */
    private String getLastSelectedFolder() {
        LastSelectedFolder lastSelectedFolder = peptideShakerGUI.getLastSelectedFolder();
        String folder = lastSelectedFolder.getLastSelectedFolder(ExportWriter.LAST_FOLDER_KEY);
        if (folder == null) {
            folder = lastSelectedFolder.getLastSelectedFolder();
        }
        return folder;
    }

    /**
     * Sets the last selected folder.
     *
     * @param folder the path to the folder
     */
    private void setLastSelectedFolder(String folder) {
        peptideShakerGUI.getLastSelectedFolder().setLastSelectedFolder(ExportWriter.LAST_FOLDER_KEY, folder);
    }

    /**
     * Returns the references to the PeptideShakerGUI.
     *
     * @return the references to the PeptideShakerGUI
     */
    public PeptideShakerGUI getPeptideShakerGUI() {
        return peptideShakerGUI;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JLabel exportAllIdentifiedProteinAccessionsLabel;
    private javax.swing.JLabel exportAllIdentifiedProteinsAsFastaLabel;
    private javax.swing.JButton exportIdentifiedProteinAccessionNumbersAsCsvButton;
    private javax.swing.JButton exportIdentifiedProteinsAsFastaButton;
    private javax.swing.JButton exportMgfButton;
    private javax.swing.JButton exportProgenesisButton;
    private javax.swing.JButton exportProteformsAsTxtButton;
    private javax.swing.JLabel exportSpectraLabel;
    private javax.swing.JLabel exportToProgenesisLinkLabel;
    private javax.swing.JComboBox graphDatabaseFormat;
    private javax.swing.JLabel graphDatabasesLabel;
    private javax.swing.JPanel graphDatabasesPanel;
    private javax.swing.JButton graphDatabasetButton;
    private javax.swing.JLabel includeValidatedPsmsLabel;
    private javax.swing.JButton inclusionListButton;
    private javax.swing.JComboBox inclusionListFormat;
    private javax.swing.JPanel inclusionListPanel;
    private javax.swing.JPanel progenesisPanel;
    private javax.swing.JComboBox proteinExportCmb1;
    private javax.swing.JComboBox proteinExportCmb2;
    private javax.swing.JPanel proteinsPanel;
    private javax.swing.JComboBox proteoformsExportCmb;
    private javax.swing.JLabel proteoformsLabel;
    private javax.swing.JComboBox psmSelectionComboBox;
    private javax.swing.JButton recalibrateMgfButton;
    private javax.swing.JLabel recalibrateSpectraLabel;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JPanel scrollPanel;
    private javax.swing.JButton skylineExportButton;
    private javax.swing.JComboBox skylineExportCmb;
    private javax.swing.JLabel skylineExportLabel;
    private javax.swing.JPanel skylinePanel;
    private javax.swing.JPanel spectraPanel;
    private javax.swing.JComboBox spectrumRecalibrationCmb;
    private javax.swing.JComboBox spectrumValidationCmb;
    private javax.swing.JButton tppExportButton;
    private javax.swing.JComboBox tppExportCmb;
    private javax.swing.JLabel tppLabel;
    private javax.swing.JPanel tppPanel;
    private javax.swing.JButton unipeptExportButton;
    private javax.swing.JLabel unipeptLabel;
    private javax.swing.JPanel unipeptPanel;
    private javax.swing.JComboBox unipeptiExportCmb;
    // End of variables declaration//GEN-END:variables
}
