package eu.isas.peptideshaker.gui.parameters;

import com.compomics.util.gui.error_handlers.HelpDialog;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import java.awt.Dialog;
import java.awt.Toolkit;

/**
 * A dialog where the user can edit the PeptideShaker preferences.
 *
 * @author Harald Barsnes
 * @author Marc Vaudel
 */
public class ProjectParametersDialog extends javax.swing.JDialog {

    /**
     * The parent frame.
     */
    private java.awt.Frame parentFrame;
    /**
     * The spectrum counting preferences.
     */
    private SpectrumCountingParameters spectrumCountingPreferences;
    /**
     * The display preferences.
     */
    private DisplayParameters displayPreferences;
    /**
     * Boolean indicating whether the user canceled the edition of preferences.
     */
    private boolean canceled = false;

    /**
     * Creates a new PreferencesDialog with a dialog as owner.
     *
     * @param parentFrame the parent frame
     * @param owner the owner
     * @param spectrumCountingPreferences the spectrum counting preferences
     * @param displayPreferences the display preferences
     */
    public ProjectParametersDialog(
            java.awt.Frame parentFrame, 
            Dialog owner, 
            SpectrumCountingParameters spectrumCountingPreferences, 
            DisplayParameters displayPreferences
    ) {
        
        super(owner, true);
        initComponents();

        this.parentFrame = parentFrame;
        this.spectrumCountingPreferences = spectrumCountingPreferences;
        this.displayPreferences = displayPreferences;

        setLocationRelativeTo(owner);
        setVisible(true);
    }

    /**
     * Creates a new PreferencesDialog with a frame as owner.
     *
     * @param parentFrame the parent frame
     * @param spectrumCountingPreferences the spectrum counting preferences
     * @param displayPreferences the display preferences
     */
    public ProjectParametersDialog(
            java.awt.Frame parentFrame, 
            SpectrumCountingParameters spectrumCountingPreferences, 
            DisplayParameters displayPreferences
    ) {
        
        super(parentFrame, true);
        initComponents();

        this.parentFrame = parentFrame;
        this.spectrumCountingPreferences = spectrumCountingPreferences;
        this.displayPreferences = displayPreferences;

        setLocationRelativeTo(parentFrame);
        setVisible(true);
    }

    /**
     * Returns the display preferences.
     *
     * @return the display preferences
     */
    public DisplayParameters getDisplayParameters() {
        return displayPreferences;
    }

    /**
     * Returns the spectrum counting preferences.
     *
     * @return the spectrum counting preferences
     */
    public SpectrumCountingParameters getSpectrumCountingParameters() {
        return spectrumCountingPreferences;
    }

    /**
     * Returns whether the user canceled the edition of the preferences.
     *
     * @return a boolean indicating whether the user canceled the edition of the
     * preferences.
     */
    public boolean isCanceled() {
        return canceled;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        backgroundPanel = new javax.swing.JPanel();
        helpJButton = new javax.swing.JButton();
        preferencesPanel = new javax.swing.JPanel();
        spectrumQuantificationLbl = new javax.swing.JLabel();
        editSpectrumQuantificationButton = new javax.swing.JButton();
        editDisplayPreferencesButton = new javax.swing.JButton();
        displayLbl = new javax.swing.JLabel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Preferences");
        setResizable(false);

        backgroundPanel.setBackground(new java.awt.Color(230, 230, 230));

        helpJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/help.GIF"))); // NOI18N
        helpJButton.setToolTipText("Help");
        helpJButton.setBorder(null);
        helpJButton.setBorderPainted(false);
        helpJButton.setContentAreaFilled(false);
        helpJButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                helpJButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                helpJButtonMouseExited(evt);
            }
        });
        helpJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpJButtonActionPerformed(evt);
            }
        });

        preferencesPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Project Preferences"));
        preferencesPanel.setOpaque(false);

        spectrumQuantificationLbl.setText("Spectrum Quantification");

        editSpectrumQuantificationButton.setText("Edit");
        editSpectrumQuantificationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editSpectrumQuantificationButtonActionPerformed(evt);
            }
        });

        editDisplayPreferencesButton.setText("Edit");
        editDisplayPreferencesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editDisplayPreferencesButtonActionPerformed(evt);
            }
        });

        displayLbl.setText("Display");

        javax.swing.GroupLayout preferencesPanelLayout = new javax.swing.GroupLayout(preferencesPanel);
        preferencesPanel.setLayout(preferencesPanelLayout);
        preferencesPanelLayout.setHorizontalGroup(
            preferencesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(preferencesPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(preferencesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(spectrumQuantificationLbl)
                    .addComponent(displayLbl))
                .addGap(18, 18, 18)
                .addGroup(preferencesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(editSpectrumQuantificationButton, javax.swing.GroupLayout.DEFAULT_SIZE, 155, Short.MAX_VALUE)
                    .addComponent(editDisplayPreferencesButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        preferencesPanelLayout.setVerticalGroup(
            preferencesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(preferencesPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(preferencesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(spectrumQuantificationLbl)
                    .addComponent(editSpectrumQuantificationButton))
                .addGap(0, 0, 0)
                .addGroup(preferencesPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(editDisplayPreferencesButton)
                    .addComponent(displayLbl))
                .addContainerGap())
        );

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(preferencesPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(backgroundPanelLayout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addComponent(helpJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cancelButton)))
                .addContainerGap())
        );
        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(preferencesPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(helpJButton)
                    .addComponent(okButton)
                    .addComponent(cancelButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Saves the setting and then closes the dialog.
     *
     * @param evt
     */
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        dispose();
    }//GEN-LAST:event_okButtonActionPerformed

    /**
     * Closes the dialog.
     *
     * @param evt
     */
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        canceled = true;
        dispose();
    }//GEN-LAST:event_cancelButtonActionPerformed

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void helpJButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_helpJButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_helpJButtonMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void helpJButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_helpJButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_helpJButtonMouseExited

    /**
     * Open the help dialog.
     *
     * @param evt
     */
    private void helpJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpJButtonActionPerformed
        
        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        
        new HelpDialog(
                parentFrame, 
                getClass().getResource("/helpFiles/PreferencesDialog.html"),
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/help.GIF")),
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                "Preferences - Help"
        );
        
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        
    }//GEN-LAST:event_helpJButtonActionPerformed

    /**
     * Edit the spectrum quantification settings.
     * 
     * @param evt 
     */
    private void editSpectrumQuantificationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editSpectrumQuantificationButtonActionPerformed
        
        SpectrumCountingSettingsDialog spectrumCountingPreferencesDialog 
                = new SpectrumCountingSettingsDialog(parentFrame, spectrumCountingPreferences);
        
        if (!spectrumCountingPreferencesDialog.isCanceled()) {
            spectrumCountingPreferences = spectrumCountingPreferencesDialog.getSpectrumCountingPreferences();
        }
        
    }//GEN-LAST:event_editSpectrumQuantificationButtonActionPerformed

    /**
     * Edit the display preferences.
     * 
     * @param evt 
     */
    private void editDisplayPreferencesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editDisplayPreferencesButtonActionPerformed
        
        DisplayPreferencesDialog displayPreferencesDialog 
                = new DisplayPreferencesDialog(parentFrame, displayPreferences);
        
        if (!displayPreferencesDialog.isCanceled()) {
            displayPreferences = displayPreferencesDialog.getDisplayPreferences();
        }
        
    }//GEN-LAST:event_editDisplayPreferencesButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel displayLbl;
    private javax.swing.JButton editDisplayPreferencesButton;
    private javax.swing.JButton editSpectrumQuantificationButton;
    private javax.swing.JButton helpJButton;
    private javax.swing.JButton okButton;
    private javax.swing.JPanel preferencesPanel;
    private javax.swing.JLabel spectrumQuantificationLbl;
    // End of variables declaration//GEN-END:variables
}
