package eu.isas.peptideshaker.gui.tabpanels;

import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.io.biology.protein.ProteinDatabase;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import static com.compomics.util.experiment.personalization.ExperimentObject.NO_KEY;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportScheme;
import eu.isas.peptideshaker.export.PSExportFactory;
import com.compomics.util.io.export.features.peptideshaker.PsProteinFeature;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;

/**
 * This tab contains the basic protein annotation and links to other protein
 * resources.
 *
 * @author Harald Barsnes
 */
public class AnnotationPanel extends javax.swing.JPanel {

    /**
     * The current protein accession number.
     */
    private String currentAccessionNumber = "";
    /**
     * The PeptideShakerGUI parent.
     */
    private final PeptideShakerGUI peptideShakerGUI;
    /**
     * A simple progress dialog.
     */
    private static ProgressDialogX progressDialog;

    /**
     * Creates a new AnnotationPanel.
     *
     * @param peptideShakerGUI the PeptideShakerGUI parent
     */
    public AnnotationPanel(PeptideShakerGUI peptideShakerGUI) {
        initComponents();
        this.peptideShakerGUI = peptideShakerGUI;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        basicAnnotationJPanel = new javax.swing.JPanel();
        accessionNumberLabel = new javax.swing.JLabel();
        accessionNumberJTextField = new javax.swing.JTextField();
        descriptionLabel = new javax.swing.JLabel();
        geneNameLabel = new javax.swing.JLabel();
        geneNameJTextField = new javax.swing.JTextField();
        texonomyLabel = new javax.swing.JLabel();
        taxonomyJTextField = new javax.swing.JTextField();
        databaseLabel = new javax.swing.JLabel();
        databaseJTextField = new javax.swing.JTextField();
        proteinDescriptionScrollPane = new javax.swing.JScrollPane();
        proteinDescriptionTextArea = new javax.swing.JTextArea();
        chromosomeLabel = new javax.swing.JLabel();
        chromosomeJTextField = new javax.swing.JTextField();
        uniprotLinkJPanel = new javax.swing.JPanel();
        uniprotLabel = new javax.swing.JLabel();
        loadUniProtJButton = new javax.swing.JButton();
        webUniProtLabel = new javax.swing.JLabel();
        dastyLinkJPanel = new javax.swing.JPanel();
        dastyLabel = new javax.swing.JLabel();
        loadDastyJButton = new javax.swing.JButton();
        webDastyLabel = new javax.swing.JLabel();
        reactomeLinkJPanel = new javax.swing.JPanel();
        reactomeLabel = new javax.swing.JLabel();
        loadReactomeJButton = new javax.swing.JButton();
        webReactomeLabel = new javax.swing.JLabel();
        stringLinkJPanel = new javax.swing.JPanel();
        stringLabel = new javax.swing.JLabel();
        loadStringJButton = new javax.swing.JButton();
        webStringLabel = new javax.swing.JLabel();
        davidLinkJPanel = new javax.swing.JPanel();
        davidLabel = new javax.swing.JLabel();
        loadDavidJButton = new javax.swing.JButton();
        webDavidLabel = new javax.swing.JLabel();
        intActLinkJPanel = new javax.swing.JPanel();
        intactLabel = new javax.swing.JLabel();
        loadIntActJButton = new javax.swing.JButton();
        webIntActLabel = new javax.swing.JLabel();
        quickGOLinkJPanel = new javax.swing.JPanel();
        quickGoLabel = new javax.swing.JLabel();
        loadQuickGOJButton = new javax.swing.JButton();
        webQuickGOLabel = new javax.swing.JLabel();
        interProLinkJPanel = new javax.swing.JPanel();
        interProLabel = new javax.swing.JLabel();
        loadInterProJButton = new javax.swing.JButton();
        webInterProLabel = new javax.swing.JLabel();
        helpPanel = new javax.swing.JPanel();
        helpScrollPane = new javax.swing.JScrollPane();
        helpEditorPane = new javax.swing.JEditorPane();
        picrLinkJLabel = new javax.swing.JLabel();
        nextProtLinkJPanel = new javax.swing.JPanel();
        nextProtLabel = new javax.swing.JLabel();
        loadNextProtJButton = new javax.swing.JButton();
        webNextProtLabel = new javax.swing.JLabel();
        pdbLinkJPanel = new javax.swing.JPanel();
        pdbLabel = new javax.swing.JLabel();
        loadPdbJButton = new javax.swing.JButton();
        webPdbLabel = new javax.swing.JLabel();

        setBackground(new java.awt.Color(255, 255, 255));

        basicAnnotationJPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Basic Protein Annotation", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        basicAnnotationJPanel.setOpaque(false);

        accessionNumberLabel.setText("Accession");

        accessionNumberJTextField.setEditable(false);

        descriptionLabel.setText("Description");

        geneNameLabel.setText("Gene Name");

        geneNameJTextField.setEditable(false);

        texonomyLabel.setText("Taxonomy");

        taxonomyJTextField.setEditable(false);

        databaseLabel.setText("Database");

        databaseJTextField.setEditable(false);

        proteinDescriptionTextArea.setEditable(false);
        proteinDescriptionTextArea.setColumns(20);
        proteinDescriptionTextArea.setLineWrap(true);
        proteinDescriptionTextArea.setRows(2);
        proteinDescriptionTextArea.setTabSize(4);
        proteinDescriptionTextArea.setWrapStyleWord(true);
        proteinDescriptionScrollPane.setViewportView(proteinDescriptionTextArea);

        chromosomeLabel.setText("Chromosome");

        chromosomeJTextField.setEditable(false);
        chromosomeJTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);

        javax.swing.GroupLayout basicAnnotationJPanelLayout = new javax.swing.GroupLayout(basicAnnotationJPanel);
        basicAnnotationJPanel.setLayout(basicAnnotationJPanelLayout);
        basicAnnotationJPanelLayout.setHorizontalGroup(
            basicAnnotationJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(basicAnnotationJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(basicAnnotationJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(accessionNumberLabel)
                    .addComponent(descriptionLabel)
                    .addComponent(geneNameLabel)
                    .addComponent(texonomyLabel)
                    .addComponent(databaseLabel))
                .addGap(38, 38, 38)
                .addGroup(basicAnnotationJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(accessionNumberJTextField, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 494, Short.MAX_VALUE)
                    .addComponent(proteinDescriptionScrollPane)
                    .addComponent(taxonomyJTextField)
                    .addComponent(databaseJTextField)
                    .addGroup(basicAnnotationJPanelLayout.createSequentialGroup()
                        .addComponent(geneNameJTextField)
                        .addGap(18, 18, 18)
                        .addComponent(chromosomeLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(chromosomeJTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 131, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        basicAnnotationJPanelLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {accessionNumberLabel, descriptionLabel, texonomyLabel});

        basicAnnotationJPanelLayout.setVerticalGroup(
            basicAnnotationJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(basicAnnotationJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(basicAnnotationJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(accessionNumberJTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(accessionNumberLabel))
                .addGroup(basicAnnotationJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(basicAnnotationJPanelLayout.createSequentialGroup()
                        .addGap(14, 14, 14)
                        .addComponent(descriptionLabel)
                        .addGap(25, 25, 25))
                    .addComponent(proteinDescriptionScrollPane, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 53, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(basicAnnotationJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(geneNameJTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(geneNameLabel)
                    .addComponent(chromosomeLabel)
                    .addComponent(chromosomeJTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(basicAnnotationJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(taxonomyJTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(texonomyLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(basicAnnotationJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(databaseJTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(databaseLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        uniprotLinkJPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "UniProt - protein knowledgebase", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        uniprotLinkJPanel.setOpaque(false);

        uniprotLabel.setText("High-quality protein sequence and functional information.");

        loadUniProtJButton.setText("Search UniProt");
        loadUniProtJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadUniProtJButtonActionPerformed(evt);
            }
        });

        webUniProtLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        webUniProtLabel.setToolTipText("Open the UniProt web page");
        webUniProtLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webUniProtLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                webUniProtLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                webUniProtLabelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout uniprotLinkJPanelLayout = new javax.swing.GroupLayout(uniprotLinkJPanel);
        uniprotLinkJPanel.setLayout(uniprotLinkJPanelLayout);
        uniprotLinkJPanelLayout.setHorizontalGroup(
            uniprotLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(uniprotLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(loadUniProtJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(uniprotLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(webUniProtLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        uniprotLinkJPanelLayout.setVerticalGroup(
            uniprotLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(uniprotLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(uniprotLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadUniProtJButton)
                    .addComponent(uniprotLabel)
                    .addComponent(webUniProtLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        dastyLinkJPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "DASty - protein sequence features", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        dastyLinkJPanel.setOpaque(false);

        dastyLabel.setText("Web client for visualizing protein sequence feature information.");

        loadDastyJButton.setText("Search DASty");
        loadDastyJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadDastyJButtonActionPerformed(evt);
            }
        });

        webDastyLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        webDastyLabel.setToolTipText("Open the DASty web page");
        webDastyLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webDastyLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                webDastyLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                webDastyLabelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout dastyLinkJPanelLayout = new javax.swing.GroupLayout(dastyLinkJPanel);
        dastyLinkJPanel.setLayout(dastyLinkJPanelLayout);
        dastyLinkJPanelLayout.setHorizontalGroup(
            dastyLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dastyLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(loadDastyJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(dastyLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(webDastyLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        dastyLinkJPanelLayout.setVerticalGroup(
            dastyLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dastyLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(dastyLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadDastyJButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(dastyLabel)
                    .addComponent(webDastyLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        reactomeLinkJPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Reactome - pathway database", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        reactomeLinkJPanel.setOpaque(false);

        reactomeLabel.setText("Manually curated and peer-reviewed pathway database.");

        loadReactomeJButton.setText("Search Reactome");
        loadReactomeJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadReactomeJButtonActionPerformed(evt);
            }
        });

        webReactomeLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        webReactomeLabel.setToolTipText("Open the Reactome web page");
        webReactomeLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webReactomeLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                webReactomeLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                webReactomeLabelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout reactomeLinkJPanelLayout = new javax.swing.GroupLayout(reactomeLinkJPanel);
        reactomeLinkJPanel.setLayout(reactomeLinkJPanelLayout);
        reactomeLinkJPanelLayout.setHorizontalGroup(
            reactomeLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(reactomeLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(loadReactomeJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(reactomeLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(webReactomeLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        reactomeLinkJPanelLayout.setVerticalGroup(
            reactomeLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(reactomeLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(reactomeLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(reactomeLabel)
                    .addComponent(loadReactomeJButton)
                    .addComponent(webReactomeLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        stringLinkJPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "STRING - protein interaction", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        stringLinkJPanel.setOpaque(false);

        stringLabel.setText("Known and Predicted Protein-Protein Interactions.");

        loadStringJButton.setText("Search STRING");
        loadStringJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadStringJButtonActionPerformed(evt);
            }
        });

        webStringLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        webStringLabel.setToolTipText("Open the STRING web page");
        webStringLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webStringLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                webStringLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                webStringLabelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout stringLinkJPanelLayout = new javax.swing.GroupLayout(stringLinkJPanel);
        stringLinkJPanel.setLayout(stringLinkJPanelLayout);
        stringLinkJPanelLayout.setHorizontalGroup(
            stringLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(stringLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(loadStringJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(stringLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 178, Short.MAX_VALUE)
                .addComponent(webStringLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        stringLinkJPanelLayout.setVerticalGroup(
            stringLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(stringLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(stringLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(stringLabel)
                    .addComponent(loadStringJButton)
                    .addComponent(webStringLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        davidLinkJPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "DAVID - functional annotation", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        davidLinkJPanel.setOpaque(false);

        davidLabel.setText("Database for Annotation, Visualization and Integrated Discovery.");

        loadDavidJButton.setText("Search DAVID");
        loadDavidJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadDavidJButtonActionPerformed(evt);
            }
        });

        webDavidLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        webDavidLabel.setToolTipText("Open the DAVID web page");
        webDavidLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webDavidLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                webDavidLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                webDavidLabelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout davidLinkJPanelLayout = new javax.swing.GroupLayout(davidLinkJPanel);
        davidLinkJPanel.setLayout(davidLinkJPanelLayout);
        davidLinkJPanelLayout.setHorizontalGroup(
            davidLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(davidLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(loadDavidJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(davidLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(webDavidLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        davidLinkJPanelLayout.setVerticalGroup(
            davidLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(davidLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(davidLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(davidLabel)
                    .addComponent(loadDavidJButton)
                    .addComponent(webDavidLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        intActLinkJPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "IntAct - protein interaction", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        intActLinkJPanel.setOpaque(false);

        intactLabel.setText("Analysis tools for protein interaction data.");

        loadIntActJButton.setText("Search IntAct");
        loadIntActJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadIntActJButtonActionPerformed(evt);
            }
        });

        webIntActLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        webIntActLabel.setToolTipText("Open the IntAct web page");
        webIntActLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webIntActLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                webIntActLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                webIntActLabelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout intActLinkJPanelLayout = new javax.swing.GroupLayout(intActLinkJPanel);
        intActLinkJPanel.setLayout(intActLinkJPanelLayout);
        intActLinkJPanelLayout.setHorizontalGroup(
            intActLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(intActLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(loadIntActJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(intactLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(webIntActLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        intActLinkJPanelLayout.setVerticalGroup(
            intActLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(intActLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(intActLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(intactLabel)
                    .addComponent(loadIntActJButton)
                    .addComponent(webIntActLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        quickGOLinkJPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "QuickGO - gene ontology terms and annotations", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        quickGOLinkJPanel.setOpaque(false);

        quickGoLabel.setText("Web-based browser for Gene Ontology terms.");

        loadQuickGOJButton.setText("Search QuickGO");
        loadQuickGOJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadQuickGOJButtonActionPerformed(evt);
            }
        });

        webQuickGOLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        webQuickGOLabel.setToolTipText("Open the QuickGO web page");
        webQuickGOLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webQuickGOLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                webQuickGOLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                webQuickGOLabelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout quickGOLinkJPanelLayout = new javax.swing.GroupLayout(quickGOLinkJPanel);
        quickGOLinkJPanel.setLayout(quickGOLinkJPanelLayout);
        quickGOLinkJPanelLayout.setHorizontalGroup(
            quickGOLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(quickGOLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(loadQuickGOJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(quickGoLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 196, Short.MAX_VALUE)
                .addComponent(webQuickGOLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        quickGOLinkJPanelLayout.setVerticalGroup(
            quickGOLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(quickGOLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(quickGOLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(quickGoLabel)
                    .addComponent(loadQuickGOJButton)
                    .addComponent(webQuickGOLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        interProLinkJPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "InterPro - predictive protein signatures", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        interProLinkJPanel.setOpaque(false);

        interProLabel.setText("Integrated database of predictive protein signatures.");

        loadInterProJButton.setText("Search InterPro");
        loadInterProJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadInterProJButtonActionPerformed(evt);
            }
        });

        webInterProLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        webInterProLabel.setToolTipText("Open the InterPro web page");
        webInterProLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webInterProLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                webInterProLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                webInterProLabelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout interProLinkJPanelLayout = new javax.swing.GroupLayout(interProLinkJPanel);
        interProLinkJPanel.setLayout(interProLinkJPanelLayout);
        interProLinkJPanelLayout.setHorizontalGroup(
            interProLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(interProLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(loadInterProJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(interProLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(webInterProLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        interProLinkJPanelLayout.setVerticalGroup(
            interProLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(interProLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(interProLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(interProLabel)
                    .addComponent(loadInterProJButton)
                    .addComponent(webInterProLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        helpPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Protein Annotation - Help", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        helpPanel.setOpaque(false);

        helpScrollPane.setBorder(null);
        helpScrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        helpScrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);

        helpEditorPane.setEditable(false);
        helpEditorPane.setContentType("text/html"); // NOI18N
        helpEditorPane.setText("<html>\n<b>Single Protein</b><br>\nTo access the annotations for the currently selected protein, simply click the button corresponding to the \nwanted resource.\n<br><br>\n<b>Multiple Proteins</b><br>\nTo get the list of all validated proteins in your project click <a href=\"validated_proteins\">here</a>.<br>\nAdvanced export options: <i>Export</i> > <i>Identification Features</i>. \n<br><br>\nTo querry using multiple proteins, click the <a href=\"dummy_link\">web</a> link next to the resource and \nfollow the instructions provided at the resource web page.\n</html>");
        helpEditorPane.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
                helpEditorPaneHyperlinkUpdate(evt);
            }
        });
        helpScrollPane.setViewportView(helpEditorPane);

        javax.swing.GroupLayout helpPanelLayout = new javax.swing.GroupLayout(helpPanel);
        helpPanel.setLayout(helpPanelLayout);
        helpPanelLayout.setHorizontalGroup(
            helpPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(helpPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(helpScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 481, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        helpPanelLayout.setVerticalGroup(
            helpPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(helpPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(helpScrollPane)
                .addContainerGap())
        );

        picrLinkJLabel.setText("<html><a href=\\\"dummy_link\\\">PICR - Protein Identifier Cross-Reference Service</a></html>");
        picrLinkJLabel.setToolTipText("<html>\nMap protein identifiers across<br>\nmultiple source databases\n</html>");
        picrLinkJLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                picrLinkJLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                picrLinkJLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                picrLinkJLabelMouseExited(evt);
            }
        });

        nextProtLinkJPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "neXtProt - human protein knowledgebase", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        nextProtLinkJPanel.setOpaque(false);

        nextProtLabel.setText("High-quality human protein information and annotation.");

        loadNextProtJButton.setText("Search neXtProt");
        loadNextProtJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadNextProtJButtonActionPerformed(evt);
            }
        });

        webNextProtLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        webNextProtLabel.setToolTipText("Open the neXtProt web page");
        webNextProtLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webNextProtLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                webNextProtLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                webNextProtLabelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout nextProtLinkJPanelLayout = new javax.swing.GroupLayout(nextProtLinkJPanel);
        nextProtLinkJPanel.setLayout(nextProtLinkJPanelLayout);
        nextProtLinkJPanelLayout.setHorizontalGroup(
            nextProtLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(nextProtLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(loadNextProtJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(nextProtLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(webNextProtLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        nextProtLinkJPanelLayout.setVerticalGroup(
            nextProtLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(nextProtLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(nextProtLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadNextProtJButton)
                    .addComponent(nextProtLabel)
                    .addComponent(webNextProtLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pdbLinkJPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "PDB - protein data bank", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("sansserif", 1, 14))); // NOI18N
        pdbLinkJPanel.setOpaque(false);

        pdbLabel.setText("Biological macromolecular resource.");

        loadPdbJButton.setText("Search PDB");
        loadPdbJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadPdbJButtonActionPerformed(evt);
            }
        });

        webPdbLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        webPdbLabel.setToolTipText("Open the PDB web page");
        webPdbLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webPdbLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                webPdbLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                webPdbLabelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout pdbLinkJPanelLayout = new javax.swing.GroupLayout(pdbLinkJPanel);
        pdbLinkJPanel.setLayout(pdbLinkJPanelLayout);
        pdbLinkJPanelLayout.setHorizontalGroup(
            pdbLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pdbLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(loadPdbJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(pdbLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 240, Short.MAX_VALUE)
                .addComponent(webPdbLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        pdbLinkJPanelLayout.setVerticalGroup(
            pdbLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pdbLinkJPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pdbLinkJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(pdbLabel)
                    .addComponent(loadPdbJButton)
                    .addComponent(webPdbLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addComponent(picrLinkJLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(nextProtLinkJPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(uniprotLinkJPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(basicAnnotationJPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(quickGOLinkJPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(stringLinkJPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(dastyLinkJPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(helpPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addGap(10, 10, 10))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(pdbLinkJPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addContainerGap())
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(reactomeLinkJPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(davidLinkJPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(intActLinkJPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(interProLinkJPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                .addContainerGap())))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(basicAnnotationJPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(helpPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(reactomeLinkJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(davidLinkJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(uniprotLinkJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(nextProtLinkJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(stringLinkJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(quickGOLinkJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(intActLinkJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(interProLinkJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(dastyLinkJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(pdbLinkJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(picrLinkJLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(124, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Open the protein accession in DASty.
     *
     * @param evt
     */
    private void loadDastyJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadDastyJButtonActionPerformed
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.ebi.ac.uk/dasty/client/index.html?q=" + accessionNumberJTextField.getText());
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_loadDastyJButtonActionPerformed

    /**
     * Open the protein accession in UniProt.
     *
     * @param evt
     */
    private void loadUniProtJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadUniProtJButtonActionPerformed
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.uniprot.org/uniprot/" + accessionNumberJTextField.getText());
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_loadUniProtJButtonActionPerformed

    /**
     * Open the protein accession in Reactome.
     *
     * @param evt
     */
    private void loadReactomeJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadReactomeJButtonActionPerformed
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.reactome.org/cgi-bin/link?SOURCE=UNIPROT&ID=" + accessionNumberJTextField.getText());
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_loadReactomeJButtonActionPerformed

    /**
     * Open the protein accession in STRING.
     *
     * @param evt
     */
    private void loadStringJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadStringJButtonActionPerformed
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://string-db.org/newstring_cgi/show_input_page.pl?identifier=" + accessionNumberJTextField.getText());
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_loadStringJButtonActionPerformed

    /**
     * Open the protein accession in DAVID.
     *
     * @param evt
     */
    private void loadDavidJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadDavidJButtonActionPerformed
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://david.abcc.ncifcrf.gov/api.jsp?type=UNIPROT_ACCESSION&ids=" + accessionNumberJTextField.getText() + "&tool=summary");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_loadDavidJButtonActionPerformed

    /**
     * Open the protein accession in IntAct.
     *
     * @param evt
     */
    private void loadIntActJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadIntActJButtonActionPerformed
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.ebi.ac.uk/intact/pages/interactions/interactions.xhtml?query=" + accessionNumberJTextField.getText());
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_loadIntActJButtonActionPerformed

    /**
     * Open the protein accession in QuickGO.
     *
     * @param evt
     */
    private void loadQuickGOJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadQuickGOJButtonActionPerformed
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.ebi.ac.uk/QuickGO/annotations?geneProductId=" + accessionNumberJTextField.getText());
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_loadQuickGOJButtonActionPerformed

    /**
     * Open the protein accession in InterPro.
     *
     * @param evt
     */
    private void loadInterProJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadInterProJButtonActionPerformed
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.ebi.ac.uk/interpro/ISearch?query=" + accessionNumberJTextField.getText());
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_loadInterProJButtonActionPerformed

    /**
     * Open the DASty web page.
     *
     * @param evt
     */
    private void webDastyLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webDastyLabelMouseClicked
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.ebi.ac.uk/dasty");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webDastyLabelMouseClicked

    /**
     * Change the cursor icon to a hand icon.
     *
     * @param evt
     */
    private void webDastyLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webDastyLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_webDastyLabelMouseEntered

    /**
     * Change the cursor back to the default icon.
     *
     * @param evt
     */
    private void webDastyLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webDastyLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webDastyLabelMouseExited

    /**
     * Open the UniProt web page.
     *
     * @param evt
     */
    private void webUniProtLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webUniProtLabelMouseClicked
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.uniprot.org");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webUniProtLabelMouseClicked

    /**
     * Change the cursor icon to a hand icon.
     *
     * @param evt
     */
    private void webUniProtLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webUniProtLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_webUniProtLabelMouseEntered

    /**
     * Change the cursor back to the default icon.
     *
     * @param evt
     */
    private void webUniProtLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webUniProtLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webUniProtLabelMouseExited

    /**
     * Open the Reactome web page.
     *
     * @param evt
     */
    private void webReactomeLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webReactomeLabelMouseClicked
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.reactome.org");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webReactomeLabelMouseClicked

    /**
     * Change the cursor icon to a hand icon.
     *
     * @param evt
     */
    private void webReactomeLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webReactomeLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_webReactomeLabelMouseEntered

    /**
     * Change the cursor back to the default icon.
     *
     * @param evt
     */
    private void webReactomeLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webReactomeLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webReactomeLabelMouseExited

    /**
     * Open the STRING web page.
     *
     * @param evt
     */
    private void webStringLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webStringLabelMouseClicked
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://string-db.org");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webStringLabelMouseClicked

    /**
     * Change the cursor icon to a hand icon.
     *
     * @param evt
     */
    private void webStringLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webStringLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_webStringLabelMouseEntered

    /**
     * Change the cursor back to the default icon.
     *
     * @param evt
     */
    private void webStringLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webStringLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webStringLabelMouseExited

    /**
     * Open the QuickGO web page.
     *
     * @param evt
     */
    private void webQuickGOLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webQuickGOLabelMouseClicked
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.ebi.ac.uk/QuickGO");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webQuickGOLabelMouseClicked

    /**
     * Change the cursor icon to a hand icon.
     *
     * @param evt
     */
    private void webQuickGOLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webQuickGOLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_webQuickGOLabelMouseEntered

    /**
     * Change the cursor back to the default icon.
     *
     * @param evt
     */
    private void webQuickGOLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webQuickGOLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webQuickGOLabelMouseExited

    /**
     * Open the InterPro web page.
     *
     * @param evt
     */
    private void webInterProLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webInterProLabelMouseClicked
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.ebi.ac.uk/interpro");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webInterProLabelMouseClicked

    /**
     * Change the cursor icon to a hand icon.
     *
     * @param evt
     */
    private void webInterProLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webInterProLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_webInterProLabelMouseEntered

    /**
     * Change the cursor back to the default icon.
     *
     * @param evt
     */
    private void webInterProLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webInterProLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webInterProLabelMouseExited

    /**
     * Open the IntAct web page.
     *
     * @param evt
     */
    private void webIntActLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webIntActLabelMouseClicked
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.ebi.ac.uk/intact");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webIntActLabelMouseClicked

    /**
     * Change the cursor icon to a hand icon.
     *
     * @param evt
     */
    private void webIntActLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webIntActLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_webIntActLabelMouseEntered

    /**
     * Change the cursor back to the default icon.
     *
     * @param evt
     */
    private void webIntActLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webIntActLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webIntActLabelMouseExited

    /**
     * Enable the hyperlinks in the help panel.
     *
     * @param evt
     */
    private void helpEditorPaneHyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {//GEN-FIRST:event_helpEditorPaneHyperlinkUpdate
        if (evt.getEventType().toString().equalsIgnoreCase(
                javax.swing.event.HyperlinkEvent.EventType.ACTIVATED.toString())) {

            if (evt.getDescription().equalsIgnoreCase("validated_proteins")) {

                if (peptideShakerGUI.getIdentification() != null) {

                    String textFileFilterDescription = "Tab separated text file (.txt)";
                    String gzipFileFilterDescription = "Gzipped tab separated text file (.gz)";
                    String excelFileFilterDescription = "Excel Workbook (.xls)";
                    String lastSelectedFolderPath = peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder();
                    FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile(this, new String[]{".xls", ".txt", ".gz"},
                            new String[]{excelFileFilterDescription, textFileFilterDescription, gzipFileFilterDescription}, "Export Report", lastSelectedFolderPath, "All Validated Proteins", false, true, false, 1);

                    if (selectedFileAndFilter != null) {

                        final File selectedFile = selectedFileAndFilter.getFile();
                        final ExportFormat exportFormat;
                        final boolean gzip;
                        if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(textFileFilterDescription)) {
                            exportFormat = ExportFormat.text;
                            gzip = false;
                        } else if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(gzipFileFilterDescription)) {
                            exportFormat = ExportFormat.text;
                            gzip = true;
                        } else {
                            exportFormat = ExportFormat.excel;
                            gzip = false;
                        }

                        progressDialog = new ProgressDialogX(peptideShakerGUI,
                                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker-orange.gif")),
                                true);
                        progressDialog.setTitle("Exporting Data. Please Wait...");

                        final String filePath = selectedFile.getPath();

                        new Thread(new Runnable() {
                            public void run() {
                                try {
                                    progressDialog.setVisible(true);
                                } catch (IndexOutOfBoundsException e) {
                                    // ignore
                                }
                            }
                        }, "ProgressDialog").start();

                        new Thread("ExportThread") {
                            @Override
                            public void run() {

                                try {
                                    HashMap<String, ArrayList<ExportFeature>> exportFeatures = new HashMap<>();
                                    ArrayList<ExportFeature> sectionContent = new ArrayList<>();

                                    sectionContent.add(PsProteinFeature.accession);
                                    exportFeatures.put(PsProteinFeature.type, sectionContent);

                                    ExportScheme validatedProteinReport = new ExportScheme(
                                            "Validated Proteins", 
                                            false, 
                                            exportFeatures, 
                                            "\t", 
                                            false, 
                                            false, 
                                            0, 
                                            false, 
                                            true, 
                                            false
                                    );

                                    PSExportFactory.writeExport(
                                            validatedProteinReport, 
                                            selectedFile, 
                                            exportFormat, 
                                            gzip, 
                                            peptideShakerGUI.getProjectParameters().getProjectUniqueName(),
                                            peptideShakerGUI.getProjectDetails(), 
                                            peptideShakerGUI.getIdentification(),
                                            peptideShakerGUI.getIdentificationFeaturesGenerator(), 
                                            peptideShakerGUI.getGeneMaps(), 
                                            null, 
                                            null, 
                                            null,
                                            peptideShakerGUI.getDisplayParameters().getnAASurroundingPeptides(), 
                                            peptideShakerGUI.getIdentificationParameters(),
                                            peptideShakerGUI.getSequenceProvider(), 
                                            peptideShakerGUI.getProteinDetailsProvider(), 
                                            peptideShakerGUI.getSpectrumProvider(), 
                                            peptideShakerGUI.getSpectrumCountingParameters(), 
                                            progressDialog
                                    );

                                    boolean processCancelled = progressDialog.isRunCanceled();
                                    progressDialog.setRunFinished();

                                    if (!processCancelled) {
                                        JOptionPane.showMessageDialog(peptideShakerGUI, "Data copied to file:\n" + filePath, "Data Exported.", JOptionPane.INFORMATION_MESSAGE);
                                    }
                                } catch (IllegalArgumentException e) {
                                    if (e.getMessage().contains("Invalid row number (65536)")) {
                                        progressDialog.setRunFinished();
                                        JOptionPane.showMessageDialog(peptideShakerGUI,
                                                "An error occurred while generating the output. This format can contain only 65,535 lines.\n" // @TODO: update the excel export library?
                                                + "Please use a text export instead.", "Output Error.", JOptionPane.ERROR_MESSAGE);
                                        e.printStackTrace();
                                    } else {
                                        progressDialog.setRunFinished();
                                        JOptionPane.showMessageDialog(peptideShakerGUI, "An error occurred while generating the output.", "Output Error.", JOptionPane.ERROR_MESSAGE);
                                        e.printStackTrace();
                                    }
                                } catch (Exception e) {
                                    progressDialog.setRunFinished();
                                    JOptionPane.showMessageDialog(peptideShakerGUI, "An error occurred while generating the output.", "Output Error.", JOptionPane.ERROR_MESSAGE);
                                    e.printStackTrace();
                                }
                            }
                        }.start();
                    }
                } else {
                    JOptionPane.showMessageDialog(peptideShakerGUI, "You have to load a project first!", "No Project", JOptionPane.WARNING_MESSAGE);
                }
            }
        }
    }//GEN-LAST:event_helpEditorPaneHyperlinkUpdate

    /**
     * Change the cursor back to the default icon.
     *
     * @param evt
     */
    private void webDavidLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webDavidLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webDavidLabelMouseExited

    /**
     * Change the cursor back to a hand icon.
     *
     * @param evt
     */
    private void webDavidLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webDavidLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_webDavidLabelMouseEntered

    /**
     * Open the DAVID web page.
     *
     * @param evt
     */
    private void webDavidLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webDavidLabelMouseClicked
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://david.abcc.ncifcrf.gov");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webDavidLabelMouseClicked

    /**
     * Change the cursor back to a hand icon.
     *
     * @param evt
     */
    private void picrLinkJLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_picrLinkJLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_picrLinkJLabelMouseEntered

    /**
     * Change the cursor back to the default icon.
     *
     * @param evt
     */
    private void picrLinkJLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_picrLinkJLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_picrLinkJLabelMouseExited

    /**
     * Open the PICR web page.
     *
     * @param evt
     */
    private void picrLinkJLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_picrLinkJLabelMouseClicked
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.ebi.ac.uk/Tools/picr/");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_picrLinkJLabelMouseClicked

    /**
     * Open the protein accession in neXtProt.
     *
     * @param evt
     */
    private void loadNextProtJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadNextProtJButtonActionPerformed
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.nextprot.org/db/entry/NX_" + accessionNumberJTextField.getText());
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_loadNextProtJButtonActionPerformed

    /**
     * Open the neXtProt web page.
     *
     * @param evt
     */
    private void webNextProtLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webNextProtLabelMouseClicked
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.nextprot.org/db/");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webNextProtLabelMouseClicked

    /**
     * Change the cursor back to a hand icon.
     *
     * @param evt
     */
    private void webNextProtLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webNextProtLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_webNextProtLabelMouseEntered

    /**
     * Change the cursor back to the default icon.
     *
     * @param evt
     */
    private void webNextProtLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webNextProtLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webNextProtLabelMouseExited

    /**
     * Open the protein accession in PDB.
     *
     * @param evt
     */
    private void loadPdbJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadPdbJButtonActionPerformed
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.rcsb.org/pdb/protein/" + accessionNumberJTextField.getText());
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_loadPdbJButtonActionPerformed

    /**
     * Open the PDB web page.
     *
     * @param evt
     */
    private void webPdbLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webPdbLabelMouseClicked
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.rcsb.org/pdb/");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webPdbLabelMouseClicked

    /**
     * Change the cursor back to a hand icon.
     *
     * @param evt
     */
    private void webPdbLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webPdbLabelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_webPdbLabelMouseEntered

    /**
     * Change the cursor back to the default icon.
     *
     * @param evt
     */
    private void webPdbLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webPdbLabelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_webPdbLabelMouseExited
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField accessionNumberJTextField;
    private javax.swing.JLabel accessionNumberLabel;
    private javax.swing.JPanel basicAnnotationJPanel;
    private javax.swing.JTextField chromosomeJTextField;
    private javax.swing.JLabel chromosomeLabel;
    private javax.swing.JLabel dastyLabel;
    private javax.swing.JPanel dastyLinkJPanel;
    private javax.swing.JTextField databaseJTextField;
    private javax.swing.JLabel databaseLabel;
    private javax.swing.JLabel davidLabel;
    private javax.swing.JPanel davidLinkJPanel;
    private javax.swing.JLabel descriptionLabel;
    private javax.swing.JTextField geneNameJTextField;
    private javax.swing.JLabel geneNameLabel;
    private javax.swing.JEditorPane helpEditorPane;
    private javax.swing.JPanel helpPanel;
    private javax.swing.JScrollPane helpScrollPane;
    private javax.swing.JPanel intActLinkJPanel;
    private javax.swing.JLabel intactLabel;
    private javax.swing.JLabel interProLabel;
    private javax.swing.JPanel interProLinkJPanel;
    private javax.swing.JButton loadDastyJButton;
    private javax.swing.JButton loadDavidJButton;
    private javax.swing.JButton loadIntActJButton;
    private javax.swing.JButton loadInterProJButton;
    private javax.swing.JButton loadNextProtJButton;
    private javax.swing.JButton loadPdbJButton;
    private javax.swing.JButton loadQuickGOJButton;
    private javax.swing.JButton loadReactomeJButton;
    private javax.swing.JButton loadStringJButton;
    private javax.swing.JButton loadUniProtJButton;
    private javax.swing.JLabel nextProtLabel;
    private javax.swing.JPanel nextProtLinkJPanel;
    private javax.swing.JLabel pdbLabel;
    private javax.swing.JPanel pdbLinkJPanel;
    private javax.swing.JLabel picrLinkJLabel;
    private javax.swing.JScrollPane proteinDescriptionScrollPane;
    private javax.swing.JTextArea proteinDescriptionTextArea;
    private javax.swing.JPanel quickGOLinkJPanel;
    private javax.swing.JLabel quickGoLabel;
    private javax.swing.JLabel reactomeLabel;
    private javax.swing.JPanel reactomeLinkJPanel;
    private javax.swing.JLabel stringLabel;
    private javax.swing.JPanel stringLinkJPanel;
    private javax.swing.JTextField taxonomyJTextField;
    private javax.swing.JLabel texonomyLabel;
    private javax.swing.JLabel uniprotLabel;
    private javax.swing.JPanel uniprotLinkJPanel;
    private javax.swing.JLabel webDastyLabel;
    private javax.swing.JLabel webDavidLabel;
    private javax.swing.JLabel webIntActLabel;
    private javax.swing.JLabel webInterProLabel;
    private javax.swing.JLabel webNextProtLabel;
    private javax.swing.JLabel webPdbLabel;
    private javax.swing.JLabel webQuickGOLabel;
    private javax.swing.JLabel webReactomeLabel;
    private javax.swing.JLabel webStringLabel;
    private javax.swing.JLabel webUniProtLabel;
    // End of variables declaration//GEN-END:variables

    /**
     * Updates the basic protein annotation information.
     *
     * @param aAccessionNumber the new accession number
     */
    public void updateBasicProteinAnnotation(String aAccessionNumber) {

        // only update if new accession number
        if (aAccessionNumber != null
                && !aAccessionNumber.equals(NO_KEY)
                && !currentAccessionNumber.equalsIgnoreCase(aAccessionNumber)) {

            currentAccessionNumber = aAccessionNumber;
            accessionNumberJTextField.setText(currentAccessionNumber);

            ProteinDetailsProvider proteinDetailsProvider = peptideShakerGUI.getProteinDetailsProvider();
            String simpleDescription = proteinDetailsProvider.getSimpleDescription(aAccessionNumber);
            String geneName = proteinDetailsProvider.getGeneName(aAccessionNumber);
            String taxonomy = proteinDetailsProvider.getTaxonomy(aAccessionNumber);
            ProteinDatabase proteinDatabase = proteinDetailsProvider.getProteinDatabase(aAccessionNumber);

            proteinDescriptionTextArea.setText(simpleDescription);
            geneNameJTextField.setText(geneName);

            if (geneName != null) {
                GeneMaps geneMaps = peptideShakerGUI.getGeneMaps();
                chromosomeJTextField.setText(geneMaps.getChromosome(geneName));
            } else {
                chromosomeJTextField.setText(null);
            }

            taxonomyJTextField.setText(taxonomy);
            databaseJTextField.setText(proteinDatabase.getFullName());

        }
    }
}
