/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.cmd.CLIExportMethods;
import eu.isas.peptideshaker.cmd.FollowUpCLIInputBean;
import eu.isas.peptideshaker.cmd.FollowUpCLIParams;
import eu.isas.peptideshaker.cmd.PathSettingsCLI;
import eu.isas.peptideshaker.cmd.PeptideShakerCLI;
import eu.isas.peptideshaker.utils.PsdbParent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class FollowUpCLI
extends PsdbParent {
    private FollowUpCLIInputBean followUpCLIInputBean = null;
    private WaitingHandler waitingHandler;
    private UtilitiesUserParameters utilitiesUserPreferences;

    public FollowUpCLI(FollowUpCLIInputBean followUpCLIInputBean) {
        this.followUpCLIInputBean = followUpCLIInputBean;
    }

    public Object call() {
        block62: {
            block61: {
                try {
                    Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
                    Field loggerField = loggerClass.getDeclaredField("logger");
                    Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                    Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                    unsafeField.setAccessible(true);
                    Object unsafe = unsafeField.get(null);
                    Long offset = (Long)unsafeClass.getMethod("staticFieldOffset", Field.class).invoke(unsafe, loggerField);
                    unsafeClass.getMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class).invoke(unsafe, loggerClass, offset, null);
                }
                catch (Throwable loggerClass) {
                    // empty catch block
                }
                this.setDbFolder(PeptideShaker.getMatchesFolder());
                this.utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
                PeptideShaker.instantiateFacories(this.utilitiesUserPreferences);
                ModificationFactory.getInstance();
                EnzymeFactory.getInstance();
                this.loadSpecies();
                this.waitingHandler = new WaitingHandlerCLIImpl();
                String inputFilePath = null;
                try {
                    if (this.followUpCLIInputBean.getZipFile() != null) {
                        inputFilePath = this.followUpCLIInputBean.getZipFile().getAbsolutePath();
                        this.loadPsdbFromZipFile(this.followUpCLIInputBean.getZipFile(), PeptideShaker.getMatchesFolder(), this.waitingHandler);
                        break block61;
                    }
                    if (this.followUpCLIInputBean.getPsdbFile() != null) {
                        inputFilePath = this.followUpCLIInputBean.getPsdbFile().getAbsolutePath();
                        this.psdbFile = this.followUpCLIInputBean.getPsdbFile();
                        this.loadPsdbFile(PeptideShaker.getMatchesFolder(), this.waitingHandler, false);
                        break block61;
                    }
                    this.waitingHandler.appendReport("PeptideShaker project input missing.", true, true);
                    return 1;
                }
                catch (IOException e) {
                    this.waitingHandler.appendReport("An error occurred while reading: " + inputFilePath + ".", true, true);
                    e.printStackTrace();
                    try {
                        PeptideShakerCLI.closePeptideShaker(this.identification);
                    }
                    catch (Exception e2) {
                        this.waitingHandler.appendReport("An error occurred while closing PeptideShaker.", true, true);
                        e2.printStackTrace();
                    }
                    return 1;
                }
            }
            try {
                if (this.loadSpectrumFiles(this.waitingHandler)) break block62;
                if (this.identification.getFractions().size() > 1) {
                    this.waitingHandler.appendReport("The spectrum files were not found. Please provide their location in the command line parameters.", true, true);
                } else {
                    this.waitingHandler.appendReport("The spectrum file was not found. Please provide its location in the command line parameters", true, true);
                }
                try {
                    PeptideShakerCLI.closePeptideShaker(this.identification);
                }
                catch (Exception e2) {
                    this.waitingHandler.appendReport("An error occurred while closing PeptideShaker.", true, true);
                    e2.printStackTrace();
                }
                return 1;
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while loading the spectrum file(s).", true, true);
                e.printStackTrace();
                try {
                    PeptideShakerCLI.closePeptideShaker(this.identification);
                }
                catch (Exception e2) {
                    this.waitingHandler.appendReport("An error occurred while closing PeptideShaker.", true, true);
                    e2.printStackTrace();
                }
                return 1;
            }
        }
        try {
            this.loadFastaFile(this.waitingHandler);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.waitingHandler.appendReport("An error occurred while parsing the FASTA file.", true, true);
            this.waitingHandler.setRunCanceled();
            return 1;
        }
        String error = PeptideShaker.loadModifications(this.getIdentificationParameters().getSearchParameters());
        if (error != null) {
            System.out.println(error);
        }
        if (this.followUpCLIInputBean.recalibrationNeeded()) {
            this.waitingHandler.appendReport("Recalibration of spectra.", true, true);
            try {
                CLIExportMethods.recalibrateSpectra(this.followUpCLIInputBean, this.identification, this.sequenceProvider, (SpectrumProvider)this.msFileHandler, this.identificationParameters, this.waitingHandler);
                this.waitingHandler.appendReport("Recalibration process completed.", true, true);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while recalibrating the spectra.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.spectrumExportNeeded()) {
            this.waitingHandler.appendReport("Spectrum export.", true, true);
            try {
                CLIExportMethods.exportSpectra(this.followUpCLIInputBean, this.identification, (SpectrumProvider)this.msFileHandler, this.waitingHandler, this.identificationParameters.getSequenceMatchingParameters());
                this.waitingHandler.appendReport("Spectrum export completed.", true, true);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while exporting the spectra.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.accessionExportNeeded()) {
            this.waitingHandler.appendReport("Protein accession export.", true, true);
            try {
                CLIExportMethods.exportAccessions(this.followUpCLIInputBean, this.identification, this.sequenceProvider, this.waitingHandler, this.filterParameters);
                this.waitingHandler.appendReport("Protein accessions export completed.", true, true);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while exporting the protein accessions.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.proteinSequencesExportNeeded()) {
            this.waitingHandler.appendReport("Protein sequences export.", true, true);
            try {
                CLIExportMethods.exportProteinSequences(this.followUpCLIInputBean, this.identification, this.sequenceProvider, this.waitingHandler, this.filterParameters);
                this.waitingHandler.appendReport("Protein details export completed.", true, true);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while exporting the protein details.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.progenesisExportNeeded()) {
            this.waitingHandler.appendReport("Progenesis export.", true, true);
            try {
                CLIExportMethods.exportProgenesis(this.followUpCLIInputBean, this.identification, this.waitingHandler, this.sequenceProvider, this.proteinDetailsProvider, this.identificationParameters.getSequenceMatchingParameters());
                this.waitingHandler.appendReport("Progenesis export completed.", true, true);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while exporting the Progenesis file.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.inclusionListNeeded()) {
            this.waitingHandler.appendReport("Inclusion list export.", true, true);
            try {
                CLIExportMethods.exportInclusionList(this.followUpCLIInputBean, this.identification, this.identificationFeaturesGenerator, (SpectrumProvider)this.msFileHandler, this.identificationParameters.getSearchParameters(), this.waitingHandler, this.filterParameters);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while generating the inclusion list.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.proteoformsNeeded()) {
            this.waitingHandler.appendReport("Proteoform export.", true, true);
            try {
                CLIExportMethods.exportProteoforms(this.followUpCLIInputBean, this.identification, this.waitingHandler);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while generating the proteoforms list.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.deepLcExportNeeded()) {
            this.waitingHandler.appendReport("DeepLC export.", true, true);
            try {
                CLIExportMethods.exportDeepLC(this.followUpCLIInputBean, this.identification, this.identificationParameters.getSearchParameters().getModificationParameters(), this.identificationParameters.getSequenceMatchingParameters(), this.sequenceProvider, (SpectrumProvider)this.msFileHandler, this.waitingHandler);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while generating the DeepLC export.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.ms2pipExportNeeded()) {
            this.waitingHandler.appendReport("ms2pip export.", true, true);
            try {
                CLIExportMethods.exportMs2pip(this.followUpCLIInputBean, this.identification, this.identificationParameters.getSearchParameters(), this.identificationParameters.getSequenceMatchingParameters(), this.sequenceProvider, (SpectrumProvider)this.msFileHandler, this.waitingHandler);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while generating the MS2PIP export.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.percolatorExportNeeded()) {
            this.waitingHandler.appendReport("Percolator export.", true, true);
            try {
                CLIExportMethods.exportPercolator(this.followUpCLIInputBean, this.identification, this.identificationParameters.getSearchParameters(), this.identificationParameters.getSequenceMatchingParameters(), this.identificationParameters.getAnnotationParameters(), this.identificationParameters.getModificationLocalizationParameters(), this.identificationParameters.getSearchParameters().getModificationParameters(), this.sequenceProvider, (SpectrumProvider)this.msFileHandler, this.waitingHandler);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while generating the Percolator export.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.RTValuesExportNeeded()) {
            this.waitingHandler.appendReport("RT values export.", true, true);
            try {
                CLIExportMethods.exportRTValues(this.followUpCLIInputBean, this.identification, this.identificationParameters.getSearchParameters(), this.identificationParameters.getSequenceMatchingParameters(), this.identificationParameters.getAnnotationParameters(), this.identificationParameters.getModificationLocalizationParameters(), this.identificationParameters.getSearchParameters().getModificationParameters(), this.sequenceProvider, (SpectrumProvider)this.msFileHandler, this.waitingHandler);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while generating the RT values export.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.PSMIdentifiersExportNeeded()) {
            this.waitingHandler.appendReport("PSM identifiers export.", true, true);
            try {
                CLIExportMethods.exportPSMIdentifiers(this.followUpCLIInputBean, this.identification, this.identificationParameters.getSearchParameters().getModificationParameters(), this.sequenceProvider, this.identificationParameters.getSequenceMatchingParameters(), (SpectrumProvider)this.msFileHandler, this.waitingHandler);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while generating the PSM identifiers export.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.followUpCLIInputBean.peaksIntensitiesObsExportNeeded()) {
            this.waitingHandler.appendReport("Peaks intensities export.", true, true);
            try {
                CLIExportMethods.exportPeaksIntensities(this.followUpCLIInputBean, this.identification, this.identificationParameters.getSearchParameters(), this.identificationParameters.getSequenceMatchingParameters(), this.identificationParameters.getAnnotationParameters(), this.identificationParameters.getModificationLocalizationParameters(), this.identificationParameters.getSearchParameters().getModificationParameters(), this.sequenceProvider, (SpectrumProvider)this.msFileHandler, this.waitingHandler);
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while generating the peaks intensities export.", true, true);
                e.printStackTrace();
                this.waitingHandler.setRunCanceled();
            }
        }
        try {
            PeptideShakerCLI.closePeptideShaker(this.identification);
        }
        catch (Exception e2) {
            this.waitingHandler.appendReport("An error occurred while closing PeptideShaker.", true, true);
            e2.printStackTrace();
            this.waitingHandler.setRunCanceled();
        }
        if (!this.waitingHandler.isRunCanceled()) {
            this.waitingHandler.appendReport("Follow-up export completed.", true, true);
            System.exit(0);
            return 0;
        }
        System.exit(1);
        return 1;
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "The PeptideShaker follow-up command line takes a psdb file and generates various types of output files." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see https://compomics.github.io/projects/peptide-shaker.html and https://compomics.github.io/projects/peptide-shaker/wiki/PeptideshakerCLI.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/peptide-shaker." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + System.getProperty("line.separator");
    }

    private static boolean isValidStartup(CommandLine aLine) throws IOException {
        if (aLine.getOptions().length == 0) {
            return false;
        }
        if (!aLine.hasOption(FollowUpCLIParams.PSDB_FILE.id) || aLine.getOptionValue(FollowUpCLIParams.PSDB_FILE.id).equals("")) {
            System.out.println("\n" + FollowUpCLIParams.PSDB_FILE.description + " not specified.\n");
            return false;
        }
        String fileTxt = aLine.getOptionValue(FollowUpCLIParams.PSDB_FILE.id);
        File testFile = new File(fileTxt.trim());
        if (!testFile.exists()) {
            System.out.println("\n" + FollowUpCLIParams.PSDB_FILE.description + " '" + testFile.getAbsolutePath() + "' not found.\n");
            return false;
        }
        return true;
    }

    private void loadSpecies() {
        try {
            SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
            speciesFactory.initiate(PeptideShaker.getConfigFolder());
        }
        catch (Exception e) {
            System.out.println("An error occurred while loading the species.");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            String[] nonPathSettingArgsAsList = PathSettingsCLI.extractAndUpdatePathOptions(args);
            Options nonPathOptions = new Options();
            FollowUpCLIParams.createOptionsCLI(nonPathOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(nonPathOptions, nonPathSettingArgsAsList);
            if (!FollowUpCLI.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "========================================" + System.getProperty("line.separator"));
                lPrintWriter.print("PeptideShaker Follow Up - Command Line" + System.getProperty("line.separator"));
                lPrintWriter.print("========================================" + System.getProperty("line.separator"));
                lPrintWriter.print(FollowUpCLI.getHeader());
                lPrintWriter.print(FollowUpCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                FollowUpCLIInputBean lCLIBean = new FollowUpCLIInputBean(line);
                FollowUpCLI followUpCLI = new FollowUpCLI(lCLIBean);
                followUpCLI.call();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("<CompomicsError>PeptideShaker used up all the memory and had to be stopped. See the PeptideShaker log for details.</CompomicsError>");
            System.err.println("Ran out of memory!");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Memory used by the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory in the Java virtual machine: " + Runtime.getRuntime().freeMemory() + ".");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.print("<CompomicsError>PeptideShaker processing failed. See the PeptideShaker log for details.</CompomicsError>");
            e.printStackTrace();
        }
    }

    public String toString() {
        return "FollowUpCLI{, cliInputBean=" + this.followUpCLIInputBean + '}';
    }
}

