/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.io.parameters.SdrfExport;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.cmd.CLIExportMethods;
import eu.isas.peptideshaker.cmd.MzidCLIInputBean;
import eu.isas.peptideshaker.cmd.MzidCLIParams;
import eu.isas.peptideshaker.cmd.PathSettingsCLI;
import eu.isas.peptideshaker.cmd.PeptideShakerCLI;
import eu.isas.peptideshaker.utils.PsdbParent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class MzidCLI
extends PsdbParent {
    private MzidCLIInputBean mzidCLIInputBean = null;
    private WaitingHandler waitingHandler;
    private ModificationFactory ptmFactory;
    private EnzymeFactory enzymeFactory;
    private UtilitiesUserParameters utilitiesUserPreferences;

    public MzidCLI(MzidCLIInputBean mzidCLIInputBean) {
        this.mzidCLIInputBean = mzidCLIInputBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() {
        block30: {
            block29: {
                try {
                    Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
                    Field loggerField = loggerClass.getDeclaredField("logger");
                    Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                    Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                    unsafeField.setAccessible(true);
                    Object unsafe = unsafeField.get(null);
                    Long offset = (Long)unsafeClass.getMethod("staticFieldOffset", Field.class).invoke(unsafe, loggerField);
                    unsafeClass.getMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class).invoke(unsafe, loggerClass, offset, null);
                }
                catch (Throwable loggerClass) {
                    // empty catch block
                }
                this.setDbFolder(PeptideShaker.getMatchesFolder());
                this.utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
                PeptideShaker.instantiateFacories(this.utilitiesUserPreferences);
                this.ptmFactory = ModificationFactory.getInstance();
                this.enzymeFactory = EnzymeFactory.getInstance();
                this.loadSpecies();
                this.waitingHandler = new WaitingHandlerCLIImpl();
                String inputFilePath = null;
                try {
                    if (this.mzidCLIInputBean.getZipFile() != null) {
                        inputFilePath = this.mzidCLIInputBean.getZipFile().getAbsolutePath();
                        this.loadPsdbFromZipFile(this.mzidCLIInputBean.getZipFile(), PeptideShaker.getMatchesFolder(), this.waitingHandler);
                        break block29;
                    }
                    if (this.mzidCLIInputBean.getPsdbFile() != null) {
                        inputFilePath = this.mzidCLIInputBean.getPsdbFile().getAbsolutePath();
                        this.psdbFile = this.mzidCLIInputBean.getPsdbFile();
                        this.loadPsdbFile(PeptideShaker.getMatchesFolder(), this.waitingHandler, false);
                        break block29;
                    }
                    this.waitingHandler.appendReport("PeptideShaker project input missing.", true, true);
                    return 1;
                }
                catch (IOException e) {
                    this.waitingHandler.appendReport("An error occurred while reading: " + inputFilePath + ".", true, true);
                    e.printStackTrace();
                    try {
                        PeptideShakerCLI.closePeptideShaker(this.identification);
                    }
                    catch (Exception e2) {
                        this.waitingHandler.appendReport("An error occurred while closing PeptideShaker.", true, true);
                        e2.printStackTrace();
                    }
                    return 1;
                }
            }
            try {
                if (this.loadSpectrumFiles(this.waitingHandler)) break block30;
                if (this.identification.getFractions().size() > 1) {
                    this.waitingHandler.appendReport("The spectrum files were not found. Please provide their location in the command line parameters.", true, true);
                } else {
                    this.waitingHandler.appendReport("The spectrum file was not found. Please provide its location in the command line parameters.", true, true);
                }
                try {
                    PeptideShakerCLI.closePeptideShaker(this.identification);
                }
                catch (Exception e2) {
                    this.waitingHandler.appendReport("An error occurred while closing PeptideShaker.", true, true);
                    e2.printStackTrace();
                }
                return 1;
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while loading the spectrum file(s).", true, true);
                e.printStackTrace();
                try {
                    PeptideShakerCLI.closePeptideShaker(this.identification);
                }
                catch (Exception e2) {
                    this.waitingHandler.appendReport("An error occurred while closing PeptideShaker.", true, true);
                    e2.printStackTrace();
                }
                return 1;
            }
        }
        try {
            this.loadFastaFile(this.waitingHandler);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.waitingHandler.appendReport("An error occurred while parsing the fasta file.", true, true);
            this.waitingHandler.setRunCanceled();
            return 1;
        }
        String error = PeptideShaker.loadModifications(this.getIdentificationParameters().getSearchParameters());
        if (error != null) {
            System.out.println(error);
        }
        double currentIntensityLimit = this.getIdentificationParameters().getAnnotationParameters().getAnnotationIntensityLimit();
        this.getIdentificationParameters().getAnnotationParameters().setIntensityLimit(0.0);
        try {
            CLIExportMethods.exportMzId(this.mzidCLIInputBean, this, this.waitingHandler);
        }
        catch (Exception e) {
            this.waitingHandler.appendReport("An error occurred while generating the mzid file.", true, true);
            e.printStackTrace();
            this.waitingHandler.setRunCanceled();
        }
        finally {
            this.getIdentificationParameters().getAnnotationParameters().setIntensityLimit(currentIntensityLimit);
        }
        try {
            File sdrfFile = new File(IoUtil.removeExtension((String)this.mzidCLIInputBean.getOutputFile().getAbsolutePath()) + ".sdrf");
            SdrfExport.writeSdrf((File)sdrfFile, (SearchParameters)this.getIdentificationParameters().getSearchParameters(), (ArrayList)this.getIdentification().getFractions(), (ModificationProvider)ModificationFactory.getInstance());
        }
        catch (Exception e) {
            this.waitingHandler.appendReport("An error occurred while generating the sdrf file.", true, true);
            e.printStackTrace();
            this.waitingHandler.setRunCanceled();
        }
        try {
            PeptideShakerCLI.closePeptideShaker(this.identification);
        }
        catch (Exception e2) {
            this.waitingHandler.appendReport("An error occurred while closing PeptideShaker.", true, true);
            e2.printStackTrace();
        }
        if (!this.waitingHandler.isRunCanceled()) {
            this.waitingHandler.appendReport("MzIdentML export completed.", true, true);
            System.exit(0);
            return 0;
        }
        System.exit(1);
        return 1;
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "The PeptideShaker mzid command line takes a psdb file and export the identification results in the mzIdentML format." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see https://compomics.github.io/projects/peptide-shaker.html and https://compomics.github.io/projects/peptide-shaker/wiki/PeptideshakerCLI.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/peptide-shaker." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + System.getProperty("line.separator");
    }

    private static boolean isValidStartup(CommandLine aLine) throws IOException {
        if (aLine.getOptions().length == 0) {
            return false;
        }
        for (MzidCLIParams mzidCLIParam : MzidCLIParams.values()) {
            if (!mzidCLIParam.mandatory || !mzidCLIParam.hasArgument || aLine.hasOption(mzidCLIParam.id) && !aLine.getOptionValue(mzidCLIParam.id).equals("")) continue;
            System.out.println("\n" + mzidCLIParam.description + " not specified.\n");
            return false;
        }
        String fileTxt = aLine.getOptionValue(MzidCLIParams.PSDB_FILE.id);
        File testFile = new File(fileTxt.trim());
        if (!testFile.exists()) {
            System.out.println("\n" + MzidCLIParams.PSDB_FILE.description + " '" + testFile.getAbsolutePath() + "' not found.\n");
            return false;
        }
        return true;
    }

    private void loadSpecies() {
        try {
            SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
            speciesFactory.initiate(PeptideShaker.getConfigFolder());
        }
        catch (Exception e) {
            System.out.println("An error occurred while loading the species.");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            String[] nonPathSettingArgsAsList = PathSettingsCLI.extractAndUpdatePathOptions(args);
            Options nonPathOptions = new Options();
            MzidCLIParams.createOptionsCLI(nonPathOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(nonPathOptions, nonPathSettingArgsAsList);
            if (!MzidCLI.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "========================================" + System.getProperty("line.separator"));
                lPrintWriter.print("PeptideShaker mzid - Command Line" + System.getProperty("line.separator"));
                lPrintWriter.print("========================================" + System.getProperty("line.separator"));
                lPrintWriter.print(MzidCLI.getHeader());
                lPrintWriter.print(MzidCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                MzidCLIInputBean lCLIBean = new MzidCLIInputBean(line);
                MzidCLI mzidCLI = new MzidCLI(lCLIBean);
                mzidCLI.call();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("<CompomicsError>PeptideShaker used up all the memory and had to be stopped. See the PeptideShaker log for details.</CompomicsError>");
            System.err.println("Ran out of memory!");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Memory used by the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory in the Java virtual machine: " + Runtime.getRuntime().freeMemory() + ".");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.print("<CompomicsError>PeptideShaker processing failed. See the PeptideShaker log for details.</CompomicsError>");
            e.printStackTrace();
        }
    }

    public String toString() {
        return "MzidCLI{, cliInputBean=" + this.mzidCLIInputBean + '}';
    }
}

