/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export;

import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.IdentificationKeys;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesCache;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.filtering.FilterParameters;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.peptide_shaker.ProjectType;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.parameters.PeptideShakerParameters;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.scoring.PSMaps;
import java.io.File;
import java.io.IOException;

public class PsdbExporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAs(File destinationFile, WaitingHandler waitingHandler, Identification identification, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumCountingParameters spectrumCountingParameters, ProjectDetails projectDetails, FilterParameters filterParameters, Metrics metrics, GeneMaps geneMaps, ProjectType projectType, IdentificationFeaturesCache identificationFeaturesCache, boolean emptyCache, DisplayParameters displayParameters, File dbFolder) throws IOException {
        identificationFeaturesCache.setReadOnly(true);
        try {
            PSMaps psMaps;
            long psMapsIdentKey;
            projectDetails.setUserAdvocateMapping(Advocate.getUserAdvocates());
            if (!identification.contains(PeptideShakerParameters.KEY)) {
                PeptideShakerParameters peptideShakerParameters = new PeptideShakerParameters(identificationParameters, spectrumCountingParameters, projectDetails, filterParameters, displayParameters, metrics, sequenceProvider, proteinDetailsProvider, geneMaps, projectType, identificationFeaturesCache);
                identification.addObject(PeptideShakerParameters.KEY, (Object)peptideShakerParameters);
            }
            if (!identification.contains(IdentificationKeys.KEY)) {
                identification.addObject(IdentificationKeys.KEY, (Object)identification.getIdentificationKeys());
            }
            if (!identification.contains(psMapsIdentKey = (psMaps = new PSMaps()).getParameterKey())) {
                identification.addObject(psMapsIdentKey, (Object)identification.getUrParam((UrParameter)psMaps));
            }
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) {
                PeptideShakerParameters peptideShakerParameters = (PeptideShakerParameters)((Object)identification.retrieveObject(PeptideShakerParameters.KEY));
                SequenceProvider tmpSequenceProvider = peptideShakerParameters.getSequenceProvider();
                ProteinDetailsProvider tmpProteinDetailsProvider = peptideShakerParameters.getProteinDetailsProvider();
                peptideShakerParameters.cleanProviders();
                identification.updateObject(PeptideShakerParameters.KEY, (Object)peptideShakerParameters);
                identification.getObjectsDB().lock(waitingHandler);
                IoUtil.copyFile((File)identification.getObjectsDB().getDbFile(), (File)destinationFile);
                identification.getObjectsDB().unlock();
                peptideShakerParameters.setSequenceProvider(tmpSequenceProvider);
                peptideShakerParameters.setProteinDetailsProvider(tmpProteinDetailsProvider);
                identification.updateObject(PeptideShakerParameters.KEY, (Object)peptideShakerParameters);
            }
        }
        finally {
            identificationFeaturesCache.setReadOnly(false);
        }
    }
}

