/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class UnipeptExport {
    private static final String LINE_BREAK = System.getProperty("line.separator");

    public static void analyzeInUnipept(List<String> peptides, boolean equateIandL, boolean filterDuplicates, boolean handleMissingCleavage, File tempHtmlFile, WaitingHandler waitingHandler) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tempHtmlFile));){
            writer.write("<html>");
            writer.newLine();
            writer.write("\t<body>");
            writer.newLine();
            writer.write("\t\t<form id=\"unipept-form\" action=\"https://unipept.ugent.be/export\" accept-charset=\"UTF-8\" method=\"post\">");
            writer.newLine();
            writer.write("\t\t\t<input name=\"utf8\" type=\"hidden\" value=\"\u00e2\u0153\u201c\">");
            writer.newLine();
            writer.write("\t\t\t<textarea name=\"qs\" id=\"qs\" rows=\"7\" style=\"visibility: hidden;\">");
            writer.newLine();
            for (String peptide : peptides) {
                writer.write(peptide);
                writer.newLine();
            }
            writer.write("\t\t\t</textarea>");
            writer.newLine();
            writer.write("\t\t\t<input type=\"text\" name=\"search_name\" id=\"search_name\" style=\"visibility: hidden;\">");
            writer.newLine();
            writer.write("\t\t\t<input type=\"checkbox\" name=\"il\" id=\"il\" value=\"1\" " + (equateIandL ? "checked=\"checked\"" : "") + " style=\"visibility: hidden;\">");
            writer.newLine();
            writer.write("\t\t\t<input type=\"checkbox\" name=\"dupes\" id=\"dupes\" value=\"1\" " + (filterDuplicates ? "checked=\"checked\"" : "") + " style=\"visibility: hidden;\">");
            writer.newLine();
            writer.write("\t\t\t<input type=\"checkbox\" name=\"missed\" id=\"missed\" value=\"1\" " + (handleMissingCleavage ? "checked=\"checked\"" : "") + " style=\"visibility: hidden;\">");
            writer.newLine();
            writer.write("\t\t</form>");
            writer.newLine();
            writer.write("\t\t<script>");
            writer.newLine();
            writer.write("\t\t\twindow.onload = () => {");
            writer.newLine();
            writer.write("\t\t\t\tdocument.getElementById(\"unipept-form\").submit();");
            writer.newLine();
            writer.write("\t\t\t};");
            writer.newLine();
            writer.write("\t\t</script>");
            writer.newLine();
            writer.write("\t</body>");
            writer.newLine();
            writer.write("</html>");
            writer.newLine();
        }
        BareBonesBrowserLaunch.openURL((String)tempHtmlFile.toURI().toString());
    }
}

