/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsProjectFeature;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;

public class PsProjectSection {
    private final EnumSet<PsProjectFeature> projectFeatures;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;

    public PsProjectSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
        this.projectFeatures = EnumSet.noneOf(PsProjectFeature.class);
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsProjectFeature) {
                this.projectFeatures.add((PsProjectFeature)exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Impossible to export " + exportFeature.getClass().getName() + " as project feature.");
        }
    }

    public void writeSection(String experiment, ProjectDetails projectDetails, WaitingHandler waitingHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            if (this.indexes) {
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText("Parameter");
            this.writer.addSeparator();
            this.writer.writeHeaderText("Value");
            this.writer.newLine();
        }
        int line = 1;
        for (PsProjectFeature projectFeature : this.projectFeatures) {
            if (this.indexes) {
                this.writer.write(Integer.toString(line));
                this.writer.addSeparator();
            }
            this.writer.write(projectFeature.getTitle());
            this.writer.addSeparator();
            switch (projectFeature) {
                case date: {
                    this.writer.write(projectDetails.getCreationDate() + "");
                    break;
                }
                case experiment: {
                    this.writer.write(experiment);
                    break;
                }
                case peptide_shaker: {
                    this.writer.write(projectDetails.getPeptideShakerVersion());
                    break;
                }
                case identification_algorithms: {
                    ArrayList<Integer> advocatesIds = projectDetails.getIdentificationAlgorithms();
                    Collections.sort(advocatesIds);
                    for (int i = 0; i < advocatesIds.size(); ++i) {
                        if (i > 0) {
                            if (i == advocatesIds.size() - 1) {
                                this.writer.write(" and ");
                            } else {
                                this.writer.write(", ");
                            }
                        }
                        Integer advocateId = advocatesIds.get(i);
                        Advocate advocate = Advocate.getAdvocate((int)advocateId);
                        this.writer.write(advocate.getName());
                    }
                    break;
                }
                case algorithms_versions: {
                    ArrayList<Integer> advocatesIds = projectDetails.getIdentificationAlgorithms();
                    HashMap<String, ArrayList<String>> versions = projectDetails.getAlgorithmNameToVersionsMap();
                    Collections.sort(advocatesIds);
                    for (int i = 0; i < advocatesIds.size(); ++i) {
                        if (i > 0) {
                            if (i == advocatesIds.size() - 1) {
                                this.writer.write(" and ");
                            } else {
                                this.writer.write(", ");
                            }
                        }
                        Integer advocateId = advocatesIds.get(i);
                        Advocate advocate = Advocate.getAdvocate((int)advocateId);
                        String advocateName = advocate.getName();
                        this.writer.write(advocateName + " (");
                        ArrayList<String> algorithmVersions = versions.get(advocateName);
                        if (algorithmVersions == null || algorithmVersions.isEmpty()) {
                            this.writer.write("unknown version)");
                            continue;
                        }
                        if (algorithmVersions.size() == 1) {
                            this.writer.write("version " + algorithmVersions.get(0) + ")");
                            continue;
                        }
                        this.writer.write("versions ");
                        for (int j = 0; j < algorithmVersions.size(); ++j) {
                            if (j > 0) {
                                if (j == algorithmVersions.size() - 1) {
                                    this.writer.write(" and ");
                                } else {
                                    this.writer.write(", ");
                                }
                            }
                            this.writer.write(algorithmVersions.get(j));
                        }
                        this.writer.write(")");
                    }
                    break;
                }
                default: {
                    this.writer.write("Not implemented");
                }
            }
            this.writer.newLine();
            ++line;
        }
    }
}

